/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.routing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.river.RiverIndexName;
import org.elasticsearch.river.RiverName;
import org.elasticsearch.river.cluster.RiverClusterService;
import org.elasticsearch.river.cluster.RiverClusterState;
import org.elasticsearch.river.cluster.RiverClusterStateUpdateTask;
import org.elasticsearch.river.cluster.RiverNodeHelper;
import org.elasticsearch.river.routing.RiverRouting;
import org.elasticsearch.river.routing.RiversRouting;
import org.elasticsearch.threadpool.ThreadPool;

public class RiversRouter
extends AbstractLifecycleComponent<RiversRouter>
implements ClusterStateListener {
    private static final TimeValue RIVER_START_RETRY_INTERVAL = TimeValue.timeValueMillis(1000L);
    private static final int RIVER_START_MAX_RETRIES = 5;
    private final String riverIndexName;
    private final Client client;
    private final RiverClusterService riverClusterService;
    private final ThreadPool threadPool;

    @Inject
    public RiversRouter(Settings settings, Client client, ClusterService clusterService, RiverClusterService riverClusterService, ThreadPool threadPool) {
        super(settings);
        this.riverIndexName = RiverIndexName.Conf.indexName(settings);
        this.riverClusterService = riverClusterService;
        this.client = client;
        this.threadPool = threadPool;
        clusterService.add(this);
    }

    @Override
    protected void doStart() throws ElasticsearchException {
    }

    @Override
    protected void doStop() throws ElasticsearchException {
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public void clusterChanged(final ClusterChangedEvent event) {
        if (!event.localNodeMaster()) {
            return;
        }
        String source = "reroute_rivers_node_changed";
        final CountDown countDown = new CountDown(5);
        this.riverClusterService.submitStateUpdateTask("reroute_rivers_node_changed", new RiverClusterStateUpdateTask(){

            @Override
            public RiverClusterState execute(RiverClusterState currentState) {
                return RiversRouter.this.updateRiverClusterState("reroute_rivers_node_changed", currentState, event.state(), countDown);
            }
        });
    }

    protected RiverClusterState updateRiverClusterState(final String source, RiverClusterState currentState, ClusterState newClusterState, final CountDown countDown) {
        if (!newClusterState.metaData().hasIndex(this.riverIndexName)) {
            if (!currentState.routing().isEmpty()) {
                return RiverClusterState.builder().state(currentState).routing(RiversRouting.builder()).build();
            }
            return currentState;
        }
        RiversRouting.Builder routingBuilder = RiversRouting.builder().routing(currentState.routing());
        boolean dirty = false;
        IndexMetaData indexMetaData = newClusterState.metaData().index(this.riverIndexName);
        boolean metaFound = true;
        for (ObjectCursor<MappingMetaData> objectCursor : indexMetaData.mappings().values()) {
            String mappingType = ((MappingMetaData)objectCursor.value).type();
            if ("_default_".equals(mappingType) || currentState.routing().hasRiverByName(mappingType)) continue;
            try {
                GetResponse getResponse = (GetResponse)this.client.prepareGet(this.riverIndexName, mappingType, "_meta").setPreference("_primary").get();
                if (getResponse.isExists()) {
                    this.logger.debug("{}/{}/_meta document found.", this.riverIndexName, mappingType);
                    String riverType = XContentMapValues.nodeStringValue(getResponse.getSourceAsMap().get("type"), null);
                    if (riverType == null) {
                        this.logger.warn("no river type provided for [{}], ignoring...", this.riverIndexName);
                        continue;
                    }
                    routingBuilder.put(new RiverRouting(new RiverName(riverType, mappingType), null));
                    dirty = true;
                    continue;
                }
                metaFound = false;
            }
            catch (NoShardAvailableActionException e) {
            }
            catch (ClusterBlockException e) {
            }
            catch (IndexMissingException e) {
            }
            catch (IllegalIndexShardStateException e) {
            }
            catch (Exception e) {
                this.logger.warn("failed to get/parse _meta for [{}]", e, mappingType);
            }
        }
        if (!metaFound) {
            if (countDown.countDown()) {
                this.logger.warn("no river _meta document found after {} attempts", 5);
            } else {
                this.logger.debug("no river _meta document found retrying in {} ms", RIVER_START_RETRY_INTERVAL.millis());
                try {
                    this.threadPool.schedule(RIVER_START_RETRY_INTERVAL, "generic", new Runnable(){

                        @Override
                        public void run() {
                            RiversRouter.this.riverClusterService.submitStateUpdateTask(source, new RiverClusterStateUpdateTask(){

                                @Override
                                public RiverClusterState execute(RiverClusterState currentState) {
                                    return RiversRouter.this.updateRiverClusterState(source, currentState, RiversRouter.this.riverClusterService.state(), countDown);
                                }
                            });
                        }
                    });
                }
                catch (EsRejectedExecutionException ex) {
                    this.logger.debug("Couldn't schedule river start retry, node might be shutting down", ex, new Object[0]);
                }
            }
        }
        for (RiverRouting riverRouting : currentState.routing()) {
            if (!indexMetaData.mappings().containsKey(riverRouting.riverName().name())) {
                routingBuilder.remove(riverRouting);
                dirty = true;
                continue;
            }
            if (riverRouting.node() == null || newClusterState.nodes().nodeExists(riverRouting.node().id())) continue;
            routingBuilder.remove(riverRouting);
            routingBuilder.put(new RiverRouting(riverRouting.riverName(), null));
            dirty = true;
        }
        HashMap nodesToRivers = Maps.newHashMap();
        for (DiscoveryNode node : newClusterState.nodes()) {
            if (!RiverNodeHelper.isRiverNode(node)) continue;
            nodesToRivers.put(node, Lists.newArrayList());
        }
        ArrayList<RiverRouting> arrayList = Lists.newArrayList();
        for (RiverRouting routing : routingBuilder.build()) {
            if (routing.node() == null) {
                arrayList.add(routing);
                continue;
            }
            ArrayList<RiverRouting> l = (ArrayList<RiverRouting>)nodesToRivers.get(routing.node());
            if (l == null) {
                l = Lists.newArrayList();
                nodesToRivers.put(routing.node(), l);
            }
            l.add(routing);
        }
        Iterator it = arrayList.iterator();
        while (it.hasNext()) {
            RiverRouting routing;
            routing = (RiverRouting)it.next();
            DiscoveryNode smallest = null;
            int smallestSize = Integer.MAX_VALUE;
            for (Map.Entry entry : nodesToRivers.entrySet()) {
                if (!RiverNodeHelper.isRiverNode((DiscoveryNode)entry.getKey(), routing.riverName()) || ((List)entry.getValue()).size() >= smallestSize) continue;
                smallestSize = ((List)entry.getValue()).size();
                smallest = (DiscoveryNode)entry.getKey();
            }
            if (smallest == null) continue;
            dirty = true;
            it.remove();
            routing.node(smallest);
            ((List)nodesToRivers.get(smallest)).add(routing);
            this.logger.debug("going to allocate river [{}] on node {}", routing.riverName().getName(), smallest);
        }
        if (dirty) {
            return RiverClusterState.builder().state(currentState).routing(routingBuilder).build();
        }
        return currentState;
    }
}

