/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.Set;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public abstract class BaseRestHandler
extends AbstractComponent
implements RestHandler {
    private final RestController controller;
    private final Client client;

    protected BaseRestHandler(Settings settings, RestController controller, Client client) {
        super(settings);
        this.controller = controller;
        this.client = client;
    }

    @Override
    public final void handleRequest(RestRequest request, RestChannel channel) throws Exception {
        this.handleRequest(request, channel, new HeadersAndContextCopyClient(this.client, request, this.controller.relevantHeaders()));
    }

    protected abstract void handleRequest(RestRequest var1, RestChannel var2, Client var3) throws Exception;

    static final class HeadersAndContextCopyClient
    extends FilterClient {
        private final RestRequest restRequest;
        private final IndicesAdmin indicesAdmin;
        private final ClusterAdmin clusterAdmin;
        private final Set<String> headers;

        HeadersAndContextCopyClient(Client in, RestRequest restRequest, Set<String> headers) {
            super(in);
            this.restRequest = restRequest;
            this.indicesAdmin = new IndicesAdmin(in.admin().indices(), restRequest, headers);
            this.clusterAdmin = new ClusterAdmin(in.admin().cluster(), restRequest, headers);
            this.headers = headers;
        }

        private static void copyHeadersAndContext(ActionRequest actionRequest, RestRequest restRequest, Set<String> headers) {
            for (String usefulHeader : headers) {
                String headerValue = restRequest.header(usefulHeader);
                if (headerValue == null) continue;
                actionRequest.putHeader(usefulHeader, headerValue);
            }
            actionRequest.copyContextFrom(restRequest);
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, Client>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, Client> action, Request request) {
            HeadersAndContextCopyClient.copyHeadersAndContext(request, this.restRequest, this.headers);
            return super.execute(action, request);
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, Client>> void execute(Action<Request, Response, RequestBuilder, Client> action, Request request, ActionListener<Response> listener) {
            HeadersAndContextCopyClient.copyHeadersAndContext(request, this.restRequest, this.headers);
            super.execute(action, request, listener);
        }

        @Override
        public ClusterAdminClient cluster() {
            return this.clusterAdmin;
        }

        @Override
        public IndicesAdminClient indices() {
            return this.indicesAdmin;
        }

        private final class IndicesAdmin
        extends FilterClient.IndicesAdmin {
            private final RestRequest restRequest;
            private final Set<String> headers;

            private IndicesAdmin(IndicesAdminClient in, RestRequest restRequest, Set<String> headers) {
                super(in);
                this.restRequest = restRequest;
                this.headers = headers;
            }

            @Override
            public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action, Request request) {
                HeadersAndContextCopyClient.copyHeadersAndContext(request, this.restRequest, this.headers);
                return super.execute(action, request);
            }

            @Override
            public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> void execute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action, Request request, ActionListener<Response> listener) {
                HeadersAndContextCopyClient.copyHeadersAndContext(request, this.restRequest, this.headers);
                super.execute(action, request, listener);
            }
        }

        private static final class ClusterAdmin
        extends FilterClient.ClusterAdmin {
            private final RestRequest restRequest;
            private final Set<String> headers;

            private ClusterAdmin(ClusterAdminClient in, RestRequest restRequest, Set<String> headers) {
                super(in);
                this.restRequest = restRequest;
                this.headers = headers;
            }

            @Override
            public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, ClusterAdminClient>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, ClusterAdminClient> action, Request request) {
                HeadersAndContextCopyClient.copyHeadersAndContext(request, this.restRequest, this.headers);
                return super.execute(action, request);
            }

            @Override
            public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, ClusterAdminClient>> void execute(Action<Request, Response, RequestBuilder, ClusterAdminClient> action, Request request, ActionListener<Response> listener) {
                HeadersAndContextCopyClient.copyHeadersAndContext(request, this.restRequest, this.headers);
                super.execute(action, request, listener);
            }
        }
    }
}

