/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.IOException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.monitor.fs.FsStats;

public class JmxFsProbe
extends AbstractComponent
implements FsProbe {
    private final NodeEnvironment nodeEnv;

    @Inject
    public JmxFsProbe(Settings settings, NodeEnvironment nodeEnv) {
        super(settings);
        this.nodeEnv = nodeEnv;
    }

    @Override
    public FsStats stats() throws IOException {
        if (!this.nodeEnv.hasNodeFile()) {
            return new FsStats(System.currentTimeMillis(), new FsStats.Info[0]);
        }
        NodeEnvironment.NodePath[] dataLocations = this.nodeEnv.nodePaths();
        FsStats.Info[] infos = new FsStats.Info[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            infos[i] = JmxFsProbe.getFSInfo(dataLocations[i]);
        }
        return new FsStats(System.currentTimeMillis(), infos);
    }

    public static FsStats.Info getFSInfo(NodeEnvironment.NodePath nodePath) throws IOException {
        FsStats.Info info = new FsStats.Info();
        info.path = nodePath.path.toAbsolutePath().toString();
        info.total = nodePath.fileStore.getTotalSpace();
        info.free = nodePath.fileStore.getUnallocatedSpace();
        info.available = nodePath.fileStore.getUsableSpace();
        info.type = nodePath.fileStore.type();
        info.mount = nodePath.fileStore.toString();
        return info;
    }
}

