/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.shape;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;

public class ShapeFetchService
extends AbstractComponent {
    private final Client client;

    @Inject
    public ShapeFetchService(Client client, Settings settings) {
        super(settings);
        this.client = client;
    }

    public ShapeBuilder fetch(GetRequest getRequest, String path) throws IOException {
        getRequest.preference("_local");
        getRequest.operationThreaded(false);
        GetResponse response = this.client.get(getRequest).actionGet();
        if (!response.isExists()) {
            throw new ElasticsearchIllegalArgumentException("Shape with ID [" + getRequest.id() + "] in type [" + getRequest.type() + "] not found");
        }
        String[] pathElements = Strings.splitStringToArray(path, '.');
        int currentPathSlot = 0;
        try (XContentParser parser = null;){
            XContentParser.Token currentToken;
            parser = XContentHelper.createParser(response.getSourceAsBytesRef());
            while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (currentToken != XContentParser.Token.FIELD_NAME) continue;
                if (pathElements[currentPathSlot].equals(parser.currentName())) {
                    parser.nextToken();
                    if (++currentPathSlot != pathElements.length) continue;
                    ShapeBuilder shapeBuilder = ShapeBuilder.parse(parser);
                    return shapeBuilder;
                }
                parser.nextToken();
                parser.skipChildren();
            }
            throw new ElasticsearchIllegalStateException("Shape with name [" + getRequest.id() + "] found but missing " + path + " field");
        }
    }
}

