/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryParser;

@Deprecated
public class MoreLikeThisFieldQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<MoreLikeThisFieldQueryBuilder> {
    private final String name;
    private String likeText;
    private String minimumShouldMatch = null;
    private int minTermFreq = -1;
    private int maxQueryTerms = -1;
    private String[] stopWords = null;
    private int minDocFreq = -1;
    private int maxDocFreq = -1;
    private int minWordLength = -1;
    private int maxWordLength = -1;
    private float boostTerms = -1.0f;
    private float boost = -1.0f;
    private String analyzer;
    private Boolean failOnUnsupportedField;
    private String queryName;

    public MoreLikeThisFieldQueryBuilder(String name) {
        this.name = name;
    }

    public MoreLikeThisFieldQueryBuilder likeText(String likeText) {
        this.likeText = likeText;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    @Deprecated
    public MoreLikeThisFieldQueryBuilder percentTermsToMatch(float percentTermsToMatch) {
        return this.minimumShouldMatch(Math.round(percentTermsToMatch * 100.0f) + "%");
    }

    public MoreLikeThisFieldQueryBuilder minTermFreq(int minTermFreqy) {
        this.minTermFreq = minTermFreqy;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder maxWordLen(int maxWordLen) {
        this.maxWordLength = maxWordLen;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public MoreLikeThisFieldQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder failOnUnsupportedField(boolean fail) {
        this.failOnUnsupportedField = fail;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mlt_field");
        builder.startObject(this.name);
        if (this.likeText == null) {
            throw new ElasticsearchIllegalArgumentException("moreLikeThisField requires '" + MoreLikeThisQueryParser.Fields.LIKE_TEXT.getPreferredName() + "' to be provided");
        }
        builder.field(MoreLikeThisQueryParser.Fields.LIKE_TEXT.getPreferredName(), this.likeText);
        if (this.minimumShouldMatch != null) {
            builder.field(MoreLikeThisQueryParser.Fields.MINIMUM_SHOULD_MATCH.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.minTermFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MIN_TERM_FREQ.getPreferredName(), this.minTermFreq);
        }
        if (this.maxQueryTerms != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MAX_QUERY_TERMS.getPreferredName(), this.maxQueryTerms);
        }
        if (this.stopWords != null && this.stopWords.length > 0) {
            builder.startArray(MoreLikeThisQueryParser.Fields.STOP_WORDS.getPreferredName());
            for (String stopWord : this.stopWords) {
                builder.value(stopWord);
            }
            builder.endArray();
        }
        if (this.minDocFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MIN_DOC_FREQ.getPreferredName(), this.minDocFreq);
        }
        if (this.maxDocFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MAX_DOC_FREQ.getPreferredName(), this.maxDocFreq);
        }
        if (this.minWordLength != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MIN_WORD_LENGTH.getPreferredName(), this.minWordLength);
        }
        if (this.maxWordLength != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MAX_WORD_LENGTH.getPreferredName(), this.maxWordLength);
        }
        if (this.boostTerms != -1.0f) {
            builder.field(MoreLikeThisQueryParser.Fields.BOOST_TERMS.getPreferredName(), this.boostTerms);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.failOnUnsupportedField != null) {
            builder.field(MoreLikeThisQueryParser.Fields.FAIL_ON_UNSUPPORTED_FIELD.getPreferredName(), (Object)this.failOnUnsupportedField);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
        builder.endObject();
    }
}

