/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

@Deprecated
public class FuzzyLikeThisQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<FuzzyLikeThisQueryBuilder> {
    private final String[] fields;
    private Float boost;
    private String likeText = null;
    private Fuzziness fuzziness;
    private Integer prefixLength;
    private Integer maxQueryTerms;
    private Boolean ignoreTF;
    private String analyzer;
    private Boolean failOnUnsupportedField;
    private String queryName;

    public FuzzyLikeThisQueryBuilder() {
        this.fields = null;
    }

    public FuzzyLikeThisQueryBuilder(String ... fields) {
        this.fields = fields;
    }

    public FuzzyLikeThisQueryBuilder likeText(String likeText) {
        this.likeText = likeText;
        return this;
    }

    public FuzzyLikeThisQueryBuilder fuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    public FuzzyLikeThisQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public FuzzyLikeThisQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public FuzzyLikeThisQueryBuilder ignoreTF(boolean ignoreTF) {
        this.ignoreTF = ignoreTF;
        return this;
    }

    public FuzzyLikeThisQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public FuzzyLikeThisQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public FuzzyLikeThisQueryBuilder failOnUnsupportedField(boolean fail) {
        this.failOnUnsupportedField = fail;
        return this;
    }

    public FuzzyLikeThisQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("flt");
        if (this.fields != null) {
            builder.startArray("fields");
            for (String field : this.fields) {
                builder.value(field);
            }
            builder.endArray();
        }
        if (this.likeText == null) {
            throw new ElasticsearchIllegalArgumentException("fuzzyLikeThis requires 'likeText' to be provided");
        }
        builder.field("like_text", this.likeText);
        if (this.maxQueryTerms != null) {
            builder.field("max_query_terms", this.maxQueryTerms);
        }
        if (this.fuzziness != null) {
            this.fuzziness.toXContent(builder, params);
        }
        if (this.prefixLength != null) {
            builder.field("prefix_length", this.prefixLength);
        }
        if (this.ignoreTF != null) {
            builder.field("ignore_tf", (Object)this.ignoreTF);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.failOnUnsupportedField != null) {
            builder.field("fail_on_unsupported_field", (Object)this.failOnUnsupportedField);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

