/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.ForwardingSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.FieldMappersLookup;

public final class DocumentFieldMappers
extends ForwardingSet<FieldMapper<?>> {
    private final FieldMappersLookup fieldMappers;
    private final FieldNameAnalyzer indexAnalyzer;
    private final FieldNameAnalyzer searchAnalyzer;
    private final FieldNameAnalyzer searchQuoteAnalyzer;

    public DocumentFieldMappers(DocumentMapper docMapper) {
        this(new FieldMappersLookup(), new FieldNameAnalyzer(docMapper.indexAnalyzer()), new FieldNameAnalyzer(docMapper.searchAnalyzer()), new FieldNameAnalyzer(docMapper.searchQuotedAnalyzer()));
    }

    private DocumentFieldMappers(FieldMappersLookup fieldMappers, FieldNameAnalyzer indexAnalyzer, FieldNameAnalyzer searchAnalyzer, FieldNameAnalyzer searchQuoteAnalyzer) {
        this.fieldMappers = fieldMappers;
        this.indexAnalyzer = indexAnalyzer;
        this.searchAnalyzer = searchAnalyzer;
        this.searchQuoteAnalyzer = searchQuoteAnalyzer;
    }

    public DocumentFieldMappers copyAndAllAll(Collection<? extends FieldMapper<?>> newMappers) {
        FieldMappersLookup fieldMappers = this.fieldMappers.copyAndAddAll(newMappers);
        FieldNameAnalyzer indexAnalyzer = this.indexAnalyzer.copyAndAddAll(Collections2.transform(newMappers, new Function<FieldMapper<?>, Map.Entry<String, Analyzer>>(){

            @Override
            public Map.Entry<String, Analyzer> apply(FieldMapper<?> input) {
                return Maps.immutableEntry(input.names().indexName(), input.indexAnalyzer());
            }
        }));
        FieldNameAnalyzer searchAnalyzer = this.searchAnalyzer.copyAndAddAll(Collections2.transform(newMappers, new Function<FieldMapper<?>, Map.Entry<String, Analyzer>>(){

            @Override
            public Map.Entry<String, Analyzer> apply(FieldMapper<?> input) {
                return Maps.immutableEntry(input.names().indexName(), input.searchAnalyzer());
            }
        }));
        FieldNameAnalyzer searchQuoteAnalyzer = this.searchQuoteAnalyzer.copyAndAddAll(Collections2.transform(newMappers, new Function<FieldMapper<?>, Map.Entry<String, Analyzer>>(){

            @Override
            public Map.Entry<String, Analyzer> apply(FieldMapper<?> input) {
                return Maps.immutableEntry(input.names().indexName(), input.searchQuoteAnalyzer());
            }
        }));
        return new DocumentFieldMappers(fieldMappers, indexAnalyzer, searchAnalyzer, searchQuoteAnalyzer);
    }

    public FieldMappers name(String name) {
        return this.fieldMappers.name(name);
    }

    public FieldMappers indexName(String indexName) {
        return this.fieldMappers.indexName(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.fieldMappers.fullName(fullName);
    }

    public List<String> simpleMatchToIndexNames(String pattern) {
        return this.fieldMappers.simpleMatchToIndexNames(pattern);
    }

    public List<String> simpleMatchToFullName(String pattern) {
        return this.fieldMappers.simpleMatchToFullName(pattern);
    }

    public FieldMappers smartName(String name) {
        return this.fieldMappers.smartName(name);
    }

    public FieldMapper<?> smartNameFieldMapper(String name) {
        return this.fieldMappers.smartNameFieldMapper(name);
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer indexAnalyzer(Analyzer defaultAnalyzer) {
        return new FieldNameAnalyzer(this.indexAnalyzer.analyzers(), defaultAnalyzer);
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    @Override
    protected Set<FieldMapper<?>> delegate() {
        return this.fieldMappers;
    }
}

