/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.LoggerInfoStream;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CreateFailedEngineException;
import org.elasticsearch.index.engine.DeleteByQueryFailedEngineException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DeleteVersionValue;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineSearcherFactory;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.FlushingRecoveryCounter;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.LiveVersionMap;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.engine.VersionValue;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.merge.policy.ElasticsearchMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.search.nested.IncludeNestedDocsQuery;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesWarmer;

public class InternalEngine
extends Engine {
    private final FailEngineOnMergeFailure mergeSchedulerFailureListener;
    private final MergeSchedulerListener mergeSchedulerListener;
    private volatile long lastDeleteVersionPruneTimeMSec;
    private final ShardIndexingService indexingService;
    @Nullable
    private final IndicesWarmer warmer;
    private final Translog translog;
    private final MergePolicyProvider mergePolicyProvider;
    private final MergeSchedulerProvider mergeScheduler;
    private final IndexWriter indexWriter;
    private final SearcherFactory searcherFactory;
    private final SearcherManager searcherManager;
    private final Lock flushLock;
    private final ReentrantLock optimizeLock;
    protected final FlushingRecoveryCounter onGoingRecoveries;
    private final LiveVersionMap versionMap;
    private final Object[] dirtyLocks;
    private final AtomicLong translogIdGenerator;
    private final AtomicBoolean versionMapRefreshPending;
    private volatile CommitInfo lastCommittedCommitInfo;
    private final Engine.IndexThrottle throttle;
    private volatile boolean possibleMergeNeeded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalEngine(EngineConfig engineConfig) throws EngineException {
        block10: {
            super(engineConfig);
            this.flushLock = new ReentrantLock();
            this.optimizeLock = new ReentrantLock();
            this.translogIdGenerator = new AtomicLong();
            this.versionMapRefreshPending = new AtomicBoolean();
            this.versionMap = new LiveVersionMap();
            this.store.incRef();
            IndexWriter writer = null;
            SearcherManager manager = null;
            boolean success = false;
            try {
                if (Version.indexCreated(engineConfig.getIndexSettings()).onOrBefore(Version.V_0_20_7)) {
                    this.logger.debug("checking for 3x segments to upgrade", new Object[0]);
                    this.maybeUpgrade3xSegments(this.store);
                } else {
                    this.logger.debug("skipping check for 3x segments", new Object[0]);
                }
                this.onGoingRecoveries = new FlushingRecoveryCounter(this, this.store, this.logger);
                this.lastDeleteVersionPruneTimeMSec = engineConfig.getThreadPool().estimatedTimeInMillis();
                this.indexingService = engineConfig.getIndexingService();
                this.warmer = engineConfig.getWarmer();
                this.translog = engineConfig.getTranslog();
                this.mergePolicyProvider = engineConfig.getMergePolicyProvider();
                this.mergeScheduler = engineConfig.getMergeScheduler();
                this.dirtyLocks = new Object[engineConfig.getIndexConcurrency() * 50];
                for (int i = 0; i < this.dirtyLocks.length; ++i) {
                    this.dirtyLocks[i] = new Object();
                }
                this.throttle = new Engine.IndexThrottle();
                this.searcherFactory = new SearchFactory(engineConfig);
                try {
                    writer = this.createWriter();
                }
                catch (IOException e) {
                    throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)e);
                }
                this.indexWriter = writer;
                this.searcherManager = manager = this.createSearcherManager();
                this.mergeSchedulerFailureListener = new FailEngineOnMergeFailure();
                this.mergeSchedulerListener = new MergeSchedulerListener();
                this.mergeScheduler.addListener(this.mergeSchedulerListener);
                this.mergeScheduler.addFailureListener(this.mergeSchedulerFailureListener);
                success = true;
                if (success) break block10;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, manager});
                    this.versionMap.clear();
                    if (!this.isClosed.get()) {
                        this.store.decRef();
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, manager});
            this.versionMap.clear();
            if (!this.isClosed.get()) {
                this.store.decRef();
            }
        }
        this.logger.trace("created new InternalEngine", new Object[0]);
    }

    private SearcherManager createSearcherManager() throws EngineException {
        SearcherManager searcherManager;
        block11: {
            boolean success = false;
            SearcherManager searcherManager2 = null;
            try {
                long translogId;
                if (Lucene.indexExists(this.store.directory())) {
                    Map commitUserData = Lucene.readSegmentInfos(this.store.directory()).getUserData();
                    if (commitUserData.containsKey("translog_id")) {
                        translogId = Long.parseLong((String)commitUserData.get("translog_id"));
                    } else {
                        translogId = System.currentTimeMillis();
                        this.commitIndexWriter(this.indexWriter, translogId, null);
                    }
                } else {
                    translogId = System.currentTimeMillis();
                    this.commitIndexWriter(this.indexWriter, translogId, null);
                }
                searcherManager2 = new SearcherManager(this.indexWriter, true, this.searcherFactory);
                SegmentInfos segmentCommitInfos = this.store.readLastCommittedSegmentsInfo();
                this.lastCommittedCommitInfo = new CommitInfo(segmentCommitInfos, Engine.CommitId.readCommitID(this.store, segmentCommitInfos));
                this.translog.newTranslog(translogId);
                this.versionMap.setManager((ReferenceManager)searcherManager2);
                this.translogIdGenerator.set(translogId);
                success = true;
                searcherManager = searcherManager2;
                if (success) break block11;
            }
            catch (IOException e) {
                try {
                    this.maybeFailEngine("start", e);
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException e1) {
                        e.addSuppressed(e1);
                    }
                    throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searcherManager2, this.indexWriter});
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searcherManager2, this.indexWriter});
        }
        return searcherManager;
    }

    private void updateIndexWriterSettings() {
        try {
            LiveIndexWriterConfig iwc = this.indexWriter.getConfig();
            iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().mbFrac());
            iwc.setUseCompoundFile(this.engineConfig.isCompoundOnFlush());
            iwc.setCheckIntegrityAtMerge(this.engineConfig.isChecksumOnMerge());
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    @Override
    public Engine.GetResult get(Engine.Get get) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            VersionValue versionValue;
            this.ensureOpen();
            if (get.realtime() && (versionValue = this.versionMap.getUnderLock(get.uid().bytes())) != null) {
                if (versionValue.delete()) {
                    Engine.GetResult getResult = Engine.GetResult.NOT_EXISTS;
                    return getResult;
                }
                if (get.versionType().isVersionConflictForReads(versionValue.version(), get.version())) {
                    Uid uid = Uid.createUid(get.uid().text());
                    throw new VersionConflictEngineException(this.shardId, uid.type(), uid.id(), versionValue.version(), get.version());
                }
                if (!get.loadSource()) {
                    Engine.GetResult uid = new Engine.GetResult(true, versionValue.version(), null);
                    return uid;
                }
                Translog.Operation op = this.translog.read(versionValue.translogLocation());
                if (op != null) {
                    Engine.GetResult getResult = new Engine.GetResult(true, versionValue.version(), op.getSource());
                    return getResult;
                }
            }
            Engine.GetResult getResult = this.getFromSearcher(get);
            return getResult;
        }
    }

    @Override
    public void create(Engine.Create create) throws EngineException {
        block27: {
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                    this.innerCreate(create);
                    break block27;
                }
                try (Releasable r = this.throttle.acquireThrottle();){
                    this.innerCreate(create);
                }
            }
            catch (IOException | IllegalStateException | OutOfMemoryError t) {
                this.maybeFailEngine("create", t);
                throw new CreateFailedEngineException(this.shardId, create, t);
            }
        }
        this.checkVersionMapRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCreate(Engine.Create create) throws IOException {
        if (this.engineConfig.isOptimizeAutoGenerateId() && create.autoGeneratedId() && !create.canHaveDuplicates()) {
            this.innerCreateNoLock(create, -1L, null);
        } else {
            Object object = this.dirtyLock(create.uid());
            synchronized (object) {
                VersionValue versionValue = this.versionMap.getUnderLock(create.uid().bytes());
                long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(create.uid()) : (this.engineConfig.isEnableGcDeletes() && versionValue.delete() && this.engineConfig.getThreadPool().estimatedTimeInMillis() - versionValue.time() > this.engineConfig.getGcDeletesInMillis() ? -1L : versionValue.version());
                this.innerCreateNoLock(create, currentVersion, versionValue);
            }
        }
    }

    private void innerCreateNoLock(Engine.Create create, long currentVersion, VersionValue versionValue) throws IOException {
        long expectedVersion = create.version();
        if (create.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
            if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                return;
            }
            throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
        }
        long updatedVersion = create.versionType().updateVersion(currentVersion, expectedVersion);
        boolean doUpdate = false;
        if (versionValue != null && !versionValue.delete() || versionValue == null && currentVersion != -1L) {
            if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                return;
            }
            if (create.origin() == Engine.Operation.Origin.REPLICA) {
                doUpdate = true;
            } else if (create.origin() == Engine.Operation.Origin.PRIMARY && create.autoGeneratedId() && create.canHaveDuplicates() && currentVersion == 1L && create.version() == -3L) {
                doUpdate = true;
                updatedVersion = 1L;
            } else {
                assert (create.origin() == Engine.Operation.Origin.PRIMARY);
                throw new DocumentAlreadyExistsException(this.shardId, create.type(), create.id());
            }
        }
        create.updateVersion(updatedVersion);
        if (doUpdate) {
            if (create.docs().size() > 1) {
                this.indexWriter.updateDocuments(create.uid(), create.docs(), create.analyzer());
            } else {
                this.indexWriter.updateDocument(create.uid(), (Iterable)create.docs().get(0), create.analyzer());
            }
        } else if (create.docs().size() > 1) {
            this.indexWriter.addDocuments(create.docs(), create.analyzer());
        } else {
            this.indexWriter.addDocument((Iterable)create.docs().get(0), create.analyzer());
        }
        Translog.Location translogLocation = this.translog.add(new Translog.Create(create));
        this.versionMap.putUnderLock(create.uid().bytes(), new VersionValue(updatedVersion, translogLocation));
        this.indexingService.postCreateUnderLock(create);
    }

    @Override
    public void index(Engine.Index index) throws EngineException {
        block27: {
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                    this.innerIndex(index);
                    break block27;
                }
                try (Releasable r = this.throttle.acquireThrottle();){
                    this.innerIndex(index);
                }
            }
            catch (IOException | IllegalStateException | OutOfMemoryError t) {
                this.maybeFailEngine("index", t);
                throw new IndexFailedEngineException(this.shardId, index, t);
            }
        }
        this.checkVersionMapRefresh();
    }

    private void checkVersionMapRefresh() {
        if (this.versionMap.ramBytesUsedForRefresh() > this.config().getVersionMapSize().bytes() && !this.versionMapRefreshPending.getAndSet(true)) {
            try {
                if (this.isClosed.get()) {
                    return;
                }
                this.engineConfig.getThreadPool().executor("refresh").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InternalEngine.this.refresh("version_table_full");
                        }
                        catch (EngineClosedException engineClosedException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException esRejectedExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerIndex(Engine.Index index) throws IOException {
        Object object = this.dirtyLock(index.uid());
        synchronized (object) {
            VersionValue versionValue = this.versionMap.getUnderLock(index.uid().bytes());
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(index.uid()) : (this.engineConfig.isEnableGcDeletes() && versionValue.delete() && this.engineConfig.getThreadPool().estimatedTimeInMillis() - versionValue.time() > this.engineConfig.getGcDeletesInMillis() ? -1L : versionValue.version());
            long expectedVersion = index.version();
            if (index.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
                if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                    return;
                }
                throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
            }
            long updatedVersion = index.versionType().updateVersion(currentVersion, expectedVersion);
            index.updateVersion(updatedVersion);
            if (currentVersion == -1L) {
                index.created(true);
                if (index.docs().size() > 1) {
                    this.indexWriter.addDocuments(index.docs(), index.analyzer());
                } else {
                    this.indexWriter.addDocument((Iterable)index.docs().get(0), index.analyzer());
                }
            } else {
                if (versionValue != null) {
                    index.created(versionValue.delete());
                }
                if (index.docs().size() > 1) {
                    this.indexWriter.updateDocuments(index.uid(), index.docs(), index.analyzer());
                } else {
                    this.indexWriter.updateDocument(index.uid(), (Iterable)index.docs().get(0), index.analyzer());
                }
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Index(index));
            this.versionMap.putUnderLock(index.uid().bytes(), new VersionValue(updatedVersion, translogLocation));
            this.indexingService.postIndexUnderLock(index);
        }
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.innerDelete(delete);
        }
        catch (IOException | IllegalStateException | OutOfMemoryError t) {
            this.maybeFailEngine("delete", t);
            throw new DeleteFailedEngineException(this.shardId, delete, t);
        }
        this.maybePruneDeletedTombstones();
        this.checkVersionMapRefresh();
    }

    private void maybePruneDeletedTombstones() {
        if (this.engineConfig.isEnableGcDeletes() && (double)(this.engineConfig.getThreadPool().estimatedTimeInMillis() - this.lastDeleteVersionPruneTimeMSec) > (double)this.engineConfig.getGcDeletesInMillis() * 0.25) {
            this.pruneDeletedTombstones();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDelete(Engine.Delete delete) throws IOException {
        Object object = this.dirtyLock(delete.uid());
        synchronized (object) {
            boolean found;
            VersionValue versionValue = this.versionMap.getUnderLock(delete.uid().bytes());
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(delete.uid()) : (this.engineConfig.isEnableGcDeletes() && versionValue.delete() && this.engineConfig.getThreadPool().estimatedTimeInMillis() - versionValue.time() > this.engineConfig.getGcDeletesInMillis() ? -1L : versionValue.version());
            long expectedVersion = delete.version();
            if (delete.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
                if (delete.origin() == Engine.Operation.Origin.RECOVERY) {
                    return;
                }
                throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion, expectedVersion);
            }
            long updatedVersion = delete.versionType().updateVersion(currentVersion, expectedVersion);
            if (currentVersion == -1L) {
                found = false;
            } else if (versionValue != null && versionValue.delete()) {
                found = false;
            } else {
                this.indexWriter.deleteDocuments(new Term[]{delete.uid()});
                found = true;
            }
            delete.updateVersion(updatedVersion, found);
            Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
            this.versionMap.putUnderLock(delete.uid().bytes(), new DeleteVersionValue(updatedVersion, this.engineConfig.getThreadPool().estimatedTimeInMillis(), translogLocation));
            this.indexingService.postDeleteUnderLock(delete);
        }
    }

    @Override
    public void delete(Engine.DeleteByQuery delete) throws EngineException {
        block25: {
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                if (delete.origin() == Engine.Operation.Origin.RECOVERY) {
                    this.innerDelete(delete);
                    break block25;
                }
                try (Releasable r = this.throttle.acquireThrottle();){
                    this.innerDelete(delete);
                }
            }
        }
    }

    private void innerDelete(Engine.DeleteByQuery delete) throws EngineException {
        try {
            Query query = delete.nested() && delete.aliasFilter() != null ? new IncludeNestedDocsQuery((Query)new XFilteredQuery(delete.query(), delete.aliasFilter()), delete.parentFilter()) : (delete.nested() ? new IncludeNestedDocsQuery(delete.query(), delete.parentFilter()) : (delete.aliasFilter() != null ? new XFilteredQuery(delete.query(), delete.aliasFilter()) : delete.query()));
            this.indexWriter.deleteDocuments(new Query[]{query});
            this.translog.add(new Translog.DeleteByQuery(delete));
        }
        catch (Throwable t) {
            this.maybeFailEngine("delete_by_query", t);
            throw new DeleteByQueryFailedEngineException(this.shardId, delete, t);
        }
        this.refresh("delete_by_query");
    }

    @Override
    public void refresh(String source) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.updateIndexWriterSettings();
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (AlreadyClosedException e) {
            this.ensureOpen();
            this.maybeFailEngine("refresh", e);
        }
        catch (EngineClosedException e) {
            throw e;
        }
        catch (Throwable t) {
            this.failEngine("refresh failed", t);
            throw new RefreshFailedEngineException(this.shardId, t);
        }
        this.maybePruneDeletedTombstones();
        this.versionMapRefreshPending.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) throws EngineException {
        this.ensureOpen();
        if (this.indexWriter.hasUncommittedChanges()) {
            this.logger.trace("can't sync commit [{}]. have pending changes", syncId);
            return Engine.SyncedFlushResult.PENDING_OPERATIONS;
        }
        if (!expectedCommitId.equals(this.lastCommittedCommitInfo.commitId)) {
            this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", syncId);
            return Engine.SyncedFlushResult.COMMIT_MISMATCH;
        }
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            if (this.indexWriter.hasUncommittedChanges()) {
                this.logger.trace("can't sync commit [{}]. have pending changes", syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.PENDING_OPERATIONS;
                return syncedFlushResult;
            }
            if (!expectedCommitId.equals(this.lastCommittedCommitInfo.commitId)) {
                this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.COMMIT_MISMATCH;
                return syncedFlushResult;
            }
            this.logger.trace("starting sync commit [{}]", syncId);
            this.commitIndexWriter(this.indexWriter, this.translogIdGenerator.get(), syncId);
            this.logger.debug("successfully sync committed. sync id [{}].", syncId);
            this.store.incRef();
            try {
                SegmentInfos segmentCommitInfos = this.store.readLastCommittedSegmentsInfo();
                this.lastCommittedCommitInfo = new CommitInfo(segmentCommitInfos, Engine.CommitId.readCommitID(this.store, segmentCommitInfos));
            }
            finally {
                this.store.decRef();
            }
            Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.SUCCESS;
            return syncedFlushResult;
        }
        catch (IOException ex) {
            this.maybeFailEngine("sync commit", ex);
            throw new EngineException(this.shardId, "failed to sync commit", (Throwable)ex);
        }
    }

    @Override
    public Engine.CommitId flush() throws EngineException {
        return this.flush(false, false);
    }

    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        return this.flush(true, force, waitIfOngoing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Engine.CommitId flush(boolean commitTranslog, boolean force, boolean waitIfOngoing) throws EngineException {
        Engine.CommitId newCommitId;
        this.ensureOpen();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.updateIndexWriterSettings();
            if (!this.flushLock.tryLock()) {
                if (!waitIfOngoing) throw new FlushNotAllowedEngineException(this.shardId, "already flushing...");
                this.logger.trace("waiting for in-flight flush to finish", new Object[0]);
                this.flushLock.lock();
                this.logger.trace("acquired flush lock after blocking", new Object[0]);
            } else {
                this.logger.trace("acquired flush lock immediately", new Object[0]);
            }
            try {
                if (commitTranslog) {
                    if (this.onGoingRecoveries.get() > 0) {
                        throw new FlushNotAllowedEngineException(this.shardId, "recovery is in progress, flush is not allowed");
                    }
                    if (this.indexWriter.hasUncommittedChanges() || force) {
                        try {
                            long translogId = this.translogIdGenerator.incrementAndGet();
                            this.translog.newTransientTranslog(translogId);
                            this.logger.trace("starting commit for flush; commitTranslog=true", new Object[0]);
                            this.commitIndexWriter(this.indexWriter, translogId, null);
                            this.logger.trace("finished commit for flush", new Object[0]);
                            this.refresh("version_table_flush");
                            this.translog.makeTransientCurrent();
                        }
                        catch (Throwable e) {
                            this.translog.revertTransient();
                            throw new FlushFailedEngineException(this.shardId, e);
                        }
                    }
                } else {
                    try {
                        long translogId = this.translog.currentId();
                        this.logger.trace("starting commit for flush; commitTranslog=false", new Object[0]);
                        this.commitIndexWriter(this.indexWriter, translogId, null);
                        this.logger.trace("finished commit for flush", new Object[0]);
                    }
                    catch (Throwable e) {
                        throw new FlushFailedEngineException(this.shardId, e);
                    }
                }
                this.store.incRef();
                try {
                    SegmentInfos segmentCommitInfos = this.store.readLastCommittedSegmentsInfo();
                    this.lastCommittedCommitInfo = new CommitInfo(segmentCommitInfos, Engine.CommitId.readCommitID(this.store, segmentCommitInfos));
                }
                catch (Throwable e) {
                    if (!this.isClosed.get()) {
                        this.logger.warn("failed to read latest segment infos on flush", e, new Object[0]);
                        if (Lucene.isCorruptionException(e)) {
                            throw new FlushFailedEngineException(this.shardId, e);
                        }
                    }
                }
                finally {
                    this.store.decRef();
                }
                newCommitId = this.lastCommittedCommitInfo.commitId;
            }
            catch (FlushFailedEngineException ex) {
                this.maybeFailEngine("flush", ex);
                throw ex;
            }
            finally {
                this.flushLock.unlock();
            }
        }
        if (!this.engineConfig.isEnableGcDeletes()) return newCommitId;
        this.pruneDeletedTombstones();
        return newCommitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneDeletedTombstones() {
        long timeMSec = this.engineConfig.getThreadPool().estimatedTimeInMillis();
        for (Map.Entry<BytesRef, VersionValue> entry : this.versionMap.getAllTombstones()) {
            BytesRef uid = entry.getKey();
            Object object = this.dirtyLock(uid);
            synchronized (object) {
                VersionValue versionValue = this.versionMap.getTombstoneUnderLock(uid);
                if (versionValue != null && timeMSec - versionValue.time() > this.engineConfig.getGcDeletesInMillis()) {
                    this.versionMap.removeTombstoneUnderLock(uid);
                }
            }
        }
        this.lastDeleteVersionPruneTimeMSec = timeMSec;
    }

    @Override
    public boolean possibleMergeNeeded() {
        IndexWriter writer = this.indexWriter;
        if (writer == null) {
            return false;
        }
        return this.possibleMergeNeeded || writer.hasPendingMerges();
    }

    @Override
    public void maybeMerge() throws EngineException {
        if (!this.possibleMergeNeeded()) {
            return;
        }
        this.possibleMergeNeeded = false;
        try (ReleasableLock _ = this.readLock.acquire();){
            this.indexWriter.maybeMerge();
        }
        catch (Throwable t) {
            this.maybeFailEngine("maybe_merge", t);
            throw new OptimizeFailedEngineException(this.shardId, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments) throws EngineException {
        assert (this.indexWriter.getConfig().getMergePolicy() instanceof ElasticsearchMergePolicy) : "MergePolicy is " + this.indexWriter.getConfig().getMergePolicy().getClass().getName();
        ElasticsearchMergePolicy mp = (ElasticsearchMergePolicy)this.indexWriter.getConfig().getMergePolicy();
        this.optimizeLock.lock();
        try {
            this.ensureOpen();
            if (upgrade) {
                this.logger.info("starting segment upgrade upgradeOnlyAncientSegments={}", upgradeOnlyAncientSegments);
                mp.setUpgradeInProgress(true, upgradeOnlyAncientSegments);
            }
            this.store.incRef();
            try {
                if (onlyExpungeDeletes) {
                    assert (!upgrade);
                    this.indexWriter.forceMergeDeletes(true);
                } else if (maxNumSegments <= 0) {
                    assert (!upgrade);
                    this.indexWriter.maybeMerge();
                } else {
                    this.indexWriter.forceMerge(maxNumSegments, true);
                }
                if (flush) {
                    this.flush(true, true, true);
                }
                if (upgrade) {
                    this.logger.info("finished segment upgrade", new Object[0]);
                }
            }
            finally {
                this.store.decRef();
            }
        }
        catch (Throwable t) {
            OptimizeFailedEngineException ex = new OptimizeFailedEngineException(this.shardId, t);
            this.maybeFailEngine("force merge", ex);
            throw ex;
        }
        finally {
            try {
                mp.setUpgradeInProgress(false, false);
            }
            finally {
                this.optimizeLock.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SnapshotIndexCommit snapshotIndex() throws EngineException {
        this.logger.trace("start flush for snapshot", new Object[0]);
        this.flush(false, false, true);
        this.logger.trace("finish flush for snapshot", new Object[0]);
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.logger.trace("pulling snapshot", new Object[0]);
            SnapshotIndexCommit snapshotIndexCommit = this.deletionPolicy.snapshot();
            return snapshotIndexCommit;
        }
        catch (IOException e) {
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
    }

    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        Translog.Snapshot phase2Snapshot;
        SnapshotIndexCommit phase1Snapshot;
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            this.onGoingRecoveries.startRecovery();
        }
        try {
            this.logger.trace("[pre-phase1] performing deletion policy snapshot", new Object[0]);
            phase1Snapshot = this.deletionPolicy.snapshot();
        }
        catch (Throwable e) {
            this.maybeFailEngine("recovery", e);
            Releasables.closeWhileHandlingException(this.onGoingRecoveries);
            throw new RecoveryEngineException(this.shardId, 1, "Snapshot failed", e);
        }
        try {
            this.logger.trace("[phase1] performing phase 1 recovery (file recovery)", new Object[0]);
            recoveryHandler.phase1(phase1Snapshot);
        }
        catch (Throwable e) {
            this.maybeFailEngine("recovery phase 1 (file transfer)", e);
            Releasables.closeWhileHandlingException(phase1Snapshot, this.onGoingRecoveries);
            throw new RecoveryEngineException(this.shardId, 1, "Execution failed", this.wrapIfClosed(e));
        }
        try {
            this.logger.trace("[pre-phase2] performing translog snapshot", new Object[0]);
            phase2Snapshot = this.translog.snapshot();
        }
        catch (Throwable e) {
            this.maybeFailEngine("translog snapshot", e);
            Releasables.closeWhileHandlingException(phase1Snapshot, this.onGoingRecoveries);
            throw new RecoveryEngineException(this.shardId, 2, "Snapshot failed", this.wrapIfClosed(e));
        }
        try {
            this.logger.trace("[phase2] performing phase 2 recovery (translog replay)", new Object[0]);
            recoveryHandler.phase2(phase2Snapshot);
        }
        catch (Throwable e) {
            this.maybeFailEngine("recovery phase 2 (snapshot transfer)", e);
            Releasables.closeWhileHandlingException(phase1Snapshot, phase2Snapshot, this.onGoingRecoveries);
            throw new RecoveryEngineException(this.shardId, 2, "Execution failed", this.wrapIfClosed(e));
        }
        this.writeLock.acquire();
        Translog.Snapshot phase3Snapshot = null;
        boolean success = false;
        try {
            this.ensureOpen();
            this.logger.trace("[pre-phase3] performing translog snapshot", new Object[0]);
            phase3Snapshot = this.translog.snapshot(phase2Snapshot);
            this.logger.trace("[phase3] performing phase 3 recovery (translog replay under write lock)", new Object[0]);
            recoveryHandler.phase3(phase3Snapshot);
            success = true;
        }
        catch (Throwable e) {
            try {
                this.maybeFailEngine("recovery phase 3 (snapshot transfer)", e);
                throw new RecoveryEngineException(this.shardId, 3, "Execution failed", this.wrapIfClosed(e));
            }
            catch (Throwable throwable) {
                Releasables.close(success, phase1Snapshot, phase2Snapshot, phase3Snapshot, this.onGoingRecoveries, this.writeLock);
                throw throwable;
            }
        }
        Releasables.close(success, phase1Snapshot, phase2Snapshot, phase3Snapshot, this.onGoingRecoveries, this.writeLock);
        this.logger.trace("[post-recovery] recovery complete", new Object[0]);
    }

    @Override
    protected boolean maybeFailEngine(String source, Throwable t) {
        boolean shouldFail = super.maybeFailEngine(source, t);
        if (shouldFail) {
            return true;
        }
        if (t instanceof AlreadyClosedException) {
            if (!this.isOpen(this.indexWriter) && this.getTragicException(this.indexWriter) != null) {
                this.failEngine("already closed by tragic event", this.getTragicException(this.indexWriter));
            }
            return true;
        }
        if (t != null && !this.isOpen(this.indexWriter) && this.getTragicException(this.indexWriter) == t) {
            this.failEngine(source, t);
            return true;
        }
        return false;
    }

    private boolean isOpen(IndexWriter writer) {
        try {
            writer.ramBytesUsed();
            return true;
        }
        catch (AlreadyClosedException ex) {
            return false;
        }
    }

    private Throwable getTragicException(IndexWriter writer) {
        try {
            writer.ramBytesUsed();
            return null;
        }
        catch (AlreadyClosedException ex) {
            return ex.getCause();
        }
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedCommitInfo.segmentInfos;
    }

    @Override
    protected final void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(this.versionMap.ramBytesUsed());
        stats.addIndexWriterMemoryInBytes(this.indexWriter.ramBytesUsed());
        stats.addIndexWriterMaxMemoryInBytes((long)(this.indexWriter.getConfig().getRAMBufferSizeMB() * 1024.0 * 1024.0));
    }

    @Override
    public List<Segment> segments() {
        try (ReleasableLock lock = this.readLock.acquire();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedCommitInfo.segmentInfos);
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block10: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment : segmentsArr) {
                        if (!segment.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment.mergeId = onGoingMerge.getId();
                        continue block10;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason) throws ElasticsearchException {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                try {
                    this.translog.sync();
                }
                catch (IOException ex) {
                    this.logger.warn("failed to sync translog", new Object[0]);
                }
                this.versionMap.clear();
                this.logger.trace("close searcherManager", new Object[0]);
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.searcherManager});
                }
                catch (Throwable t) {
                    this.logger.warn("Failed to close SearcherManager", t, new Object[0]);
                }
                this.logger.trace("rollback indexWriter", new Object[0]);
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException e) {
                    // empty catch block
                }
                this.logger.trace("rollback indexWriter done", new Object[0]);
                this.store.decRef();
                this.mergeScheduler.removeListener(this.mergeSchedulerListener);
                this.mergeScheduler.removeFailureListener(this.mergeSchedulerFailureListener);
            }
            catch (Throwable e) {
                try {
                    this.logger.warn("failed to rollback writer on close", e, new Object[0]);
                    this.store.decRef();
                    this.mergeScheduler.removeListener(this.mergeSchedulerListener);
                    this.mergeScheduler.removeFailureListener(this.mergeSchedulerFailureListener);
                }
                catch (Throwable throwable) {
                    this.store.decRef();
                    this.mergeScheduler.removeListener(this.mergeSchedulerListener);
                    this.mergeScheduler.removeFailureListener(this.mergeSchedulerFailureListener);
                    this.logger.debug("engine closed [{}]", reason);
                    throw throwable;
                }
                this.logger.debug("engine closed [{}]", reason);
            }
            this.logger.debug("engine closed [{}]", reason);
        }
    }

    @Override
    public boolean hasUncommittedChanges() {
        return this.indexWriter.hasUncommittedChanges();
    }

    @Override
    protected SearcherManager getSearcherManager() {
        return this.searcherManager;
    }

    private Object dirtyLock(BytesRef uid) {
        int hash = DjbHashFunction.DJB_HASH(uid.bytes, uid.offset, uid.length);
        return this.dirtyLocks[MathUtils.mod(hash, this.dirtyLocks.length)];
    }

    private Object dirtyLock(Term uid) {
        return this.dirtyLock(uid.bytes());
    }

    private long loadCurrentVersionFromIndex(Term uid) throws IOException {
        try (Engine.Searcher searcher = this.acquireSearcher("load_version");){
            long l = Versions.loadVersion(searcher.reader(), uid);
            return l;
        }
    }

    private IndexWriter createWriter() throws IOException {
        try {
            boolean create = !Lucene.indexExists(this.store.directory());
            IndexWriterConfig iwc = new IndexWriterConfig(Lucene.VERSION, this.engineConfig.getAnalyzer());
            iwc.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
            iwc.setIndexDeletionPolicy((IndexDeletionPolicy)this.deletionPolicy);
            iwc.setInfoStream((InfoStream)new LoggerInfoStream(this.logger));
            iwc.setMergeScheduler(this.mergeScheduler.newMergeScheduler());
            Object mergePolicy = this.mergePolicyProvider.getMergePolicy();
            mergePolicy = new ElasticsearchMergePolicy((MergePolicy)mergePolicy);
            iwc.setMergePolicy(mergePolicy);
            iwc.setSimilarity(this.engineConfig.getSimilarity());
            iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().mbFrac());
            iwc.setMaxThreadStates(this.engineConfig.getIndexConcurrency());
            iwc.setCodec(this.engineConfig.getCodec());
            iwc.setWriteLockTimeout(5000L);
            iwc.setUseCompoundFile(this.engineConfig.isCompoundOnFlush());
            iwc.setCheckIntegrityAtMerge(this.engineConfig.isChecksumOnMerge());
            iwc.setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

                public void warm(AtomicReader reader) throws IOException {
                    block5: {
                        try {
                            assert (Engine.isMergedSegment(reader));
                            if (InternalEngine.this.warmer != null) {
                                Engine.Searcher searcher = new Engine.Searcher("warmer", new IndexSearcher((IndexReader)reader));
                                IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, searcher);
                                InternalEngine.this.warmer.warmNewReaders(context);
                            }
                        }
                        catch (Throwable t) {
                            if (!InternalEngine.this.isClosed.get()) {
                                InternalEngine.this.logger.warn("Warm-up failed", t, new Object[0]);
                            }
                            if (!(t instanceof Error)) break block5;
                            throw (Error)t;
                        }
                    }
                }
            });
            return new IndexWriter(this.store.directory(), iwc);
        }
        catch (LockObtainFailedException ex) {
            boolean isLocked = IndexWriter.isLocked((Directory)this.store.directory());
            this.logger.warn("Could not lock IndexWriter isLocked [{}]", ex, isLocked);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeUpgrade3xSegments(Store store) throws EngineException {
        block8: {
            store.incRef();
            try {
                boolean doUpgrade;
                try {
                    doUpgrade = Lucene.indexNeeds3xUpgrading(store.directory());
                }
                catch (IOException ex) {
                    throw new EngineCreationFailureException(this.shardId, "failed to read commit", (Throwable)ex);
                }
                if (doUpgrade) {
                    try {
                        Lucene.upgradeLucene3xSegmentsMetadata(store.directory());
                    }
                    catch (IOException ex) {
                        throw new EngineCreationFailureException(this.shardId, "failed to upgrade 3.x segments_N commit point", (Throwable)ex);
                    }
                    this.logger.debug("upgraded current 3.x segments file on startup", new Object[0]);
                    break block8;
                }
                this.logger.debug("segments file is already after 3.x; not upgrading", new Object[0]);
            }
            finally {
                store.decRef();
            }
        }
    }

    public void activateThrottling() {
        this.throttle.activate();
    }

    public void deactivateThrottling() {
        this.throttle.deactivate();
    }

    long getGcDeletesInMillis() {
        return this.engineConfig.getGcDeletesInMillis();
    }

    LiveIndexWriterConfig getCurrentIndexWriterConfig() {
        return this.indexWriter.getConfig();
    }

    private void commitIndexWriter(IndexWriter writer, long translogID, String syncId) throws IOException {
        try {
            HashMap<String, String> commitData = new HashMap<String, String>(2);
            commitData.put("translog_id", Long.toString(translogID));
            if (syncId != null) {
                commitData.put("sync_id", syncId);
            }
            writer.setCommitData(commitData);
            writer.commit();
        }
        catch (Throwable ex) {
            this.failEngine("lucene commit failed", ex);
            throw ex;
        }
    }

    private static class CommitInfo {
        private final SegmentInfos segmentInfos;
        private final Engine.CommitId commitId;

        private CommitInfo(SegmentInfos segmentInfos, Engine.CommitId commitId) {
            this.segmentInfos = segmentInfos;
            this.commitId = commitId;
        }
    }

    class MergeSchedulerListener
    implements MergeSchedulerProvider.Listener {
        private final AtomicInteger numMergesInFlight = new AtomicInteger(0);
        private final AtomicBoolean isThrottling = new AtomicBoolean();

        MergeSchedulerListener() {
        }

        @Override
        public synchronized void beforeMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMerges();
            if (this.numMergesInFlight.incrementAndGet() > maxNumMerges && !this.isThrottling.getAndSet(true)) {
                InternalEngine.this.logger.info("now throttling indexing: numMergesInFlight={}, maxNumMerges={}", this.numMergesInFlight, maxNumMerges);
                InternalEngine.this.indexingService.throttlingActivated();
                InternalEngine.this.activateThrottling();
            }
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMerges();
            if (this.numMergesInFlight.decrementAndGet() < maxNumMerges && this.isThrottling.getAndSet(false)) {
                InternalEngine.this.logger.info("stop throttling indexing: numMergesInFlight={}, maxNumMerges={}", this.numMergesInFlight, maxNumMerges);
                InternalEngine.this.indexingService.throttlingDeactivated();
                InternalEngine.this.deactivateThrottling();
            }
        }
    }

    class FailEngineOnMergeFailure
    implements MergeSchedulerProvider.FailureListener {
        FailEngineOnMergeFailure() {
        }

        @Override
        public void onFailedMerge(MergePolicy.MergeException e) {
            if (Lucene.isCorruptionException((Throwable)e)) {
                if (InternalEngine.this.engineConfig.isFailEngineOnCorruption()) {
                    InternalEngine.this.failEngine("corrupt file detected source: [merge]", (Throwable)e);
                } else {
                    InternalEngine.this.logger.warn("corrupt file detected source: [merge] but [{}] is set to [{}]", (Throwable)e, "index.fail_on_corruption", InternalEngine.this.engineConfig.isFailEngineOnCorruption());
                }
            } else if (InternalEngine.this.engineConfig.isFailOnMergeFailure()) {
                InternalEngine.this.failEngine("merge exception", (Throwable)e);
            }
        }
    }

    class SearchFactory
    extends EngineSearcherFactory {
        SearchFactory(EngineConfig engineConfig) {
            super(engineConfig);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IndexSearcher newSearcher(IndexReader reader) throws IOException {
            IndexSearcher searcher = new IndexSearcher(reader);
            searcher.setSimilarity(InternalEngine.this.engineConfig.getSimilarity());
            if (InternalEngine.this.warmer == null) return searcher;
            IndexSearcher newSearcher = null;
            boolean closeNewSearcher = false;
            try {
                if (InternalEngine.this.searcherManager == null) {
                    newSearcher = searcher;
                } else {
                    try (Engine.Searcher currentSearcher = InternalEngine.this.acquireSearcher("search_factory");){
                        ArrayList<AtomicReader> readers = Lists.newArrayList();
                        for (AtomicReaderContext newReaderContext : searcher.getIndexReader().leaves()) {
                            if (Engine.isMergedSegment(newReaderContext.reader())) continue;
                            boolean found = false;
                            for (AtomicReaderContext currentReaderContext : currentSearcher.reader().leaves()) {
                                if (!currentReaderContext.reader().getCoreCacheKey().equals(newReaderContext.reader().getCoreCacheKey())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            readers.add(newReaderContext.reader());
                        }
                        if (!readers.isEmpty()) {
                            newSearcher = new IndexSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[readers.size()]), false));
                            closeNewSearcher = true;
                        }
                    }
                }
                if (newSearcher != null) {
                    IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, new Engine.Searcher("warmer", newSearcher));
                    InternalEngine.this.warmer.warmNewReaders(context);
                }
                InternalEngine.this.warmer.warmTopReader(new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, new Engine.Searcher("warmer", searcher)));
                if (newSearcher == null || !closeNewSearcher) return searcher;
            }
            catch (Throwable e) {
                try {
                    if (!InternalEngine.this.isClosed.get()) {
                        InternalEngine.this.logger.warn("failed to prepare/warm", e, new Object[0]);
                    }
                    if (newSearcher == null || !closeNewSearcher) return searcher;
                }
                catch (Throwable throwable) {
                    if (newSearcher == null || !closeNewSearcher) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                return searcher;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
            return searcher;
        }
    }
}

