/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import java.util.Comparator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;

abstract class PriorityComparator
implements Comparator<ShardRouting> {
    PriorityComparator() {
    }

    @Override
    public final int compare(ShardRouting o1, ShardRouting o2) {
        String o1Index = o1.index();
        String o2Index = o2.index();
        int cmp = 0;
        if (!o1Index.equals(o2Index)) {
            Settings settingsO1 = this.getIndexSettings(o1Index);
            Settings settingsO2 = this.getIndexSettings(o2Index);
            cmp = Long.compare(this.priority(settingsO2), this.priority(settingsO1));
            if (cmp == 0 && (cmp = Long.compare(this.timeCreated(settingsO2), this.timeCreated(settingsO1))) == 0) {
                cmp = o2Index.compareTo(o1Index);
            }
        }
        return cmp;
    }

    private int priority(Settings settings) {
        return settings.getAsInt("index.priority", (Integer)1);
    }

    private long timeCreated(Settings settings) {
        return settings.getAsLong("index.creation_date", (Long)-1L);
    }

    protected abstract Settings getIndexSettings(String var1);
}

