/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import org.apache.lucene.search.FuzzyQuery;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentParser;

public final class Fuzziness
implements ToXContent {
    public static final XContentBuilderString X_FIELD_NAME = new XContentBuilderString("fuzziness");
    public static final Fuzziness ZERO = new Fuzziness(0);
    public static final Fuzziness ONE = new Fuzziness(1);
    public static final Fuzziness TWO = new Fuzziness(2);
    public static final Fuzziness AUTO = new Fuzziness("AUTO");
    public static final ParseField FIELD = new ParseField(X_FIELD_NAME.camelCase().getValue(), new String[0]);
    private final Object fuzziness;

    private Fuzziness(int fuzziness) {
        Preconditions.checkArgument(fuzziness >= 0 && fuzziness <= 2, "Valid edit distances are [0, 1, 2] but was [" + fuzziness + "]");
        this.fuzziness = fuzziness;
    }

    private Fuzziness(float fuzziness) {
        Preconditions.checkArgument((double)fuzziness >= 0.0 && fuzziness < 1.0f, "Valid similarities must be in the interval [0..1] but was [" + fuzziness + "]");
        this.fuzziness = Float.valueOf(fuzziness);
    }

    private Fuzziness(String fuzziness) {
        this.fuzziness = fuzziness;
    }

    public static Fuzziness fromSimilarity(float similarity) {
        return new Fuzziness(similarity);
    }

    public static Fuzziness fromEdits(int edits) {
        return new Fuzziness(edits);
    }

    public static Fuzziness build(Object fuzziness) {
        if (fuzziness instanceof Fuzziness) {
            return (Fuzziness)fuzziness;
        }
        String string = fuzziness.toString();
        if (AUTO.asString().equalsIgnoreCase(string)) {
            return AUTO;
        }
        return new Fuzziness(string);
    }

    public static Fuzziness parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        switch (token) {
            case VALUE_STRING: 
            case VALUE_NUMBER: {
                String fuzziness = parser.text();
                if (AUTO.asString().equalsIgnoreCase(fuzziness)) {
                    return AUTO;
                }
                try {
                    int minimumSimilarity = Integer.parseInt(fuzziness);
                    switch (minimumSimilarity) {
                        case 0: {
                            return ZERO;
                        }
                        case 1: {
                            return ONE;
                        }
                        case 2: {
                            return TWO;
                        }
                    }
                    return Fuzziness.build(fuzziness);
                }
                catch (NumberFormatException ex) {
                    return Fuzziness.build(fuzziness);
                }
            }
        }
        throw new ElasticsearchIllegalArgumentException("Can't parse fuzziness on token: [" + (Object)((Object)token) + "]");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean includeFieldName) throws IOException {
        if (includeFieldName) {
            builder.field(X_FIELD_NAME, this.fuzziness);
        } else {
            builder.value(this.fuzziness);
        }
        return builder;
    }

    public int asDistance() {
        return this.asDistance(null);
    }

    public int asDistance(String text) {
        if (this.fuzziness instanceof String && this == AUTO) {
            int len = this.termLen(text);
            if (len <= 2) {
                return 0;
            }
            if (len > 5) {
                return 2;
            }
            return 1;
        }
        return FuzzyQuery.floatToEdits((float)this.asFloat(), (int)this.termLen(text));
    }

    public TimeValue asTimeValue() {
        if (this == AUTO) {
            return TimeValue.timeValueMillis(1L);
        }
        return TimeValue.parseTimeValue(this.fuzziness.toString(), null);
    }

    public long asLong() {
        if (this == AUTO) {
            return 1L;
        }
        try {
            return Long.parseLong(this.fuzziness.toString());
        }
        catch (NumberFormatException ex) {
            return (long)Double.parseDouble(this.fuzziness.toString());
        }
    }

    public int asInt() {
        if (this == AUTO) {
            return 1;
        }
        try {
            return Integer.parseInt(this.fuzziness.toString());
        }
        catch (NumberFormatException ex) {
            return (int)Float.parseFloat(this.fuzziness.toString());
        }
    }

    public short asShort() {
        if (this == AUTO) {
            return 1;
        }
        try {
            return Short.parseShort(this.fuzziness.toString());
        }
        catch (NumberFormatException ex) {
            return (short)Float.parseFloat(this.fuzziness.toString());
        }
    }

    public byte asByte() {
        if (this == AUTO) {
            return 1;
        }
        try {
            return Byte.parseByte(this.fuzziness.toString());
        }
        catch (NumberFormatException ex) {
            return (byte)Float.parseFloat(this.fuzziness.toString());
        }
    }

    public double asDouble() {
        if (this == AUTO) {
            return 1.0;
        }
        return Double.parseDouble(this.fuzziness.toString());
    }

    public float asFloat() {
        if (this == AUTO) {
            return 1.0f;
        }
        return Float.parseFloat(this.fuzziness.toString());
    }

    public float asSimilarity() {
        return this.asSimilarity(null);
    }

    public float asSimilarity(String text) {
        if (this == AUTO) {
            int len = this.termLen(text);
            if (len <= 2) {
                return 0.0f;
            }
            if (len > 5) {
                return 0.5f;
            }
            return 0.66f;
        }
        if (this.fuzziness instanceof Float) {
            return ((Float)this.fuzziness).floatValue();
        }
        if (this.fuzziness instanceof Integer) {
            int dist = Math.min((Integer)this.fuzziness, 2);
            return Math.min(0.999f, Math.max(0.0f, 1.0f - (float)dist / (float)this.termLen(text)));
        }
        float similarity = Float.parseFloat(this.fuzziness.toString());
        if (similarity >= 0.0f && similarity < 1.0f) {
            return similarity;
        }
        throw new ElasticsearchIllegalArgumentException("Can't get similarity from fuzziness [" + this.fuzziness + "]");
    }

    private int termLen(String text) {
        return text == null ? 5 : text.codePointCount(0, text.length());
    }

    public String asString() {
        return this.fuzziness.toString();
    }
}

