/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class WeightFactorFunction
extends ScoreFunction {
    private static final ScoreFunction SCORE_ONE = new ScoreOne(CombineFunction.MULT);
    private final ScoreFunction scoreFunction;
    private float weight = 1.0f;

    public WeightFactorFunction(float weight, ScoreFunction scoreFunction) {
        super(CombineFunction.MULT);
        if (scoreFunction instanceof BoostScoreFunction) {
            throw new ElasticsearchIllegalArgumentException("'boost_factor' and 'weight' cannot be used together. Use 'weight'.");
        }
        this.scoreFunction = scoreFunction == null ? SCORE_ONE : scoreFunction;
        this.weight = weight;
    }

    public WeightFactorFunction(float weight) {
        super(CombineFunction.MULT);
        this.scoreFunction = SCORE_ONE;
        this.weight = weight;
    }

    @Override
    public void setNextReader(AtomicReaderContext context) {
        this.scoreFunction.setNextReader(context);
    }

    @Override
    public double score(int docId, float subQueryScore) {
        return this.scoreFunction.score(docId, subQueryScore) * (double)this.getWeight();
    }

    @Override
    public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
        Explanation functionExplanation = this.scoreFunction.explainScore(docId, subQueryScore);
        ComplexExplanation functionScoreExplanation = new ComplexExplanation(true, functionExplanation.getValue() * this.getWeight(), "product of:");
        functionScoreExplanation.addDetail(functionExplanation);
        functionScoreExplanation.addDetail(this.explainWeight());
        return functionScoreExplanation;
    }

    public Explanation explainWeight() {
        return new Explanation(this.getWeight(), "weight");
    }

    public float getWeight() {
        return this.weight;
    }

    private static class ScoreOne
    extends ScoreFunction {
        protected ScoreOne(CombineFunction scoreCombiner) {
            super(scoreCombiner);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) {
        }

        @Override
        public double score(int docId, float subQueryScore) {
            return 1.0;
        }

        @Override
        public Explanation explainScore(int docId, Explanation subQueryScore) {
            return new Explanation(1.0f, "constant score 1.0 - no function provided");
        }
    }
}

