/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public abstract class MatchDocIdSetIterator
extends DocIdSetIterator {
    private final int maxDoc;
    private int doc = -1;

    public MatchDocIdSetIterator(int maxDoc) {
        this.maxDoc = maxDoc;
    }

    protected abstract boolean matchDoc(int var1);

    public int docID() {
        return this.doc;
    }

    public int nextDoc() throws IOException {
        do {
            ++this.doc;
            if (this.doc < this.maxDoc) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        } while (!this.matchDoc(this.doc));
        return this.doc;
    }

    public int advance(int target) throws IOException {
        if (target >= this.maxDoc) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = target;
        while (!this.matchDoc(this.doc)) {
            ++this.doc;
            if (this.doc < this.maxDoc) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        return this.doc;
    }
}

