/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cli;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Locale;
import org.elasticsearch.common.cli.commons.CommandLine;

public abstract class Terminal {
    public static final String DEBUG_SYSTEM_PROPERTY = "es.cli.debug";
    public static final Terminal DEFAULT = ConsoleTerminal.supported() ? new ConsoleTerminal() : new SystemTerminal();
    private Verbosity verbosity = Verbosity.NORMAL;
    private final boolean isDebugEnabled;

    public Terminal() {
        this(Verbosity.NORMAL);
    }

    public Terminal(Verbosity verbosity) {
        this.verbosity = verbosity;
        this.isDebugEnabled = "true".equals(System.getProperty(DEBUG_SYSTEM_PROPERTY, "false"));
    }

    public void verbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public Verbosity verbosity() {
        return this.verbosity;
    }

    public abstract String readText(String var1, Object ... var2);

    public abstract char[] readSecret(String var1, Object ... var2);

    protected abstract void printStackTrace(Throwable var1);

    public void println() {
        this.println(Verbosity.NORMAL);
    }

    public void println(String msg, Object ... args) {
        this.println(Verbosity.NORMAL, msg, args);
    }

    public void print(String msg, Object ... args) {
        this.print(Verbosity.NORMAL, msg, args);
    }

    public void println(Verbosity verbosity) {
        this.println(verbosity, "", new Object[0]);
    }

    public void println(Verbosity verbosity, String msg, Object ... args) {
        this.print(verbosity, msg + System.lineSeparator(), args);
    }

    public void print(Verbosity verbosity, String msg, Object ... args) {
        if (this.verbosity.enabled(verbosity)) {
            this.doPrint(msg, args);
        }
    }

    public void printError(String msg, Object ... args) {
        this.println(Verbosity.SILENT, "ERROR: " + msg, args);
    }

    public void printError(Throwable t) {
        this.printError("%s", t.getMessage());
        if (this.isDebugEnabled) {
            this.printStackTrace(t);
        }
    }

    public void printWarn(String msg, Object ... args) {
        this.println(Verbosity.SILENT, "WARN: " + msg, args);
    }

    protected abstract void doPrint(String var1, Object ... var2);

    public abstract PrintWriter writer();

    private static class SystemTerminal
    extends Terminal {
        private final PrintWriter printWriter = new PrintWriter(System.out);

        private SystemTerminal() {
        }

        @Override
        public void doPrint(String msg, Object ... args) {
            System.out.print(String.format(Locale.ROOT, msg, args));
        }

        @Override
        public String readText(String text, Object ... args) {
            this.print(text, args);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            try {
                return reader.readLine();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public char[] readSecret(String text, Object ... args) {
            return this.readText(text, args).toCharArray();
        }

        @Override
        public void printStackTrace(Throwable t) {
            t.printStackTrace(this.printWriter);
        }

        @Override
        public PrintWriter writer() {
            return this.printWriter;
        }
    }

    private static class ConsoleTerminal
    extends Terminal {
        final Console console = System.console();

        private ConsoleTerminal() {
        }

        static boolean supported() {
            return System.console() != null;
        }

        @Override
        public void doPrint(String msg, Object ... args) {
            this.console.printf(msg, args);
            this.console.flush();
        }

        @Override
        public String readText(String text, Object ... args) {
            return this.console.readLine(text, args);
        }

        @Override
        public char[] readSecret(String text, Object ... args) {
            return this.console.readPassword(text, args);
        }

        @Override
        public PrintWriter writer() {
            return this.console.writer();
        }

        @Override
        public void printStackTrace(Throwable t) {
            t.printStackTrace(this.console.writer());
        }
    }

    public static enum Verbosity {
        SILENT(0),
        NORMAL(1),
        VERBOSE(2);

        private final int level;

        private Verbosity(int level) {
            this.level = level;
        }

        public boolean enabled(Verbosity verbosity) {
            return this.level >= verbosity.level;
        }

        public static Verbosity resolve(CommandLine cli) {
            if (cli.hasOption("s")) {
                return SILENT;
            }
            if (cli.hasOption("v")) {
                return VERBOSE;
            }
            return NORMAL;
        }
    }
}

