/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class UnassignedInfo
implements ToXContent {
    public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime");
    public static final String INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING = "index.unassigned.node_left.delayed_timeout";
    private static final TimeValue DEFAULT_DELAYED_NODE_LEFT_TIMEOUT = TimeValue.timeValueMinutes(1L);
    private final Reason reason;
    private final long timestamp;
    private final String details;

    public UnassignedInfo(Reason reason, String details) {
        this(reason, System.currentTimeMillis(), details);
    }

    private UnassignedInfo(Reason reason, long timestamp, String details) {
        this.reason = reason;
        this.timestamp = timestamp;
        this.details = details;
    }

    UnassignedInfo(StreamInput in) throws IOException {
        this.reason = Reason.values()[in.readByte()];
        this.timestamp = in.readLong();
        this.details = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte((byte)this.reason.ordinal());
        out.writeLong(this.timestamp);
        out.writeOptionalString(this.details);
    }

    public UnassignedInfo readFrom(StreamInput in) throws IOException {
        return new UnassignedInfo(in);
    }

    public Reason getReason() {
        return this.reason;
    }

    public long getTimestampInMillis() {
        return this.timestamp;
    }

    @Nullable
    public String getDetails() {
        return this.details;
    }

    public long getAllocationDelayTimeoutSetting(Settings settings, Settings indexSettings) {
        if (this.reason != Reason.NODE_LEFT) {
            return 0L;
        }
        TimeValue delayTimeout = indexSettings.getAsTime(INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING, settings.getAsTime(INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING, DEFAULT_DELAYED_NODE_LEFT_TIMEOUT));
        return Math.max(0L, delayTimeout.millis());
    }

    public long getDelayAllocationExpirationIn(Settings settings, Settings indexSettings) {
        long delayTimeout = this.getAllocationDelayTimeoutSetting(settings, indexSettings);
        if (delayTimeout == 0L) {
            return 0L;
        }
        long delta = System.currentTimeMillis() - this.timestamp;
        if (delta < 0L) {
            return 0L;
        }
        return delayTimeout - delta;
    }

    public static int getNumberOfDelayedUnassigned(Settings settings, ClusterState state) {
        int count = 0;
        for (ShardRouting shard : state.routingTable().shardsWithState(ShardRoutingState.UNASSIGNED)) {
            if (shard.primary()) continue;
            IndexMetaData indexMetaData = state.metaData().index(shard.getIndex());
            long delay = shard.unassignedInfo().getDelayAllocationExpirationIn(settings, indexMetaData.getSettings());
            if (delay <= 0L) continue;
            ++count;
        }
        return count;
    }

    public static long findSmallestDelayedAllocationSetting(Settings settings, ClusterState state) {
        long nextDelaySetting = Long.MAX_VALUE;
        for (ShardRouting shard : state.routingTable().shardsWithState(ShardRoutingState.UNASSIGNED)) {
            if (shard.primary()) continue;
            IndexMetaData indexMetaData = state.metaData().index(shard.getIndex());
            long delayTimeoutSetting = shard.unassignedInfo().getAllocationDelayTimeoutSetting(settings, indexMetaData.getSettings());
            if (delayTimeoutSetting <= 0L || delayTimeoutSetting >= nextDelaySetting) continue;
            nextDelaySetting = delayTimeoutSetting;
        }
        return nextDelaySetting == Long.MAX_VALUE ? 0L : nextDelaySetting;
    }

    public static long findNextDelayedAllocationIn(Settings settings, ClusterState state) {
        long nextDelay = Long.MAX_VALUE;
        for (ShardRouting shard : state.routingTable().shardsWithState(ShardRoutingState.UNASSIGNED)) {
            if (shard.primary()) continue;
            IndexMetaData indexMetaData = state.metaData().index(shard.getIndex());
            long nextShardDelay = shard.unassignedInfo().getDelayAllocationExpirationIn(settings, indexMetaData.getSettings());
            if (nextShardDelay <= 0L || nextShardDelay >= nextDelay) continue;
            nextDelay = nextShardDelay;
        }
        return nextDelay == Long.MAX_VALUE ? 0L : nextDelay;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("unassigned_info[[reason=").append((Object)this.reason).append("]");
        sb.append(", at[").append(DATE_TIME_FORMATTER.printer().print(this.timestamp)).append("]");
        if (this.details != null) {
            sb.append(", details[").append(this.details).append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("unassigned_info");
        builder.field("reason", (Object)this.reason);
        builder.field("at", DATE_TIME_FORMATTER.printer().print(this.timestamp));
        if (this.details != null) {
            builder.field("details", this.details);
        }
        builder.endObject();
        return builder;
    }

    public static enum Reason {
        UNKNOWN,
        INDEX_CREATED,
        CLUSTER_RECOVERED,
        INDEX_REOPENED,
        DANGLING_INDEX_IMPORTED,
        NEW_INDEX_RESTORED,
        EXISTING_INDEX_RESTORED,
        REPLICA_ADDED,
        ALLOCATION_FAILED,
        NODE_LEFT,
        REROUTE_CANCELLED;

    }
}

