/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportShardReplicationOperationAction<Request extends ShardReplicationOperationRequest, ReplicaRequest extends ShardReplicationOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final IndicesService indicesService;
    protected final ShardStateAction shardStateAction;
    protected final ReplicationType defaultReplicationType;
    protected final WriteConsistencyLevel defaultWriteConsistencyLevel;
    protected final TransportRequestOptions transportOptions;
    final String transportReplicaAction;
    final String executor;
    final boolean checkWriteConsistency;

    protected TransportShardReplicationOperationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, actionName, threadPool, actionFilters);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.shardStateAction = shardStateAction;
        this.transportReplicaAction = actionName + "[r]";
        this.executor = this.executor();
        this.checkWriteConsistency = this.checkWriteConsistency();
        transportService.registerHandler(actionName, new OperationTransportHandler());
        transportService.registerHandler(this.transportReplicaAction, new ReplicaOperationTransportHandler());
        this.transportOptions = this.transportOptions();
        this.defaultReplicationType = ReplicationType.fromString(settings.get("action.replication_type", "sync"));
        this.defaultWriteConsistencyLevel = WriteConsistencyLevel.fromString(settings.get("action.write_consistency", "quorum"));
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new PrimaryPhase(this, request, listener).run();
    }

    protected abstract Request newRequestInstance();

    protected abstract ReplicaRequest newReplicaRequestInstance();

    protected abstract Response newResponseInstance();

    protected abstract String executor();

    protected abstract void shardOperationOnReplica(ReplicaOperationRequest var1);

    protected abstract Tuple<Response, ReplicaRequest> shardOperationOnPrimary(ClusterState var1, PrimaryOperationRequest var2) throws Throwable;

    protected abstract ShardIterator shards(ClusterState var1, InternalRequest var2) throws ElasticsearchException;

    protected abstract boolean checkWriteConsistency();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.concreteIndex());
    }

    protected abstract boolean resolveIndex();

    protected boolean resolveRequest(ClusterState state, InternalRequest request, ActionListener<Response> listener) {
        return true;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected boolean retryPrimaryException(Throwable e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    protected boolean ignoreReplicaException(Throwable e) {
        if (TransportActions.isShardNotAvailableException(e)) {
            return true;
        }
        return this.isConflictException(e);
    }

    protected boolean isConflictException(Throwable e) {
        Throwable cause = ExceptionsHelper.unwrapCause(e);
        if (cause instanceof VersionConflictEngineException) {
            return true;
        }
        return cause instanceof DocumentAlreadyExistsException;
    }

    protected Releasable getIndexShardOperationsCounter(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.index().getName());
        IndexShard indexShard = indexService.shardSafe(shardId.id());
        return new IndexShardReference(indexShard);
    }

    private void failReplicaIfNeeded(String index, int shardId, Throwable t) {
        this.logger.trace("failure on replica [{}][{}]", t, index, shardId);
        if (!this.ignoreReplicaException(t)) {
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                this.logger.debug("ignoring failed replica [{}][{}] because index was already removed.", index, shardId);
                return;
            }
            IndexShard indexShard = indexService.shard(shardId);
            if (indexShard == null) {
                this.logger.debug("ignoring failed replica [{}][{}] because index was already removed.", index, shardId);
                return;
            }
            indexShard.failShard(this.actionName + " failed on replica", t);
        }
    }

    static class IndexShardReference
    implements Releasable {
        private final IndexShard counter;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        IndexShardReference(IndexShard counter) {
            counter.incrementOperationCounter();
            this.counter = counter;
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.counter.decrementOperationCounter();
            }
        }
    }

    protected static class InternalRequest {
        final Request request;
        String concreteIndex;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        InternalRequest(Request request) {
            this.this$0 = var1_1;
            this.request = request;
        }

        public Request request() {
            return this.request;
        }

        void concreteIndex(String concreteIndex) {
            this.concreteIndex = concreteIndex;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }

    static final class ReplicationPhase
    extends AbstractRunnable {
        private final ReplicaRequest replicaRequest;
        private final Response finalResponse;
        private final ShardIterator shardIt;
        private final ActionListener<Response> listener;
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private final AtomicInteger success = new AtomicInteger(1);
        private final IndexMetaData indexMetaData;
        private final ShardRouting originalPrimaryShard;
        private final AtomicInteger pending;
        private final int totalShards;
        private final ClusterStateObserver observer;
        private final Releasable indexShardReference;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        public ReplicationPhase(ShardIterator originalShardIt, ReplicaRequest replicaRequest, Response finalResponse, ClusterStateObserver observer, ShardRouting originalPrimaryShard, InternalRequest internalRequest, ActionListener<Response> listener, Releasable indexShardReference) {
            this.this$0 = var1_1;
            this.replicaRequest = replicaRequest;
            this.listener = listener;
            this.finalResponse = finalResponse;
            this.originalPrimaryShard = originalPrimaryShard;
            this.observer = observer;
            this.indexMetaData = observer.observedState().metaData().index(internalRequest.concreteIndex());
            this.indexShardReference = indexShardReference;
            ClusterState newState = var1_1.clusterService.state();
            int numberOfUnassignedOrShadowReplicas = 0;
            int numberOfPendingShardInstances = 0;
            if (observer.observedState() != newState) {
                ShardRouting shard;
                observer.reset(newState);
                this.shardIt = var1_1.shards(newState, internalRequest);
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (shard.primary()) {
                        if (!originalPrimaryShard.currentNodeId().equals(shard.currentNodeId())) {
                            ++numberOfPendingShardInstances;
                        }
                        if (!shard.relocating()) continue;
                        ++numberOfPendingShardInstances;
                        continue;
                    }
                    if (IndexMetaData.isIndexUsingShadowReplicas(this.indexMetaData.settings())) {
                        ++numberOfUnassignedOrShadowReplicas;
                        continue;
                    }
                    if (shard.unassigned()) {
                        ++numberOfUnassignedOrShadowReplicas;
                        continue;
                    }
                    if (shard.relocating()) {
                        numberOfPendingShardInstances += 2;
                        continue;
                    }
                    ++numberOfPendingShardInstances;
                }
                ((ShardReplicationOperationRequest)internalRequest.request()).setCanHaveDuplicates();
            } else {
                ShardRouting shard;
                this.shardIt = originalShardIt;
                this.shardIt.reset();
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (shard.state() != ShardRoutingState.STARTED) {
                        ((ShardReplicationOperationRequest)replicaRequest).setCanHaveDuplicates();
                    }
                    if (shard.unassigned()) {
                        ++numberOfUnassignedOrShadowReplicas;
                        continue;
                    }
                    if (shard.primary()) {
                        if (!shard.relocating()) continue;
                        ++numberOfPendingShardInstances;
                        continue;
                    }
                    if (IndexMetaData.isIndexUsingShadowReplicas(this.indexMetaData.settings())) {
                        ++numberOfUnassignedOrShadowReplicas;
                        continue;
                    }
                    if (shard.relocating()) {
                        numberOfPendingShardInstances += 2;
                        continue;
                    }
                    ++numberOfPendingShardInstances;
                }
            }
            this.totalShards = 1 + numberOfPendingShardInstances + numberOfUnassignedOrShadowReplicas;
            this.pending = new AtomicInteger(numberOfPendingShardInstances);
        }

        int totalShards() {
            return this.totalShards;
        }

        int successful() {
            return this.success.get();
        }

        int pending() {
            return this.pending.get();
        }

        @Override
        public void onFailure(Throwable t) {
            this.this$0.logger.error("unexpected error while replicating for action [{}]. shard [{}]. ", t, this.this$0.actionName, this.shardIt.shardId());
            this.forceFinishAsFailed(t);
        }

        @Override
        protected void doRun() {
            ShardRouting shard;
            if (this.pending.get() == 0) {
                this.doFinish();
                return;
            }
            this.shardIt.reset();
            while ((shard = this.shardIt.nextOrNull()) != null) {
                if (shard.unassigned()) continue;
                if (shard.primary()) {
                    if (!this.originalPrimaryShard.currentNodeId().equals(shard.currentNodeId())) {
                        this.performOnReplica(shard, shard.currentNodeId());
                    }
                    if (!shard.relocating()) continue;
                    this.performOnReplica(shard, shard.relocatingNodeId());
                    continue;
                }
                if (IndexMetaData.isIndexUsingShadowReplicas(this.indexMetaData.settings())) continue;
                this.performOnReplica(shard, shard.currentNodeId());
                if (!shard.relocating()) continue;
                this.performOnReplica(shard, shard.relocatingNodeId());
            }
        }

        void performOnReplica(final ShardRouting shard, final String nodeId) {
            if (!this.observer.observedState().nodes().nodeExists(nodeId)) {
                this.onReplicaFailure(nodeId, null);
                return;
            }
            final ReplicaOperationRequest shardRequest = new ReplicaOperationRequest(this.this$0, this.shardIt.shardId(), this.replicaRequest);
            if (!nodeId.equals(this.observer.observedState().nodes().localNodeId())) {
                final DiscoveryNode node = this.observer.observedState().nodes().get(nodeId);
                this.this$0.transportService.sendRequest(node, this.this$0.transportReplicaAction, shardRequest, this.this$0.transportOptions, new EmptyTransportResponseHandler("same"){

                    @Override
                    public void handleResponse(TransportResponse.Empty vResponse) {
                        ReplicationPhase.this.onReplicaSuccess();
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        ReplicationPhase.this.onReplicaFailure(nodeId, exp);
                        ReplicationPhase.this.this$0.logger.trace("[{}] transport failure during replica request [{}] ", exp, node, ReplicationPhase.this.replicaRequest);
                        if (!ReplicationPhase.this.this$0.ignoreReplicaException(exp)) {
                            ReplicationPhase.this.this$0.logger.warn("failed to perform " + ReplicationPhase.this.this$0.actionName + " on remote replica " + node + ReplicationPhase.this.shardIt.shardId(), exp, new Object[0]);
                            ReplicationPhase.this.this$0.shardStateAction.shardFailed(shard, ReplicationPhase.this.indexMetaData.getUUID(), "Failed to perform [" + ReplicationPhase.this.this$0.actionName + "] on replica, message [" + ExceptionsHelper.detailedMessage(exp) + "]");
                        }
                    }
                });
            } else if (((ShardReplicationOperationRequest)this.replicaRequest).operationThreaded()) {
                try {
                    this.this$0.threadPool.executor(this.this$0.executor).execute(new AbstractRunnable(){

                        @Override
                        protected void doRun() {
                            try {
                                ReplicationPhase.this.this$0.shardOperationOnReplica(shardRequest);
                                ReplicationPhase.this.onReplicaSuccess();
                            }
                            catch (Throwable e) {
                                ReplicationPhase.this.onReplicaFailure(nodeId, e);
                                ReplicationPhase.this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                            }
                        }

                        @Override
                        public boolean isForceExecution() {
                            return true;
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            ReplicationPhase.this.onReplicaFailure(nodeId, t);
                        }
                    });
                }
                catch (Throwable e) {
                    this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                    this.onReplicaFailure(nodeId, e);
                }
            } else {
                try {
                    this.this$0.shardOperationOnReplica(shardRequest);
                    this.onReplicaSuccess();
                }
                catch (Throwable e) {
                    this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                    this.onReplicaFailure(nodeId, e);
                }
            }
        }

        void onReplicaFailure(String nodeId, @Nullable Throwable e) {
            this.decPendingAndFinishIfNeeded();
        }

        void onReplicaSuccess() {
            this.success.incrementAndGet();
            this.decPendingAndFinishIfNeeded();
        }

        private void decPendingAndFinishIfNeeded() {
            if (this.pending.decrementAndGet() <= 0) {
                this.doFinish();
            }
        }

        private void forceFinishAsFailed(Throwable t) {
            if (this.finished.compareAndSet(false, true)) {
                Releasables.close(this.indexShardReference);
                this.listener.onFailure(t);
            }
        }

        private void doFinish() {
            if (this.finished.compareAndSet(false, true)) {
                Releasables.close(this.indexShardReference);
                this.listener.onResponse(this.finalResponse);
            }
        }
    }

    static final class PrimaryPhase
    extends AbstractRunnable {
        private final ActionListener<Response> listener;
        private final InternalRequest internalRequest;
        private final ClusterStateObserver observer;
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private volatile Releasable indexShardReference;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        PrimaryPhase(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.internalRequest = new InternalRequest((TransportShardReplicationOperationAction)var1_1, request);
            this.listener = listener;
            this.observer = new ClusterStateObserver(var1_1.clusterService, ((ShardReplicationOperationRequest)this.internalRequest.request()).timeout(), ((TransportShardReplicationOperationAction)var1_1).logger);
        }

        @Override
        public void onFailure(Throwable e) {
            this.finishWithUnexpectedFailure(e);
        }

        @Override
        protected void doRun() {
            if (!this.checkBlocks()) {
                return;
            }
            ShardIterator shardIt = this.this$0.shards(this.observer.observedState(), this.internalRequest);
            ShardRouting primary = this.resolvePrimary(shardIt);
            if (primary == null) {
                this.retryBecauseUnavailable(shardIt.shardId(), "No active shards.");
                return;
            }
            if (!primary.active()) {
                this.this$0.logger.trace("primary shard [{}] is not yet active, scheduling a retry.", primary.shardId());
                this.retryBecauseUnavailable(shardIt.shardId(), "Primary shard is not active or isn't assigned to a known node.");
                return;
            }
            if (!this.observer.observedState().nodes().nodeExists(primary.currentNodeId())) {
                this.this$0.logger.trace("primary shard [{}] is assigned to anode we do not know the node, scheduling a retry.", primary.shardId(), primary.currentNodeId());
                this.retryBecauseUnavailable(shardIt.shardId(), "Primary shard is not active or isn't assigned to a known node.");
                return;
            }
            this.routeRequestOrPerformLocally(primary, shardIt);
        }

        protected boolean checkBlocks() {
            ClusterBlockException blockException = this.this$0.checkGlobalBlock(this.observer.observedState());
            if (blockException != null) {
                if (blockException.retryable()) {
                    this.this$0.logger.trace("cluster is blocked ({}), scheduling a retry", blockException.getMessage());
                    this.retry(blockException);
                } else {
                    this.finishAsFailed(blockException);
                }
                return false;
            }
            if (this.this$0.resolveIndex()) {
                this.internalRequest.concreteIndex(this.observer.observedState().metaData().concreteSingleIndex(((ShardReplicationOperationRequest)this.internalRequest.request()).index(), ((ShardReplicationOperationRequest)this.internalRequest.request()).indicesOptions()));
            } else {
                this.internalRequest.concreteIndex(((ShardReplicationOperationRequest)this.internalRequest.request()).index());
            }
            if (!this.this$0.resolveRequest(this.observer.observedState(), this.internalRequest, this.listener)) {
                return false;
            }
            blockException = this.this$0.checkRequestBlock(this.observer.observedState(), this.internalRequest);
            if (blockException != null) {
                if (blockException.retryable()) {
                    this.this$0.logger.trace("cluster is blocked ({}), scheduling a retry", blockException.getMessage());
                    this.retry(blockException);
                } else {
                    this.finishAsFailed(blockException);
                }
                return false;
            }
            return true;
        }

        protected ShardRouting resolvePrimary(ShardIterator shardIt) {
            ShardRouting shard;
            while ((shard = shardIt.nextOrNull()) != null) {
                if (!shard.primary()) continue;
                return shard;
            }
            return null;
        }

        protected void routeRequestOrPerformLocally(final ShardRouting primary, final ShardIterator shardsIt) {
            block5: {
                if (primary.currentNodeId().equals(this.observer.observedState().nodes().localNodeId())) {
                    try {
                        if (((ShardReplicationOperationRequest)this.internalRequest.request()).operationThreaded()) {
                            this.this$0.threadPool.executor(this.this$0.executor).execute(new AbstractRunnable(){

                                @Override
                                public void onFailure(Throwable t) {
                                    PrimaryPhase.this.finishAsFailed(t);
                                }

                                @Override
                                protected void doRun() throws Exception {
                                    PrimaryPhase.this.performOnPrimary(primary, shardsIt);
                                }
                            });
                            break block5;
                        }
                        this.performOnPrimary(primary, shardsIt);
                    }
                    catch (Throwable t) {
                        this.finishAsFailed(t);
                    }
                } else {
                    DiscoveryNode node = this.observer.observedState().nodes().get(primary.currentNodeId());
                    this.this$0.transportService.sendRequest(node, this.this$0.actionName, (TransportRequest)this.internalRequest.request(), this.this$0.transportOptions, new BaseTransportResponseHandler<Response>(){

                        @Override
                        public Response newInstance() {
                            return PrimaryPhase.this.this$0.newResponseInstance();
                        }

                        @Override
                        public String executor() {
                            return "same";
                        }

                        @Override
                        public void handleResponse(Response response) {
                            PrimaryPhase.this.finishOnRemoteSuccess(response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            try {
                                if (exp.unwrapCause() instanceof ConnectTransportException || exp.unwrapCause() instanceof NodeClosedException || PrimaryPhase.this.this$0.retryPrimaryException(exp)) {
                                    ((ShardReplicationOperationRequest)PrimaryPhase.this.internalRequest.request()).setCanHaveDuplicates();
                                    PrimaryPhase.this.this$0.logger.trace("received an error from node the primary was assigned to ({}), scheduling a retry", exp.getMessage());
                                    PrimaryPhase.this.retry(exp);
                                } else {
                                    PrimaryPhase.this.finishAsFailed(exp);
                                }
                            }
                            catch (Throwable t) {
                                PrimaryPhase.this.finishWithUnexpectedFailure(t);
                            }
                        }
                    });
                }
            }
        }

        void retry(Throwable failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.finishAsFailed(failure);
                return;
            }
            ((ShardReplicationOperationRequest)this.internalRequest.request()).operationThreaded(true);
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    PrimaryPhase.this.run();
                }

                @Override
                public void onClusterServiceClose() {
                    PrimaryPhase.this.finishAsFailed(new NodeClosedException(PrimaryPhase.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    PrimaryPhase.this.run();
                }
            });
        }

        void finishAndMoveToReplication(ReplicationPhase replicationPhase) {
            if (this.finished.compareAndSet(false, true)) {
                replicationPhase.run();
            } else assert (false) : "finishAndMoveToReplication called but operation is already finished";
        }

        void finishAsFailed(Throwable failure) {
            if (this.finished.compareAndSet(false, true)) {
                Releasables.close(this.indexShardReference);
                this.this$0.logger.trace("operation failed", failure, new Object[0]);
                this.listener.onFailure(failure);
            } else assert (false) : "finishAsFailed called but operation is already finished";
        }

        void finishWithUnexpectedFailure(Throwable failure) {
            this.this$0.logger.warn("unexpected error during the primary phase for action [{}]", failure, this.this$0.actionName);
            if (this.finished.compareAndSet(false, true)) {
                Releasables.close(this.indexShardReference);
                this.listener.onFailure(failure);
            } else assert (false) : "finishWithUnexpectedFailure called but operation is already finished";
        }

        void finishOnRemoteSuccess(Response response) {
            if (this.finished.compareAndSet(false, true)) {
                this.this$0.logger.trace("operation succeeded", new Object[0]);
                this.listener.onResponse(response);
            } else assert (false) : "finishOnRemoteSuccess called but operation is already finished";
        }

        void performOnPrimary(ShardRouting primary, ShardIterator shardsIt) {
            ReplicationPhase replicationPhase;
            String writeConsistencyFailure = this.checkWriteConsistency(primary);
            if (writeConsistencyFailure != null) {
                this.retryBecauseUnavailable(primary.shardId(), writeConsistencyFailure);
                return;
            }
            try {
                this.indexShardReference = this.this$0.getIndexShardOperationsCounter(primary.shardId());
                PrimaryOperationRequest por = new PrimaryOperationRequest(this.this$0, primary.id(), this.internalRequest.concreteIndex(), this.internalRequest.request());
                Tuple primaryResponse = this.this$0.shardOperationOnPrimary(this.observer.observedState(), por);
                this.this$0.logger.trace("operation completed on primary [{}]", primary);
                replicationPhase = new ReplicationPhase(this.this$0, shardsIt, (ShardReplicationOperationRequest)primaryResponse.v2(), (ActionResponse)primaryResponse.v1(), this.observer, primary, this.internalRequest, this.listener, this.indexShardReference);
            }
            catch (Throwable e) {
                ((ShardReplicationOperationRequest)this.internalRequest.request).setCanHaveDuplicates();
                if (this.this$0.retryPrimaryException(e)) {
                    this.this$0.logger.trace("had an error while performing operation on primary ({}), scheduling a retry.", e.getMessage());
                    Releasables.close(this.indexShardReference);
                    this.indexShardReference = null;
                    this.retry(e);
                    return;
                }
                if (e instanceof ElasticsearchException && ((ElasticsearchException)e).status() == RestStatus.CONFLICT) {
                    if (this.this$0.logger.isTraceEnabled()) {
                        this.this$0.logger.trace(primary.shortSummary() + ": Failed to execute [" + this.internalRequest.request() + "]", e, new Object[0]);
                    }
                } else if (this.this$0.logger.isDebugEnabled()) {
                    this.this$0.logger.debug(primary.shortSummary() + ": Failed to execute [" + this.internalRequest.request() + "]", e, new Object[0]);
                }
                this.finishAsFailed(e);
                return;
            }
            this.finishAndMoveToReplication(replicationPhase);
        }

        String checkWriteConsistency(ShardRouting shard) {
            int requiredNumber;
            int sizeActive;
            if (!this.this$0.checkWriteConsistency) {
                return null;
            }
            WriteConsistencyLevel consistencyLevel = ((ShardReplicationOperationRequest)this.internalRequest.request()).consistencyLevel() != WriteConsistencyLevel.DEFAULT ? ((ShardReplicationOperationRequest)this.internalRequest.request()).consistencyLevel() : this.this$0.defaultWriteConsistencyLevel;
            IndexRoutingTable indexRoutingTable = this.observer.observedState().getRoutingTable().index(shard.index());
            if (indexRoutingTable != null) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(shard.getId());
                if (shardRoutingTable != null) {
                    sizeActive = shardRoutingTable.activeShards().size();
                    requiredNumber = consistencyLevel == WriteConsistencyLevel.QUORUM && shardRoutingTable.getSize() > 2 ? shardRoutingTable.getSize() / 2 + 1 : (consistencyLevel == WriteConsistencyLevel.ALL ? shardRoutingTable.getSize() : 1);
                } else {
                    sizeActive = 0;
                    requiredNumber = 1;
                }
            } else {
                sizeActive = 0;
                requiredNumber = 1;
            }
            if (sizeActive < requiredNumber) {
                this.this$0.logger.trace("not enough active copies of shard [{}] to meet write consistency of [{}] (have {}, needed {}), scheduling a retry.", new Object[]{shard.shardId(), consistencyLevel, sizeActive, requiredNumber});
                return "Not enough active copies to meet write consistency of [" + (Object)((Object)consistencyLevel) + "] (have " + sizeActive + ", needed " + requiredNumber + ").";
            }
            return null;
        }

        void retryBecauseUnavailable(ShardId shardId, String message) {
            this.retry(new UnavailableShardsException(shardId, message + " Timeout: [" + ((ShardReplicationOperationRequest)this.internalRequest.request()).timeout() + "], request: " + this.internalRequest.request().toString()));
        }
    }

    protected class ReplicaOperationRequest
    extends TransportRequest
    implements IndicesRequest {
        public ShardId shardId;
        public ReplicaRequest request;

        ReplicaOperationRequest() {
        }

        ReplicaOperationRequest(ShardId shardId, ReplicaRequest request) {
            super((TransportRequest)request);
            this.shardId = shardId;
            this.request = request;
        }

        @Override
        public String[] indices() {
            return ((ShardReplicationOperationRequest)this.request).indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return ((ShardReplicationOperationRequest)this.request).indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            int shard = -1;
            if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                this.shardId = ShardId.readShardId(in);
            } else {
                shard = in.readVInt();
            }
            this.request = TransportShardReplicationOperationAction.this.newReplicaRequestInstance();
            ((ShardReplicationOperationRequest)this.request).readFrom(in);
            if (in.getVersion().before(Version.V_1_4_0_Beta1)) {
                assert (shard >= 0);
                this.shardId = new ShardId(((ShardReplicationOperationRequest)this.request).index(), shard);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                this.shardId.writeTo(out);
            } else {
                out.writeVInt(this.shardId.id());
                ((ShardReplicationOperationRequest)this.request).index(this.shardId.getIndex());
            }
            ((ShardReplicationOperationRequest)this.request).writeTo(out);
        }
    }

    protected static class PrimaryOperationRequest {
        public ShardId shardId;
        public Request request;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        public PrimaryOperationRequest(int shardId, String index, Request request) {
            this.this$0 = var1_1;
            this.shardId = new ShardId(index, shardId);
            this.request = request;
        }
    }

    class ReplicaOperationTransportHandler
    extends BaseTransportRequestHandler<ReplicaOperationRequest> {
        ReplicaOperationTransportHandler() {
        }

        @Override
        public ReplicaOperationRequest newInstance() {
            return new ReplicaOperationRequest();
        }

        @Override
        public String executor() {
            return TransportShardReplicationOperationAction.this.executor;
        }

        @Override
        public boolean isForceExecution() {
            return true;
        }

        @Override
        public void messageReceived(ReplicaOperationRequest request, TransportChannel channel) throws Exception {
            try (Releasable shardReference = TransportShardReplicationOperationAction.this.getIndexShardOperationsCounter(request.shardId);){
                TransportShardReplicationOperationAction.this.shardOperationOnReplica(request);
            }
            catch (Throwable t) {
                TransportShardReplicationOperationAction.this.failReplicaIfNeeded(request.shardId.getIndex(), request.shardId.id(), t);
                throw t;
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class OperationTransportHandler
    extends BaseTransportRequestHandler<Request> {
        OperationTransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportShardReplicationOperationAction.this.newRequestInstance();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            ((ShardReplicationOperationRequest)request).operationThreaded(true);
            TransportShardReplicationOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Throwable e1) {
                        TransportShardReplicationOperationAction.this.logger.warn("Failed to send response for " + TransportShardReplicationOperationAction.this.actionName, e1, new Object[0]);
                    }
                }
            });
        }
    }
}

