/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class FieldStatsShardResponse
extends BroadcastShardOperationResponse {
    private Map<String, FieldStats> fieldStats;

    public FieldStatsShardResponse() {
    }

    public FieldStatsShardResponse(ShardId shardId, Map<String, FieldStats> fieldStats) {
        super(shardId);
        this.fieldStats = fieldStats;
    }

    public Map<String, FieldStats> getFieldStats() {
        return this.fieldStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.fieldStats = new HashMap<String, FieldStats>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            FieldStats value = FieldStats.read(in);
            this.fieldStats.put(key, value);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.fieldStats.size());
        for (Map.Entry<String, FieldStats> entry : this.fieldStats.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }
}

