/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelProviderAction;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCommitAction
extends CVSModelProviderAction {
    public AbstractCommitAction(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    public void execute() {
        final ArrayList resources = new ArrayList();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourceTraversal[] traversals = AbstractCommitAction.this.getResourceTraversals(monitor);
                        resources.add(AbstractCommitAction.this.getOutgoingChanges(AbstractCommitAction.this.getSynchronizationContext().getDiffTree(), traversals, monitor));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handleError((Shell)this.getConfiguration().getSite().getShell(), (Exception)e, null, null);
        }
        catch (InterruptedException interruptedException) {}
        if (!resources.isEmpty() && ((IResource[])resources.get(0)).length > 0) {
            Shell shell = this.getConfiguration().getSite().getShell();
            try {
                CommitWizard.run(this.getConfiguration().getSite().getPart(), shell, (IResource[])resources.get(0));
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
    }

    protected abstract ResourceTraversal[] getResourceTraversals(IProgressMonitor var1) throws CoreException;

    protected IResource[] getOutgoingChanges(IResourceDiffTree tree, ResourceTraversal[] traversals, IProgressMonitor monitor) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IDiff[] diffs = tree.getDiffs(traversals);
        int i = 0;
        while (i < diffs.length) {
            IResource resource;
            IDiff diff = diffs[i];
            if (this.hasLocalChange(diff) && (resource = ResourceDiffTree.getResourceFor((IDiff)diff)) != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private boolean hasLocalChange(IDiff diff) {
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            return twd.getDirection() == 256 || twd.getDirection() == 768;
        }
        return false;
    }
}

