/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ResetMemoryBlockAction
implements IViewActionDelegate {
    private IViewPart fView;
    private ArrayList fSelectedMB = new ArrayList();

    public void init(IViewPart view) {
        this.fView = view;
    }

    public void run(IAction action) {
        if (this.fSelectedMB.isEmpty()) {
            return;
        }
        boolean resetVisible = false;
        String resetPref = DebugUITools.getPreferenceStore().getString(IDebugPreferenceConstants.PREF_RESET_MEMORY_BLOCK);
        if (resetPref.equals(IDebugPreferenceConstants.RESET_VISIBLE)) {
            resetVisible = true;
        }
        for (IMemoryBlock mb : this.fSelectedMB) {
            if (!(this.fView instanceof MemoryView)) continue;
            MemoryView memView = (MemoryView)this.fView;
            IMemoryRenderingContainer[] containers = memView.getMemoryRenderingContainers();
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof RenderingViewPane) {
                    ((RenderingViewPane)containers[i]).resetRenderings(mb, resetVisible);
                }
                ++i;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            Object[] objs = strucSel.toArray();
            this.fSelectedMB.clear();
            int i = 0;
            while (i < objs.length) {
                if (objs[i] instanceof IMemoryBlock) {
                    this.fSelectedMB.add(objs[i]);
                }
                if (objs[i] instanceof IMemoryRendering) {
                    this.fSelectedMB.add(((IMemoryRendering)objs[i]).getMemoryBlock());
                }
                ++i;
            }
        }
    }
}

