/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import org.apache.xerces.util.XMLChar;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.nsedit.TargetNamespaceChangeHandler;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateNamespaceInformationCommand
extends BaseCommand {
    protected XSDSchema xsdSchema;
    protected String newPrefix;
    protected String newTargetNamespace;

    public UpdateNamespaceInformationCommand(String label, XSDSchema xsdSchema, String newPrefix, String newTargetNamespace) {
        super(label);
        this.xsdSchema = xsdSchema;
        this.newPrefix = newPrefix;
        this.newTargetNamespace = newTargetNamespace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        UpdateNamespaceInformationCommand.ensureSchemaElement(this.xsdSchema);
        Element element = this.xsdSchema.getElement();
        try {
            String prefix;
            String targetNamespace;
            String oldPrefix;
            String oldNamespace;
            String modelTargetNamespace;
            block23: {
                block21: {
                    block22: {
                        modelTargetNamespace = this.xsdSchema.getTargetNamespace();
                        oldNamespace = this.xsdSchema.getTargetNamespace();
                        TypesHelper helper = new TypesHelper(this.xsdSchema);
                        oldPrefix = helper.getPrefix(element.getAttribute("targetNamespace"), false);
                        if (modelTargetNamespace == null) {
                            modelTargetNamespace = "";
                        }
                        targetNamespace = this.newTargetNamespace.trim();
                        prefix = this.newPrefix.trim();
                        if (!this.validatePrefix(prefix)) break block21;
                        if (this.validateTargetNamespace(targetNamespace)) break block22;
                        break block21;
                    }
                    if (prefix.length() <= 0 || targetNamespace.length() != 0) break block23;
                }
                Object var11_8 = null;
                this.endRecording();
                return;
            }
            this.beginRecording(element);
            String xsdForXSDPrefix = this.xsdSchema.getSchemaForSchemaQNamePrefix();
            Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
            if (prefix.length() == 0 && (xsdForXSDPrefix == null || xsdForXSDPrefix != null && xsdForXSDPrefix.trim().length() == 0)) {
                xsdForXSDPrefix = XSDEditorPlugin.getPlugin().getXMLSchemaPrefix();
                xsdForXSDPrefix = this.getUniqueSchemaForSchemaPrefix(xsdForXSDPrefix, map);
                element.setAttribute("xmlns:" + xsdForXSDPrefix, "http://www.w3.org/2001/XMLSchema");
                this.updateAllNodes(element, xsdForXSDPrefix);
                if (element.getAttribute("xmlns") != null && element.getAttribute("xmlns").equals("http://www.w3.org/2001/XMLSchema")) {
                    element.removeAttribute("xmlns");
                }
            }
            if (targetNamespace.length() > 0 || targetNamespace.length() == 0 && prefix.length() == 0) {
                if (oldPrefix != null && oldPrefix.length() > 0) {
                    element.removeAttribute("xmlns:" + oldPrefix);
                } else if (element.getAttribute("xmlns") != null && !element.getAttribute("xmlns").equals("http://www.w3.org/2001/XMLSchema")) {
                    element.removeAttribute("xmlns");
                }
            }
            if (targetNamespace.length() > 0) {
                if (!modelTargetNamespace.equals(targetNamespace)) {
                    element.setAttribute("targetNamespace", targetNamespace);
                }
                if (prefix.length() > 0) {
                    element.setAttribute("xmlns:" + prefix, targetNamespace);
                } else {
                    element.setAttribute("xmlns", targetNamespace);
                }
            } else if (prefix.length() == 0) {
                element.removeAttribute("targetNamespace");
            }
            TargetNamespaceChangeHandler targetNamespaceChangeHandler = new TargetNamespaceChangeHandler(this.xsdSchema, oldNamespace, targetNamespace);
            targetNamespaceChangeHandler.resolve();
            UpdateNamespaceInformationCommand.updateElement((XSDConcreteComponent)this.xsdSchema);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.endRecording();
            throw throwable;
        }
        this.endRecording();
    }

    /*
     * Unable to fully structure code
     */
    private static void updateElement(XSDConcreteComponent concreteComp) {
        block9: {
            try {
                concreteComp.updateElement();
                break block9;
            }
            catch (Exception v0) {
                containments = concreteComp.eClass().getEAllReferences().iterator();
                ** while (containments.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                eReference = (EReference)containments.next();
                if (!eReference.isContainment()) continue;
                if (eReference.isMany()) {
                    objects = ((Collection)concreteComp.eGet((EStructuralFeature)eReference)).iterator();
                    while (objects.hasNext()) {
                        xsdConcreteComponent = (XSDConcreteComponent)objects.next();
                        try {
                            xsdConcreteComponent.updateElement();
                        }
                        catch (Exception v1) {}
                    }
                    continue;
                }
                xsdConcreteComponent = (XSDConcreteComponent)concreteComp.eGet((EStructuralFeature)eReference);
                if (xsdConcreteComponent == null) continue;
                try {
                    xsdConcreteComponent.updateElement();
                }
                catch (Exception v2) {}
                continue;
            }
        }
    }

    private String getUniqueSchemaForSchemaPrefix(String xsdForXSDPrefix, Map map) {
        if (xsdForXSDPrefix == null || xsdForXSDPrefix != null && xsdForXSDPrefix.trim().length() == 0) {
            xsdForXSDPrefix = "xsd";
        }
        int prefixExtension = 1;
        while (map.containsKey(xsdForXSDPrefix) && prefixExtension < 100) {
            xsdForXSDPrefix = String.valueOf(xsdForXSDPrefix) + String.valueOf(prefixExtension);
            ++prefixExtension;
        }
        return xsdForXSDPrefix;
    }

    private void updateAllNodes(Element element, String prefix) {
        element.setPrefix(prefix);
        NodeList list = element.getChildNodes();
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child != null && child instanceof Element) {
                    child.setPrefix(prefix);
                    if (child.hasChildNodes()) {
                        this.updateAllNodes((Element)child, prefix);
                    }
                }
                ++i;
            }
        }
    }

    private boolean validateTargetNamespace(String ns) {
        if (ns.equals("")) {
            return true;
        }
        String errorMessage = null;
        try {
            URI testURI = new URI(ns);
            testURI.isAbsolute();
        }
        catch (URISyntaxException uRISyntaxException) {
            errorMessage = XSDEditorPlugin.getXSDString("_WARN_INVALID_TARGET_NAMESPACE");
        }
        return errorMessage == null || errorMessage.length() == 0;
    }

    protected boolean validatePrefix(String prefix) {
        if (prefix != null && prefix.equals("")) {
            return true;
        }
        return XMLChar.isValidNCName((String)prefix);
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
    }
}

