/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.Trace;

public class EclipseUtil {
    static /* synthetic */ Class class$0;

    private EclipseUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IStatus createServerProject(String name, IPath path, IProgressMonitor monitor) {
        try {
            IStatus iStatus;
            try {
                block9: {
                    block8: {
                        IProject project;
                        block7: {
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            project = workspace.getRoot().getProject(name);
                            IProjectDescription description = workspace.newProjectDescription(name);
                            description.setLocation(path);
                            project.create(description, ProgressUtil.getSubMonitorFor(monitor, 1000));
                            if (!monitor.isCanceled()) break block7;
                            break block8;
                        }
                        project.open(ProgressUtil.getSubMonitorFor(monitor, 1000));
                        if (monitor.isCanceled()) break block8;
                        ServerPlugin.getProjectProperties((IProject)project).setServerProject(true, monitor);
                        if (!monitor.isCanceled()) break block9;
                    }
                    Object var6_8 = null;
                    monitor.done();
                    return null;
                }
                iStatus = Status.OK_STATUS;
                Object var6_9 = null;
            }
            catch (CoreException ce) {
                Trace.trace(Trace.SEVERE, "Could not create server project named " + name, ce);
                Status status = new Status(4, "org.eclipse.wst.server.ui", 0, NLS.bind((String)Messages.errorCouldNotCreateServerProjectStatus, (Object)ce.getMessage()), (Throwable)ce);
                Object var6_10 = null;
                monitor.done();
                return status;
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Could not create server project (2) named " + name, e);
                Status status = new Status(4, "org.eclipse.wst.server.ui", 0, Messages.errorCouldNotCreateServerProject, (Throwable)e);
                Object var6_11 = null;
                monitor.done();
                return status;
            }
            monitor.done();
            return iStatus;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            monitor.done();
            throw throwable;
        }
    }

    public static void createNewServerProject(final Shell shell, String name, IPath path, IProgressMonitor monitor) {
        final IStatus status = EclipseUtil.createServerProject(name, path, monitor);
        if (!status.isOK()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    Shell shell2 = shell;
                    if (shell == null) {
                        shell2 = EclipseUtil.getShell();
                    }
                    EclipseUtil.openError(shell2, Messages.errorCouldNotCreateServerProject, status);
                }
            });
        }
    }

    public static ImageDescriptor getProjectImageDescriptor(IProject project) {
        IWorkbenchAdapter adapter;
        if (project == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IWorkbenchAdapter)project.getAdapter((Class)clazz)) != null) {
            return adapter.getImageDescriptor((Object)project);
        }
        return null;
    }

    public static Shell getShell() {
        return EclipseUtil.getStandardDisplay().getActiveShell();
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void openError(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = EclipseUtil.getShell();
                MessageDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message);
            }
        });
    }

    public static void openError(final String message, final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = EclipseUtil.getShell();
                ErrorDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message, (IStatus)status);
            }
        });
    }

    public static void openError(Shell shell, String message) {
        MessageDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message);
    }

    public static void openError(Shell shell, String message, IStatus status) {
        ErrorDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message, (IStatus)status);
    }

    public static boolean validateEdit(Shell shell, IServer server) {
        IStatus status = ServerUtil.validateEdit((Object)shell, (IServer)server);
        return EclipseUtil.validateEdit(shell, status);
    }

    protected static boolean validateEdit(Shell shell, IStatus status) {
        if (status != null && status.getSeverity() == 4) {
            String message = Messages.editorValidateEditFailureMessage;
            ErrorDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message, (IStatus)status);
            return false;
        }
        return true;
    }
}

