/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.PublishAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegPublishServiceInterfaceSimpleAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class RegPublishServiceAdvancedAction
extends PublishAction {
    public RegPublishServiceAdvancedAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(1));
        this.propertyTable_.put("queryStyleServices", String.valueOf(1));
    }

    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String[] parameters;
        String busNodeIds = parser.getParameter("nodeId_Business");
        String[] serIntIds = parser.getParameterValues("nodeId_ServiceInterface");
        String wsdlURL = parser.getParameter("wsdlURL");
        String[] nameLanguages = parser.getParameterValues("advancedNameLanguage");
        String[] names = parser.getParameterValues("advancedName");
        String[] descriptionLanguages = parser.getParameterValues("advancedDescriptionLanguage");
        String[] descriptions = parser.getParameterValues("advancedDescription");
        String[] catTypes = parser.getParameterValues("advancedCategoryType");
        String[] catKeyNames = parser.getParameterValues("advancedCategoryKeyName");
        String[] catKeyValues = parser.getParameterValues("advancedCategoryKeyValue");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (busNodeIds != null) {
            Vector<ListElement> serviceBusiness = (Vector<ListElement>)formToolPI.getProperty("advancedServiceBusiness");
            if (serviceBusiness == null) {
                serviceBusiness = new Vector<ListElement>();
            } else {
                serviceBusiness.removeAllElements();
            }
            Vector serviceBusinessCopy = (Vector)formToolPI.getProperty("advancedServiceBusinessCopy");
            ListElement listElement = (ListElement)serviceBusinessCopy.elementAt(0);
            serviceBusiness.addElement(listElement);
            BusinessEntity sp = (BusinessEntity)listElement.getObject();
            this.propertyTable_.put("advancedServiceBusiness", serviceBusiness);
            this.propertyTable_.put("advancedServiceServiceProvider", sp);
            this.propertyTable_.put("uuidBusinessKey", sp.getBusinessKey());
        } else {
            this.removeProperty("advancedServiceBusiness");
            this.removeProperty("advancedServiceServiceProvider");
            if (!this.subQueryInitiated_) {
                inputsValid = false;
                formToolPI.flagError("advancedServiceBusiness");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_BUSINESS"));
            }
        }
        if (serIntIds != null && serIntIds.length > 0) {
            Vector<ListElement> serviceInterfaces = (Vector<ListElement>)formToolPI.getProperty("advancedServiceServiceInterfaces");
            if (serviceInterfaces == null) {
                serviceInterfaces = new Vector<ListElement>();
            } else {
                serviceInterfaces.removeAllElements();
            }
            Vector serviceInterfacesCopy = (Vector)formToolPI.getProperty("advancedServiceServiceInterfacesCopy");
            Vector<Object> tmodels = new Vector<Object>();
            Iterator it = serviceInterfacesCopy.iterator();
            block2: while (it.hasNext()) {
                ListElement listElement = (ListElement)it.next();
                int targetNodeId = listElement.getTargetNodeId();
                int i = 0;
                while (i < serIntIds.length) {
                    try {
                        if (targetNodeId == Integer.parseInt(serIntIds[i])) {
                            serviceInterfaces.add(listElement);
                            tmodels.add(listElement.getObject());
                            continue block2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ++i;
                }
            }
            this.propertyTable_.put("advancedServiceServiceInterfaces", serviceInterfaces);
            this.propertyTable_.put("advancedServiceTModel", tmodels);
        } else {
            this.removeProperty("advancedServiceServiceInterfaces");
            this.removeProperty("advancedServiceTModel");
        }
        if (wsdlURL != null) {
            this.propertyTable_.put("wsdlURL", wsdlURL);
            this.propertyTable_.put("advancedServiceWSDLURL", wsdlURL);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(wsdlURL)) {
            inputsValid = false;
            formToolPI.flagError("advancedServiceWSDLURL");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_WSDL_URL"));
        }
        Hashtable<String, Boolean> languageHash = new Hashtable<String, Boolean>();
        if (nameLanguages != null && names != null) {
            Vector<Name> nameVector = new Vector<Name>();
            parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_NAME");
            int i = 0;
            while (i < names.length) {
                Name uddi4jName;
                parameters[1] = String.valueOf(i + 1);
                if (nameLanguages[i].length() > 0) {
                    uddi4jName = new Name(names[i], nameLanguages[i]);
                } else {
                    uddi4jName = new Name(names[i]);
                    if (i != 0 && !this.subQueryInitiated_) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedServiceNames", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(nameLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceNames", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(nameLanguages[i], Boolean.TRUE);
                }
                if (names[i].trim().length() < 1) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceNames", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                nameVector.addElement(uddi4jName);
                ++i;
            }
            this.propertyTable_.put("advancedServiceNames", nameVector);
        } else {
            this.removeProperty("advancedServiceNames");
            if (!this.subQueryInitiated_) {
                inputsValid = false;
                formToolPI.flagError("advancedServiceNames");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_NO_NAMES"));
            }
        }
        if (descriptionLanguages != null && descriptions != null) {
            Vector<Description> descriptionVector = new Vector<Description>();
            parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_DESCRIPTION");
            languageHash.clear();
            int i = 0;
            while (i < descriptions.length) {
                Description uddi4jDescription;
                parameters[1] = String.valueOf(i + 1);
                if (descriptionLanguages[i].length() > 0) {
                    uddi4jDescription = new Description(descriptions[i], descriptionLanguages[i]);
                } else {
                    uddi4jDescription = new Description(descriptions[i]);
                    if (i != 0 && !this.subQueryInitiated_) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedServiceDescriptions", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(descriptionLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(descriptionLanguages[i], Boolean.TRUE);
                }
                if (descriptions[i].trim().length() < 1) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                descriptionVector.addElement(uddi4jDescription);
                ++i;
            }
            this.propertyTable_.put("advancedServiceDescriptions", descriptionVector);
        } else {
            this.removeProperty("advancedServiceDescriptions");
        }
        if (catTypes != null && catKeyNames != null && catKeyValues != null) {
            CategoryBag catBag = new CategoryBag();
            int i = 0;
            while (i < catTypes.length) {
                KeyedReference kr = new KeyedReference(catKeyNames[i], catKeyValues[i], catTypes[i]);
                catBag.add(kr);
                ++i;
            }
            this.propertyTable_.put("advancedServiceCategories", catBag);
        } else {
            this.removeProperty("advancedServiceCategories");
        }
        return inputsValid;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            BusinessService bs;
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            BusinessEntity be = (BusinessEntity)this.propertyTable_.get("advancedServiceServiceProvider");
            String businessKey = (String)this.propertyTable_.get("uuidBusinessKey");
            Vector tModelVector = (Vector)this.propertyTable_.get("advancedServiceTModel");
            String wsdlURL = (String)this.propertyTable_.get("advancedServiceWSDLURL");
            Vector nameVector = (Vector)this.propertyTable_.get("advancedServiceNames");
            Vector descriptionVector = (Vector)this.propertyTable_.get("advancedServiceDescriptions");
            CategoryBag categoryBag = (CategoryBag)this.propertyTable_.get("advancedServiceCategories");
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            UDDIProxy proxy = regElement.getProxy();
            Uddi4jHelper uddi4jHelper = new Uddi4jHelper();
            Definition def = uddi4jHelper.getWSDLDefinition(wsdlURL);
            if (tModelVector != null && tModelVector.size() > 0) {
                bs = uddi4jHelper.newBusinessService(wsdlURL, def, tModelVector.toArray(new TModel[0]));
            } else {
                int i;
                RegPublishServiceInterfaceSimpleAction regPublishSIAction = new RegPublishServiceInterfaceSimpleAction(this.controller_);
                int currentNodeId = this.getSelectedNavigatorNode().getNodeId();
                NodeManager nodeManager = this.regNode_.getNodeManager();
                TModel[] tModels = null;
                if (uddi4jHelper.isMonolithicWSDL(def)) {
                    tModels = new TModel[]{uddi4jHelper.newTModel(wsdlURL, def)};
                } else {
                    String[] imports = uddi4jHelper.getImports(def, wsdlURL);
                    tModels = new TModel[imports.length];
                    i = 0;
                    while (i < tModels.length) {
                        tModels[i] = uddi4jHelper.newTModel(imports[i]);
                        ++i;
                    }
                }
                Hashtable tModelsTable = new Hashtable();
                if (tModels != null) {
                    i = 0;
                    while (i < tModels.length) {
                        boolean inputsValid = regPublishSIAction.populatePropertyTable(uddi4jHelper.getWSDL(tModels[i]), tModels[i]);
                        if (inputsValid) {
                            regPublishSIAction.run();
                            Object savedTModel = regPublishSIAction.getPropertyTable().get("savedTModel");
                            if (savedTModel != null) {
                                tModelsTable.put(((TModel)savedTModel).getNameString(), savedTModel);
                            }
                            nodeManager.setSelectedNodeId(currentNodeId);
                        }
                        ++i;
                    }
                }
                bs = uddi4jHelper.newBusinessService(wsdlURL, def, tModelsTable);
            }
            if (be != null) {
                bs.setBusinessKey(be.getBusinessKey());
            } else if (businessKey != null) {
                bs.setBusinessKey(businessKey);
            }
            bs.setNameVector(nameVector);
            bs.setDescriptionVector(descriptionVector);
            bs.setCategoryBag(categoryBag);
            Vector<BusinessService> bsVector = new Vector<BusinessService>();
            bsVector.add(bs);
            regElement.handlePreInvocation(bs);
            bs = (BusinessService)proxy.save_service(regElement.getAuthInfoString(), bsVector).getBusinessServiceVector().get(0);
            this.addPublishedItemNode(bs, regElement);
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_PUBLISHED", bs.getDefaultNameString()));
            return true;
        }
        catch (WSDLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("WSDLException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

