/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.ui.IActionFilter;
import org.eclipse.wst.rdb.data.internal.core.editor.IRowData;
import org.eclipse.wst.rdb.data.internal.ui.editor.TableDataEditor;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class TableDataCell
implements IActionFilter {
    protected TableDataEditor editor;
    protected Object row;
    protected int col;

    public TableDataCell(TableDataEditor editor, Object row, int col) {
        this.editor = editor;
        this.row = row;
        this.col = col;
    }

    public int getCol() {
        return this.col;
    }

    public Object getRow() {
        return this.row;
    }

    public TableDataEditor getEditor() {
        return this.editor;
    }

    public Object getValue() {
        if (this.row instanceof IRowData) {
            return ((IRowData)this.row).getValue(this.col);
        }
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals("vendor")) {
            String vendor = this.editor.getSqlTable().getSchema().getDatabase().getVendor();
            return value.equals(vendor);
        }
        if (name.equals("version")) {
            String version = this.editor.getSqlTable().getSchema().getDatabase().getVersion();
            return value.equals(version);
        }
        if (name.equals("dataType")) {
            Column sqlCol = (Column)this.editor.getSqlTable().getColumns().get(this.col);
            return value.equals(sqlCol.getDataType().getName());
        }
        if (name.equals("nullable")) {
            Column sqlCol = (Column)this.editor.getSqlTable().getColumns().get(this.col);
            return new Boolean(value).booleanValue() == sqlCol.isNullable();
        }
        if (name.equals("insertionCell")) {
            boolean b = this.row instanceof IRowData;
            return new Boolean(value) ^ b;
        }
        return false;
    }
}

