/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.repo.SVNRepositories;
import org.tigris.subversion.subclipse.core.repo.SVNRepositoryLocation;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.RelocateWizardUrlPage;
import org.tigris.subversion.subclipse.ui.wizards.RelocateWizardWarningPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class RelocateWizard
extends Wizard {
    private SVNRepositoryLocation repository;
    private IProject[] sharedProjects;
    private RelocateWizardWarningPage warningPage;
    private RelocateWizardUrlPage urlPage;

    public RelocateWizard(SVNRepositoryLocation repository) {
        this.repository = repository;
        this.setWindowTitle(Policy.bind("RelocateWizard.title"));
        this.setSharedProjects();
    }

    public void addPages() {
        this.warningPage = new RelocateWizardWarningPage("warningPage", Policy.bind("RelocateWizard.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"));
        this.addPage((IWizardPage)this.warningPage);
        this.urlPage = new RelocateWizardUrlPage("urlPage", Policy.bind("RelocateWizard.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"), this.repository.getUrl().toString());
        this.addPage((IWizardPage)this.urlPage);
    }

    public boolean performFinish() {
        try {
            SVNRepositoryLocation newRepository = SVNRepositoryLocation.fromString((String)this.urlPage.getNewUrl());
            newRepository.setUsername(this.repository.getUsername());
            newRepository.setLabel(this.repository.getLabel());
            newRepository.validateConnection((IProgressMonitor)new NullProgressMonitor());
            ISVNClientAdapter client = this.repository.getSVNClient();
            int i = 0;
            while (i < this.sharedProjects.length) {
                client.relocate(this.repository.getUrl().toString(), newRepository.getUrl().toString(), this.sharedProjects[i].getLocation().toString(), true);
                ++i;
            }
            SVNRepositories repositories = SVNProviderPlugin.getPlugin().getRepositories();
            repositories.addOrUpdateRepository((ISVNRepositoryLocation)newRepository);
            int i2 = 0;
            while (i2 < this.sharedProjects.length) {
                SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus((IContainer)this.sharedProjects[i2], true);
                this.sharedProjects[i2].refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.sharedProjects[i2], (String)SVNProviderPlugin.getTypeId());
                provider.setProject(this.sharedProjects[i2]);
                ++i2;
            }
            repositories.disposeRepository((ISVNRepositoryLocation)this.repository);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("RelocateWizard.heading"), (String)e.getMessage());
            return false;
        }
        return true;
    }

    private void setSharedProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> shared = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)projects[i], (String)SVNProviderPlugin.getTypeId());
            if (teamProvider != null) {
                try {
                    SVNTeamProvider svnProvider = (SVNTeamProvider)teamProvider;
                    if (svnProvider.getSVNWorkspaceRoot().getRepository().equals(this.repository)) {
                        shared.add(projects[i]);
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        this.sharedProjects = new IProject[shared.size()];
        shared.toArray(this.sharedProjects);
    }

    public IProject[] getSharedProjects() {
        return this.sharedProjects;
    }
}

