/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.debug.ui.RdtDebugUiImages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.launcher.RubyApplicationShortcut;
import org.rubypeople.rdt.internal.launching.InterpreterRunnerConfiguration;
import org.rubypeople.rdt.internal.ui.util.DirectorySelector;

public class RubyArgumentsTab
extends AbstractLaunchConfigurationTab {
    protected Text interpreterArgsText;
    protected Text programArgsText;
    protected DirectorySelector workingDirectorySelector;
    protected Button useDefaultWorkingDirectoryButton;
    private IProject rubyProject;

    public void createControl(Composite composite) {
        Composite composite2 = this.createPageRoot(composite);
        new Label(composite2, 0).setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyArguments.working_dir"));
        this.workingDirectorySelector = new DirectorySelector(composite2);
        this.workingDirectorySelector.setBrowseDialogMessage(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyArguments.working_dir_browser_message"));
        this.workingDirectorySelector.setLayoutData((Object)new GridData(768));
        this.workingDirectorySelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.useDefaultWorkingDirectoryButton = new Button(composite3, 32);
        this.useDefaultWorkingDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RubyArgumentsTab.this.setUseDefaultWorkingDirectory(((Button)selectionEvent.getSource()).getSelection());
            }
        });
        new Label(composite3, 0).setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyArguments.working_dir_use_default_message"));
        composite3.pack();
        new Label(composite2, 0);
        new Label(composite2, 0).setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyArguments.interpreter_args_box_title"));
        this.interpreterArgsText = new Text(composite2, 2562);
        this.interpreterArgsText.setLayoutData((Object)new GridData(1808));
        this.interpreterArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(composite2, 0).setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyArguments.program_args_box_title"));
        this.programArgsText = new Text(composite2, 2562);
        this.programArgsText.setLayoutData((Object)new GridData(1808));
        this.programArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void setUseDefaultWorkingDirectory(boolean bl) {
        if (this.useDefaultWorkingDirectoryButton.getSelection() != bl) {
            this.useDefaultWorkingDirectoryButton.setSelection(bl);
        }
        if (bl) {
            this.workingDirectorySelector.setSelectionText(RubyApplicationShortcut.getDefaultWorkingDirectory(this.rubyProject));
        }
        this.workingDirectorySelector.setEnabled(!bl);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.USE_DEFAULT_WORKING_DIRECTORY", true);
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.WORKING_DIRECTORY", RubyApplicationShortcut.getDefaultWorkingDirectory(this.rubyProject));
        iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = true;
        try {
            string = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.WORKING_DIRECTORY", "");
            string2 = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.INTERPRETER_ARGUMENTS", "");
            string3 = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.PROGRAM_ARGUMENTS", "");
            bl = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.USE_DEFAULT_WORKING_DIRECTORY", true);
            InterpreterRunnerConfiguration interpreterRunnerConfiguration = new InterpreterRunnerConfiguration(iLaunchConfiguration);
            this.rubyProject = interpreterRunnerConfiguration.getProject().getProject();
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        this.workingDirectorySelector.setSelectionText(string);
        this.interpreterArgsText.setText(string2);
        this.programArgsText.setText(string3);
        this.setUseDefaultWorkingDirectory(bl);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.WORKING_DIRECTORY", this.workingDirectorySelector.getValidatedSelectionText());
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.INTERPRETER_ARGUMENTS", this.interpreterArgsText.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.PROGRAM_ARGUMENTS", this.programArgsText.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.USE_DEFAULT_WORKING_DIRECTORY", this.useDefaultWorkingDirectoryButton.getSelection());
    }

    protected Composite createPageRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.setControl((Control)composite2);
        return composite2;
    }

    public String getName() {
        return RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyArguments.name");
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.WORKING_DIRECTORY", "");
            if (string.length() == 0) {
                this.setErrorMessage(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyArguments.working_dir_error_message"));
                return false;
            }
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void log(Throwable throwable) {
        RdtDebugUiPlugin.log(throwable);
    }

    public Image getImage() {
        return RdtDebugUiImages.get("org.rubypeople.rdt.debug.ui.arguments_tab.gif");
    }
}

