/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.model;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;
import org.rubypeople.rdt.internal.debug.core.model.RubyValue;

public class RubyVariable
extends PlatformObject
implements IVariable {
    private boolean isStatic;
    private boolean isLocal;
    private boolean isInstance;
    private boolean isConstant;
    private RubyStackFrame stackFrame;
    private String name;
    private String objectId;
    private RubyValue value;
    private RubyVariable parent;

    public RubyVariable(RubyStackFrame rubyStackFrame, String string, String string2) {
        this.initialize(rubyStackFrame, string, string2, null, new RubyValue(this));
    }

    public RubyVariable(RubyStackFrame rubyStackFrame, String string, String string2, String string3, String string4, boolean bl, String string5) {
        this.initialize(rubyStackFrame, string, string2, string5, new RubyValue(this, string3, string4, bl));
    }

    protected final void initialize(RubyStackFrame rubyStackFrame, String string, String string2, String string3, RubyValue rubyValue) {
        this.stackFrame = rubyStackFrame;
        this.value = rubyValue;
        this.name = string;
        this.objectId = string3;
        this.isStatic = string2.equals("class");
        this.isLocal = string2.equals("local");
        this.isInstance = string2.equals("instance");
        this.isConstant = string2.equals("constant");
    }

    public IValue getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceTypeName() {
        return "RefTypeName";
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.stackFrame.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public void setValue(String string) throws DebugException {
    }

    public void setValue(IValue iValue) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String string) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue iValue) throws DebugException {
        return false;
    }

    public String toString() {
        if (this.isHashValue()) {
            return String.valueOf(this.getName()) + " => " + this.getValue();
        }
        return String.valueOf(this.getName()) + " = " + this.getValue();
    }

    public RubyStackFrame getStackFrame() {
        return this.stackFrame;
    }

    public RubyVariable getParent() {
        return this.parent;
    }

    public void setParent(RubyVariable rubyVariable) {
        this.parent = rubyVariable;
    }

    public String getQualifiedName() {
        if (this.parent == null) {
            return this.getName();
        }
        if (this.isHashValue()) {
            if (((RubyValue)this.getValue()).getReferenceTypeName().equals("String")) {
                return String.valueOf(this.parent.getQualifiedName()) + "[" + this.getName() + "]";
            }
            return "[ObjectSpace._id2ref(" + this.getObjectId() + ")]";
        }
        if (this.getName().startsWith("[")) {
            return String.valueOf(this.parent.getQualifiedName()) + this.getName();
        }
        return String.valueOf(this.parent.getQualifiedName()) + "." + this.getName();
    }

    public boolean isInstance() {
        return this.isInstance;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isHashValue() {
        return this.parent != null && ((RubyValue)this.parent.getValue()).getReferenceTypeName().equals("Hash");
    }
}

