/***************************************************************************
                          csearchsocket.h  -  description
                             -------------------
    begin                : Thu May 27 2004
    copyright            : (C) 2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSEARCHSOCKET_H
#define CSEARCHSOCKET_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cconnection.h>
#include <dclib/core/ccallback.h>

class DLL_EXPORT CSearchSocket : public CConnection {
public:
	/** */
	CSearchSocket();
	/** */
	virtual ~CSearchSocket();

	/** */
	int HandleMessage( char * c, int len );
	/** */
	void SetCallBackFunction( _CCallback * callback );

	/** */
	virtual void DataAvailable( const char * buffer, int len );
	/** */
	virtual void ConnectionState( eConnectionState state );

private:
	/** callback function */
	_CCallback * m_pCallback;
	/** */
	CThread m_SearchSocketThread;
};

/** */
inline void CSearchSocket::SetCallBackFunction( _CCallback * callback )
{ m_SearchSocketThread.Lock(); if ( m_pCallback ) delete m_pCallback; m_pCallback = callback; m_SearchSocketThread.UnLock(); }

#endif
