/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;

public final class ceiling
extends Primitive {
    private static final Primitive CEILING = new ceiling();

    private ceiling() {
        super("ceiling", "number &optional divisor");
    }

    public LispObject execute(LispObject arg) {
        return this.execute(arg, Fixnum.ONE);
    }

    public LispObject execute(LispObject first, LispObject second) {
        LispObject quotient = first.truncate(second);
        LispThread thread = LispThread.currentThread();
        LispObject remainder = thread._values[1];
        if (remainder.zerop()) {
            return quotient;
        }
        if (second.minusp() ? first.plusp() : first.minusp()) {
            return quotient;
        }
        thread._values[0] = quotient = quotient.incr();
        thread._values[1] = remainder.subtract(second);
        return quotient;
    }
}

