/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.StackFrame;
import org.armedbear.lisp.Symbol;

public class LispStackFrame
extends StackFrame {
    public final LispObject operator;
    private final LispObject[] args;
    private static final LispObject UNAVAILABLE_ARG = new UnavailableArgument();

    public LispStackFrame(Object[] stack, int framePos, int numArgs) {
        this.operator = (LispObject)stack[framePos];
        this.args = new LispObject[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            this.args[i] = (LispObject)stack[framePos + 1 + i];
        }
    }

    public LispObject typeOf() {
        return Symbol.LISP_STACK_FRAME;
    }

    public LispObject classOf() {
        return BuiltInClass.LISP_STACK_FRAME;
    }

    public String printObject() {
        String result = "";
        String LISP_STACK_FRAME = "LISP-STACK-FRAME";
        try {
            result = Symbol.PRIN1_TO_STRING.execute(this.toLispList()).printObject();
        }
        catch (Throwable t) {
            Debug.trace("Serious printing error: ");
            Debug.trace(t);
            result = this.unreadableString("LISP-STACK-FRAME");
        }
        return result;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.LISP_STACK_FRAME) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.LISP_STACK_FRAME) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public LispObject toLispList() {
        LispObject lambdaName;
        LispObject result = this.argsToLispList();
        if (this.operator instanceof Operator && (lambdaName = ((Operator)this.operator).getLambdaName()) != null && lambdaName != Lisp.NIL) {
            return result.push(lambdaName);
        }
        return result.push(this.operator);
    }

    private LispObject argsToLispList() {
        LispObject result = Lisp.NIL;
        for (int i = 0; i < this.args.length; ++i) {
            result = this.args[i] == null ? result.push(UNAVAILABLE_ARG) : result.push(this.args[i]);
        }
        return result.nreverse();
    }

    public SimpleString toLispString() {
        String result;
        try {
            result = this.toLispList().printObject();
        }
        catch (Throwable t) {
            Debug.trace("Serious printing error: ");
            Debug.trace(t);
            result = this.unreadableString("LISP-STACK-FRAME");
        }
        return new SimpleString(result);
    }

    public int getNumArgs() {
        return this.args.length;
    }

    public LispObject getOperator() {
        return this.operator;
    }

    public LispObject getParts() {
        LispObject result = Lisp.NIL;
        result = result.push(new Cons("OPERATOR", this.getOperator()));
        LispObject args = this.argsToLispList();
        if (args != Lisp.NIL) {
            result = result.push(new Cons("ARGS", args));
        }
        return result.nreverse();
    }

    private static final class UnavailableArgument
    extends LispObject {
        public String printObject() {
            return this.unreadableString("unavailable arg", false);
        }
    }
}

