require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_INTR_H_)) {
    eval 'sub _POWERPC_INTR_H_ () {1;}' unless defined(&_POWERPC_INTR_H_);
    eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
    eval 'sub IPL_SOFT () {1;}' unless defined(&IPL_SOFT);
    eval 'sub IPL_SOFTCLOCK () {2;}' unless defined(&IPL_SOFTCLOCK);
    eval 'sub IPL_SOFTNET () {3;}' unless defined(&IPL_SOFTNET);
    eval 'sub IPL_SOFTTTY () {4;}' unless defined(&IPL_SOFTTTY);
    eval 'sub IPL_BIO () {5;}' unless defined(&IPL_BIO);
    eval 'sub IPL_NET () {6;}' unless defined(&IPL_NET);
    eval 'sub IPL_TTY () {7;}' unless defined(&IPL_TTY);
    eval 'sub IPL_VM () {8;}' unless defined(&IPL_VM);
    eval 'sub IPL_AUDIO () {9;}' unless defined(&IPL_AUDIO);
    eval 'sub IPL_CLOCK () {10;}' unless defined(&IPL_CLOCK);
    eval 'sub IPL_SCHED () {11;}' unless defined(&IPL_SCHED);
    eval 'sub IPL_HIGH () {12;}' unless defined(&IPL_HIGH);
    eval 'sub IPL_NUM () {13;}' unless defined(&IPL_NUM);
    eval 'sub IPL_MPSAFE () {0x100;}' unless defined(&IPL_MPSAFE);
    eval 'sub IST_NONE () {0;}' unless defined(&IST_NONE);
    eval 'sub IST_PULSE () {1;}' unless defined(&IST_PULSE);
    eval 'sub IST_EDGE () {2;}' unless defined(&IST_EDGE);
    eval 'sub IST_LEVEL () {3;}' unless defined(&IST_LEVEL);
    if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
	require 'sys/evcount.ph';
	require 'machine/atomic.ph';
	eval 'sub PPC_NIRQ () {66;}' unless defined(&PPC_NIRQ);
	eval 'sub PPC_CLK_IRQ () {64;}' unless defined(&PPC_CLK_IRQ);
	eval 'sub PPC_STAT_IRQ () {65;}' unless defined(&PPC_STAT_IRQ);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub splassert {
	        my($__wantipl) = @_;
    		eval q( &do {  &if ( &splassert_ctl > 0) {  &splassert_check($__wantipl,  &__func__); } }  &while (0));
	    }' unless defined(&splassert);
	    eval 'sub splsoftassert {
	        my($wantipl) = @_;
    		eval q( &splassert($wantipl));
	    }' unless defined(&splsoftassert);
	} else {
	    eval 'sub splassert {
	        my($wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splassert);
	    eval 'sub splsoftassert {
	        my($wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splsoftassert);
	}
	eval 'sub set_sint {
	    my($p) = @_;
    	    eval q( &atomic_setbits_int( &curcpu()-> &ci_ipending, $p));
	}' unless defined(&set_sint);
	eval 'sub splbio () {
	    eval q( &splraise( &IPL_BIO));
	}' unless defined(&splbio);
	eval 'sub splnet () {
	    eval q( &splraise( &IPL_NET));
	}' unless defined(&splnet);
	eval 'sub spltty () {
	    eval q( &splraise( &IPL_TTY));
	}' unless defined(&spltty);
	eval 'sub splaudio () {
	    eval q( &splraise( &IPL_AUDIO));
	}' unless defined(&splaudio);
	eval 'sub splclock () {
	    eval q( &splraise( &IPL_CLOCK));
	}' unless defined(&splclock);
	eval 'sub splvm () {
	    eval q( &splraise( &IPL_VM));
	}' unless defined(&splvm);
	eval 'sub splsched () {
	    eval q( &splhigh());
	}' unless defined(&splsched);
	eval 'sub spllock () {
	    eval q( &splhigh());
	}' unless defined(&spllock);
	eval 'sub splstatclock () {
	    eval q( &splhigh());
	}' unless defined(&splstatclock);
	eval 'sub splsoftclock () {
	    eval q( &splraise( &IPL_SOFTCLOCK));
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splraise( &IPL_SOFTNET));
	}' unless defined(&splsoftnet);
	eval 'sub splsofttty () {
	    eval q( &splraise( &IPL_SOFTTTY));
	}' unless defined(&splsofttty);
	eval 'sub SI_TO_IRQBIT {
	    my($x) = @_;
    	    eval q((1<< ($x)));
	}' unless defined(&SI_TO_IRQBIT);
	eval 'sub SI_SOFTCLOCK () {0;}' unless defined(&SI_SOFTCLOCK);
	eval 'sub SI_SOFTNET () {1;}' unless defined(&SI_SOFTNET);
	eval 'sub SI_SOFTTTY () {2;}' unless defined(&SI_SOFTTTY);
	eval 'sub SI_NQUEUES () {3;}' unless defined(&SI_NQUEUES);
	require 'machine/mutex.ph';
	require 'sys/queue.ph';
	eval 'sub setsoftclock () {
	    eval q( &set_sint( &SI_TO_IRQBIT( &SI_SOFTCLOCK)));
	}' unless defined(&setsoftclock);
	eval 'sub setsoftnet () {
	    eval q( &set_sint( &SI_TO_IRQBIT( &SI_SOFTNET)));
	}' unless defined(&setsoftnet);
	eval 'sub setsofttty () {
	    eval q( &set_sint( &SI_TO_IRQBIT( &SI_SOFTTTY)));
	}' unless defined(&setsofttty);
	eval 'sub splhigh () {
	    eval q( &splraise( &IPL_HIGH));
	}' unless defined(&splhigh);
	eval 'sub spl0 () {
	    eval q( &spllower( &IPL_NONE));
	}' unless defined(&spl0);
	eval 'sub MAX_PRECONF_INTR () {16;}' unless defined(&MAX_PRECONF_INTR);
	eval 'sub PPC_IPI_NOP () {0;}' unless defined(&PPC_IPI_NOP);
	eval 'sub PPC_IPI_DDB () {1;}' unless defined(&PPC_IPI_DDB);
    }
}
1;
