require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'machine/bus.ph';
require 'sys/device.ph';
require 'sys/selinfo.ph';
if(defined(&DEBUG)) {
    eval 'sub bootverbose () {1;}' unless defined(&bootverbose);
} else {
    eval 'sub bootverbose () {0;}' unless defined(&bootverbose);
}
if(defined(&BROOKTREE_ALLOC_PAGES)) {
    eval 'sub BKTR_ALLOC_PAGES () { &BROOKTREE_ALLOC_PAGES;}' unless defined(&BKTR_ALLOC_PAGES);
}
if(defined(&BROOKTREE_SYSTEM_DEFAULT)) {
    eval 'sub BKTR_SYSTEM_DEFAULT () { &BROOKTREE_SYSTEM_DEFAULT;}' unless defined(&BKTR_SYSTEM_DEFAULT);
}
if(defined(&OVERRIDE_CARD)) {
    eval 'sub BKTR_OVERRIDE_CARD () { &OVERRIDE_CARD;}' unless defined(&BKTR_OVERRIDE_CARD);
}
if(defined(&OVERRIDE_TUNER)) {
    eval 'sub BKTR_OVERRIDE_TUNER () { &OVERRIDE_TUNER;}' unless defined(&BKTR_OVERRIDE_TUNER);
}
if(defined(&OVERRIDE_DBX)) {
    eval 'sub BKTR_OVERRIDE_DBX () { &OVERRIDE_DBX;}' unless defined(&BKTR_OVERRIDE_DBX);
}
if(defined(&OVERRIDE_MSP)) {
    eval 'sub BKTR_OVERRIDE_MSP () { &OVERRIDE_MSP;}' unless defined(&BKTR_OVERRIDE_MSP);
}
unless(defined(&PCI_LATENCY_TIMER)) {
    eval 'sub PCI_LATENCY_TIMER () {0xc;}' unless defined(&PCI_LATENCY_TIMER);
}
require 'dev/pci/pcivar.ph';
eval 'sub PCI_VENDOR_BROOKTREE () {0x109e;}' unless defined(&PCI_VENDOR_BROOKTREE);
eval 'sub PCI_PRODUCT_BROOKTREE_BT848 () {0x350;}' unless defined(&PCI_PRODUCT_BROOKTREE_BT848);
eval 'sub PCI_PRODUCT_BROOKTREE_BT849 () {0x351;}' unless defined(&PCI_PRODUCT_BROOKTREE_BT849);
eval 'sub PCI_PRODUCT_BROOKTREE_BT878 () {0x36e;}' unless defined(&PCI_PRODUCT_BROOKTREE_BT878);
eval 'sub PCI_PRODUCT_BROOKTREE_BT879 () {0x36f;}' unless defined(&PCI_PRODUCT_BROOKTREE_BT879);
eval 'sub BROOKTREE_848 () {1;}' unless defined(&BROOKTREE_848);
eval 'sub BROOKTREE_848A () {2;}' unless defined(&BROOKTREE_848A);
eval 'sub BROOKTREE_849A () {3;}' unless defined(&BROOKTREE_849A);
eval 'sub BROOKTREE_878 () {4;}' unless defined(&BROOKTREE_878);
eval 'sub BROOKTREE_879 () {5;}' unless defined(&BROOKTREE_879);
unless(defined(&BTBYTE)) {
    sub BTBYTE {
	my($what) = @_;
	eval q( &bregister_t $what:8; 'int' :24);
    }
}
unless(defined(&BTWORD)) {
    sub BTWORD {
	my($what) = @_;
	eval q( &bregister_t $what:16; 'int': 16);
    }
}
unless(defined(&BTLONG)) {
    sub BTLONG {
	my($what) = @_;
	eval q( &bregister_t $what:32);
    }
}
eval 'sub BT848_DSTATUS_PRES () {(1<<7);}' unless defined(&BT848_DSTATUS_PRES);
eval 'sub BT848_DSTATUS_HLOC () {(1<<6);}' unless defined(&BT848_DSTATUS_HLOC);
eval 'sub BT848_DSTATUS_FIELD () {(1<<5);}' unless defined(&BT848_DSTATUS_FIELD);
eval 'sub BT848_DSTATUS_NUML () {(1<<4);}' unless defined(&BT848_DSTATUS_NUML);
eval 'sub BT848_DSTATUS_CSEL () {(1<<3);}' unless defined(&BT848_DSTATUS_CSEL);
eval 'sub BT848_DSTATUS_PLOCK () {(1<<2);}' unless defined(&BT848_DSTATUS_PLOCK);
eval 'sub BT848_DSTATUS_LOF () {(1<<1);}' unless defined(&BT848_DSTATUS_LOF);
eval 'sub BT848_DSTATUS_COF () {(1<<0);}' unless defined(&BT848_DSTATUS_COF);
eval 'sub BT848_IFORM_MUXSEL () {(0x3<<5);}' unless defined(&BT848_IFORM_MUXSEL);
eval 'sub BT848_IFORM_M_MUX1 () {(0x3<<5);}' unless defined(&BT848_IFORM_M_MUX1);
eval 'sub BT848_IFORM_M_MUX0 () {(0x2<<5);}' unless defined(&BT848_IFORM_M_MUX0);
eval 'sub BT848_IFORM_M_MUX2 () {(0x1<<5);}' unless defined(&BT848_IFORM_M_MUX2);
eval 'sub BT848_IFORM_M_MUX3 () {(0x);}' unless defined(&BT848_IFORM_M_MUX3);
eval 'sub BT848_IFORM_M_RSVD () {(0x<<5);}' unless defined(&BT848_IFORM_M_RSVD);
eval 'sub BT848_IFORM_XTSEL () {(0x3<<3);}' unless defined(&BT848_IFORM_XTSEL);
eval 'sub BT848_IFORM_X_AUTO () {(0x3<<3);}' unless defined(&BT848_IFORM_X_AUTO);
eval 'sub BT848_IFORM_X_XT1 () {(0x2<<3);}' unless defined(&BT848_IFORM_X_XT1);
eval 'sub BT848_IFORM_X_XT0 () {(0x1<<3);}' unless defined(&BT848_IFORM_X_XT0);
eval 'sub BT848_IFORM_X_RSVD () {(0x<<3);}' unless defined(&BT848_IFORM_X_RSVD);
eval 'sub BT848_E_CONTROL_LNOTCH () {(1<<7);}' unless defined(&BT848_E_CONTROL_LNOTCH);
eval 'sub BT848_E_CONTROL_COMP () {(1<<6);}' unless defined(&BT848_E_CONTROL_COMP);
eval 'sub BT848_E_CONTROL_LDEC () {(1<<5);}' unless defined(&BT848_E_CONTROL_LDEC);
eval 'sub BT848_E_CONTROL_CBSENSE () {(1<<4);}' unless defined(&BT848_E_CONTROL_CBSENSE);
eval 'sub BT848_E_CONTROL_RSVD () {(1<<3);}' unless defined(&BT848_E_CONTROL_RSVD);
eval 'sub BT848_E_CONTROL_CON_MSB () {(1<<2);}' unless defined(&BT848_E_CONTROL_CON_MSB);
eval 'sub BT848_E_CONTROL_SAT_U_MSB () {(1<<1);}' unless defined(&BT848_E_CONTROL_SAT_U_MSB);
eval 'sub BT848_E_CONTROL_SAT_V_MSB () {(1<<0);}' unless defined(&BT848_E_CONTROL_SAT_V_MSB);
eval 'sub BT848_E_SCLOOP_RSVD1 () {(1<<7);}' unless defined(&BT848_E_SCLOOP_RSVD1);
eval 'sub BT848_E_SCLOOP_CAGC () {(1<<6);}' unless defined(&BT848_E_SCLOOP_CAGC);
eval 'sub BT848_E_SCLOOP_CKILL () {(1<<5);}' unless defined(&BT848_E_SCLOOP_CKILL);
eval 'sub BT848_E_SCLOOP_HFILT () {(0x3<<3);}' unless defined(&BT848_E_SCLOOP_HFILT);
eval 'sub BT848_E_SCLOOP_HFILT_ICON () {(0x3<<3);}' unless defined(&BT848_E_SCLOOP_HFILT_ICON);
eval 'sub BT848_E_SCLOOP_HFILT_QCIF () {(0x2<<3);}' unless defined(&BT848_E_SCLOOP_HFILT_QCIF);
eval 'sub BT848_E_SCLOOP_HFILT_CIF () {(0x1<<3);}' unless defined(&BT848_E_SCLOOP_HFILT_CIF);
eval 'sub BT848_E_SCLOOP_HFILT_AUTO () {(0x<<3);}' unless defined(&BT848_E_SCLOOP_HFILT_AUTO);
eval 'sub BT848_E_SCLOOP_RSVD0 () {(0x7<<0);}' unless defined(&BT848_E_SCLOOP_RSVD0);
eval 'sub BT848_ADC_RESERVED () {(0x80);}' unless defined(&BT848_ADC_RESERVED);
eval 'sub BT848_ADC_SYNC_T () {(1<<5);}' unless defined(&BT848_ADC_SYNC_T);
eval 'sub BT848_ADC_AGC_EN () {(1<<4);}' unless defined(&BT848_ADC_AGC_EN);
eval 'sub BT848_ADC_CLK_SLEEP () {(1<<3);}' unless defined(&BT848_ADC_CLK_SLEEP);
eval 'sub BT848_ADC_Y_SLEEP () {(1<<2);}' unless defined(&BT848_ADC_Y_SLEEP);
eval 'sub BT848_ADC_C_SLEEP () {(1<<1);}' unless defined(&BT848_ADC_C_SLEEP);
eval 'sub BT848_ADC_CRUSH () {(1<<0);}' unless defined(&BT848_ADC_CRUSH);
eval 'sub BT848_TGCTRL_TGCKI () {(3<<3);}' unless defined(&BT848_TGCTRL_TGCKI);
eval 'sub BT848_TGCTRL_TGCKI_XTAL () {(0<<3);}' unless defined(&BT848_TGCTRL_TGCKI_XTAL);
eval 'sub BT848_TGCTRL_TGCKI_PLL () {(1<<3);}' unless defined(&BT848_TGCTRL_TGCKI_PLL);
eval 'sub BT848_TGCTRL_TGCKI_GPCLK () {(2<<3);}' unless defined(&BT848_TGCTRL_TGCKI_GPCLK);
eval 'sub BT848_TGCTRL_TGCKI_GPCLK_I () {(3<<3);}' unless defined(&BT848_TGCTRL_TGCKI_GPCLK_I);
eval 'sub BT848_O_CONTROL_LNOTCH () {(1<<7);}' unless defined(&BT848_O_CONTROL_LNOTCH);
eval 'sub BT848_O_CONTROL_COMP () {(1<<6);}' unless defined(&BT848_O_CONTROL_COMP);
eval 'sub BT848_O_CONTROL_LDEC () {(1<<5);}' unless defined(&BT848_O_CONTROL_LDEC);
eval 'sub BT848_O_CONTROL_CBSENSE () {(1<<4);}' unless defined(&BT848_O_CONTROL_CBSENSE);
eval 'sub BT848_O_CONTROL_RSVD () {(1<<3);}' unless defined(&BT848_O_CONTROL_RSVD);
eval 'sub BT848_O_CONTROL_CON_MSB () {(1<<2);}' unless defined(&BT848_O_CONTROL_CON_MSB);
eval 'sub BT848_O_CONTROL_SAT_U_MSB () {(1<<1);}' unless defined(&BT848_O_CONTROL_SAT_U_MSB);
eval 'sub BT848_O_CONTROL_SAT_V_MSB () {(1<<0);}' unless defined(&BT848_O_CONTROL_SAT_V_MSB);
eval 'sub BT848_O_SCLOOP_RSVD1 () {(1<<7);}' unless defined(&BT848_O_SCLOOP_RSVD1);
eval 'sub BT848_O_SCLOOP_CAGC () {(1<<6);}' unless defined(&BT848_O_SCLOOP_CAGC);
eval 'sub BT848_O_SCLOOP_CKILL () {(1<<5);}' unless defined(&BT848_O_SCLOOP_CKILL);
eval 'sub BT848_O_SCLOOP_HFILT () {(0x3<<3);}' unless defined(&BT848_O_SCLOOP_HFILT);
eval 'sub BT848_O_SCLOOP_HFILT_ICON () {(0x3<<3);}' unless defined(&BT848_O_SCLOOP_HFILT_ICON);
eval 'sub BT848_O_SCLOOP_HFILT_QCIF () {(0x2<<3);}' unless defined(&BT848_O_SCLOOP_HFILT_QCIF);
eval 'sub BT848_O_SCLOOP_HFILT_CIF () {(0x1<<3);}' unless defined(&BT848_O_SCLOOP_HFILT_CIF);
eval 'sub BT848_O_SCLOOP_HFILT_AUTO () {(0x<<3);}' unless defined(&BT848_O_SCLOOP_HFILT_AUTO);
eval 'sub BT848_O_SCLOOP_RSVD0 () {(0x7<<0);}' unless defined(&BT848_O_SCLOOP_RSVD0);
eval 'sub BT848_COLOR_CTL_WSWAP_ODD () {(1<<3);}' unless defined(&BT848_COLOR_CTL_WSWAP_ODD);
eval 'sub BT848_COLOR_CTL_WSWAP_EVEN () {(1<<2);}' unless defined(&BT848_COLOR_CTL_WSWAP_EVEN);
eval 'sub BT848_COLOR_CTL_BSWAP_ODD () {(1<<1);}' unless defined(&BT848_COLOR_CTL_BSWAP_ODD);
eval 'sub BT848_COLOR_CTL_BSWAP_EVEN () {(1<<0);}' unless defined(&BT848_COLOR_CTL_BSWAP_EVEN);
eval 'sub BT848_COLOR_CTL_GAMMA () {(1<<4);}' unless defined(&BT848_COLOR_CTL_GAMMA);
eval 'sub BT848_COLOR_CTL_RGB_DED () {(1<<5);}' unless defined(&BT848_COLOR_CTL_RGB_DED);
eval 'sub BT848_COLOR_CTL_COLOR_BARS () {(1<<6);}' unless defined(&BT848_COLOR_CTL_COLOR_BARS);
eval 'sub BT848_COLOR_CTL_EXT_FRMRATE () {(1<<7);}' unless defined(&BT848_COLOR_CTL_EXT_FRMRATE);
eval 'sub BT848_CAP_CTL_DITH_FRAME () {(1<<4);}' unless defined(&BT848_CAP_CTL_DITH_FRAME);
eval 'sub BT848_CAP_CTL_VBI_ODD () {(1<<3);}' unless defined(&BT848_CAP_CTL_VBI_ODD);
eval 'sub BT848_CAP_CTL_VBI_EVEN () {(1<<2);}' unless defined(&BT848_CAP_CTL_VBI_EVEN);
eval 'sub BT848_CAP_CTL_ODD () {(1<<1);}' unless defined(&BT848_CAP_CTL_ODD);
eval 'sub BT848_CAP_CTL_EVEN () {(1<<0);}' unless defined(&BT848_CAP_CTL_EVEN);
eval 'sub BT848_PLL_F_C () {(1<<6);}' unless defined(&BT848_PLL_F_C);
eval 'sub BT848_PLL_F_X () {(1<<7);}' unless defined(&BT848_PLL_F_X);
eval 'sub BT848_INT_RISCS () {(0xf<<28);}' unless defined(&BT848_INT_RISCS);
eval 'sub BT848_INT_RISC_EN () {(1<<27);}' unless defined(&BT848_INT_RISC_EN);
eval 'sub BT848_INT_RACK () {(1<<25);}' unless defined(&BT848_INT_RACK);
eval 'sub BT848_INT_FIELD () {(1<<24);}' unless defined(&BT848_INT_FIELD);
eval 'sub BT848_INT_MYSTERYBIT () {(1<<23);}' unless defined(&BT848_INT_MYSTERYBIT);
eval 'sub BT848_INT_SCERR () {(1<<19);}' unless defined(&BT848_INT_SCERR);
eval 'sub BT848_INT_OCERR () {(1<<18);}' unless defined(&BT848_INT_OCERR);
eval 'sub BT848_INT_PABORT () {(1<<17);}' unless defined(&BT848_INT_PABORT);
eval 'sub BT848_INT_RIPERR () {(1<<16);}' unless defined(&BT848_INT_RIPERR);
eval 'sub BT848_INT_PPERR () {(1<<15);}' unless defined(&BT848_INT_PPERR);
eval 'sub BT848_INT_FDSR () {(1<<14);}' unless defined(&BT848_INT_FDSR);
eval 'sub BT848_INT_FTRGT () {(1<<13);}' unless defined(&BT848_INT_FTRGT);
eval 'sub BT848_INT_FBUS () {(1<<12);}' unless defined(&BT848_INT_FBUS);
eval 'sub BT848_INT_RISCI () {(1<<11);}' unless defined(&BT848_INT_RISCI);
eval 'sub BT848_INT_GPINT () {(1<<9);}' unless defined(&BT848_INT_GPINT);
eval 'sub BT848_INT_I2CDONE () {(1<<8);}' unless defined(&BT848_INT_I2CDONE);
eval 'sub BT848_INT_RSV1 () {(1<<7);}' unless defined(&BT848_INT_RSV1);
eval 'sub BT848_INT_RSV0 () {(1<<6);}' unless defined(&BT848_INT_RSV0);
eval 'sub BT848_INT_VPRES () {(1<<5);}' unless defined(&BT848_INT_VPRES);
eval 'sub BT848_INT_HLOCK () {(1<<4);}' unless defined(&BT848_INT_HLOCK);
eval 'sub BT848_INT_OFLOW () {(1<<3);}' unless defined(&BT848_INT_OFLOW);
eval 'sub BT848_INT_HSYNC () {(1<<2);}' unless defined(&BT848_INT_HSYNC);
eval 'sub BT848_INT_VSYNC () {(1<<1);}' unless defined(&BT848_INT_VSYNC);
eval 'sub BT848_INT_FMTCHG () {(1<<0);}' unless defined(&BT848_INT_FMTCHG);
eval 'sub BT848_INT_BITS () {("\\020\\01FMTCHG\\02VSYNC\\03HSYNC\\04OFLOW\\05HLOCK\\06VPRES\\07RSV0" "\\010RSV1\\011I2CDONE\\012GPINT\\014RISCI\\015FBUS\\016FTRGT\\017FDSR" "\\020PPERR\\021RIPERR\\022PABORT\\023OCERR\\024SCERR" "\\030MYSTERYBIT\\031FIELD\\032RACK\\034RISC_EN");}' unless defined(&BT848_INT_BITS);
eval 'sub BT848_DMA_CTL_PL23TP4 () {(0<<6);}' unless defined(&BT848_DMA_CTL_PL23TP4);
eval 'sub BT848_DMA_CTL_PL23TP8 () {(1<<6);}' unless defined(&BT848_DMA_CTL_PL23TP8);
eval 'sub BT848_DMA_CTL_PL23TP16 () {(2<<6);}' unless defined(&BT848_DMA_CTL_PL23TP16);
eval 'sub BT848_DMA_CTL_PL23TP32 () {(3<<6);}' unless defined(&BT848_DMA_CTL_PL23TP32);
eval 'sub BT848_DMA_CTL_PL1TP4 () {(0<<4);}' unless defined(&BT848_DMA_CTL_PL1TP4);
eval 'sub BT848_DMA_CTL_PL1TP8 () {(1<<4);}' unless defined(&BT848_DMA_CTL_PL1TP8);
eval 'sub BT848_DMA_CTL_PL1TP16 () {(2<<4);}' unless defined(&BT848_DMA_CTL_PL1TP16);
eval 'sub BT848_DMA_CTL_PL1TP32 () {(3<<4);}' unless defined(&BT848_DMA_CTL_PL1TP32);
eval 'sub BT848_DMA_CTL_PKTP4 () {(0<<2);}' unless defined(&BT848_DMA_CTL_PKTP4);
eval 'sub BT848_DMA_CTL_PKTP8 () {(1<<2);}' unless defined(&BT848_DMA_CTL_PKTP8);
eval 'sub BT848_DMA_CTL_PKTP16 () {(2<<2);}' unless defined(&BT848_DMA_CTL_PKTP16);
eval 'sub BT848_DMA_CTL_PKTP32 () {(3<<2);}' unless defined(&BT848_DMA_CTL_PKTP32);
eval 'sub BT848_DMA_CTL_RISC_EN () {(1<<1);}' unless defined(&BT848_DMA_CTL_RISC_EN);
eval 'sub BT848_DMA_CTL_FIFO_EN () {(1<<0);}' unless defined(&BT848_DMA_CTL_FIFO_EN);
eval 'sub BT848_DATA_CTL_I2CDIV () {(0xf<<4);}' unless defined(&BT848_DATA_CTL_I2CDIV);
eval 'sub BT848_DATA_CTL_I2CSYNC () {(1<<3);}' unless defined(&BT848_DATA_CTL_I2CSYNC);
eval 'sub BT848_DATA_CTL_I2CW3B () {(1<<2);}' unless defined(&BT848_DATA_CTL_I2CW3B);
eval 'sub BT848_DATA_CTL_I2CSCL () {(1<<1);}' unless defined(&BT848_DATA_CTL_I2CSCL);
eval 'sub BT848_DATA_CTL_I2CSDA () {(1<<0);}' unless defined(&BT848_DATA_CTL_I2CSDA);
eval 'sub BKTR_DSTATUS () {0x;}' unless defined(&BKTR_DSTATUS);
eval 'sub BKTR_IFORM () {0x4;}' unless defined(&BKTR_IFORM);
eval 'sub BKTR_TDEC () {0x8;}' unless defined(&BKTR_TDEC);
eval 'sub BKTR_E_CROP () {0xc;}' unless defined(&BKTR_E_CROP);
eval 'sub BKTR_O_CROP () {0x8c;}' unless defined(&BKTR_O_CROP);
eval 'sub BKTR_E_VDELAY_LO () {0x10;}' unless defined(&BKTR_E_VDELAY_LO);
eval 'sub BKTR_O_VDELAY_LO () {0x90;}' unless defined(&BKTR_O_VDELAY_LO);
eval 'sub BKTR_E_VACTIVE_LO () {0x14;}' unless defined(&BKTR_E_VACTIVE_LO);
eval 'sub BKTR_O_VACTIVE_LO () {0x94;}' unless defined(&BKTR_O_VACTIVE_LO);
eval 'sub BKTR_E_DELAY_LO () {0x18;}' unless defined(&BKTR_E_DELAY_LO);
eval 'sub BKTR_O_DELAY_LO () {0x98;}' unless defined(&BKTR_O_DELAY_LO);
eval 'sub BKTR_E_HACTIVE_LO () {0x1c;}' unless defined(&BKTR_E_HACTIVE_LO);
eval 'sub BKTR_O_HACTIVE_LO () {0x9c;}' unless defined(&BKTR_O_HACTIVE_LO);
eval 'sub BKTR_E_HSCALE_HI () {0x20;}' unless defined(&BKTR_E_HSCALE_HI);
eval 'sub BKTR_O_HSCALE_HI () {0xa0;}' unless defined(&BKTR_O_HSCALE_HI);
eval 'sub BKTR_E_HSCALE_LO () {0x24;}' unless defined(&BKTR_E_HSCALE_LO);
eval 'sub BKTR_O_HSCALE_LO () {0xa4;}' unless defined(&BKTR_O_HSCALE_LO);
eval 'sub BKTR_BRIGHT () {0x28;}' unless defined(&BKTR_BRIGHT);
eval 'sub BKTR_E_CONTROL () {0x2c;}' unless defined(&BKTR_E_CONTROL);
eval 'sub BKTR_O_CONTROL () {0xac;}' unless defined(&BKTR_O_CONTROL);
eval 'sub BKTR_CONTRAST_LO () {0x30;}' unless defined(&BKTR_CONTRAST_LO);
eval 'sub BKTR_SAT_U_LO () {0x34;}' unless defined(&BKTR_SAT_U_LO);
eval 'sub BKTR_SAT_V_LO () {0x38;}' unless defined(&BKTR_SAT_V_LO);
eval 'sub BKTR_HUE () {0x3c;}' unless defined(&BKTR_HUE);
eval 'sub BKTR_E_SCLOOP () {0x40;}' unless defined(&BKTR_E_SCLOOP);
eval 'sub BKTR_O_SCLOOP () {0xc0;}' unless defined(&BKTR_O_SCLOOP);
eval 'sub BKTR_OFORM () {0x48;}' unless defined(&BKTR_OFORM);
eval 'sub BKTR_E_VSCALE_HI () {0x4c;}' unless defined(&BKTR_E_VSCALE_HI);
eval 'sub BKTR_O_VSCALE_HI () {0xcc;}' unless defined(&BKTR_O_VSCALE_HI);
eval 'sub BKTR_E_VSCALE_LO () {0x50;}' unless defined(&BKTR_E_VSCALE_LO);
eval 'sub BKTR_O_VSCALE_LO () {0xd0;}' unless defined(&BKTR_O_VSCALE_LO);
eval 'sub BKTR_TEST () {0x54;}' unless defined(&BKTR_TEST);
eval 'sub BKTR_ADELAY () {0x60;}' unless defined(&BKTR_ADELAY);
eval 'sub BKTR_BDELAY () {0x64;}' unless defined(&BKTR_BDELAY);
eval 'sub BKTR_ADC () {0x68;}' unless defined(&BKTR_ADC);
eval 'sub BKTR_E_VTC () {0x6c;}' unless defined(&BKTR_E_VTC);
eval 'sub BKTR_O_VTC () {0xec;}' unless defined(&BKTR_O_VTC);
eval 'sub BKTR_SRESET () {0x7c;}' unless defined(&BKTR_SRESET);
eval 'sub BKTR_COLOR_FMT () {0xd4;}' unless defined(&BKTR_COLOR_FMT);
eval 'sub BKTR_COLOR_CTL () {0xd8;}' unless defined(&BKTR_COLOR_CTL);
eval 'sub BKTR_CAP_CTL () {0xdc;}' unless defined(&BKTR_CAP_CTL);
eval 'sub BKTR_VBI_PACK_SIZE () {0xe0;}' unless defined(&BKTR_VBI_PACK_SIZE);
eval 'sub BKTR_VBI_PACK_DEL () {0xe4;}' unless defined(&BKTR_VBI_PACK_DEL);
eval 'sub BKTR_INT_STAT () {0x100;}' unless defined(&BKTR_INT_STAT);
eval 'sub BKTR_INT_MASK () {0x104;}' unless defined(&BKTR_INT_MASK);
eval 'sub BKTR_RISC_COUNT () {0x120;}' unless defined(&BKTR_RISC_COUNT);
eval 'sub BKTR_RISC_STRT_ADD () {0x114;}' unless defined(&BKTR_RISC_STRT_ADD);
eval 'sub BKTR_GPIO_DMA_CTL () {0x10c;}' unless defined(&BKTR_GPIO_DMA_CTL);
eval 'sub BKTR_GPIO_OUT_EN () {0x118;}' unless defined(&BKTR_GPIO_OUT_EN);
eval 'sub BKTR_GPIO_REG_INP () {0x11c;}' unless defined(&BKTR_GPIO_REG_INP);
eval 'sub BKTR_GPIO_DATA () {0x200;}' unless defined(&BKTR_GPIO_DATA);
eval 'sub BKTR_I2C_DATA_CTL () {0x110;}' unless defined(&BKTR_I2C_DATA_CTL);
eval 'sub BKTR_TGCTRL () {0x84;}' unless defined(&BKTR_TGCTRL);
eval 'sub BKTR_PLL_F_LO () {0xf0;}' unless defined(&BKTR_PLL_F_LO);
eval 'sub BKTR_PLL_F_HI () {0xf4;}' unless defined(&BKTR_PLL_F_HI);
eval 'sub BKTR_PLL_F_XCI () {0xf8;}' unless defined(&BKTR_PLL_F_XCI);
eval 'sub BT848_TUNER_MODE_TV () {1;}' unless defined(&BT848_TUNER_MODE_TV);
eval 'sub BT848_TUNER_MODE_RADIO () {2;}' unless defined(&BT848_TUNER_MODE_RADIO);
eval 'sub EEPROMBLOCKSIZE () {32;}' unless defined(&EEPROMBLOCKSIZE);
unless(defined(&INB)) {
    sub INB {
	my($sc,$o) = @_;
	eval q((({  &u_int8_t  &__v;  &__v =  &bus_space_read_1(($sc)-> &memt, ($sc)-> &memh, ($o));  &bus_space_barrier(($sc)-> &memt, ($sc)-> &memh, ($o), 1,  &BUS_SPACE_BARRIER_READ); ( &__v); })));
    }
}
unless(defined(&INW)) {
    sub INW {
	my($sc,$o) = @_;
	eval q((({  &u_int16_t  &__v;  &__v =  &bus_space_read_2(($sc)-> &memt, ($sc)-> &memh, ($o));  &bus_space_barrier(($sc)-> &memt, ($sc)-> &memh, ($o), 4,  &BUS_SPACE_BARRIER_READ); ( &__v); })));
    }
}
unless(defined(&INL)) {
    sub INL {
	my($sc,$o) = @_;
	eval q((({  &u_int32_t  &__v;  &__v =  &bus_space_read_4(($sc)-> &memt, ($sc)-> &memh, ($o));  &bus_space_barrier(($sc)-> &memt, ($sc)-> &memh, ($o), 4,  &BUS_SPACE_BARRIER_READ); ( &__v); })));
    }
}
unless(defined(&OUTB)) {
    sub OUTB {
	my($sc,$o,$v) = @_;
	eval q( &do {  &bus_space_write_1(($sc)-> &memt, ($sc)-> &memh, ($o), ($v));  &bus_space_barrier(($sc)-> &memt, ($sc)-> &memh, ($o), 1,  &BUS_SPACE_BARRIER_WRITE); }  &while (0));
    }
}
unless(defined(&OUTW)) {
    sub OUTW {
	my($sc,$o,$v) = @_;
	eval q( &do {  &bus_space_write_2(($sc)-> &memt, ($sc)-> &memh, ($o), ($v));  &bus_space_barrier(($sc)-> &memt, ($sc)-> &memh, ($o), 2,  &BUS_SPACE_BARRIER_WRITE); }  &while (0));
    }
}
unless(defined(&OUTL)) {
    sub OUTL {
	my($sc,$o,$v) = @_;
	eval q( &do {  &bus_space_write_4(($sc)-> &memt, ($sc)-> &memh, ($o), ($v));  &bus_space_barrier(($sc)-> &memt, ($sc)-> &memh, ($o), 4,  &BUS_SPACE_BARRIER_WRITE); }  &while (0));
    }
}
eval 'sub METEOR_SIG_MODE_MASK () {0xffff0000;}' unless defined(&METEOR_SIG_MODE_MASK);
eval 'sub METEOR_SIG_FIELD_MODE () {0x10000;}' unless defined(&METEOR_SIG_FIELD_MODE);
eval 'sub METEOR_SIG_FRAME_MODE () {0x;}' unless defined(&METEOR_SIG_FRAME_MODE);
eval 'sub METEOR_INITIALIZED () {0x1;}' unless defined(&METEOR_INITIALIZED);
eval 'sub METEOR_OPEN () {0x2;}' unless defined(&METEOR_OPEN);
eval 'sub METEOR_MMAP () {0x4;}' unless defined(&METEOR_MMAP);
eval 'sub METEOR_INTR () {0x8;}' unless defined(&METEOR_INTR);
eval 'sub METEOR_READ () {0x10;}' unless defined(&METEOR_READ);
eval 'sub METEOR_SINGLE () {0x20;}' unless defined(&METEOR_SINGLE);
eval 'sub METEOR_CONTIN () {0x40;}' unless defined(&METEOR_CONTIN);
eval 'sub METEOR_SYNCAP () {0x80;}' unless defined(&METEOR_SYNCAP);
eval 'sub METEOR_CAP_MASK () {0xf0;}' unless defined(&METEOR_CAP_MASK);
eval 'sub METEOR_NTSC () {0x100;}' unless defined(&METEOR_NTSC);
eval 'sub METEOR_PAL () {0x200;}' unless defined(&METEOR_PAL);
eval 'sub METEOR_SECAM () {0x400;}' unless defined(&METEOR_SECAM);
eval 'sub BROOKTREE_NTSC () {0x100;}' unless defined(&BROOKTREE_NTSC);
eval 'sub BROOKTREE_PAL () {0x200;}' unless defined(&BROOKTREE_PAL);
eval 'sub BROOKTREE_SECAM () {0x400;}' unless defined(&BROOKTREE_SECAM);
eval 'sub METEOR_AUTOMODE () {0x800;}' unless defined(&METEOR_AUTOMODE);
eval 'sub METEOR_FORM_MASK () {0xf00;}' unless defined(&METEOR_FORM_MASK);
eval 'sub METEOR_DEV0 () {0x1000;}' unless defined(&METEOR_DEV0);
eval 'sub METEOR_DEV1 () {0x2000;}' unless defined(&METEOR_DEV1);
eval 'sub METEOR_DEV2 () {0x4000;}' unless defined(&METEOR_DEV2);
eval 'sub METEOR_DEV3 () {0x8000;}' unless defined(&METEOR_DEV3);
eval 'sub METEOR_DEV_SVIDEO () {0x6000;}' unless defined(&METEOR_DEV_SVIDEO);
eval 'sub METEOR_DEV_RGB () {0xa000;}' unless defined(&METEOR_DEV_RGB);
eval 'sub METEOR_DEV_MASK () {0xf000;}' unless defined(&METEOR_DEV_MASK);
eval 'sub METEOR_RGB16 () {0x10000;}' unless defined(&METEOR_RGB16);
eval 'sub METEOR_RGB24 () {0x20000;}' unless defined(&METEOR_RGB24);
eval 'sub METEOR_YUV_PACKED () {0x40000;}' unless defined(&METEOR_YUV_PACKED);
eval 'sub METEOR_YUV_PLANAR () {0x80000;}' unless defined(&METEOR_YUV_PLANAR);
eval 'sub METEOR_WANT_EVEN () {0x100000;}' unless defined(&METEOR_WANT_EVEN);
eval 'sub METEOR_WANT_ODD () {0x200000;}' unless defined(&METEOR_WANT_ODD);
eval 'sub METEOR_WANT_MASK () {0x300000;}' unless defined(&METEOR_WANT_MASK);
eval 'sub METEOR_ONLY_EVEN_FIELDS () {0x1000000;}' unless defined(&METEOR_ONLY_EVEN_FIELDS);
eval 'sub METEOR_ONLY_ODD_FIELDS () {0x2000000;}' unless defined(&METEOR_ONLY_ODD_FIELDS);
eval 'sub METEOR_ONLY_FIELDS_MASK () {0x3000000;}' unless defined(&METEOR_ONLY_FIELDS_MASK);
eval 'sub METEOR_YUV_422 () {0x4000000;}' unless defined(&METEOR_YUV_422);
eval 'sub METEOR_OUTPUT_FMT_MASK () {0x40f0000;}' unless defined(&METEOR_OUTPUT_FMT_MASK);
eval 'sub METEOR_WANT_TS () {0x8000000;}' unless defined(&METEOR_WANT_TS);
eval 'sub METEOR_RGB () {0x20000000;}' unless defined(&METEOR_RGB);
eval 'sub METEOR_FIELD_MODE () {0x80000000;}' unless defined(&METEOR_FIELD_MODE);
eval 'sub TUNER_INITIALIZED () {0x1;}' unless defined(&TUNER_INITIALIZED);
eval 'sub TUNER_OPEN () {0x2;}' unless defined(&TUNER_OPEN);
eval 'sub VBI_INITIALIZED () {0x1;}' unless defined(&VBI_INITIALIZED);
eval 'sub VBI_OPEN () {0x2;}' unless defined(&VBI_OPEN);
eval 'sub VBI_CAPTURE () {0x4;}' unless defined(&VBI_CAPTURE);
eval 'sub BT848_USE_XTALS () {0;}' unless defined(&BT848_USE_XTALS);
eval 'sub BT848_USE_PLL () {1;}' unless defined(&BT848_USE_PLL);
eval 'sub Bt848_MAX_SIGN () {16;}' unless defined(&Bt848_MAX_SIGN);
1;
