require '_h2ph_pre.ph';

no warnings qw(redefine misc);

eval 'sub TI_PCI_ID () { &PCI_ID_REG;}' unless defined(&TI_PCI_ID);
eval 'sub TI_PCI_CMDSTAT () { &PCI_COMMAND_STATUS_REG;}' unless defined(&TI_PCI_CMDSTAT);
eval 'sub TI_PCI_CLASSCODE () { &PCI_CLASS_REG;}' unless defined(&TI_PCI_CLASSCODE);
eval 'sub TI_PCI_BIST () { &PCI_BHLC_REG;}' unless defined(&TI_PCI_BIST);
eval 'sub TI_PCI_LOMEM () { &PCI_MAPS;}' unless defined(&TI_PCI_LOMEM);
eval 'sub TI_PCI_SUBSYS () { &PCI_SUBVEND_0;}' unless defined(&TI_PCI_SUBSYS);
eval 'sub TI_PCI_ROMBASE () {0x30;}' unless defined(&TI_PCI_ROMBASE);
eval 'sub TI_PCI_INT () { &PCI_INTLINE;}' unless defined(&TI_PCI_INT);
eval 'sub TI_MISC_HOST_CTL () {0x40;}' unless defined(&TI_MISC_HOST_CTL);
eval 'sub TI_MISC_LOCAL_CTL () {0x44;}' unless defined(&TI_MISC_LOCAL_CTL);
eval 'sub TI_SEM_AB () {0x48;}' unless defined(&TI_SEM_AB);
eval 'sub TI_MISC_CONF () {0x50;}' unless defined(&TI_MISC_CONF);
eval 'sub TI_TIMER_BITS () {0x54;}' unless defined(&TI_TIMER_BITS);
eval 'sub TI_TIMERREF () {0x58;}' unless defined(&TI_TIMERREF);
eval 'sub TI_PCI_STATE () {0x5c;}' unless defined(&TI_PCI_STATE);
eval 'sub TI_MAIN_EVENT_A () {0x60;}' unless defined(&TI_MAIN_EVENT_A);
eval 'sub TI_MAILBOX_EVENT_A () {0x64;}' unless defined(&TI_MAILBOX_EVENT_A);
eval 'sub TI_WINBASE () {0x68;}' unless defined(&TI_WINBASE);
eval 'sub TI_WINDATA () {0x6c;}' unless defined(&TI_WINDATA);
eval 'sub TI_MAIN_EVENT_B () {0x70;}' unless defined(&TI_MAIN_EVENT_B);
eval 'sub TI_MAILBOX_EVENT_B () {0x74;}' unless defined(&TI_MAILBOX_EVENT_B);
eval 'sub TI_TIMERREF_B () {0x78;}' unless defined(&TI_TIMERREF_B);
eval 'sub TI_SERIAL () {0x7c;}' unless defined(&TI_SERIAL);
eval 'sub TI_MHC_INTSTATE () {0x1;}' unless defined(&TI_MHC_INTSTATE);
eval 'sub TI_MHC_CLEARINT () {0x2;}' unless defined(&TI_MHC_CLEARINT);
eval 'sub TI_MHC_RESET () {0x8;}' unless defined(&TI_MHC_RESET);
eval 'sub TI_MHC_BYTE_SWAP_ENB () {0x10;}' unless defined(&TI_MHC_BYTE_SWAP_ENB);
eval 'sub TI_MHC_WORD_SWAP_ENB () {0x20;}' unless defined(&TI_MHC_WORD_SWAP_ENB);
eval 'sub TI_MHC_MASK_INTS () {0x40;}' unless defined(&TI_MHC_MASK_INTS);
eval 'sub TI_MHC_CHIP_REV_MASK () {0xf0000000;}' unless defined(&TI_MHC_CHIP_REV_MASK);
eval 'sub TI_MHC_BIGENDIAN_INIT () {( &TI_MHC_BYTE_SWAP_ENB| &TI_MHC_WORD_SWAP_ENB| &TI_MHC_CLEARINT);}' unless defined(&TI_MHC_BIGENDIAN_INIT);
eval 'sub TI_MHC_LITTLEENDIAN_INIT () {( &TI_MHC_WORD_SWAP_ENB| &TI_MHC_CLEARINT);}' unless defined(&TI_MHC_LITTLEENDIAN_INIT);
eval 'sub TI_REV_TIGON_I () {0x40000000;}' unless defined(&TI_REV_TIGON_I);
eval 'sub TI_REV_TIGON_II () {0x60000000;}' unless defined(&TI_REV_TIGON_II);
eval 'sub TI_FIRMWARE_MAJOR () {0xc;}' unless defined(&TI_FIRMWARE_MAJOR);
eval 'sub TI_FIRMWARE_MINOR () {0x4;}' unless defined(&TI_FIRMWARE_MINOR);
eval 'sub TI_FIRMWARE_FIX () {0xd;}' unless defined(&TI_FIRMWARE_FIX);
eval 'sub TI_MLC_EE_WRITE_ENB () {0x10;}' unless defined(&TI_MLC_EE_WRITE_ENB);
eval 'sub TI_MLC_SRAM_BANK_SIZE () {0x300;}' unless defined(&TI_MLC_SRAM_BANK_SIZE);
eval 'sub TI_MLC_LOCALADDR_21 () {0x4000;}' unless defined(&TI_MLC_LOCALADDR_21);
eval 'sub TI_MLC_LOCALADDR_22 () {0x8000;}' unless defined(&TI_MLC_LOCALADDR_22);
eval 'sub TI_MLC_SBUS_WRITEERR () {0x80000;}' unless defined(&TI_MLC_SBUS_WRITEERR);
eval 'sub TI_MLC_EE_CLK () {0x100000;}' unless defined(&TI_MLC_EE_CLK);
eval 'sub TI_MLC_EE_TXEN () {0x200000;}' unless defined(&TI_MLC_EE_TXEN);
eval 'sub TI_MLC_EE_DOUT () {0x400000;}' unless defined(&TI_MLC_EE_DOUT);
eval 'sub TI_MLC_EE_DIN () {0x800000;}' unless defined(&TI_MLC_EE_DIN);
eval 'sub TI_MLC_SRAM_BANK_DISA () {0x;}' unless defined(&TI_MLC_SRAM_BANK_DISA);
eval 'sub TI_MLC_SRAM_BANK_1024K () {0x100;}' unless defined(&TI_MLC_SRAM_BANK_1024K);
eval 'sub TI_MLC_SRAM_BANK_512K () {0x200;}' unless defined(&TI_MLC_SRAM_BANK_512K);
eval 'sub TI_MLC_SRAM_BANK_256K () {0x300;}' unless defined(&TI_MLC_SRAM_BANK_256K);
eval 'sub TI_EE_MAC_OFFSET () {0x8c;}' unless defined(&TI_EE_MAC_OFFSET);
eval 'sub TI_DMA_ASSIST () {0x11c;}' unless defined(&TI_DMA_ASSIST);
eval 'sub TI_CPU_STATE () {0x140;}' unless defined(&TI_CPU_STATE);
eval 'sub TI_CPU_PROGRAM_COUNTER () {0x144;}' unless defined(&TI_CPU_PROGRAM_COUNTER);
eval 'sub TI_SRAM_ADDR () {0x154;}' unless defined(&TI_SRAM_ADDR);
eval 'sub TI_SRAM_DATA () {0x158;}' unless defined(&TI_SRAM_DATA);
eval 'sub TI_GEN_0 () {0x180;}' unless defined(&TI_GEN_0);
eval 'sub TI_GEN_X () {0x1fc;}' unless defined(&TI_GEN_X);
eval 'sub TI_MAC_TX_STATE () {0x200;}' unless defined(&TI_MAC_TX_STATE);
eval 'sub TI_MAC_RX_STATE () {0x220;}' unless defined(&TI_MAC_RX_STATE);
eval 'sub TI_CPU_CTL_B () {0x240;}' unless defined(&TI_CPU_CTL_B);
eval 'sub TI_CPU_PROGRAM_COUNTER_B () {0x244;}' unless defined(&TI_CPU_PROGRAM_COUNTER_B);
eval 'sub TI_SRAM_ADDR_B () {0x254;}' unless defined(&TI_SRAM_ADDR_B);
eval 'sub TI_SRAM_DATA_B () {0x258;}' unless defined(&TI_SRAM_DATA_B);
eval 'sub TI_GEN_B_0 () {0x280;}' unless defined(&TI_GEN_B_0);
eval 'sub TI_GEN_B_X () {0x2fc;}' unless defined(&TI_GEN_B_X);
eval 'sub TI_MCR_SRAM_SYNCHRONOUS () {0x100000;}' unless defined(&TI_MCR_SRAM_SYNCHRONOUS);
eval 'sub TI_PCISTATE_FORCE_RESET () {0x1;}' unless defined(&TI_PCISTATE_FORCE_RESET);
eval 'sub TI_PCISTATE_PROVIDE_LEN () {0x2;}' unless defined(&TI_PCISTATE_PROVIDE_LEN);
eval 'sub TI_PCISTATE_READ_MAXDMA () {0x1c;}' unless defined(&TI_PCISTATE_READ_MAXDMA);
eval 'sub TI_PCISTATE_WRITE_MAXDMA () {0xe0;}' unless defined(&TI_PCISTATE_WRITE_MAXDMA);
eval 'sub TI_PCISTATE_MINDMA () {0xff00;}' unless defined(&TI_PCISTATE_MINDMA);
eval 'sub TI_PCISTATE_FIFO_RETRY_ENB () {0x10000;}' unless defined(&TI_PCISTATE_FIFO_RETRY_ENB);
eval 'sub TI_PCISTATE_USE_MEM_RD_MULT () {0x20000;}' unless defined(&TI_PCISTATE_USE_MEM_RD_MULT);
eval 'sub TI_PCISTATE_NO_SWAP_READ_DMA () {0x40000;}' unless defined(&TI_PCISTATE_NO_SWAP_READ_DMA);
eval 'sub TI_PCISTATE_NO_SWAP_WRITE_DMA () {0x80000;}' unless defined(&TI_PCISTATE_NO_SWAP_WRITE_DMA);
eval 'sub TI_PCISTATE_66MHZ_BUS () {0x80000;}' unless defined(&TI_PCISTATE_66MHZ_BUS);
eval 'sub TI_PCISTATE_32BIT_BUS () {0x100000;}' unless defined(&TI_PCISTATE_32BIT_BUS);
eval 'sub TI_PCISTATE_ENB_BYTE_ENABLES () {0x800000;}' unless defined(&TI_PCISTATE_ENB_BYTE_ENABLES);
eval 'sub TI_PCISTATE_READ_CMD () {0xf000000;}' unless defined(&TI_PCISTATE_READ_CMD);
eval 'sub TI_PCISTATE_WRITE_CMD () {0xf0000000;}' unless defined(&TI_PCISTATE_WRITE_CMD);
eval 'sub TI_PCI_READMAX_4 () {0x4;}' unless defined(&TI_PCI_READMAX_4);
eval 'sub TI_PCI_READMAX_16 () {0x8;}' unless defined(&TI_PCI_READMAX_16);
eval 'sub TI_PCI_READMAX_32 () {0xc;}' unless defined(&TI_PCI_READMAX_32);
eval 'sub TI_PCI_READMAX_64 () {0x10;}' unless defined(&TI_PCI_READMAX_64);
eval 'sub TI_PCI_READMAX_128 () {0x14;}' unless defined(&TI_PCI_READMAX_128);
eval 'sub TI_PCI_READMAX_256 () {0x18;}' unless defined(&TI_PCI_READMAX_256);
eval 'sub TI_PCI_READMAX_1024 () {0x1c;}' unless defined(&TI_PCI_READMAX_1024);
eval 'sub TI_PCI_WRITEMAX_4 () {0x20;}' unless defined(&TI_PCI_WRITEMAX_4);
eval 'sub TI_PCI_WRITEMAX_16 () {0x40;}' unless defined(&TI_PCI_WRITEMAX_16);
eval 'sub TI_PCI_WRITEMAX_32 () {0x60;}' unless defined(&TI_PCI_WRITEMAX_32);
eval 'sub TI_PCI_WRITEMAX_64 () {0x80;}' unless defined(&TI_PCI_WRITEMAX_64);
eval 'sub TI_PCI_WRITEMAX_128 () {0xa0;}' unless defined(&TI_PCI_WRITEMAX_128);
eval 'sub TI_PCI_WRITEMAX_256 () {0xc0;}' unless defined(&TI_PCI_WRITEMAX_256);
eval 'sub TI_PCI_WRITEMAX_1024 () {0xe0;}' unless defined(&TI_PCI_WRITEMAX_1024);
eval 'sub TI_PCI_READ_CMD () {0x6000000;}' unless defined(&TI_PCI_READ_CMD);
eval 'sub TI_PCI_WRITE_CMD () {0x70000000;}' unless defined(&TI_PCI_WRITE_CMD);
eval 'sub TI_DMASTATE_ENABLE () {0x1;}' unless defined(&TI_DMASTATE_ENABLE);
eval 'sub TI_DMASTATE_PAUSE () {0x2;}' unless defined(&TI_DMASTATE_PAUSE);
eval 'sub TI_CPUSTATE_RESET () {0x1;}' unless defined(&TI_CPUSTATE_RESET);
eval 'sub TI_CPUSTATE_STEP () {0x2;}' unless defined(&TI_CPUSTATE_STEP);
eval 'sub TI_CPUSTATE_ROMFAIL () {0x10;}' unless defined(&TI_CPUSTATE_ROMFAIL);
eval 'sub TI_CPUSTATE_HALT () {0x10000;}' unless defined(&TI_CPUSTATE_HALT);
eval 'sub TI_TXSTATE_RESET () {0x1;}' unless defined(&TI_TXSTATE_RESET);
eval 'sub TI_TXSTATE_ENB () {0x2;}' unless defined(&TI_TXSTATE_ENB);
eval 'sub TI_TXSTATE_STOP () {0x4;}' unless defined(&TI_TXSTATE_STOP);
eval 'sub TI_RXSTATE_RESET () {0x1;}' unless defined(&TI_RXSTATE_RESET);
eval 'sub TI_RXSTATE_ENB () {0x2;}' unless defined(&TI_RXSTATE_ENB);
eval 'sub TI_RXSTATE_STOP () {0x4;}' unless defined(&TI_RXSTATE_STOP);
eval 'sub TI_MB_HOSTINTR_HI () {0x500;}' unless defined(&TI_MB_HOSTINTR_HI);
eval 'sub TI_MB_HOSTINTR_LO () {0x504;}' unless defined(&TI_MB_HOSTINTR_LO);
eval 'sub TI_MB_HOSTINTR () { &TI_MB_HOSTINTR_LO;}' unless defined(&TI_MB_HOSTINTR);
eval 'sub TI_MB_CMDPROD_IDX_HI () {0x508;}' unless defined(&TI_MB_CMDPROD_IDX_HI);
eval 'sub TI_MB_CMDPROD_IDX_LO () {0x50c;}' unless defined(&TI_MB_CMDPROD_IDX_LO);
eval 'sub TI_MB_CMDPROD_IDX () { &TI_MB_CMDPROD_IDX_LO;}' unless defined(&TI_MB_CMDPROD_IDX);
eval 'sub TI_MB_SENDPROD_IDX_HI () {0x510;}' unless defined(&TI_MB_SENDPROD_IDX_HI);
eval 'sub TI_MB_SENDPROD_IDX_LO () {0x514;}' unless defined(&TI_MB_SENDPROD_IDX_LO);
eval 'sub TI_MB_SENDPROD_IDX () { &TI_MB_SENDPROD_IDX_LO;}' unless defined(&TI_MB_SENDPROD_IDX);
eval 'sub TI_MB_STDRXPROD_IDX_HI () {0x518;}' unless defined(&TI_MB_STDRXPROD_IDX_HI);
eval 'sub TI_MB_STDRXPROD_IDX_LO () {0x51c;}' unless defined(&TI_MB_STDRXPROD_IDX_LO);
eval 'sub TI_MB_STDRXPROD_IDX () { &TI_MB_STDRXPROD_IDX_LO;}' unless defined(&TI_MB_STDRXPROD_IDX);
eval 'sub TI_MB_JUMBORXPROD_IDX_HI () {0x520;}' unless defined(&TI_MB_JUMBORXPROD_IDX_HI);
eval 'sub TI_MB_JUMBORXPROD_IDX_LO () {0x524;}' unless defined(&TI_MB_JUMBORXPROD_IDX_LO);
eval 'sub TI_MB_JUMBORXPROD_IDX () { &TI_MB_JUMBORXPROD_IDX_LO;}' unless defined(&TI_MB_JUMBORXPROD_IDX);
eval 'sub TI_MB_MINIRXPROD_IDX_HI () {0x528;}' unless defined(&TI_MB_MINIRXPROD_IDX_HI);
eval 'sub TI_MB_MINIRXPROD_IDX_LO () {0x52c;}' unless defined(&TI_MB_MINIRXPROD_IDX_LO);
eval 'sub TI_MB_MINIRXPROD_IDX () { &TI_MB_MINIRXPROD_IDX_LO;}' unless defined(&TI_MB_MINIRXPROD_IDX);
eval 'sub TI_MB_RSVD () {0x530;}' unless defined(&TI_MB_RSVD);
eval 'sub TI_GCR_BASE () {0x600;}' unless defined(&TI_GCR_BASE);
eval 'sub TI_GCR_MACADDR () {0x600;}' unless defined(&TI_GCR_MACADDR);
eval 'sub TI_GCR_PAR0 () {0x600;}' unless defined(&TI_GCR_PAR0);
eval 'sub TI_GCR_PAR1 () {0x604;}' unless defined(&TI_GCR_PAR1);
eval 'sub TI_GCR_GENINFO_HI () {0x608;}' unless defined(&TI_GCR_GENINFO_HI);
eval 'sub TI_GCR_GENINFO_LO () {0x60c;}' unless defined(&TI_GCR_GENINFO_LO);
eval 'sub TI_GCR_MCASTADDR () {0x610;}' unless defined(&TI_GCR_MCASTADDR);
eval 'sub TI_GCR_MAR0 () {0x610;}' unless defined(&TI_GCR_MAR0);
eval 'sub TI_GCR_MAR1 () {0x614;}' unless defined(&TI_GCR_MAR1);
eval 'sub TI_GCR_OPMODE () {0x618;}' unless defined(&TI_GCR_OPMODE);
eval 'sub TI_GCR_DMA_READCFG () {0x61c;}' unless defined(&TI_GCR_DMA_READCFG);
eval 'sub TI_GCR_DMA_WRITECFG () {0x620;}' unless defined(&TI_GCR_DMA_WRITECFG);
eval 'sub TI_GCR_TX_BUFFER_RATIO () {0x624;}' unless defined(&TI_GCR_TX_BUFFER_RATIO);
eval 'sub TI_GCR_EVENTCONS_IDX () {0x628;}' unless defined(&TI_GCR_EVENTCONS_IDX);
eval 'sub TI_GCR_CMDCONS_IDX () {0x62c;}' unless defined(&TI_GCR_CMDCONS_IDX);
eval 'sub TI_GCR_TUNEPARMS () {0x630;}' unless defined(&TI_GCR_TUNEPARMS);
eval 'sub TI_GCR_RX_COAL_TICKS () {0x630;}' unless defined(&TI_GCR_RX_COAL_TICKS);
eval 'sub TI_GCR_TX_COAL_TICKS () {0x634;}' unless defined(&TI_GCR_TX_COAL_TICKS);
eval 'sub TI_GCR_STAT_TICKS () {0x638;}' unless defined(&TI_GCR_STAT_TICKS);
eval 'sub TI_GCR_TX_MAX_COAL_BD () {0x63c;}' unless defined(&TI_GCR_TX_MAX_COAL_BD);
eval 'sub TI_GCR_RX_MAX_COAL_BD () {0x640;}' unless defined(&TI_GCR_RX_MAX_COAL_BD);
eval 'sub TI_GCR_NIC_TRACING () {0x644;}' unless defined(&TI_GCR_NIC_TRACING);
eval 'sub TI_GCR_GLINK () {0x648;}' unless defined(&TI_GCR_GLINK);
eval 'sub TI_GCR_LINK () {0x64c;}' unless defined(&TI_GCR_LINK);
eval 'sub TI_GCR_NICTRACE_PTR () {0x650;}' unless defined(&TI_GCR_NICTRACE_PTR);
eval 'sub TI_GCR_NICTRACE_START () {0x654;}' unless defined(&TI_GCR_NICTRACE_START);
eval 'sub TI_GCR_NICTRACE_LEN () {0x658;}' unless defined(&TI_GCR_NICTRACE_LEN);
eval 'sub TI_GCR_IFINDEX () {0x65c;}' unless defined(&TI_GCR_IFINDEX);
eval 'sub TI_GCR_IFMTU () {0x660;}' unless defined(&TI_GCR_IFMTU);
eval 'sub TI_GCR_MASK_INTRS () {0x664;}' unless defined(&TI_GCR_MASK_INTRS);
eval 'sub TI_GCR_GLINK_STAT () {0x668;}' unless defined(&TI_GCR_GLINK_STAT);
eval 'sub TI_GCR_LINK_STAT () {0x66c;}' unless defined(&TI_GCR_LINK_STAT);
eval 'sub TI_GCR_RXRETURNCONS_IDX () {0x680;}' unless defined(&TI_GCR_RXRETURNCONS_IDX);
eval 'sub TI_GCR_CMDRING () {0x700;}' unless defined(&TI_GCR_CMDRING);
unless(defined(&TI_GCR_NIC_ADDR)) {
    sub TI_GCR_NIC_ADDR {
	my($x) = @_;
	eval q(($x -  &TI_GCR_BASE));
    }
}
eval 'sub TI_WINDOW () {0x800;}' unless defined(&TI_WINDOW);
eval 'sub TI_WINLEN () {0x800;}' unless defined(&TI_WINLEN);
eval 'sub TI_TICKS_PER_SEC () {1000000;}' unless defined(&TI_TICKS_PER_SEC);
eval 'sub TI_OPMODE_BYTESWAP_BD () {0x2;}' unless defined(&TI_OPMODE_BYTESWAP_BD);
eval 'sub TI_OPMODE_WORDSWAP_BD () {0x4;}' unless defined(&TI_OPMODE_WORDSWAP_BD);
eval 'sub TI_OPMODE_WARN_ENB () {0x8;}' unless defined(&TI_OPMODE_WARN_ENB);
eval 'sub TI_OPMODE_BYTESWAP_DATA () {0x10;}' unless defined(&TI_OPMODE_BYTESWAP_DATA);
eval 'sub TI_OPMODE_1_DMA_ACTIVE () {0x40;}' unless defined(&TI_OPMODE_1_DMA_ACTIVE);
eval 'sub TI_OPMODE_SBUS () {0x100;}' unless defined(&TI_OPMODE_SBUS);
eval 'sub TI_OPMODE_DONT_FRAG_JUMBO () {0x200;}' unless defined(&TI_OPMODE_DONT_FRAG_JUMBO);
eval 'sub TI_OPMODE_INCLUDE_CRC () {0x400;}' unless defined(&TI_OPMODE_INCLUDE_CRC);
eval 'sub TI_OPMODE_RX_BADFRAMES () {0x800;}' unless defined(&TI_OPMODE_RX_BADFRAMES);
eval 'sub TI_OPMODE_NO_EVENT_INTRS () {0x1000;}' unless defined(&TI_OPMODE_NO_EVENT_INTRS);
eval 'sub TI_OPMODE_NO_TX_INTRS () {0x2000;}' unless defined(&TI_OPMODE_NO_TX_INTRS);
eval 'sub TI_OPMODE_NO_RX_INTRS () {0x4000;}' unless defined(&TI_OPMODE_NO_RX_INTRS);
eval 'sub TI_OPMODE_FATAL_ENB () {0x40000000;}' unless defined(&TI_OPMODE_FATAL_ENB);
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
    eval 'sub TI_DMA_SWAP_OPTIONS () { &TI_OPMODE_BYTESWAP_DATA|  &TI_OPMODE_BYTESWAP_BD| &TI_OPMODE_WORDSWAP_BD;}' unless defined(&TI_DMA_SWAP_OPTIONS);
} else {
    eval 'sub TI_DMA_SWAP_OPTIONS () { &TI_OPMODE_BYTESWAP_DATA;}' unless defined(&TI_DMA_SWAP_OPTIONS);
}
eval 'sub TI_DMA_STATE_THRESH_16W () {0x100;}' unless defined(&TI_DMA_STATE_THRESH_16W);
eval 'sub TI_DMA_STATE_THRESH_8W () {0x80;}' unless defined(&TI_DMA_STATE_THRESH_8W);
eval 'sub TI_DMA_STATE_THRESH_4W () {0x40;}' unless defined(&TI_DMA_STATE_THRESH_4W);
eval 'sub TI_DMA_STATE_THRESH_2W () {0x20;}' unless defined(&TI_DMA_STATE_THRESH_2W);
eval 'sub TI_DMA_STATE_THRESH_1W () {0x10;}' unless defined(&TI_DMA_STATE_THRESH_1W);
eval 'sub TI_DMA_STATE_FORCE_32_BIT () {0x8;}' unless defined(&TI_DMA_STATE_FORCE_32_BIT);
eval 'sub TI_GLNK_SENSE_NO_BEG () {0x2000;}' unless defined(&TI_GLNK_SENSE_NO_BEG);
eval 'sub TI_GLNK_LOOPBACK () {0x4000;}' unless defined(&TI_GLNK_LOOPBACK);
eval 'sub TI_GLNK_PREF () {0x8000;}' unless defined(&TI_GLNK_PREF);
eval 'sub TI_GLNK_1000MB () {0x40000;}' unless defined(&TI_GLNK_1000MB);
eval 'sub TI_GLNK_FULL_DUPLEX () {0x80000;}' unless defined(&TI_GLNK_FULL_DUPLEX);
eval 'sub TI_GLNK_TX_FLOWCTL_Y () {0x200000;}' unless defined(&TI_GLNK_TX_FLOWCTL_Y);
eval 'sub TI_GLNK_RX_FLOWCTL_Y () {0x800000;}' unless defined(&TI_GLNK_RX_FLOWCTL_Y);
eval 'sub TI_GLNK_AUTONEGENB () {0x20000000;}' unless defined(&TI_GLNK_AUTONEGENB);
eval 'sub TI_GLNK_ENB () {0x40000000;}' unless defined(&TI_GLNK_ENB);
eval 'sub TI_LNK_LOOPBACK () {0x4000;}' unless defined(&TI_LNK_LOOPBACK);
eval 'sub TI_LNK_PREF () {0x8000;}' unless defined(&TI_LNK_PREF);
eval 'sub TI_LNK_10MB () {0x10000;}' unless defined(&TI_LNK_10MB);
eval 'sub TI_LNK_100MB () {0x20000;}' unless defined(&TI_LNK_100MB);
eval 'sub TI_LNK_1000MB () {0x40000;}' unless defined(&TI_LNK_1000MB);
eval 'sub TI_LNK_FULL_DUPLEX () {0x80000;}' unless defined(&TI_LNK_FULL_DUPLEX);
eval 'sub TI_LNK_HALF_DUPLEX () {0x100000;}' unless defined(&TI_LNK_HALF_DUPLEX);
eval 'sub TI_LNK_TX_FLOWCTL_Y () {0x200000;}' unless defined(&TI_LNK_TX_FLOWCTL_Y);
eval 'sub TI_LNK_RX_FLOWCTL_Y () {0x800000;}' unless defined(&TI_LNK_RX_FLOWCTL_Y);
eval 'sub TI_LNK_AUTONEGENB () {0x20000000;}' unless defined(&TI_LNK_AUTONEGENB);
eval 'sub TI_LNK_ENB () {0x40000000;}' unless defined(&TI_LNK_ENB);
eval 'sub TI_EVENT_RING_CNT () {256;}' unless defined(&TI_EVENT_RING_CNT);
eval 'sub TI_CMD_RING_CNT () {64;}' unless defined(&TI_CMD_RING_CNT);
eval 'sub TI_STD_RX_RING_CNT () {512;}' unless defined(&TI_STD_RX_RING_CNT);
eval 'sub TI_JUMBO_RX_RING_CNT () {256;}' unless defined(&TI_JUMBO_RX_RING_CNT);
eval 'sub TI_MINI_RX_RING_CNT () {1024;}' unless defined(&TI_MINI_RX_RING_CNT);
eval 'sub TI_RETURN_RING_CNT () {2048;}' unless defined(&TI_RETURN_RING_CNT);
eval 'sub TI_TX_RING_CNT_128 () {128;}' unless defined(&TI_TX_RING_CNT_128);
eval 'sub TI_TX_RING_BASE_128 () {0x3800;}' unless defined(&TI_TX_RING_BASE_128);
eval 'sub TI_TX_RING_CNT_256 () {256;}' unless defined(&TI_TX_RING_CNT_256);
eval 'sub TI_TX_RING_BASE_256 () {0x3000;}' unless defined(&TI_TX_RING_BASE_256);
eval 'sub TI_TX_RING_CNT_512 () {512;}' unless defined(&TI_TX_RING_CNT_512);
eval 'sub TI_TX_RING_BASE_512 () {0x2000;}' unless defined(&TI_TX_RING_BASE_512);
eval 'sub TI_TX_RING_CNT () { &TI_TX_RING_CNT_512;}' unless defined(&TI_TX_RING_CNT);
eval 'sub TI_TX_RING_BASE () { &TI_TX_RING_BASE_512;}' unless defined(&TI_TX_RING_BASE);
eval 'sub TI_MEM_MAX () {0x7fffff;}' unless defined(&TI_MEM_MAX);
unless(defined(&TI_HOSTADDR)) {
    sub TI_HOSTADDR {
	my($x) = @_;
	eval q( ($x->{ti_addr_lo}));
    }
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
eval 'sub TI_RCB_FLAG_TCP_UDP_CKSUM () {0x1;}' unless defined(&TI_RCB_FLAG_TCP_UDP_CKSUM);
eval 'sub TI_RCB_FLAG_IP_CKSUM () {0x2;}' unless defined(&TI_RCB_FLAG_IP_CKSUM);
eval 'sub TI_RCB_FLAG_NO_PHDR_CKSUM () {0x8;}' unless defined(&TI_RCB_FLAG_NO_PHDR_CKSUM);
eval 'sub TI_RCB_FLAG_VLAN_ASSIST () {0x10;}' unless defined(&TI_RCB_FLAG_VLAN_ASSIST);
eval 'sub TI_RCB_FLAG_COAL_UPD_ONLY () {0x20;}' unless defined(&TI_RCB_FLAG_COAL_UPD_ONLY);
eval 'sub TI_RCB_FLAG_HOST_RING () {0x40;}' unless defined(&TI_RCB_FLAG_HOST_RING);
eval 'sub TI_RCB_FLAG_IEEE_SNAP_CKSUM () {0x80;}' unless defined(&TI_RCB_FLAG_IEEE_SNAP_CKSUM);
eval 'sub TI_RCB_FLAG_USE_EXT_RX_BD () {0x100;}' unless defined(&TI_RCB_FLAG_USE_EXT_RX_BD);
eval 'sub TI_RCB_FLAG_RING_DISABLED () {0x200;}' unless defined(&TI_RCB_FLAG_RING_DISABLED);
eval 'sub IF_ADMIN_STATUS_UP () {1;}' unless defined(&IF_ADMIN_STATUS_UP);
eval 'sub IF_ADMIN_STATUS_DOWN () {2;}' unless defined(&IF_ADMIN_STATUS_DOWN);
eval 'sub IF_ADMIN_STATUS_TESTING () {3;}' unless defined(&IF_ADMIN_STATUS_TESTING);
eval 'sub IF_OPER_STATUS_UP () {1;}' unless defined(&IF_OPER_STATUS_UP);
eval 'sub IF_OPER_STATUS_DOWN () {2;}' unless defined(&IF_OPER_STATUS_DOWN);
eval 'sub IF_OPER_STATUS_TESTING () {3;}' unless defined(&IF_OPER_STATUS_TESTING);
eval 'sub IF_OPER_STATUS_UNKNOWN () {4;}' unless defined(&IF_OPER_STATUS_UNKNOWN);
eval 'sub IF_OPER_STATUS_DORMANT () {5;}' unless defined(&IF_OPER_STATUS_DORMANT);
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
} else {
}
eval 'sub TI_JUMBO_FRAMELEN () {9018;}' unless defined(&TI_JUMBO_FRAMELEN);
eval 'sub TI_JUMBO_MTU () {( &TI_JUMBO_FRAMELEN -  &ETHER_HDR_LEN -  &ETHER_CRC_LEN);}' unless defined(&TI_JUMBO_MTU);
eval 'sub TI_PAGE_SIZE () { &PAGE_SIZE;}' unless defined(&TI_PAGE_SIZE);
eval 'sub TI_BDERR_CRC () {0x1;}' unless defined(&TI_BDERR_CRC);
eval 'sub TI_BDERR_COLLDETECT () {0x2;}' unless defined(&TI_BDERR_COLLDETECT);
eval 'sub TI_BDERR_LINKLOST () {0x4;}' unless defined(&TI_BDERR_LINKLOST);
eval 'sub TI_BDERR_DECODE () {0x8;}' unless defined(&TI_BDERR_DECODE);
eval 'sub TI_BDERR_ODD_NIBBLES () {0x10;}' unless defined(&TI_BDERR_ODD_NIBBLES);
eval 'sub TI_BDERR_MAC_ABRT () {0x20;}' unless defined(&TI_BDERR_MAC_ABRT);
eval 'sub TI_BDERR_RUNT () {0x40;}' unless defined(&TI_BDERR_RUNT);
eval 'sub TI_BDERR_TRUNC () {0x80;}' unless defined(&TI_BDERR_TRUNC);
eval 'sub TI_BDERR_GIANT () {0x100;}' unless defined(&TI_BDERR_GIANT);
eval 'sub TI_BDFLAG_TCP_UDP_CKSUM () {0x1;}' unless defined(&TI_BDFLAG_TCP_UDP_CKSUM);
eval 'sub TI_BDFLAG_IP_CKSUM () {0x2;}' unless defined(&TI_BDFLAG_IP_CKSUM);
eval 'sub TI_BDFLAG_END () {0x4;}' unless defined(&TI_BDFLAG_END);
eval 'sub TI_BDFLAG_MORE () {0x8;}' unless defined(&TI_BDFLAG_MORE);
eval 'sub TI_BDFLAG_JUMBO_RING () {0x10;}' unless defined(&TI_BDFLAG_JUMBO_RING);
eval 'sub TI_BDFLAG_UCAST_PKT () {0x20;}' unless defined(&TI_BDFLAG_UCAST_PKT);
eval 'sub TI_BDFLAG_MCAST_PKT () {0x40;}' unless defined(&TI_BDFLAG_MCAST_PKT);
eval 'sub TI_BDFLAG_BCAST_PKT () {0x60;}' unless defined(&TI_BDFLAG_BCAST_PKT);
eval 'sub TI_BDFLAG_IP_FRAG () {0x80;}' unless defined(&TI_BDFLAG_IP_FRAG);
eval 'sub TI_BDFLAG_IP_FRAG_END () {0x100;}' unless defined(&TI_BDFLAG_IP_FRAG_END);
eval 'sub TI_BDFLAG_VLAN_TAG () {0x200;}' unless defined(&TI_BDFLAG_VLAN_TAG);
eval 'sub TI_BDFLAG_ERROR () {0x400;}' unless defined(&TI_BDFLAG_ERROR);
eval 'sub TI_BDFLAG_COAL_NOW () {0x800;}' unless defined(&TI_BDFLAG_COAL_NOW);
eval 'sub TI_BDFLAG_MINI_RING () {0x1000;}' unless defined(&TI_BDFLAG_MINI_RING);
eval 'sub TI_BDTYPE_TYPE_NULL () {0x;}' unless defined(&TI_BDTYPE_TYPE_NULL);
eval 'sub TI_BDTYPE_SEND_BD () {0x1;}' unless defined(&TI_BDTYPE_SEND_BD);
eval 'sub TI_BDTYPE_RECV_BD () {0x2;}' unless defined(&TI_BDTYPE_RECV_BD);
eval 'sub TI_BDTYPE_RECV_JUMBO_BD () {0x3;}' unless defined(&TI_BDTYPE_RECV_JUMBO_BD);
eval 'sub TI_BDTYPE_RECV_BD_LAST () {0x4;}' unless defined(&TI_BDTYPE_RECV_BD_LAST);
eval 'sub TI_BDTYPE_SEND_DATA () {0x5;}' unless defined(&TI_BDTYPE_SEND_DATA);
eval 'sub TI_BDTYPE_SEND_DATA_LAST () {0x6;}' unless defined(&TI_BDTYPE_SEND_DATA_LAST);
eval 'sub TI_BDTYPE_RECV_DATA () {0x7;}' unless defined(&TI_BDTYPE_RECV_DATA);
eval 'sub TI_BDTYPE_RECV_DATA_LAST () {0xb;}' unless defined(&TI_BDTYPE_RECV_DATA_LAST);
eval 'sub TI_BDTYPE_EVENT_RUPT () {0xc;}' unless defined(&TI_BDTYPE_EVENT_RUPT);
eval 'sub TI_BDTYPE_EVENT_NO_RUPT () {0xd;}' unless defined(&TI_BDTYPE_EVENT_NO_RUPT);
eval 'sub TI_BDTYPE_ODD_START () {0xe;}' unless defined(&TI_BDTYPE_ODD_START);
eval 'sub TI_BDTYPE_UPDATE_STATS () {0xf;}' unless defined(&TI_BDTYPE_UPDATE_STATS);
eval 'sub TI_BDTYPE_SEND_DUMMY_DMA () {0x10;}' unless defined(&TI_BDTYPE_SEND_DUMMY_DMA);
eval 'sub TI_BDTYPE_EVENT_PROD () {0x11;}' unless defined(&TI_BDTYPE_EVENT_PROD);
eval 'sub TI_BDTYPE_TX_CONS () {0x12;}' unless defined(&TI_BDTYPE_TX_CONS);
eval 'sub TI_BDTYPE_RX_PROD () {0x13;}' unless defined(&TI_BDTYPE_RX_PROD);
eval 'sub TI_BDTYPE_REFRESH_STATS () {0x14;}' unless defined(&TI_BDTYPE_REFRESH_STATS);
eval 'sub TI_BDTYPE_SEND_DATA_LAST_VLAN () {0x15;}' unless defined(&TI_BDTYPE_SEND_DATA_LAST_VLAN);
eval 'sub TI_BDTYPE_SEND_DATA_COAL () {0x16;}' unless defined(&TI_BDTYPE_SEND_DATA_COAL);
eval 'sub TI_BDTYPE_SEND_DATA_LAST_COAL () {0x17;}' unless defined(&TI_BDTYPE_SEND_DATA_LAST_COAL);
eval 'sub TI_BDTYPE_SEND_DATA_LAST_VLAN_COAL () {0x18;}' unless defined(&TI_BDTYPE_SEND_DATA_LAST_VLAN_COAL);
eval 'sub TI_BDTYPE_TX_CONS_NO_INTR () {0x19;}' unless defined(&TI_BDTYPE_TX_CONS_NO_INTR);
unless(defined(&TI_CMD_CMD)) {
    sub TI_CMD_CMD {
	my($cmd) = @_;
	eval q(((((($cmd)-> &ti_cmdx)) >> 24) & 0xff));
    }
}
unless(defined(&TI_CMD_CODE)) {
    sub TI_CMD_CODE {
	my($cmd) = @_;
	eval q(((((($cmd)-> &ti_cmdx)) >> 12) & 0xfff));
    }
}
unless(defined(&TI_CMD_IDX)) {
    sub TI_CMD_IDX {
	my($cmd) = @_;
	eval q((((($cmd)-> &ti_cmdx)) & 0xfff));
    }
}
eval 'sub TI_CMD_HOST_STATE () {0x1;}' unless defined(&TI_CMD_HOST_STATE);
eval 'sub TI_CMD_CODE_STACK_UP () {0x1;}' unless defined(&TI_CMD_CODE_STACK_UP);
eval 'sub TI_CMD_CODE_STACK_DOWN () {0x2;}' unless defined(&TI_CMD_CODE_STACK_DOWN);
eval 'sub TI_CMD_FDR_FILTERING () {0x2;}' unless defined(&TI_CMD_FDR_FILTERING);
eval 'sub TI_CMD_CODE_FILT_ENB () {0x1;}' unless defined(&TI_CMD_CODE_FILT_ENB);
eval 'sub TI_CMD_CODE_FILT_DIS () {0x2;}' unless defined(&TI_CMD_CODE_FILT_DIS);
eval 'sub TI_CMD_SET_RX_PROD_IDX () {0x3;}' unless defined(&TI_CMD_SET_RX_PROD_IDX);
eval 'sub TI_CMD_UPDATE_GENCOM () {0x4;}' unless defined(&TI_CMD_UPDATE_GENCOM);
eval 'sub TI_CMD_RESET_JUMBO_RING () {0x5;}' unless defined(&TI_CMD_RESET_JUMBO_RING);
eval 'sub TI_CMD_SET_PARTIAL_RX_CNT () {0x6;}' unless defined(&TI_CMD_SET_PARTIAL_RX_CNT);
eval 'sub TI_CMD_ADD_MCAST_ADDR () {0x8;}' unless defined(&TI_CMD_ADD_MCAST_ADDR);
eval 'sub TI_CMD_DEL_MCAST_ADDR () {0x9;}' unless defined(&TI_CMD_DEL_MCAST_ADDR);
eval 'sub TI_CMD_SET_PROMISC_MODE () {0xa;}' unless defined(&TI_CMD_SET_PROMISC_MODE);
eval 'sub TI_CMD_CODE_PROMISC_ENB () {0x1;}' unless defined(&TI_CMD_CODE_PROMISC_ENB);
eval 'sub TI_CMD_CODE_PROMISC_DIS () {0x2;}' unless defined(&TI_CMD_CODE_PROMISC_DIS);
eval 'sub TI_CMD_LINK_NEGOTIATION () {0xb;}' unless defined(&TI_CMD_LINK_NEGOTIATION);
eval 'sub TI_CMD_CODE_NEGOTIATE_BOTH () {0x;}' unless defined(&TI_CMD_CODE_NEGOTIATE_BOTH);
eval 'sub TI_CMD_CODE_NEGOTIATE_GIGABIT () {0x1;}' unless defined(&TI_CMD_CODE_NEGOTIATE_GIGABIT);
eval 'sub TI_CMD_CODE_NEGOTIATE_10_100 () {0x2;}' unless defined(&TI_CMD_CODE_NEGOTIATE_10_100);
eval 'sub TI_CMD_SET_MAC_ADDR () {0xc;}' unless defined(&TI_CMD_SET_MAC_ADDR);
eval 'sub TI_CMD_CLR_PROFILE () {0xd;}' unless defined(&TI_CMD_CLR_PROFILE);
eval 'sub TI_CMD_SET_ALLMULTI () {0xe;}' unless defined(&TI_CMD_SET_ALLMULTI);
eval 'sub TI_CMD_CODE_ALLMULTI_ENB () {0x1;}' unless defined(&TI_CMD_CODE_ALLMULTI_ENB);
eval 'sub TI_CMD_CODE_ALLMULTI_DIS () {0x2;}' unless defined(&TI_CMD_CODE_ALLMULTI_DIS);
eval 'sub TI_CMD_CLR_STATS () {0xf;}' unless defined(&TI_CMD_CLR_STATS);
eval 'sub TI_CMD_SET_RX_JUMBO_PROD_IDX () {0x10;}' unless defined(&TI_CMD_SET_RX_JUMBO_PROD_IDX);
eval 'sub TI_CMD_RFRSH_STATS () {0x11;}' unless defined(&TI_CMD_RFRSH_STATS);
eval 'sub TI_CMD_EXT_ADD_MCAST () {0x12;}' unless defined(&TI_CMD_EXT_ADD_MCAST);
eval 'sub TI_CMD_EXT_DEL_MCAST () {0x13;}' unless defined(&TI_CMD_EXT_DEL_MCAST);
unless(defined(&TI_DO_CMD)) {
    sub TI_DO_CMD {
	my($x, $y, $z) = @_;
	eval q( ($cmd->{ti_cmdx}) = ((($x) << 24) | (($y) << 12) | (($z)));  &ti_cmd( &sc,  &cmd););
    }
}
unless(defined(&TI_DO_CMD_EXT)) {
    sub TI_DO_CMD_EXT {
	my($x, $y, $z, $v, $w) = @_;
	eval q( ($cmd->{ti_cmdx}) = ((($x) << 24) | (($y) << 12) | (($z)));  &ti_cmd_ext( &sc,  &cmd, $v, $w););
    }
}
unless(defined(&TI_INC)) {
    sub TI_INC {
	my($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&TI_UPDATE_JUMBOPROD)) {
    sub TI_UPDATE_JUMBOPROD {
	my($x, $y) = @_;
	eval q( &if ( ($x->{ti_hwrev}) ==  &TI_HWREV_TIGON) {  &TI_DO_CMD( &TI_CMD_SET_RX_JUMBO_PROD_IDX, 0, $y); }  &else {  &CSR_WRITE_4($x,  &TI_MB_JUMBORXPROD_IDX, $y); });
    }
}
unless(defined(&TI_UPDATE_MINIPROD)) {
    sub TI_UPDATE_MINIPROD {
	my($x, $y) = @_;
	eval q( &CSR_WRITE_4($x,  &TI_MB_MINIRXPROD_IDX, $y););
    }
}
unless(defined(&TI_UPDATE_STDPROD)) {
    sub TI_UPDATE_STDPROD {
	my($x, $y) = @_;
	eval q( &if ( ($x->{ti_hwrev}) ==  &TI_HWREV_TIGON) {  &TI_DO_CMD( &TI_CMD_SET_RX_PROD_IDX, 0, $y); }  &else {  &CSR_WRITE_4($x,  &TI_MB_STDRXPROD_IDX, $y); });
    }
}
unless(defined(&TI_EVENT_EVENT)) {
    sub TI_EVENT_EVENT {
	my($e) = @_;
	eval q(((((($e)-> &ti_eventx)) >> 24) & 0xff));
    }
}
unless(defined(&TI_EVENT_CODE)) {
    sub TI_EVENT_CODE {
	my($e) = @_;
	eval q(((((($e)-> &ti_eventx)) >> 12) & 0xfff));
    }
}
unless(defined(&TI_EVENT_IDX)) {
    sub TI_EVENT_IDX {
	my($e) = @_;
	eval q(((((($e)-> &ti_eventx))) & 0xfff));
    }
}
eval 'sub TI_EV_FIRMWARE_UP () {0x1;}' unless defined(&TI_EV_FIRMWARE_UP);
eval 'sub TI_EV_STATS_UPDATED () {0x4;}' unless defined(&TI_EV_STATS_UPDATED);
eval 'sub TI_EV_LINKSTAT_CHANGED () {0x6;}' unless defined(&TI_EV_LINKSTAT_CHANGED);
eval 'sub TI_EV_CODE_GIG_LINK_UP () {0x1;}' unless defined(&TI_EV_CODE_GIG_LINK_UP);
eval 'sub TI_EV_CODE_LINK_DOWN () {0x2;}' unless defined(&TI_EV_CODE_LINK_DOWN);
eval 'sub TI_EV_CODE_LINK_UP () {0x3;}' unless defined(&TI_EV_CODE_LINK_UP);
eval 'sub TI_EV_ERROR () {0x7;}' unless defined(&TI_EV_ERROR);
eval 'sub TI_EV_CODE_ERR_INVAL_CMD () {0x1;}' unless defined(&TI_EV_CODE_ERR_INVAL_CMD);
eval 'sub TI_EV_CODE_ERR_UNIMP_CMD () {0x2;}' unless defined(&TI_EV_CODE_ERR_UNIMP_CMD);
eval 'sub TI_EV_CODE_ERR_BADCFG () {0x3;}' unless defined(&TI_EV_CODE_ERR_BADCFG);
eval 'sub TI_EV_MCAST_UPDATED () {0x8;}' unless defined(&TI_EV_MCAST_UPDATED);
eval 'sub TI_EV_CODE_MCAST_ADD () {0x1;}' unless defined(&TI_EV_CODE_MCAST_ADD);
eval 'sub TI_EV_CODE_MCAST_DEL () {0x2;}' unless defined(&TI_EV_CODE_MCAST_DEL);
eval 'sub TI_EV_RESET_JUMBO_RING () {0x9;}' unless defined(&TI_EV_RESET_JUMBO_RING);
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{ti_btag}),  ($sc->{ti_bhandle}), ($reg), ($val)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{ti_btag}),  ($sc->{ti_bhandle}), ($reg)));
    }
}
unless(defined(&TI_SETBIT)) {
    sub TI_SETBIT {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($sc, ($reg), ( &CSR_READ_4($sc, ($reg)) | ($x))));
    }
}
unless(defined(&TI_CLRBIT)) {
    sub TI_CLRBIT {
	my($sc, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($sc, ($reg), ( &CSR_READ_4($sc, ($reg)) & ~($x))));
    }
}
eval 'sub TI_SSLOTS () {256;}' unless defined(&TI_SSLOTS);
eval 'sub TI_MSLOTS () {256;}' unless defined(&TI_MSLOTS);
eval 'sub TI_JSLOTS () {384;}' unless defined(&TI_JSLOTS);
eval 'sub TI_JRAWLEN () {( &TI_JUMBO_FRAMELEN +  &ETHER_ALIGN);}' unless defined(&TI_JRAWLEN);
eval 'sub TI_JLEN () {( &TI_JRAWLEN + ($sizeof{ &u_int64_t} - ( &TI_JRAWLEN % $sizeof{ &u_int64_t})));}' unless defined(&TI_JLEN);
eval 'sub TI_JPAGESZ () { &PAGE_SIZE;}' unless defined(&TI_JPAGESZ);
eval 'sub TI_RESID () {( &TI_JPAGESZ - ( &TI_JLEN *  &TI_JSLOTS) %  &TI_JPAGESZ);}' unless defined(&TI_RESID);
eval 'sub TI_JMEM () {(( &TI_JLEN *  &TI_JSLOTS) +  &TI_RESID);}' unless defined(&TI_JMEM);
unless(defined(&TI_RING_DMA_ADDR)) {
    sub TI_RING_DMA_ADDR {
	my($sc, $offset) = @_;
	eval q((($sc)-> ($ti_ring_map->{dm_segs[0]}->{ds_addr}) +  &offsetof('struct ti_ring_data', $offset)));
    }
}
unless(defined(&TI_RING_DMASYNC)) {
    sub TI_RING_DMASYNC {
	my($sc, $offset, $op) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmatag, ($sc)-> &ti_ring_map,  &offsetof('struct ti_ring_data', $offset), $sizeof{(0)->$offset}, ($op)));
    }
}
if(defined(&__LP64__)) {
    eval 'sub TI_NTXSEG () {30;}' unless defined(&TI_NTXSEG);
} else {
    eval 'sub TI_NTXSEG () {31;}' unless defined(&TI_NTXSEG);
}
eval 'sub TI_HWREV_TIGON () {0x1;}' unless defined(&TI_HWREV_TIGON);
eval 'sub TI_HWREV_TIGON_II () {0x2;}' unless defined(&TI_HWREV_TIGON_II);
eval 'sub TI_TIMEOUT () {1000;}' unless defined(&TI_TIMEOUT);
eval 'sub TI_TXCONS_UNSET () {0xffff;}' unless defined(&TI_TXCONS_UNSET);
eval 'sub ti_ev_prodidx () { ($ti_rdata->{ti_ev_prodidx_r});}' unless defined(&ti_ev_prodidx);
eval 'sub ti_return_prodidx () { ($ti_rdata->{ti_return_prodidx_r});}' unless defined(&ti_return_prodidx);
eval 'sub ti_tx_considx () { ($ti_rdata->{ti_tx_considx_r});}' unless defined(&ti_tx_considx);
eval 'sub EEPROM_CTL_READ () {0xa1;}' unless defined(&EEPROM_CTL_READ);
eval 'sub EEPROM_CTL_WRITE () {0xa0;}' unless defined(&EEPROM_CTL_WRITE);
eval 'sub EEPROM_START () { &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_CLK);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_DOUT);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_TXEN);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_DOUT);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_CLK);;}' unless defined(&EEPROM_START);
eval 'sub EEPROM_STOP () { &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_TXEN);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_DOUT);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_CLK);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_TXEN);  &TI_SETBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_DOUT);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_TXEN);  &TI_CLRBIT( &sc,  &TI_MISC_LOCAL_CTL,  &TI_MLC_EE_CLK);;}' unless defined(&EEPROM_STOP);
1;
