require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_IXGB_H_DEFINED_)) {
    eval 'sub _IXGB_H_DEFINED_ () {1;}' unless defined(&_IXGB_H_DEFINED_);
    require './dev/pci/bpfilter.ph';
    require './dev/pci/vlan.ph';
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/sockio.ph';
    require 'sys/mbuf.ph';
    require 'sys/malloc.ph';
    require 'sys/kernel.ph';
    require 'sys/device.ph';
    require 'sys/socket.ph';
    require 'sys/timeout.ph';
    require 'net/if.ph';
    require 'net/if_dl.ph';
    require 'net/if_media.ph';
    require 'netinet/in.ph';
    require 'netinet/ip.ph';
    require 'netinet/if_ether.ph';
    require 'netinet/tcp.ph';
    require 'netinet/udp.ph';
    if((defined(&NVLAN) ? &NVLAN : undef) > 0) {
	require 'net/if_types.ph';
	require 'net/if_vlan_var.ph';
    }
    if((defined(&NBPFILTER) ? &NBPFILTER : undef) > 0) {
	require 'net/bpf.ph';
    }
    eval 'sub TRUE () {1;}' unless defined(&TRUE);
    eval 'sub FALSE () {0;}' unless defined(&FALSE);
    require 'dev/pci/pcireg.ph';
    require 'dev/pci/pcivar.ph';
    require 'dev/pci/pcidevs.ph';
    require 'dev/pci/ixgb_hw.ph';
    require 'dev/pci/ixgb_ee.ph';
    require 'dev/pci/ixgb_ids.ph';
    eval 'sub IXGB_MAX_TXD () {2048;}' unless defined(&IXGB_MAX_TXD);
    eval 'sub IXGB_MAX_RXD () {1024;}' unless defined(&IXGB_MAX_RXD);
    eval 'sub TIDV () {32;}' unless defined(&TIDV);
    eval 'sub RDTR () {72;}' unless defined(&RDTR);
    eval 'sub IXGB_TX_TIMEOUT () {5;}' unless defined(&IXGB_TX_TIMEOUT);
    eval 'sub IXGB_TX_CLEANUP_THRESHOLD () {( ($sc->{num_tx_desc}) / 8);}' unless defined(&IXGB_TX_CLEANUP_THRESHOLD);
    eval 'sub FLOW_CONTROL_NONE () { &ixgb_fc_none;}' unless defined(&FLOW_CONTROL_NONE);
    eval 'sub FLOW_CONTROL_RX_PAUSE () { &ixgb_fc_rx_pause;}' unless defined(&FLOW_CONTROL_RX_PAUSE);
    eval 'sub FLOW_CONTROL_TX_PAUSE () { &ixgb_fc_tx_pause;}' unless defined(&FLOW_CONTROL_TX_PAUSE);
    eval 'sub FLOW_CONTROL_FULL () { &ixgb_fc_full;}' unless defined(&FLOW_CONTROL_FULL);
    eval 'sub FLOW_CONTROL () { &FLOW_CONTROL_FULL;}' unless defined(&FLOW_CONTROL);
    eval 'sub FCRTL () {0x28000;}' unless defined(&FCRTL);
    eval 'sub FCRTH () {0x30000;}' unless defined(&FCRTH);
    eval 'sub FCPAUSE () {0x100;}' unless defined(&FCPAUSE);
    eval 'sub IXGB_MMBA () {0x10;}' unless defined(&IXGB_MMBA);
    eval 'sub IXGB_ROUNDUP {
        my($size, $unit) = @_;
	    eval q(((($size) + ($unit) - 1) & ~(($unit) - 1)));
    }' unless defined(&IXGB_ROUNDUP);
    eval 'sub MAX_NUM_MULTICAST_ADDRESSES () {128;}' unless defined(&MAX_NUM_MULTICAST_ADDRESSES);
    eval 'sub DEBUG_INIT () {0;}' unless defined(&DEBUG_INIT);
    eval 'sub DEBUG_IOCTL () {0;}' unless defined(&DEBUG_IOCTL);
    eval 'sub DEBUG_HW () {0;}' unless defined(&DEBUG_HW);
    eval 'sub INIT_DEBUGOUT {
        my($S) = @_;
	    eval q( &if ( &DEBUG_INIT)  &printf($S \\"\\\\n\\"));
    }' unless defined(&INIT_DEBUGOUT);
    eval 'sub INIT_DEBUGOUT1 {
        my($S, $A) = @_;
	    eval q( &if ( &DEBUG_INIT)  &printf($S \\"\\\\n\\", $A));
    }' unless defined(&INIT_DEBUGOUT1);
    eval 'sub INIT_DEBUGOUT2 {
        my($S, $A, $B) = @_;
	    eval q( &if ( &DEBUG_INIT)  &printf($S \\"\\\\n\\", $A, $B));
    }' unless defined(&INIT_DEBUGOUT2);
    eval 'sub IOCTL_DEBUGOUT {
        my($S) = @_;
	    eval q( &if ( &DEBUG_IOCTL)  &printf($S \\"\\\\n\\"));
    }' unless defined(&IOCTL_DEBUGOUT);
    eval 'sub IOCTL_DEBUGOUT1 {
        my($S, $A) = @_;
	    eval q( &if ( &DEBUG_IOCTL)  &printf($S \\"\\\\n\\", $A));
    }' unless defined(&IOCTL_DEBUGOUT1);
    eval 'sub IOCTL_DEBUGOUT2 {
        my($S, $A, $B) = @_;
	    eval q( &if ( &DEBUG_IOCTL)  &printf($S \\"\\\\n\\", $A, $B));
    }' unless defined(&IOCTL_DEBUGOUT2);
    eval 'sub HW_DEBUGOUT {
        my($S) = @_;
	    eval q( &if ( &DEBUG_HW)  &printf($S \\"\\\\n\\"));
    }' unless defined(&HW_DEBUGOUT);
    eval 'sub HW_DEBUGOUT1 {
        my($S, $A) = @_;
	    eval q( &if ( &DEBUG_HW)  &printf($S \\"\\\\n\\", $A));
    }' unless defined(&HW_DEBUGOUT1);
    eval 'sub HW_DEBUGOUT2 {
        my($S, $A, $B) = @_;
	    eval q( &if ( &DEBUG_HW)  &printf($S \\"\\\\n\\", $A, $B));
    }' unless defined(&HW_DEBUGOUT2);
    eval 'sub IXGB_RXBUFFER_2048 () {2048;}' unless defined(&IXGB_RXBUFFER_2048);
    eval 'sub IXGB_RXBUFFER_4096 () {4096;}' unless defined(&IXGB_RXBUFFER_4096);
    eval 'sub IXGB_RXBUFFER_8192 () {8192;}' unless defined(&IXGB_RXBUFFER_8192);
    eval 'sub IXGB_RXBUFFER_16384 () {16384;}' unless defined(&IXGB_RXBUFFER_16384);
    eval 'sub IXGB_MAX_SCATTER () {100;}' unless defined(&IXGB_MAX_SCATTER);
    eval("sub OFFLOAD_NONE () { 0; }") unless defined(&OFFLOAD_NONE);
    eval("sub OFFLOAD_TCP_IP () { 1; }") unless defined(&OFFLOAD_TCP_IP);
    eval("sub OFFLOAD_UDP_IP () { 2; }") unless defined(&OFFLOAD_UDP_IP);
}
1;
