require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'machine/atomic.ph';
unless(defined(&atomic_set)) {
    sub atomic_set {
	my($p, $v) = @_;
	eval q((*($p) = ($v)));
    }
}
unless(defined(&atomic_read)) {
    sub atomic_read {
	my($p) = @_;
	eval q((*($p)));
    }
}
unless(defined(&atomic_inc)) {
    sub atomic_inc {
	my($p) = @_;
	eval q( &__sync_fetch_and_add($p, 1));
    }
}
unless(defined(&atomic_dec)) {
    sub atomic_dec {
	my($p) = @_;
	eval q( &__sync_fetch_and_sub($p, 1));
    }
}
unless(defined(&atomic_add)) {
    sub atomic_add {
	my($n, $p) = @_;
	eval q( &__sync_fetch_and_add($p, $n));
    }
}
unless(defined(&atomic_sub)) {
    sub atomic_sub {
	my($n, $p) = @_;
	eval q( &__sync_fetch_and_sub($p, $n));
    }
}
unless(defined(&atomic_add_return)) {
    sub atomic_add_return {
	my($n, $p) = @_;
	eval q( &__sync_add_and_fetch($p, $n));
    }
}
unless(defined(&atomic_sub_return)) {
    sub atomic_sub_return {
	my($n, $p) = @_;
	eval q( &__sync_sub_and_fetch($p, $n));
    }
}
unless(defined(&atomic_inc_return)) {
    sub atomic_inc_return {
	my($v) = @_;
	eval q( &atomic_add_return(1, ($v)));
    }
}
unless(defined(&atomic_dec_return)) {
    sub atomic_dec_return {
	my($v) = @_;
	eval q( &atomic_sub_return(1, ($v)));
    }
}
unless(defined(&atomic_dec_and_test)) {
    sub atomic_dec_and_test {
	my($v) = @_;
	eval q(( &atomic_dec_return($v) == 0));
    }
}
unless(defined(&atomic_inc_and_test)) {
    sub atomic_inc_and_test {
	my($v) = @_;
	eval q(( &atomic_inc_return($v) == 0));
    }
}
unless(defined(&atomic_xchg)) {
    sub atomic_xchg {
	my($v,$n) = @_;
	eval q({  &__sync_synchronize();  &__sync_lock_test_and_set($v, $n); });
    }
}
if(defined(&__LP64__)) {
    eval 'sub atomic64_set {
        my($p, $v) = @_;
	    eval q((*($p) = ($v)));
    }' unless defined(&atomic64_set);
    eval 'sub atomic64_read {
        my($p) = @_;
	    eval q((*($p)));
    }' unless defined(&atomic64_read);
    eval 'sub atomic64_xchg {
        my($v,$n) = @_;
	    eval q({  &__sync_synchronize();  &__sync_lock_test_and_set($v, $n); });
    }' unless defined(&atomic64_xchg);
} else {
    eval 'sub atomic64_set {
        my($v,$i) = @_;
	    eval q({  &mtx_init( ($v->{lock}),  &IPL_HIGH);  ($v->{val}) = $i; });
    }' unless defined(&atomic64_set);
    eval 'sub atomic64_read {
        my($v) = @_;
	    eval q({  &int64_t  &val;  &mtx_enter( ($v->{lock}));  &val =  ($v->{val});  &mtx_leave( ($v->{lock}));  &val; });
    }' unless defined(&atomic64_read);
    eval 'sub atomic64_xchg {
        my($v,$n) = @_;
	    eval q({  &int64_t  &val;  &mtx_enter( ($v->{lock}));  &val =  ($v->{val});  ($v->{val}) = $n;  &mtx_leave( ($v->{lock}));  &val; });
    }' unless defined(&atomic64_xchg);
}
unless(defined(&atomic_set_int)) {
    sub atomic_set_int {
	my($p, $bits) = @_;
	eval q( &atomic_setbits_int($p,$bits));
    }
}
unless(defined(&atomic_clear_int)) {
    sub atomic_clear_int {
	my($p, $bits) = @_;
	eval q( &atomic_clearbits_int($p,$bits));
    }
}
unless(defined(&atomic_fetchadd_int)) {
    sub atomic_fetchadd_int {
	my($p, $n) = @_;
	eval q( &__sync_fetch_and_add($p, $n));
    }
}
unless(defined(&atomic_fetchsub_int)) {
    sub atomic_fetchsub_int {
	my($p, $n) = @_;
	eval q( &__sync_fetch_and_sub($p, $n));
    }
}
if(defined(&__i386__) || defined(&__amd64__)) {
    eval 'sub atomic_cmpset_int {
        my($dst,$exp,$src) = @_;
	    eval q({ \'int\'  &res = $exp;  &__asm  &__volatile ( \\"	lock ;			\\" \\"	cmpxchgl %1,%2 ;	\\" \\"       setz	%%al ;		\\" \\"	movzbl	%%al,%0 ;	\\" \\"1:				\\" \\"# atomic_cmpset_int\\" : \\"+a\\" ( &res) : \\"r\\" ($src), \\"m\\" (*($dst)) : \\"memory\\"); ( &res); });
    }' unless defined(&atomic_cmpset_int);
} else {
    eval 'sub atomic_cmpset_int {
        my($dst,$old,$new) = @_;
	    eval q({ \'int\'  &s =  &splhigh();  &if (*$dst==$old) { *$dst = $new;  &splx( &s); 1; }  &splx( &s); 0; });
    }' unless defined(&atomic_cmpset_int);
}
unless(defined(&test_and_set_bit)) {
    sub test_and_set_bit {
	my($b,$p) = @_;
	eval q({ 'int'  &s =  &splhigh(); my $m = 1<<$b; my $r = *( &volatile 'int' *)$p &  $m; *( &volatile 'int' *)$p |=  $m;  &splx( &s);  $r; });
    }
}
unless(defined(&clear_bit)) {
    sub clear_bit {
	my($b,$p) = @_;
	eval q({  &atomic_clear_int((( &volatile 'u_int' *)$p) + ($b >> 5), 1<< ($b & 0x1f)); });
    }
}
unless(defined(&set_bit)) {
    sub set_bit {
	my($b,$p) = @_;
	eval q({  &atomic_set_int((( &volatile 'u_int' *)$p) + ($b >> 5), 1<< ($b & 0x1f)); });
    }
}
unless(defined(&test_bit)) {
    sub test_bit {
	my($b,$p) = @_;
	eval q({ !!((( &volatile 'u_int' *)$p)[$b >> 5] & (1<< ($b & 0x1f))); });
    }
}
unless(defined(&find_first_zero_bit)) {
    sub find_first_zero_bit {
	my($p,$max) = @_;
	eval q({ 'int'  &b;  &volatile 'u_int' * &ptr = ( &volatile 'u_int' *)$p;  &for ( &b = 0;  &b < $max;  &b += 32) {  &if ( $ptr[ &b >> 5] != ~0) {  &for (;;) {  &if (( $ptr[ &b >> 5] & (1<< ( &b & 0x1f))) == 0)  &b;  &b++; } } } $max; });
    }
}
1;
