require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_VMPARAM_H_)) {
    eval 'sub _MACHINE_VMPARAM_H_ () {1;}' unless defined(&_MACHINE_VMPARAM_H_);
    eval 'sub USRTEXT () {0x2000;}' unless defined(&USRTEXT);
    eval 'sub USRSTACK () { &VM_MIN_KERNEL_ADDRESS;}' unless defined(&USRSTACK);
    unless(defined(&MAXTSIZ)) {
	eval 'sub MAXTSIZ () {(32*1024*1024);}' unless defined(&MAXTSIZ);
    }
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(64*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(256*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&BRKSIZ)) {
	eval 'sub BRKSIZ () { &MAXDSIZ;}' unless defined(&BRKSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(2*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(32*1024*1024);}' unless defined(&MAXSSIZ);
    }
    eval 'sub STACKGAP_RANDOM () {64*1024;}' unless defined(&STACKGAP_RANDOM);
    eval 'sub STACKGAP_RANDOM_SUN4M () {256*1024;}' unless defined(&STACKGAP_RANDOM_SUN4M);
    unless(defined(&SHMMAXPGS)) {
	eval 'sub SHMMAXPGS () {1024;}' unless defined(&SHMMAXPGS);
    }
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)0x2000);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () {(( &vaddr_t) &VM_MIN_KERNEL_ADDRESS);}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t) &VM_MIN_KERNEL_ADDRESS);}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t) &KERNBASE);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)0xfe000000);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    eval 'sub IOSPACE_BASE () { &VM_MAX_KERNEL_ADDRESS;}' unless defined(&IOSPACE_BASE);
    eval 'sub IOSPACE_LEN () {0x1000000;}' unless defined(&IOSPACE_LEN);
    eval 'sub VM_PHYSSEG_MAX () {32;}' unless defined(&VM_PHYSSEG_MAX);
    eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_BSEARCH;}' unless defined(&VM_PHYSSEG_STRAT);
    eval 'sub VM_PHYSSEG_NOADD () {1;}' unless defined(&VM_PHYSSEG_NOADD);
    if(defined (&_KERNEL)  && !defined(&_LOCORE)) {
	eval 'sub dvma_mapin {
	    my($map,$va,$len,$canwait) = @_;
    	    eval q( &dvma_mapin_space($map,$va,$len,$canwait,0));
	}' unless defined(&dvma_mapin);
    }
}
1;
