require '_h2ph_pre.ph';

no warnings qw(redefine misc);

eval 'sub IWI_CMD_RING_COUNT () {16;}' unless defined(&IWI_CMD_RING_COUNT);
eval 'sub IWI_TX_RING_COUNT () {64;}' unless defined(&IWI_TX_RING_COUNT);
eval 'sub IWI_RX_RING_COUNT () {32;}' unless defined(&IWI_RX_RING_COUNT);
eval 'sub IWI_CSR_INTR () {0x8;}' unless defined(&IWI_CSR_INTR);
eval 'sub IWI_CSR_INTR_MASK () {0xc;}' unless defined(&IWI_CSR_INTR_MASK);
eval 'sub IWI_CSR_INDIRECT_ADDR () {0x10;}' unless defined(&IWI_CSR_INDIRECT_ADDR);
eval 'sub IWI_CSR_INDIRECT_DATA () {0x14;}' unless defined(&IWI_CSR_INDIRECT_DATA);
eval 'sub IWI_CSR_AUTOINC_ADDR () {0x18;}' unless defined(&IWI_CSR_AUTOINC_ADDR);
eval 'sub IWI_CSR_AUTOINC_DATA () {0x1c;}' unless defined(&IWI_CSR_AUTOINC_DATA);
eval 'sub IWI_CSR_RST () {0x20;}' unless defined(&IWI_CSR_RST);
eval 'sub IWI_CSR_CTL () {0x24;}' unless defined(&IWI_CSR_CTL);
eval 'sub IWI_CSR_IO () {0x30;}' unless defined(&IWI_CSR_IO);
eval 'sub IWI_CSR_CMD_BASE () {0x200;}' unless defined(&IWI_CSR_CMD_BASE);
eval 'sub IWI_CSR_CMD_SIZE () {0x204;}' unless defined(&IWI_CSR_CMD_SIZE);
unless(defined(&IWI_CSR_TX_BASE)) {
    sub IWI_CSR_TX_BASE {
	my($ac) = @_;
	eval q((0x208 + ($ac) * 8));
    }
}
unless(defined(&IWI_CSR_TX_SIZE)) {
    sub IWI_CSR_TX_SIZE {
	my($ac) = @_;
	eval q((0x20c + ($ac) * 8));
    }
}
eval 'sub IWI_CSR_CMD_RIDX () {0x280;}' unless defined(&IWI_CSR_CMD_RIDX);
unless(defined(&IWI_CSR_TX_RIDX)) {
    sub IWI_CSR_TX_RIDX {
	my($ac) = @_;
	eval q((0x284 + ($ac) * 4));
    }
}
eval 'sub IWI_CSR_RX_RIDX () {0x2a0;}' unless defined(&IWI_CSR_RX_RIDX);
eval 'sub IWI_CSR_RX_BASE () {0x500;}' unless defined(&IWI_CSR_RX_BASE);
eval 'sub IWI_CSR_TABLE0_SIZE () {0x700;}' unless defined(&IWI_CSR_TABLE0_SIZE);
eval 'sub IWI_CSR_TABLE0_BASE () {0x704;}' unless defined(&IWI_CSR_TABLE0_BASE);
eval 'sub IWI_CSR_NODE_BASE () {0xc0c;}' unless defined(&IWI_CSR_NODE_BASE);
eval 'sub IWI_CSR_CMD_WIDX () {0xf80;}' unless defined(&IWI_CSR_CMD_WIDX);
unless(defined(&IWI_CSR_TX_WIDX)) {
    sub IWI_CSR_TX_WIDX {
	my($ac) = @_;
	eval q((0xf84 + ($ac) * 4));
    }
}
eval 'sub IWI_CSR_RX_WIDX () {0xfa0;}' unless defined(&IWI_CSR_RX_WIDX);
eval 'sub IWI_CSR_READ_INT () {0xff4;}' unless defined(&IWI_CSR_READ_INT);
eval 'sub IWI_CSR_CURRENT_TX_RATE () { &IWI_CSR_TABLE0_BASE;}' unless defined(&IWI_CSR_CURRENT_TX_RATE);
eval 'sub IWI_INTR_RX_DONE () {0x2;}' unless defined(&IWI_INTR_RX_DONE);
eval 'sub IWI_INTR_CMD_DONE () {0x800;}' unless defined(&IWI_INTR_CMD_DONE);
eval 'sub IWI_INTR_TX1_DONE () {0x1000;}' unless defined(&IWI_INTR_TX1_DONE);
eval 'sub IWI_INTR_TX2_DONE () {0x2000;}' unless defined(&IWI_INTR_TX2_DONE);
eval 'sub IWI_INTR_TX3_DONE () {0x4000;}' unless defined(&IWI_INTR_TX3_DONE);
eval 'sub IWI_INTR_TX4_DONE () {0x8000;}' unless defined(&IWI_INTR_TX4_DONE);
eval 'sub IWI_INTR_FW_INITED () {0x1000000;}' unless defined(&IWI_INTR_FW_INITED);
eval 'sub IWI_INTR_RADIO_OFF () {0x4000000;}' unless defined(&IWI_INTR_RADIO_OFF);
eval 'sub IWI_INTR_FATAL_ERROR () {0x40000000;}' unless defined(&IWI_INTR_FATAL_ERROR);
eval 'sub IWI_INTR_PARITY_ERROR () {0x80000000;}' unless defined(&IWI_INTR_PARITY_ERROR);
eval 'sub IWI_INTR_MASK () {( &IWI_INTR_RX_DONE |  &IWI_INTR_CMD_DONE |  &IWI_INTR_TX1_DONE |  &IWI_INTR_TX2_DONE |  &IWI_INTR_TX3_DONE |  &IWI_INTR_TX4_DONE |  &IWI_INTR_FW_INITED |  &IWI_INTR_RADIO_OFF |  &IWI_INTR_FATAL_ERROR |  &IWI_INTR_PARITY_ERROR);}' unless defined(&IWI_INTR_MASK);
eval 'sub IWI_RST_PRINCETON_RESET () {0x1;}' unless defined(&IWI_RST_PRINCETON_RESET);
eval 'sub IWI_RST_SW_RESET () {0x80;}' unless defined(&IWI_RST_SW_RESET);
eval 'sub IWI_RST_MASTER_DISABLED () {0x100;}' unless defined(&IWI_RST_MASTER_DISABLED);
eval 'sub IWI_RST_STOP_MASTER () {0x200;}' unless defined(&IWI_RST_STOP_MASTER);
eval 'sub IWI_CTL_CLOCK_READY () {0x1;}' unless defined(&IWI_CTL_CLOCK_READY);
eval 'sub IWI_CTL_ALLOW_STANDBY () {0x2;}' unless defined(&IWI_CTL_ALLOW_STANDBY);
eval 'sub IWI_CTL_INIT () {0x4;}' unless defined(&IWI_CTL_INIT);
eval 'sub IWI_IO_RADIO_ENABLED () {0x10000;}' unless defined(&IWI_IO_RADIO_ENABLED);
eval 'sub IWI_READ_INT_INIT_HOST () {0x20000000;}' unless defined(&IWI_READ_INT_INIT_HOST);
eval 'sub IWI_CB_DEFAULT_CTL () {0x8cea0000;}' unless defined(&IWI_CB_DEFAULT_CTL);
eval 'sub IWI_CB_MAXDATALEN () {8191;}' unless defined(&IWI_CB_MAXDATALEN);
eval 'sub IWI_HDR_TYPE_DATA () {0;}' unless defined(&IWI_HDR_TYPE_DATA);
eval 'sub IWI_HDR_TYPE_COMMAND () {1;}' unless defined(&IWI_HDR_TYPE_COMMAND);
eval 'sub IWI_HDR_TYPE_NOTIF () {3;}' unless defined(&IWI_HDR_TYPE_NOTIF);
eval 'sub IWI_HDR_TYPE_FRAME () {9;}' unless defined(&IWI_HDR_TYPE_FRAME);
eval 'sub IWI_HDR_FLAG_IRQ () {0x4;}' unless defined(&IWI_HDR_FLAG_IRQ);
eval 'sub IWI_NOTIF_TYPE_ASSOCIATION () {10;}' unless defined(&IWI_NOTIF_TYPE_ASSOCIATION);
eval 'sub IWI_NOTIF_TYPE_AUTHENTICATION () {11;}' unless defined(&IWI_NOTIF_TYPE_AUTHENTICATION);
eval 'sub IWI_NOTIF_TYPE_SCAN_CHANNEL () {12;}' unless defined(&IWI_NOTIF_TYPE_SCAN_CHANNEL);
eval 'sub IWI_NOTIF_TYPE_SCAN_COMPLETE () {13;}' unless defined(&IWI_NOTIF_TYPE_SCAN_COMPLETE);
eval 'sub IWI_NOTIF_TYPE_BAD_LINK () {15;}' unless defined(&IWI_NOTIF_TYPE_BAD_LINK);
eval 'sub IWI_NOTIF_TYPE_BEACON () {17;}' unless defined(&IWI_NOTIF_TYPE_BEACON);
eval 'sub IWI_NOTIF_TYPE_PAIRWISE_KEY () {18;}' unless defined(&IWI_NOTIF_TYPE_PAIRWISE_KEY);
eval 'sub IWI_NOTIF_TYPE_CALIBRATION () {20;}' unless defined(&IWI_NOTIF_TYPE_CALIBRATION);
eval 'sub IWI_NOTIF_TYPE_NOISE () {25;}' unless defined(&IWI_NOTIF_TYPE_NOISE);
eval 'sub IWI_DEAUTHENTICATED () {0;}' unless defined(&IWI_DEAUTHENTICATED);
eval 'sub IWI_AUTHENTICATED () {9;}' unless defined(&IWI_AUTHENTICATED);
eval 'sub IWI_DEASSOCIATED () {0;}' unless defined(&IWI_DEASSOCIATED);
eval 'sub IWI_ASSOCIATED () {12;}' unless defined(&IWI_ASSOCIATED);
eval 'sub IWI_BEACON_MISSED () {1;}' unless defined(&IWI_BEACON_MISSED);
eval 'sub IWI_DATA_CMD_TX () {0xb;}' unless defined(&IWI_DATA_CMD_TX);
eval 'sub IWI_DATA_FLAG_SHPREAMBLE () {(1<< 2);}' unless defined(&IWI_DATA_FLAG_SHPREAMBLE);
eval 'sub IWI_DATA_FLAG_NO_WEP () {(1<< 5);}' unless defined(&IWI_DATA_FLAG_NO_WEP);
eval 'sub IWI_DATA_FLAG_NEED_ACK () {(1<< 7);}' unless defined(&IWI_DATA_FLAG_NEED_ACK);
eval 'sub IWI_DATA_XFLAG_CCK () {(1<< 0);}' unless defined(&IWI_DATA_XFLAG_CCK);
eval 'sub IWI_DATA_XFLAG_QOS () {(1<< 4);}' unless defined(&IWI_DATA_XFLAG_QOS);
eval 'sub IWI_DATA_KEY_USE_PAIRWISE () {(1<< 5);}' unless defined(&IWI_DATA_KEY_USE_PAIRWISE);
eval 'sub IWI_DATA_KEY_WEP40 () {(1<< 6);}' unless defined(&IWI_DATA_KEY_WEP40);
eval 'sub IWI_DATA_KEY_WEP104 () {(1<< 7);}' unless defined(&IWI_DATA_KEY_WEP104);
eval 'sub IWI_MAX_NSEG () {6;}' unless defined(&IWI_MAX_NSEG);
eval 'sub IWI_MAX_SCATTER () {( &IWI_MAX_NSEG - 2);}' unless defined(&IWI_MAX_SCATTER);
eval 'sub IWI_CMD_ENABLE () {2;}' unless defined(&IWI_CMD_ENABLE);
eval 'sub IWI_CMD_SET_CONFIG () {6;}' unless defined(&IWI_CMD_SET_CONFIG);
eval 'sub IWI_CMD_SET_ESSID () {8;}' unless defined(&IWI_CMD_SET_ESSID);
eval 'sub IWI_CMD_SET_MAC_ADDRESS () {11;}' unless defined(&IWI_CMD_SET_MAC_ADDRESS);
eval 'sub IWI_CMD_SET_RTS_THRESHOLD () {15;}' unless defined(&IWI_CMD_SET_RTS_THRESHOLD);
eval 'sub IWI_CMD_SET_FRAG_THRESHOLD () {16;}' unless defined(&IWI_CMD_SET_FRAG_THRESHOLD);
eval 'sub IWI_CMD_SET_POWER_MODE () {17;}' unless defined(&IWI_CMD_SET_POWER_MODE);
eval 'sub IWI_CMD_SET_GROUP_KEY () {18;}' unless defined(&IWI_CMD_SET_GROUP_KEY);
eval 'sub IWI_CMD_SET_PAIRWISE_KEY () {19;}' unless defined(&IWI_CMD_SET_PAIRWISE_KEY);
eval 'sub IWI_CMD_ASSOCIATE () {21;}' unless defined(&IWI_CMD_ASSOCIATE);
eval 'sub IWI_CMD_SET_RATES () {22;}' unless defined(&IWI_CMD_SET_RATES);
eval 'sub IWI_CMD_SET_QOS_PARAMS () {25;}' unless defined(&IWI_CMD_SET_QOS_PARAMS);
eval 'sub IWI_CMD_SCAN () {26;}' unless defined(&IWI_CMD_SCAN);
eval 'sub IWI_CMD_SET_OPTIE () {31;}' unless defined(&IWI_CMD_SET_OPTIE);
eval 'sub IWI_CMD_DISABLE () {33;}' unless defined(&IWI_CMD_DISABLE);
eval 'sub IWI_CMD_SET_RANDOM_SEED () {34;}' unless defined(&IWI_CMD_SET_RANDOM_SEED);
eval 'sub IWI_CMD_SET_TX_POWER () {35;}' unless defined(&IWI_CMD_SET_TX_POWER);
eval 'sub IWI_CMD_SET_SENSITIVITY () {42;}' unless defined(&IWI_CMD_SET_SENSITIVITY);
eval 'sub IWI_CMD_SET_QOS_CAP () {84;}' unless defined(&IWI_CMD_SET_QOS_CAP);
eval 'sub IWI_MODE_11A () {0;}' unless defined(&IWI_MODE_11A);
eval 'sub IWI_MODE_11B () {1;}' unless defined(&IWI_MODE_11B);
eval 'sub IWI_MODE_11G () {2;}' unless defined(&IWI_MODE_11G);
eval 'sub IWI_POWER_MODE_CAM () {0;}' unless defined(&IWI_POWER_MODE_CAM);
eval 'sub IWI_RATESET_TYPE_NEGOTIATED () {0;}' unless defined(&IWI_RATESET_TYPE_NEGOTIATED);
eval 'sub IWI_RATESET_TYPE_SUPPORTED () {1;}' unless defined(&IWI_RATESET_TYPE_SUPPORTED);
eval 'sub IWI_TXPOWER_MAX () {20;}' unless defined(&IWI_TXPOWER_MAX);
eval 'sub IWI_TXPOWER_RATIO () {( &IEEE80211_TXPOWER_MAX /  &IWI_TXPOWER_MAX);}' unless defined(&IWI_TXPOWER_RATIO);
eval 'sub IWI_AUTH_OPEN () {0;}' unless defined(&IWI_AUTH_OPEN);
eval 'sub IWI_AUTH_SHARED () {1;}' unless defined(&IWI_AUTH_SHARED);
eval 'sub IWI_AUTH_NONE () {3;}' unless defined(&IWI_AUTH_NONE);
eval 'sub IWI_ASSOC_ASSOCIATE () {0;}' unless defined(&IWI_ASSOC_ASSOCIATE);
eval 'sub IWI_ASSOC_REASSOCIATE () {1;}' unless defined(&IWI_ASSOC_REASSOCIATE);
eval 'sub IWI_ASSOC_DISASSOCIATE () {2;}' unless defined(&IWI_ASSOC_DISASSOCIATE);
eval 'sub IWI_ASSOC_SIBSS () {3;}' unless defined(&IWI_ASSOC_SIBSS);
eval 'sub IWI_ASSOC_POLICY_QOS () {(1<< 0);}' unless defined(&IWI_ASSOC_POLICY_QOS);
eval 'sub IWI_ASSOC_POLICY_RSN () {(1<< 1);}' unless defined(&IWI_ASSOC_POLICY_RSN);
eval 'sub IWI_ASSOC_SHPREAMBLE () {(1<< 2);}' unless defined(&IWI_ASSOC_SHPREAMBLE);
eval 'sub IWI_CHAN_5GHZ () {(0<< 6);}' unless defined(&IWI_CHAN_5GHZ);
eval 'sub IWI_CHAN_2GHZ () {(1<< 6);}' unless defined(&IWI_CHAN_2GHZ);
eval 'sub IWI_SCAN_TYPE_PASSIVE () {0x11;}' unless defined(&IWI_SCAN_TYPE_PASSIVE);
eval 'sub IWI_SCAN_TYPE_DIRECTED () {0x22;}' unless defined(&IWI_SCAN_TYPE_DIRECTED);
eval 'sub IWI_SCAN_TYPE_BROADCAST () {0x33;}' unless defined(&IWI_SCAN_TYPE_BROADCAST);
eval 'sub IWI_SCAN_TYPE_BDIRECTED () {0x44;}' unless defined(&IWI_SCAN_TYPE_BDIRECTED);
eval 'sub IWI_GROUP_KEY_CMD_SETKEY () {0x8;}' unless defined(&IWI_GROUP_KEY_CMD_SETKEY);
eval 'sub IWI_CIPHER_WEP () {0;}' unless defined(&IWI_CIPHER_WEP);
eval 'sub IWI_CIPHER_CCMP () {2;}' unless defined(&IWI_CIPHER_CCMP);
eval 'sub IWI_CIPHER_TKIP () {3;}' unless defined(&IWI_CIPHER_TKIP);
eval 'sub IWI_MEM_EEPROM_CTL () {0x300040;}' unless defined(&IWI_MEM_EEPROM_CTL);
eval 'sub IWI_MEM_EVENT_CTL () {0x300004;}' unless defined(&IWI_MEM_EVENT_CTL);
eval 'sub IWI_LED_ASSOC () {(1<< 5);}' unless defined(&IWI_LED_ASSOC);
eval 'sub IWI_LED_MASK () {0xd9fffffb;}' unless defined(&IWI_LED_MASK);
eval 'sub IWI_EEPROM_MAC () {0x21;}' unless defined(&IWI_EEPROM_MAC);
eval 'sub IWI_EEPROM_DELAY () {1;}' unless defined(&IWI_EEPROM_DELAY);
eval 'sub IWI_EEPROM_C () {(1<< 0);}' unless defined(&IWI_EEPROM_C);
eval 'sub IWI_EEPROM_S () {(1<< 1);}' unless defined(&IWI_EEPROM_S);
eval 'sub IWI_EEPROM_D () {(1<< 2);}' unless defined(&IWI_EEPROM_D);
eval 'sub IWI_EEPROM_Q () {(1<< 4);}' unless defined(&IWI_EEPROM_Q);
eval 'sub IWI_EEPROM_SHIFT_D () {2;}' unless defined(&IWI_EEPROM_SHIFT_D);
eval 'sub IWI_EEPROM_SHIFT_Q () {4;}' unless defined(&IWI_EEPROM_SHIFT_Q);
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_REGION_4)) {
    sub CSR_READ_REGION_4 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_read_region_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_REGION_1)) {
    sub CSR_WRITE_REGION_1 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_write_region_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&MEM_WRITE_1)) {
    sub MEM_WRITE_1 {
	my($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_1(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_2)) {
    sub MEM_WRITE_2 {
	my($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_2(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_4)) {
    sub MEM_WRITE_4 {
	my($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_MULTI_1)) {
    sub MEM_WRITE_MULTI_1 {
	my($sc, $addr, $buf, $len) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_MULTI_1(($sc),  &IWI_CSR_INDIRECT_DATA, ($buf), ($len)); }  &while ( 0));
    }
}
unless(defined(&IWI_EEPROM_CTL)) {
    sub IWI_EEPROM_CTL {
	my($sc, $val) = @_;
	eval q( &do {  &MEM_WRITE_4(($sc),  &IWI_MEM_EEPROM_CTL, ($val));  &DELAY( &IWI_EEPROM_DELAY); }  &while ( 0));
    }
}
1;
