require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'machine/endian.ph';
eval 'sub BBSIZE () {1024;}' unless defined(&BBSIZE);
eval 'sub SBSIZE () {1024;}' unless defined(&SBSIZE);
eval 'sub BBOFF () {(( &off_t)(0));}' unless defined(&BBOFF);
eval 'sub SBOFF () {(( &off_t)( &BBOFF +  &BBSIZE));}' unless defined(&SBOFF);
eval 'sub BBLOCK () {(( &daddr_t)(0));}' unless defined(&BBLOCK);
eval 'sub SBLOCK () {(( &daddr_t)( &BBLOCK +  &BBSIZE /  &DEV_BSIZE));}' unless defined(&SBLOCK);
eval 'sub LOG_MINBSIZE () {10;}' unless defined(&LOG_MINBSIZE);
eval 'sub MINBSIZE () {(1<<  &LOG_MINBSIZE);}' unless defined(&MINBSIZE);
eval 'sub LOG_MINFSIZE () {10;}' unless defined(&LOG_MINFSIZE);
eval 'sub MINFSIZE () {(1<<  &LOG_MINFSIZE);}' unless defined(&MINFSIZE);
eval 'sub MAXMNTLEN () {512;}' unless defined(&MAXMNTLEN);
eval 'sub MINFREE () {5;}' unless defined(&MINFREE);
eval 'sub E2FS_MAGIC () {0xef53;}' unless defined(&E2FS_MAGIC);
eval 'sub E2FS_REV0 () {0;}' unless defined(&E2FS_REV0);
eval 'sub E2FS_REV1 () {1;}' unless defined(&E2FS_REV1);
eval 'sub EXT2F_COMPAT_PREALLOC () {0x1;}' unless defined(&EXT2F_COMPAT_PREALLOC);
eval 'sub EXT2F_COMPAT_HASJOURNAL () {0x4;}' unless defined(&EXT2F_COMPAT_HASJOURNAL);
eval 'sub EXT2F_COMPAT_RESIZE () {0x10;}' unless defined(&EXT2F_COMPAT_RESIZE);
eval 'sub EXT2F_COMPAT_DIRHASHINDEX () {0x20;}' unless defined(&EXT2F_COMPAT_DIRHASHINDEX);
eval 'sub EXT2F_ROCOMPAT_SPARSESUPER () {0x1;}' unless defined(&EXT2F_ROCOMPAT_SPARSESUPER);
eval 'sub EXT2F_ROCOMPAT_LARGEFILE () {0x2;}' unless defined(&EXT2F_ROCOMPAT_LARGEFILE);
eval 'sub EXT2F_ROCOMPAT_BTREE_DIR () {0x4;}' unless defined(&EXT2F_ROCOMPAT_BTREE_DIR);
eval 'sub EXT2F_ROCOMPAT_HUGE_FILE () {0x8;}' unless defined(&EXT2F_ROCOMPAT_HUGE_FILE);
eval 'sub EXT2F_INCOMPAT_COMP () {0x1;}' unless defined(&EXT2F_INCOMPAT_COMP);
eval 'sub EXT2F_INCOMPAT_FTYPE () {0x2;}' unless defined(&EXT2F_INCOMPAT_FTYPE);
eval 'sub EXT2F_INCOMPAT_RECOVER () {0x4;}' unless defined(&EXT2F_INCOMPAT_RECOVER);
eval 'sub EXT2F_INCOMPAT_JOURNAL_DEV () {0x8;}' unless defined(&EXT2F_INCOMPAT_JOURNAL_DEV);
eval 'sub EXT2F_INCOMPAT_META_BG () {0x10;}' unless defined(&EXT2F_INCOMPAT_META_BG);
eval 'sub EXT2F_INCOMPAT_EXTENTS () {0x40;}' unless defined(&EXT2F_INCOMPAT_EXTENTS);
eval 'sub EXT2F_INCOMPAT_FLEX_BG () {0x200;}' unless defined(&EXT2F_INCOMPAT_FLEX_BG);
eval 'sub EXT2F_COMPAT_SUPP () {0x;}' unless defined(&EXT2F_COMPAT_SUPP);
eval 'sub EXT2F_ROCOMPAT_SUPP () {( &EXT2F_ROCOMPAT_SPARSESUPER |  &EXT2F_ROCOMPAT_LARGEFILE);}' unless defined(&EXT2F_ROCOMPAT_SUPP);
eval 'sub EXT2F_INCOMPAT_SUPP () {( &EXT2F_INCOMPAT_FTYPE);}' unless defined(&EXT2F_INCOMPAT_SUPP);
eval 'sub EXT4F_RO_INCOMPAT_SUPP () {( &EXT2F_INCOMPAT_EXTENTS |  &EXT2F_INCOMPAT_FLEX_BG |  &EXT2F_INCOMPAT_META_BG |  &EXT2F_INCOMPAT_RECOVER);}' unless defined(&EXT4F_RO_INCOMPAT_SUPP);
eval 'sub E2FS_BEH_CONTINUE () {1;}' unless defined(&E2FS_BEH_CONTINUE);
eval 'sub E2FS_BEH_READONLY () {2;}' unless defined(&E2FS_BEH_READONLY);
eval 'sub E2FS_BEH_PANIC () {3;}' unless defined(&E2FS_BEH_PANIC);
eval 'sub E2FS_BEH_DEFAULT () { &E2FS_BEH_CONTINUE;}' unless defined(&E2FS_BEH_DEFAULT);
eval 'sub E2FS_OS_LINUX () {0;}' unless defined(&E2FS_OS_LINUX);
eval 'sub E2FS_OS_HURD () {1;}' unless defined(&E2FS_OS_HURD);
eval 'sub E2FS_OS_MASIX () {2;}' unless defined(&E2FS_OS_MASIX);
eval 'sub E2FS_ISCLEAN () {0x1;}' unless defined(&E2FS_ISCLEAN);
eval 'sub E2FS_ERRORS () {0x2;}' unless defined(&E2FS_ERRORS);
unless(defined(&cg_has_sb)) {
    sub cg_has_sb {
	my($i) = @_;
	eval q(; { 'int'  &a3 , &a5 ,  &a7;  &if ($i == 0|| $i == 1) 1;  &for ( &a3 = 3,  &a5 = 5,  &a7 = 7;  &a3 <= $i ||  &a5 <= $i ||  &a7 <= $i;  &a3 *= 3,  &a5 *= 5,  &a7 *= 7)  &if ($i ==  &a3 || $i ==  &a5 || $i ==  &a7) 1; 0; });
    }
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
    eval 'sub e2fs_sbload {
        my($old, $new) = @_;
	    eval q( &memcpy(($new), ($old),  &SBSIZE););
    }' unless defined(&e2fs_sbload);
    eval 'sub e2fs_cgload {
        my($old, $new, $size) = @_;
	    eval q( &memcpy(($new), ($old), ($size)););
    }' unless defined(&e2fs_cgload);
    eval 'sub e2fs_sbsave {
        my($old, $new) = @_;
	    eval q( &memcpy(($new), ($old),  &SBSIZE););
    }' unless defined(&e2fs_sbsave);
    eval 'sub e2fs_cgsave {
        my($old, $new, $size) = @_;
	    eval q( &memcpy(($new), ($old), ($size)););
    }' unless defined(&e2fs_cgsave);
} else {
    eval 'sub e2fs_sbload {
        my($old, $new) = @_;
	    eval q( &e2fs_sb_bswap(($old), ($new)));
    }' unless defined(&e2fs_sbload);
    eval 'sub e2fs_cgload {
        my($old, $new, $size) = @_;
	    eval q( &e2fs_cg_bswap(($old), ($new), ($size)););
    }' unless defined(&e2fs_cgload);
    eval 'sub e2fs_sbsave {
        my($old, $new) = @_;
	    eval q( &e2fs_sb_bswap(($old), ($new)));
    }' unless defined(&e2fs_sbsave);
    eval 'sub e2fs_cgsave {
        my($old, $new, $size) = @_;
	    eval q( &e2fs_cg_bswap(($old), ($new), ($size)););
    }' unless defined(&e2fs_cgsave);
}
unless(defined(&fsbtodb)) {
    sub fsbtodb {
	my($fs, $b) = @_;
	eval q((($b) << ($fs)-> &e2fs_fsbtodb));
    }
}
unless(defined(&dbtofsb)) {
    sub dbtofsb {
	my($fs, $b) = @_;
	eval q((($b) >> ($fs)-> &e2fs_fsbtodb));
    }
}
unless(defined(&ino_to_cg)) {
    sub ino_to_cg {
	my($fs, $x) = @_;
	eval q(((($x) - 1) / ($fs)-> ($e2fs->{e2fs_ipg})));
    }
}
unless(defined(&ino_to_fsba)) {
    sub ino_to_fsba {
	my($fs, $x) = @_;
	eval q((($fs)-> ($e2fs_gd[ino_to_cg($fs, x)]->{e$xt2bgd_i_tables}) + ((($x)-1) % ($fs)-> ($e2fs->{e2fs_ipg}))/($fs)-> &e2fs_ipb));
    }
}
unless(defined(&ino_to_fsbo)) {
    sub ino_to_fsbo {
	my($fs, $x) = @_;
	eval q(((($x)-1) % ($fs)-> &e2fs_ipb));
    }
}
unless(defined(&dtog)) {
    sub dtog {
	my($fs, $d) = @_;
	eval q(((($d) - ($fs)-> ($e2fs->{e2fs_first_dblock})) / ($fs)-> ($e2fs->{e2fs_fpg})));
    }
}
unless(defined(&dtogd)) {
    sub dtogd {
	my($fs, $d) = @_;
	eval q(((($d) - ($fs)-> ($e2fs->{e2fs_first_dblock})) % ($fs)-> ($e2fs->{e2fs_fpg})));
    }
}
unless(defined(&blkoff)) {
    sub blkoff {
	my($fs, $loc) = @_;
	eval q((($loc) & ($fs)-> &e2fs_qbmask));
    }
}
unless(defined(&lblktosize)) {
    sub lblktosize {
	my($fs, $blk) = @_;
	eval q((($blk) << ($fs)-> &e2fs_bshift));
    }
}
unless(defined(&lblkno)) {
    sub lblkno {
	my($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &e2fs_bshift));
    }
}
unless(defined(&blkroundup)) {
    sub blkroundup {
	my($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &e2fs_qbmask) & ($fs)-> &e2fs_bmask));
    }
}
unless(defined(&fragroundup)) {
    sub fragroundup {
	my($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &e2fs_qbmask) & ($fs)-> &e2fs_bmask));
    }
}
unless(defined(&freespace)) {
    sub freespace {
	my($fs) = @_;
	eval q((($fs)-> ($e2fs->{e2fs_fbcount}) - ($fs)-> ($e2fs->{e2fs_rbcount})));
    }
}
unless(defined(&NINDIR)) {
    sub NINDIR {
	my($fs) = @_;
	eval q((($fs)-> &e2fs_bsize / $sizeof{ &u_int32_t}));
    }
}
1;
