# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from twisted.trial.unittest import TestCase
from twisted.internet import defer
from elisa.core.media_uri import MediaUri
from elisa.plugins.coherence.coherence_resource import CoherenceResource
from elisa.plugins.base.models.network import NetworkServiceModel

class FakeService:
    def get_sid(self):
        return 'uuid:idontremember'

    def get_id(self):
        return 'iamanid'

    def get_device(self):
        class Device:
            def get_uuid(self):
                return 'goo'

        d = Device()
        d.friendly_name = 'iamfriendly'
        return d


class FakeClient:
    def browse(self, container_id):
        return defer.succeed(['woo', 'foo', 'bar'])


class TestCoherenceResourceProvider(TestCase):

    def setUp(self):
        # we are doing bad things, but we don't want to have initialize called
        self.provider = CoherenceResource()

    def test_unsupported_uri(self):
        model, dfr = self.provider.get(MediaUri('coherence://idontexist'))
        self.failUnlessFailure(dfr, NotImplementedError)
        return dfr

    def test_list_media_servers(self):
        self.provider._known_media_servers = \
            {u'upnp://iamfake': ('imanudn', FakeService())}

        def got_media_servers(model):
            self.failUnless(model.media_servers)
            first = model.media_servers[0]
            self.failUnless(isinstance(first, NetworkServiceModel))
            self.assertEquals(first.uid, 'uuid:goo')
            self.assertEquals(first.name, 'iamfriendly')
            self.assertEquals(first.type, 'iamanid')
            self.assertEquals(first.elisa_uri, MediaUri('upnp://goo?sid=idontremember'))

        uri = MediaUri('coherence://media_servers')
        model, dfr = self.provider.get(uri)
        dfr.addCallback(got_media_servers)
        return dfr
