/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.Visibility;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class BeanContextSupport
extends BeanContextChildSupport
implements BeanContext,
Serializable,
PropertyChangeListener,
VetoableChangeListener {
    private static final long serialVersionUID = -4879613978649577204L;
    protected transient ArrayList bcmListeners;
    protected transient HashMap children;
    protected transient boolean designTime;
    protected transient Locale locale;
    protected transient boolean okToUseGui;
    private transient boolean serializing;

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.bcsPreDeserializationHook(s);
        BeanContext peer = this.getBeanContextPeer();
        if (peer == null || peer == this) {
            this.readChildren(s);
        }
    }

    private void writeObject(ObjectOutputStream s) throws ClassNotFoundException, IOException {
        this.serializing = true;
        s.defaultWriteObject();
        this.bcsPreSerializationHook(s);
        BeanContext peer = this.getBeanContextPeer();
        if (peer == null || peer == this) {
            this.writeChildren(s);
        }
        this.serializing = false;
    }

    public BeanContextSupport() {
        this(null, null, false, true);
    }

    public BeanContextSupport(BeanContext peer) {
        this(peer, null, false, true);
    }

    public BeanContextSupport(BeanContext peer, Locale locale) {
        this(peer, locale, false, true);
    }

    public BeanContextSupport(BeanContext peer, Locale locale, boolean dtime) {
        this(peer, locale, dtime, true);
    }

    public BeanContextSupport(BeanContext peer, Locale locale, boolean dtime, boolean visible) {
        super(peer);
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.designTime = dtime;
        this.okToUseGui = visible;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(Object targetChild) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            BCSChild child;
            if (targetChild == null) {
                throw new IllegalArgumentException();
            }
            Object object2 = this.children;
            synchronized (object2) {
                if (this.children.containsKey(targetChild)) return false;
                if (!this.validatePendingAdd(targetChild)) {
                    return false;
                }
                child = this.createBCSChild(targetChild, this.beanContextChildPeer);
                this.children.put(targetChild, child);
            }
            object2 = targetChild;
            synchronized (object2) {
                BeanContextChild bcChild = null;
                if (targetChild instanceof BeanContextChild) {
                    bcChild = (BeanContextChild)targetChild;
                }
                if (targetChild instanceof BeanContextProxy) {
                    bcChild = ((BeanContextProxy)targetChild).getBeanContextProxy();
                }
                if (bcChild != null) {
                    try {
                        bcChild.setBeanContext(this);
                        bcChild.addVetoableChangeListener("beanContext", this);
                        bcChild.addPropertyChangeListener("beanContext", this);
                    }
                    catch (PropertyVetoException e) {
                        HashMap hashMap = this.children;
                        synchronized (hashMap) {
                            this.children.remove(targetChild);
                            throw new IllegalStateException("The child refused to associate itself with this context.", e);
                        }
                    }
                }
                if (targetChild instanceof Visibility) {
                    Visibility visibleChild = (Visibility)targetChild;
                    if (this.okToUseGui) {
                        visibleChild.okToUseGui();
                    } else {
                        visibleChild.dontUseGui();
                    }
                }
                this.childJustAddedHook(targetChild, child);
            }
            this.fireChildrenAdded(new BeanContextMembershipEvent((BeanContext)this, new Object[]{targetChild}));
            return true;
        }
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextMembershipListener(BeanContextMembershipListener listener) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (!this.bcmListeners.contains(listener)) {
                this.bcmListeners.add(listener);
            }
        }
    }

    public boolean avoidingGui() {
        return this.needsGui() && !this.okToUseGui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator bcsChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return new BCSIterator(this.children.values().iterator());
        }
    }

    protected void bcsPreDeserializationHook(ObjectInputStream ois) throws ClassNotFoundException, IOException {
    }

    protected void bcsPreSerializationHook(ObjectOutputStream oos) throws IOException {
    }

    protected void childDeserializedHook(Object child, BCSChild bcsc) {
    }

    protected void childJustAddedHook(Object child, BCSChild bcsc) {
    }

    protected void childJustRemovedHook(Object child, BCSChild bcsc) {
    }

    protected static final boolean classEquals(Class first, Class second) {
        return first == second || first.getName().equals(second.getName());
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.containsKey(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsAll(Collection c) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator it = c.iterator();
            do {
                if (it.hasNext()) continue;
                return true;
            } while (this.children.containsKey(it.next()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object o) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.containsKey(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object[] copyChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray();
        }
    }

    protected BCSChild createBCSChild(Object targetChild, Object peer) {
        return new BCSChild(targetChild, peer);
    }

    protected final void deserialize(ObjectInputStream ois, Collection coll) throws ClassNotFoundException, IOException {
        int itemCount = ois.readInt();
        int i = 0;
        while (i < itemCount) {
            coll.add(ois.readObject());
            ++i;
        }
    }

    public void dontUseGui() {
        this.okToUseGui = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenAdded(BeanContextMembershipEvent bcme) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            for (BeanContextMembershipListener l : this.bcmListeners) {
                l.childrenAdded(bcme);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenRemoved(BeanContextMembershipEvent bcme) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            for (BeanContextMembershipListener l : this.bcmListeners) {
                l.childrenRemoved(bcme);
            }
        }
    }

    public BeanContext getBeanContextPeer() {
        return (BeanContext)this.beanContextChildPeer;
    }

    protected static final BeanContextChild getChildBeanContextChild(Object child) {
        if (child == null) {
            return null;
        }
        if (child instanceof BeanContextChild && child instanceof BeanContextProxy) {
            throw new IllegalArgumentException("Child cannot implement BeanContextChild and BeanContextProxy simultaneously.");
        }
        if (child instanceof BeanContextChild) {
            return (BeanContextChild)child;
        }
        if (child instanceof BeanContextProxy) {
            return ((BeanContextProxy)child).getBeanContextProxy();
        }
        return null;
    }

    protected static final BeanContextMembershipListener getChildBeanContextMembershipListener(Object child) {
        if (child instanceof BeanContextMembershipListener) {
            return (BeanContextMembershipListener)child;
        }
        return null;
    }

    protected static final PropertyChangeListener getChildPropertyChangeListener(Object child) {
        if (child instanceof PropertyChangeListener) {
            return (PropertyChangeListener)child;
        }
        return null;
    }

    protected static final Serializable getChildSerializable(Object child) {
        if (child instanceof Serializable) {
            return (Serializable)child;
        }
        return null;
    }

    protected static final VetoableChangeListener getChildVetoableChangeListener(Object child) {
        if (child instanceof VetoableChangeListener) {
            return (VetoableChangeListener)child;
        }
        return null;
    }

    protected static final Visibility getChildVisibility(Object child) {
        if (child instanceof Visibility) {
            return (Visibility)child;
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public URL getResource(String name, BeanContextChild bcc) {
        if (!this.contains(bcc)) {
            throw new IllegalArgumentException("argument not a child");
        }
        ClassLoader loader = bcc.getClass().getClassLoader();
        return loader == null ? ClassLoader.getSystemResource(name) : loader.getResource(name);
    }

    public InputStream getResourceAsStream(String name, BeanContextChild bcc) {
        if (!this.contains(bcc)) {
            throw new IllegalArgumentException("argument not a child");
        }
        ClassLoader loader = bcc.getClass().getClassLoader();
        return loader == null ? ClassLoader.getSystemResourceAsStream(name) : loader.getResourceAsStream(name);
    }

    protected void initialize() {
        this.bcmListeners = new ArrayList();
        this.children = new HashMap();
    }

    public Object instantiateChild(String beanName) throws IOException, ClassNotFoundException {
        return Beans.instantiate(this.getClass().getClassLoader(), beanName, this);
    }

    public boolean isDesignTime() {
        return this.designTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.isEmpty();
        }
    }

    public boolean isSerializing() {
        return this.serializing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().iterator();
        }
    }

    public boolean needsGui() {
        return false;
    }

    public void okToUseGui() {
        this.okToUseGui = true;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getNewValue() != this) {
            this.remove(pce.getSource(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readChildren(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ArrayList temp = new ArrayList();
        this.deserialize(ois, temp);
        Iterator i = temp.iterator();
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                while (i.hasNext()) {
                    BCSChild bcs = (BCSChild)i.next();
                    this.childDeserializedHook(bcs.getTargetChild(), bcs);
                    this.children.put(bcs.getTargetChild(), bcs);
                }
            }
        }
    }

    public boolean remove(Object targetChild) {
        return this.remove(targetChild, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean remove(Object targetChild, boolean callChildSetBC) {
        Object object = globalHierarchyLock;
        synchronized (object) {
            BCSChild child;
            if (targetChild == null) {
                throw new IllegalArgumentException();
            }
            Object object2 = this.children;
            synchronized (object2) {
                if (!this.children.containsKey(targetChild)) return false;
                if (!this.validatePendingRemove(targetChild)) {
                    return false;
                }
                child = (BCSChild)this.children.remove(targetChild);
            }
            object2 = targetChild;
            synchronized (object2) {
                BeanContextChild bcChild = null;
                if (targetChild instanceof BeanContextChild) {
                    bcChild = (BeanContextChild)targetChild;
                }
                if (targetChild instanceof BeanContextProxy) {
                    bcChild = ((BeanContextProxy)targetChild).getBeanContextProxy();
                }
                if (bcChild != null) {
                    try {
                        if (callChildSetBC) {
                            bcChild.setBeanContext(null);
                        }
                        bcChild.removeVetoableChangeListener("beanContext", this);
                        bcChild.removePropertyChangeListener("beanContext", this);
                    }
                    catch (PropertyVetoException e) {
                        HashMap hashMap = this.children;
                        synchronized (hashMap) {
                            this.children.put(targetChild, child);
                            throw new IllegalStateException("The child refused to disassociate itself with this context.", e);
                        }
                    }
                }
                this.childJustRemovedHook(targetChild, child);
            }
            this.fireChildrenRemoved(new BeanContextMembershipEvent((BeanContext)this, new Object[]{targetChild}));
            return true;
        }
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            this.bcmListeners.remove(bcml);
        }
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    protected final void serialize(ObjectOutputStream oos, Collection coll) throws IOException {
        Object[] items = coll.toArray();
        int itemCount = 0;
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof Serializable) {
                ++itemCount;
            }
            ++i;
        }
        oos.writeInt(itemCount);
        i = 0;
        while (i < items.length) {
            if (items[i] instanceof Serializable) {
                oos.writeObject(items[i]);
            }
            ++i;
        }
    }

    public void setDesignTime(boolean dtime) {
        boolean save = this.designTime;
        this.designTime = dtime;
        this.firePropertyChange("designMode", save, dtime);
    }

    public void setLocale(Locale newLocale) throws PropertyVetoException {
        if (newLocale == null || this.locale == newLocale) {
            return;
        }
        this.fireVetoableChange("locale", this.locale, newLocale);
        Locale oldLocale = this.locale;
        this.locale = newLocale;
        this.firePropertyChange("locale", oldLocale, newLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] array) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray(array);
        }
    }

    protected boolean validatePendingAdd(Object targetChild) {
        return true;
    }

    protected boolean validatePendingRemove(Object targetChild) {
        return true;
    }

    public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeChildren(ObjectOutputStream oos) throws IOException {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            this.serialize(oos, this.children.values());
        }
    }

    protected class BCSChild
    implements Serializable {
        private static final long serialVersionUID = -5815286101609939109L;
        private Object targetChild;
        private Object peer;

        BCSChild(Object targetChild, Object peer) {
            this.targetChild = targetChild;
            this.peer = peer;
        }

        private Object getTargetChild() {
            return this.targetChild;
        }
    }

    protected static final class BCSIterator
    implements Iterator {
        private Iterator child;

        BCSIterator(Iterator child) {
            this.child = child;
        }

        public boolean hasNext() {
            return this.child.hasNext();
        }

        public Object next() {
            return this.child.next();
        }

        public void remove() {
        }
    }
}

