/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.html2.DomHTMLCollection;
import gnu.xml.dom.html2.DomHTMLDocument;
import gnu.xml.dom.html2.DomHTMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableCaptionElement;
import org.w3c.dom.html2.HTMLTableElement;
import org.w3c.dom.html2.HTMLTableSectionElement;

public class DomHTMLTableElement
extends DomHTMLElement
implements HTMLTableElement {
    protected DomHTMLTableElement(DomHTMLDocument owner, String namespaceURI, String name) {
        super(owner, namespaceURI, name);
    }

    public HTMLTableCaptionElement getCaption() {
        return (HTMLTableCaptionElement)this.getChildElement("caption");
    }

    public void setCaption(HTMLTableCaptionElement caption) {
        HTMLTableCaptionElement ref = this.getCaption();
        if (ref == null) {
            this.appendChild(caption);
        } else {
            this.replaceChild(caption, ref);
        }
    }

    public HTMLTableSectionElement getTHead() {
        return (HTMLTableSectionElement)this.getChildElement("thead");
    }

    public void setTHead(HTMLTableSectionElement tHead) {
        HTMLTableSectionElement ref = this.getTHead();
        if (ref == null) {
            this.appendChild(tHead);
        } else {
            this.replaceChild(tHead, ref);
        }
    }

    public HTMLTableSectionElement getTFoot() {
        return (HTMLTableSectionElement)this.getChildElement("tfoot");
    }

    public void setTFoot(HTMLTableSectionElement tFoot) {
        HTMLTableSectionElement ref = this.getTFoot();
        if (ref == null) {
            this.appendChild(tFoot);
        } else {
            this.replaceChild(tFoot, ref);
        }
    }

    public HTMLCollection getRows() {
        DomHTMLCollection ret = new DomHTMLCollection((DomHTMLDocument)this.getOwnerDocument(), this);
        ret.addNodeName("tr");
        ret.evaluate();
        return ret;
    }

    public HTMLCollection getTBodies() {
        DomHTMLCollection ret = new DomHTMLCollection((DomHTMLDocument)this.getOwnerDocument(), this);
        ret.addNodeName("tbody");
        ret.evaluate();
        return ret;
    }

    public String getAlign() {
        return this.getHTMLAttribute("align");
    }

    public void setAlign(String align) {
        this.setHTMLAttribute("align", align);
    }

    public String getBgColor() {
        return this.getHTMLAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setHTMLAttribute("bgcolor", bgColor);
    }

    public String getBorder() {
        return this.getHTMLAttribute("border");
    }

    public void setBorder(String border) {
        this.setHTMLAttribute("border", border);
    }

    public String getCellPadding() {
        return this.getHTMLAttribute("cellpadding");
    }

    public void setCellPadding(String cellPadding) {
        this.setHTMLAttribute("cellpadding", cellPadding);
    }

    public String getCellSpacing() {
        return this.getHTMLAttribute("cellspacing");
    }

    public void setCellSpacing(String cellSpacing) {
        this.setHTMLAttribute("cellspacing", cellSpacing);
    }

    public String getFrame() {
        return this.getHTMLAttribute("frame");
    }

    public void setFrame(String frame) {
        this.setHTMLAttribute("frame", frame);
    }

    public String getRules() {
        return this.getHTMLAttribute("rules");
    }

    public void setRules(String rules) {
        this.setHTMLAttribute("rules", rules);
    }

    public String getSummary() {
        return this.getHTMLAttribute("summary");
    }

    public void setSummary(String summary) {
        this.setHTMLAttribute("summary", summary);
    }

    public String getWidth() {
        return this.getHTMLAttribute("width");
    }

    public void setWidth(String width) {
        this.setHTMLAttribute("width", width);
    }

    public HTMLElement createTHead() {
        HTMLTableSectionElement ref = this.getTHead();
        if (ref == null) {
            return (HTMLElement)this.getOwnerDocument().createElement("thead");
        }
        return ref;
    }

    public void deleteTHead() {
        HTMLTableSectionElement ref = this.getTHead();
        if (ref != null) {
            this.removeChild(ref);
        }
    }

    public HTMLElement createTFoot() {
        HTMLTableSectionElement ref = this.getTFoot();
        if (ref == null) {
            return (HTMLElement)this.getOwnerDocument().createElement("tfoot");
        }
        return ref;
    }

    public void deleteTFoot() {
        HTMLTableSectionElement ref = this.getTFoot();
        if (ref != null) {
            this.removeChild(ref);
        }
    }

    public HTMLElement createCaption() {
        HTMLTableCaptionElement ref = this.getCaption();
        if (ref == null) {
            return (HTMLElement)this.getOwnerDocument().createElement("caption");
        }
        return ref;
    }

    public void deleteCaption() {
        HTMLTableCaptionElement ref = this.getCaption();
        if (ref != null) {
            this.removeChild(ref);
        }
    }

    public HTMLElement insertRow(int index) {
        Node ref = this.getRow(index);
        Element row = this.getOwnerDocument().createElement("tr");
        if (ref == null) {
            Node tbody = this.getChildElement("tbody");
            if (tbody == null) {
                tbody = this.getOwnerDocument().createElement("tfoot");
                this.appendChild(tbody);
            }
            tbody.appendChild(row);
        } else {
            ref.getParentNode().insertBefore(row, ref);
        }
        return (HTMLElement)row;
    }

    public void deleteRow(int index) {
        Node ref = this.getRow(index);
        if (ref == null) {
            throw new DomDOMException(1);
        }
        ref.getParentNode().removeChild(ref);
    }

    Node getRow(int index) {
        Node tbody;
        int i = 0;
        Node thead = this.getChildElement("thead");
        if (thead != null) {
            Node ctx = thead.getFirstChild();
            while (ctx != null) {
                String ctxName = ctx.getLocalName();
                if (ctxName == null) {
                    ctxName = ctx.getNodeName();
                }
                if ("tr".equalsIgnoreCase(ctxName)) {
                    if (index == i) {
                        return ctx;
                    }
                    ++i;
                }
                ctx = ctx.getNextSibling();
            }
        }
        if ((tbody = this.getChildElement("tbody")) == null) {
            tbody = this;
        }
        Node ctx = tbody.getFirstChild();
        while (ctx != null) {
            String ctxName = ctx.getLocalName();
            if (ctxName == null) {
                ctxName = ctx.getNodeName();
            }
            if ("tr".equalsIgnoreCase(ctxName)) {
                if (index == i) {
                    return ctx;
                }
                ++i;
            }
            ctx = ctx.getNextSibling();
        }
        Node tfoot = this.getChildElement("tfoot");
        if (tfoot != null) {
            Node ctx2 = tfoot.getFirstChild();
            while (ctx2 != null) {
                String ctxName = ctx2.getLocalName();
                if (ctxName == null) {
                    ctxName = ctx2.getNodeName();
                }
                if ("tr".equalsIgnoreCase(ctxName)) {
                    if (index == i) {
                        return ctx2;
                    }
                    ++i;
                }
                ctx2 = ctx2.getNextSibling();
            }
        }
        return null;
    }
}

