/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractSequentialList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class AWTUtilities {
    static WeakHashMap visibleChildrenCache = new WeakHashMap();

    public static List getVisibleChildren(Container c) {
        Component[] children = c.getComponents();
        Object o = visibleChildrenCache.get(children);
        VisibleComponentList visibleChildren = null;
        if (o == null) {
            visibleChildren = new VisibleComponentList(children);
            visibleChildrenCache.put(children, visibleChildren);
        } else {
            visibleChildren = (VisibleComponentList)o;
        }
        return visibleChildren;
    }

    public static Rectangle calculateInsetArea(Rectangle base, Insets insets, Rectangle ret) {
        if (ret == null) {
            ret = new Rectangle();
        }
        ret.setBounds(base.x + insets.left, base.y + insets.top, base.width - (insets.left + insets.right), base.height - (insets.top + insets.bottom));
        return ret;
    }

    public static Rectangle getLocalBounds(Component aComponent) {
        Rectangle bounds = aComponent.getBounds();
        return new Rectangle(0, 0, bounds.width, bounds.height);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static Container getAncestorNamed(String name, Component comp) {
        while (comp != null && comp.getName() != name) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Container getAncestorOfClass(Class c, Component comp) {
        while (comp != null && !c.isInstance(comp)) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Window windowForComponent(Component comp) {
        return (Window)AWTUtilities.getAncestorOfClass(Window.class, comp);
    }

    public static Component getRoot(Component comp) {
        Applet app = null;
        Window win = null;
        while (comp != null) {
            if (win == null && comp instanceof Window) {
                win = (Window)comp;
            } else if (comp instanceof Applet) {
                app = (Applet)comp;
            }
            comp = comp.getParent();
        }
        if (win != null) {
            return win;
        }
        return app;
    }

    public static boolean isDescendingFrom(Component a, Component b) {
        while (a != null && b != null) {
            if (a == b) {
                return true;
            }
            a = a.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y) {
        if (parent == null || !parent.contains(x, y)) {
            return null;
        }
        if (!(parent instanceof Container)) {
            return parent;
        }
        Container c = (Container)parent;
        return c.findComponentAt(x, y);
    }

    public static void convertPointToScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(c0.x, c0.y);
    }

    public static void convertPointFromScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(-c0.x, -c0.y);
    }

    public static Point convertPoint(Component source, int x, int y, Component destination) {
        Point pt = new Point(x, y);
        if (source == null && destination == null) {
            return pt;
        }
        if (source == null) {
            source = AWTUtilities.getRoot(destination);
        }
        if (destination == null) {
            destination = AWTUtilities.getRoot(source);
        }
        if (source.isShowing() && destination.isShowing()) {
            AWTUtilities.convertPointToScreen(pt, source);
            AWTUtilities.convertPointFromScreen(pt, destination);
        }
        return pt;
    }

    public static Rectangle convertRectangle(Component source, Rectangle rect, Component destination) {
        Point pt = AWTUtilities.convertPoint(source, rect.x, rect.y, destination);
        return new Rectangle(pt.x, pt.y, rect.width, rect.height);
    }

    public static MouseEvent convertMouseEvent(Component source, MouseEvent sourceEvent, Component destination) {
        Point newpt = AWTUtilities.convertPoint(source, sourceEvent.getX(), sourceEvent.getY(), destination);
        return new MouseEvent(destination, sourceEvent.getID(), sourceEvent.getWhen(), sourceEvent.getModifiers(), newpt.x, newpt.y, sourceEvent.getClickCount(), sourceEvent.isPopupTrigger(), sourceEvent.getButton());
    }

    public static void invokeLater(Runnable doRun) {
        EventQueue.invokeLater(doRun);
    }

    public static void invokeAndWait(Runnable doRun) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(doRun);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static boolean isValidKey(int keyCode) {
        switch (keyCode) {
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 160: 
            case 161: 
            case 162: 
            case 192: 
            case 222: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 61440: 
            case 61441: 
            case 61442: 
            case 61443: 
            case 61444: 
            case 61445: 
            case 61446: 
            case 61447: 
            case 61448: 
            case 61449: 
            case 61450: 
            case 61451: 
            case 65312: 
            case 65368: 
            case 65406: 
            case 65480: 
            case 65481: 
            case 65482: 
            case 65483: 
            case 65485: 
            case 65487: 
            case 65488: 
            case 65489: {
                return true;
            }
        }
        return false;
    }

    static class VisibleComponentList
    extends AbstractSequentialList {
        Component[] components;

        VisibleComponentList(Component[] c) {
            this.components = c;
        }

        public ListIterator listIterator(int index) {
            return new VisibleComponentIterator(index);
        }

        public int size() {
            int visibleComponents = 0;
            int i = 0;
            while (i < this.components.length) {
                if (this.components[i].isVisible()) {
                    ++visibleComponents;
                }
                ++i;
            }
            return visibleComponents;
        }

        class VisibleComponentIterator
        implements ListIterator {
            int index;
            int listIndex;

            VisibleComponentIterator(int listIndex) {
                this.listIndex = listIndex;
                int visibleComponentsFound = 0;
                this.index = 0;
                while (visibleComponentsFound != listIndex) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        ++visibleComponentsFound;
                    }
                    ++this.index;
                }
            }

            public boolean hasNext() {
                boolean hasNext = false;
                int i = this.index;
                while (i < VisibleComponentList.this.components.length) {
                    if (VisibleComponentList.this.components[i].isVisible()) {
                        hasNext = true;
                        break;
                    }
                    ++i;
                }
                return hasNext;
            }

            public Object next() {
                Component o = null;
                while (this.index < VisibleComponentList.this.components.length) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        o = VisibleComponentList.this.components[this.index];
                        break;
                    }
                    ++this.index;
                }
                if (o != null) {
                    ++this.index;
                    ++this.listIndex;
                    return o;
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                boolean hasPrevious = false;
                int i = this.index - 1;
                while (i >= 0) {
                    if (VisibleComponentList.this.components[i].isVisible()) {
                        hasPrevious = true;
                        break;
                    }
                    --i;
                }
                return hasPrevious;
            }

            public Object previous() {
                Component o = null;
                --this.index;
                while (this.index >= 0) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        o = VisibleComponentList.this.components[this.index];
                        break;
                    }
                    --this.index;
                }
                if (o != null) {
                    --this.listIndex;
                    return o;
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.listIndex + 1;
            }

            public int previousIndex() {
                return this.listIndex - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            public void set(Object o) {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }
        }
    }
}

