/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private long maxPos;

    public FileCacheImageOutputStream(OutputStream s, File cacheDir) throws IOException {
        this.stream = s;
        this.cacheFile = File.createTempFile("imageio", ".tmp", cacheDir);
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
        this.maxPos = 0L;
    }

    public void close() throws IOException {
        this.maxPos = this.cache.length();
        this.seek(this.maxPos);
        this.flushBefore(this.maxPos);
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        this.stream.flush();
        this.stream = null;
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        int val = this.cache.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    public int read(byte[] data, int offset, int len) throws IOException {
        this.bitOffset = 0;
        int num = this.cache.read(data, offset, len);
        if (num != -1) {
            this.streamPos += (long)num;
        }
        return num;
    }

    public void write(byte[] data, int offset, int len) throws IOException {
        this.flushBits();
        this.cache.write(data, offset, len);
        this.streamPos += (long)len;
        this.maxPos = Math.max(this.streamPos, this.maxPos);
    }

    public void write(int value) throws IOException {
        this.flushBits();
        this.cache.write(value);
        ++this.streamPos;
        this.maxPos = Math.max(this.streamPos, this.maxPos);
    }

    public long length() {
        long l;
        try {
            l = this.cache.length();
        }
        catch (IOException iOException) {
            l = -1L;
        }
        return l;
    }

    public void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        this.cache.seek(pos);
        this.streamPos = this.cache.getFilePointer();
        this.maxPos = Math.max(this.streamPos, this.maxPos);
        this.bitOffset = 0;
    }

    public void flushBefore(long pos) throws IOException {
        long oldPos = this.flushedPos;
        super.flushBefore(pos);
        long flushed = this.flushedPos - oldPos;
        if (flushed > 0L) {
            int len = 512;
            byte[] buf = new byte[len];
            this.cache.seek(oldPos);
            while (flushed > 0L) {
                int l = (int)Math.min(flushed, (long)len);
                this.cache.readFully(buf, 0, l);
                this.stream.write(buf, 0, l);
                flushed -= (long)l;
            }
            this.stream.flush();
        }
    }
}

