/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.rmi.CORBA;

import gnu.CORBA.CDR.HeadlessInput;
import gnu.CORBA.CDR.Vio;
import gnu.CORBA.CDR.gnuRuntime;
import gnu.CORBA.CDR.gnuValueStream;
import gnu.CORBA.OrbFunctional;
import gnu.CORBA.Unexpected;
import gnu.java.lang.CPStringBuilder;
import gnu.javax.rmi.CORBA.CorbaInput;
import gnu.javax.rmi.CORBA.CorbaOutput;
import gnu.javax.rmi.CORBA.DefaultWriteObjectTester;
import gnu.javax.rmi.CORBA.PortableRemoteObjectDelegateImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import org.omg.SendingContext.RunTime;

public class RmiUtilities {
    public static byte VERSION = 1;
    static final int NON_WRITABLE = 136;
    public static final String RMI_STRING_ID = StringValueHelper.id();
    public static final String RMI_CLASS_ID = "RMI:javax.rmi.CORBA.ClassDesc:2BABDA04587ADCCC:CFBF02CF5294176B";
    public static final String RMI_STRING_ARRAY_ID = "RMI:[Ljava.lang.String;:071DA8BE7F971128:A0F0A4387A3BB342";
    static WStringValueHelper wStringValueHelper = new WStringValueHelper();
    WeakHashMap io_format = new WeakHashMap();
    static final java.lang.Object STANDARD = new java.lang.Object();
    static final java.lang.Object CUSTOM_DWO = new java.lang.Object();
    static final java.lang.Object CUSTOM_NO_DWO = new java.lang.Object();
    static final Class[] READ_OBJECT_ARGS = new Class[]{ObjectInputStream.class};
    static final Class[] WRITE_OBJECT_ARGS = new Class[]{ObjectOutputStream.class};
    static final int S_X = 16908034;

    void writeFields(org.omg.CORBA.portable.OutputStream an_output, Serializable object) {
        OutputStream output = (OutputStream)an_output;
        try {
            Class<? extends java.lang.Object> o_class = object.getClass();
            Field[] fields = RmiUtilities.getWritableFields(o_class);
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                Class fc = f.getType();
                java.lang.Object v = f.get(object);
                if (fc == String.class) {
                    output.write_value((Serializable)v, wStringValueHelper);
                } else if (fc == Integer.TYPE) {
                    output.write_long((Integer)v);
                } else if (fc == Long.TYPE) {
                    output.write_longlong(((Number)v).longValue());
                } else if (fc == Double.TYPE) {
                    output.write_double(((Number)v).doubleValue());
                } else if (fc == Float.TYPE) {
                    output.write_float(((Number)v).floatValue());
                } else if (fc == Boolean.TYPE) {
                    output.write_boolean((Boolean)v);
                } else if (fc == Short.TYPE) {
                    output.write_short(((Number)v).shortValue());
                } else if (fc == Byte.TYPE) {
                    output.write_octet(((Number)v).byteValue());
                } else if (fc == Character.TYPE) {
                    output.write_wchar(((Character)v).charValue());
                } else {
                    if (!fc.isInterface() && Remote.class.isAssignableFrom(fc)) {
                        fc = this.getExportedInterface(fc);
                    }
                    this.writeMember(output, v, fc);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            MARSHAL m = new MARSHAL("Cannot write " + object);
            m.minor = 1195573275;
            m.initCause(ex);
            throw m;
        }
    }

    void writeMember(OutputStream output, java.lang.Object object, Class xClass) {
        gnuRuntime g;
        if (output instanceof gnuValueStream && (g = ((gnuValueStream)((java.lang.Object)output)).getRunTime()) != null) {
            g.target = null;
        }
        if (Serializable.class.isAssignableFrom(xClass) || Remote.class.isAssignableFrom(xClass)) {
            if (Object.class.isAssignableFrom(xClass) || Remote.class.isAssignableFrom(xClass)) {
                if (object == null) {
                    output.write_Object(null);
                } else if (this.isTieRequired(object)) {
                    this.exportTie(output, object, xClass);
                } else {
                    this.writeValue(output, (Serializable)object);
                }
            } else {
                output.write_value((Serializable)object, xClass);
            }
        } else {
            MARSHAL m = new MARSHAL(xClass + " is not Serializable");
            m.minor = 1195573276;
            throw m;
        }
    }

    public boolean isTieRequired(java.lang.Object object) {
        return object instanceof Remote && !(object instanceof Stub);
    }

    Class getExportedInterface(java.lang.Object object) throws MARSHAL {
        Class<?> fc = null;
        Class<?>[] interfaces = object.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!Remote.class.equals(interfaces[i]) && Remote.class.isAssignableFrom(interfaces[i])) {
                if (fc == null) {
                    fc = interfaces[i];
                } else {
                    MARSHAL m = new MARSHAL("Both " + fc + " and " + interfaces[i] + " extends Remote");
                    m.minor = 1195573274;
                    throw m;
                }
            }
            ++i;
        }
        if (fc == null) {
            MARSHAL m = new MARSHAL(object.getClass() + " does not implement any interface, derived from Remote");
            m.minor = 1195573274;
            throw m;
        }
        return fc;
    }

    public static long getHashCode(Class c) {
        Class<?> of;
        Class<?> clazz = of = c.isArray() ? c.getComponentType() : null;
        if (c.isArray() && (!Serializable.class.isAssignableFrom(of) || of.isPrimitive() || Remote.class.isAssignableFrom(of))) {
            return 0L;
        }
        if (!Serializable.class.isAssignableFrom(c)) {
            return 0L;
        }
        try {
            MessageDigest shaDigest;
            int writeObjectPresentCode;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            Class superClass = c.getSuperclass();
            if (superClass != null) {
                out.writeLong(RmiUtilities.getHashCode(superClass));
            }
            try {
                c.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                writeObjectPresentCode = 2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                writeObjectPresentCode = 1;
            }
            out.writeInt(writeObjectPresentCode);
            Field[] fields = c.getDeclaredFields();
            Arrays.sort(fields, new Comparator(){

                public int compare(java.lang.Object a, java.lang.Object b) {
                    Field fa = (Field)a;
                    Field fb = (Field)b;
                    return fa.getName().compareTo(fb.getName());
                }
            });
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                if ((f.getModifiers() & 0x88) == 0) {
                    out.writeUTF(f.getName());
                    out.writeUTF(RmiUtilities.getDescriptor(f.getType()));
                }
                ++i;
            }
            out.flush();
            out.close();
            try {
                shaDigest = MessageDigest.getInstance("SHA");
            }
            catch (Exception exception) {
                throw new InternalError("SHA digesting algorithm is not available");
            }
            byte[] sha = shaDigest.digest(bout.toByteArray());
            long hash = 0L;
            int i2 = 0;
            while (i2 < Math.min(8, sha.length)) {
                hash += (long)(sha[i2] & 0xFF) << i2 * 8;
                ++i2;
            }
            return hash;
        }
        catch (IOException ioex) {
            throw new Unexpected(ioex);
        }
    }

    public static String toHex(long l) {
        CPStringBuilder b = new CPStringBuilder();
        b.append(Long.toHexString(l).toUpperCase());
        while (b.length() < 16) {
            b.insert(0, '0');
        }
        return b.toString();
    }

    static String getDescriptor(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return "Z";
        }
        if (type.equals(Byte.TYPE)) {
            return "B";
        }
        if (type.equals(Short.TYPE)) {
            return "S";
        }
        if (type.equals(Character.TYPE)) {
            return "C";
        }
        if (type.equals(Integer.TYPE)) {
            return "I";
        }
        if (type.equals(Long.TYPE)) {
            return "J";
        }
        if (type.equals(Float.TYPE)) {
            return "F";
        }
        if (type.equals(Double.TYPE)) {
            return "D";
        }
        if (type.equals(Void.TYPE)) {
            return "V";
        }
        if (type.isArray()) {
            CPStringBuilder l = new CPStringBuilder("[");
            Class<?> component = type.getComponentType();
            while (component.isArray()) {
                l.append('[');
                component = component.getComponentType();
            }
            l.append('L');
            l.append(component.getName().replace('.', '/'));
            l.append(';');
            return l.toString();
        }
        return "L" + type.getName().replace('.', '/') + ';';
    }

    public static Field[] getWritableFields(Class c) {
        TreeSet<Field> set = new TreeSet<Field>(new Comparator(){

            public int compare(java.lang.Object a, java.lang.Object b) {
                return ((Field)a).getName().compareTo(((Field)b).getName());
            }
        });
        while (!c.equals(java.lang.Object.class)) {
            Field[] f = c.getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if ((f[i].getModifiers() & 0x88) == 0) {
                    f[i].setAccessible(true);
                    set.add(f[i]);
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        Field[] r = new Field[set.size()];
        int p = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            r[p++] = (Field)it.next();
        }
        return r;
    }

    void exportTie(OutputStream output, java.lang.Object implementation, Class interfaceClass) {
        try {
            Tie t = Util.getTie((Remote)implementation);
            if (t instanceof Servant) {
                POA rootPoa = POAHelper.narrow(output.orb().resolve_initial_references("RootPOA"));
                Object co = rootPoa.servant_to_reference((Servant)((java.lang.Object)t));
                Stub stub = (Stub)PortableRemoteObject.narrow(co, interfaceClass);
                this.writeRemoteObject(output, stub);
                if (rootPoa.the_POAManager().get_state().value() == 0) {
                    rootPoa.the_POAManager().activate();
                }
            } else if (t instanceof Object) {
                Object co = (Object)((java.lang.Object)t);
                output.orb().connect(co);
                Stub stub = (Stub)PortableRemoteObject.narrow(co, interfaceClass);
                this.writeRemoteObject(output, stub);
            }
        }
        catch (Exception ex) {
            MARSHAL m = new MARSHAL("Unable to export " + implementation);
            m.minor = 1195573274;
            m.initCause(ex);
            throw m;
        }
    }

    void ensureOrbRunning(OutputStream output) {
        if (output.orb() instanceof OrbFunctional) {
            ((OrbFunctional)output.orb()).ensureRunning();
        }
    }

    public void writeRemoteObject(org.omg.CORBA.portable.OutputStream an_output, java.lang.Object object) {
        OutputStream output = (OutputStream)an_output;
        if (this.isTieRequired(object)) {
            Class fc = this.getExportedInterface(object);
            this.exportTie(output, object, fc);
        } else if (object instanceof Object) {
            this.ensureOrbRunning(output);
            an_output.write_Object((Object)object);
        } else if (object != null && object instanceof Serializable) {
            this.writeFields(an_output, (Serializable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(org.omg.CORBA.portable.OutputStream an_output, Serializable object) {
        OutputStream output = (OutputStream)an_output;
        if (this.isTieRequired(object)) {
            Class fc = this.getExportedInterface(object);
            this.exportTie(output, object, fc);
        } else if (object instanceof Object) {
            this.ensureOrbRunning(output);
            an_output.write_Object((Object)((java.lang.Object)object));
        } else {
            if (object instanceof Externalizable) {
                try {
                    CorbaOutput stream = new CorbaOutput(output, object, this);
                    ((ObjectOutputStream)stream).write(VERSION);
                    ((Externalizable)object).writeExternal(stream);
                }
                catch (Exception ex) {
                    MARSHAL m = new MARSHAL("writeExternal failed");
                    m.minor = 1195573254;
                    m.initCause(ex);
                    throw m;
                }
            }
            if (object instanceof Serializable) {
                java.lang.Object mode = null;
                java.lang.Object m = this.io_format;
                synchronized (m) {
                    mode = this.io_format.get(object.getClass());
                    if (mode == STANDARD) {
                        this.writeFields(an_output, object);
                        return;
                    }
                }
                try {
                    m = object.getClass().getDeclaredMethod("writeObject", WRITE_OBJECT_ARGS);
                    ((AccessibleObject)m).setAccessible(true);
                    try {
                        CorbaOutput stream = new CorbaOutput(output, object, this);
                        ((ObjectOutputStream)stream).write(VERSION);
                        if (mode == CUSTOM_DWO) {
                            ((ObjectOutputStream)stream).write(1);
                        } else if (mode == CUSTOM_NO_DWO) {
                            ((ObjectOutputStream)stream).write(0);
                        } else {
                            DefaultWriteObjectTester tester = new DefaultWriteObjectTester(object);
                            ((Method)m).invoke(object, tester);
                            WeakHashMap weakHashMap = this.io_format;
                            synchronized (weakHashMap) {
                                this.io_format.put(object.getClass(), tester.dwo_called ? CUSTOM_DWO : CUSTOM_NO_DWO);
                                ((ObjectOutputStream)stream).write(tester.dwo_called ? 1 : 0);
                            }
                        }
                        ((Method)m).invoke(object, stream);
                        ((ObjectOutputStream)stream).flush();
                    }
                    catch (Exception ex) {
                        MARSHAL mx = new MARSHAL(String.valueOf(object.getClass().getName()) + ".writeObject failed");
                        mx.initCause(ex);
                        throw mx;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.writeFields(an_output, object);
                    WeakHashMap weakHashMap = this.io_format;
                    synchronized (weakHashMap) {
                        this.io_format.put(object.getClass(), STANDARD);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable readValue(org.omg.CORBA.portable.InputStream in, int offset, Class clz, String repositoryID, RunTime sender) {
        java.lang.Object m;
        if (in instanceof HeadlessInput) {
            ((HeadlessInput)in).subsequentCalls = true;
        }
        gnuRuntime g = null;
        Serializable object = null;
        try {
            g = (gnuRuntime)sender;
            if (sender != null) {
                object = g.target;
            }
        }
        catch (ClassCastException classCastException) {
            g = null;
        }
        InputStream input = (InputStream)in;
        if (Remote.class.isAssignableFrom(clz) || ValueBase.class.isAssignableFrom(clz)) {
            if (clz.isInterface()) {
                try {
                    clz = Util.loadClass(PortableRemoteObjectDelegateImpl.getStubClassName(clz.getName()), null, clz.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    MARSHAL m2 = new MARSHAL("Cannot get stub from interface " + clz.getClass().getName());
                    m2.minor = 1195573274;
                    m2.initCause(e);
                    throw m2;
                }
            }
            if (ObjectImpl.class.isAssignableFrom(clz)) {
                Object ro = input.read_Object();
                ObjectImpl obj = (ObjectImpl)ro;
                if (obj == null) {
                    return null;
                }
                Delegate delegate = obj._get_delegate();
                object = this.instantiate(offset, clz, g);
                ((ObjectImpl)((java.lang.Object)object))._set_delegate(delegate);
            }
        } else if (Object.class.isAssignableFrom(clz)) {
            object = (Serializable)((java.lang.Object)input.read_Object());
        }
        if (object == null) {
            object = this.instantiate(offset, clz, g);
        }
        if (object instanceof ObjectImpl) {
            return object;
        }
        if (object instanceof Externalizable) {
            try {
                CorbaInput stream = new CorbaInput(input, object, this, offset, repositoryID, g);
                byte version = stream.readByte();
                if (version != 1) {
                    throw new MARSHAL("Unsuported RMI-IIOP version " + version);
                }
                ((Externalizable)object).readExternal(stream);
            }
            catch (Exception ex) {
                m = new MARSHAL("readExternal failed");
                ((Throwable)m).initCause(ex);
                throw m;
            }
        }
        java.lang.Object mode = null;
        m = this.io_format;
        synchronized (m) {
            mode = this.io_format.get(object.getClass());
        }
        if (mode == STANDARD) {
            this.readFields(offset, repositoryID, object, input, g);
        } else {
            try {
                m = object.getClass().getDeclaredMethod("readObject", READ_OBJECT_ARGS);
                try {
                    ((AccessibleObject)m).setAccessible(true);
                    CorbaInput stream = new CorbaInput(input, object, this, offset, repositoryID, g);
                    byte version = stream.readByte();
                    if (version != 1) {
                        throw new MARSHAL("Unsuported RMI-IIOP version " + version);
                    }
                    boolean dwo = stream.readByte() != 0;
                    ((Method)m).invoke(object, stream);
                    WeakHashMap weakHashMap = this.io_format;
                    synchronized (weakHashMap) {
                        this.io_format.put(object.getClass(), dwo ? CUSTOM_DWO : CUSTOM_NO_DWO);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MARSHAL mx = new MARSHAL(String.valueOf(object.getClass().getName()) + ".readObject failed");
                    mx.initCause(ex);
                    throw mx;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                WeakHashMap weakHashMap = this.io_format;
                synchronized (weakHashMap) {
                    this.io_format.put(object.getClass(), STANDARD);
                    this.readFields(offset, repositoryID, object, input, g);
                }
            }
        }
        return object;
    }

    Serializable instantiate(int offset, Class clz, gnuRuntime g) throws MARSHAL {
        Serializable object;
        try {
            object = (Serializable)Vio.instantiateAnyWay(clz);
            g.objectWritten(object, offset);
        }
        catch (Exception e) {
            MARSHAL m = new MARSHAL("Unable to instantiate " + clz);
            m.minor = 1195573264;
            m.initCause(e);
            throw m;
        }
        return object;
    }

    void readFields(int offset, String repositoryID, Serializable object, InputStream input, gnuRuntime r) throws MARSHAL {
        Field f = null;
        Class<? extends java.lang.Object> o_class = object.getClass();
        try {
            Field[] fields = RmiUtilities.getWritableFields(o_class);
            int i = 0;
            while (i < fields.length) {
                Class<?> fc;
                if (input instanceof HeadlessInput) {
                    ((HeadlessInput)input).subsequentCalls = true;
                }
                Serializable v = (fc = (f = fields[i]).getType()) == String.class ? input.read_value(wStringValueHelper) : (fc == Integer.TYPE ? new Integer(input.read_long()) : (fc == Long.TYPE ? new Long(input.read_longlong()) : (fc == Double.TYPE ? new Double(input.read_double()) : (fc == Float.TYPE ? new Float(input.read_float()) : (fc == Boolean.TYPE ? (input.read_boolean() ? Boolean.TRUE : Boolean.FALSE) : (fc == Short.TYPE ? new Short(input.read_short()) : (fc == Byte.TYPE ? new Byte(input.read_octet()) : (fc == Character.TYPE ? new Character(input.read_char()) : (Object.class.isAssignableFrom(fc) || Remote.class.isAssignableFrom(fc) ? this.readValue(input, offset, fc, null, r) : Vio.read((org.omg.CORBA.portable.InputStream)input, fc))))))))));
                f.set(object, v);
                ++i;
            }
        }
        catch (Exception ex) {
            MARSHAL m = new MARSHAL("Cannot read " + o_class.getName() + " field " + f);
            m.initCause(ex);
            m.minor = 1195573275;
            throw m;
        }
    }
}

