<?php
/**
 * @file
 * Template for a VALARM file.
 */
/**
 * $alarm
 *   An array with the following information about each alarm:
 *
 *   $alarm['action'] - the action to take, either 'DISPLAY' or 'EMAIL'
 *   $alarm['trigger'] - the time period for the trigger, like -P2D.
 *   $alarm['repeat'] - the number of times to repeat the alarm.
 *   $alarm['duration'] - the time period between repeated alarms, like P1D.
 *   $alarm['description'] - the description of the alarm.
 *
 *   An email alarm should have two additional parts:
 *   $alarm['email'] - a comma-separated list of email recipients.
 *   $alarm['summary'] - the subject of the alarm email.
 *
 * If you are editing this file, remember that all output lines generated by it
 * must end with DOS-style \r\n line endings, and not Unix-style \n, in order to
 * comply with the iCal spec: http://tools.ietf.org/html/rfc5545#section-3.1.
 */
print "BEGIN:VALARM\r\n";
print "ACTION:" . $alarm['action']  . "\r\n";
if (!empty($alarm['trigger'])):
  print "TRIGGER:" . $alarm['trigger']  . "\r\n";
endif;
if (!empty($alarm['repeat'])):
  print "REPEAT:" . $alarm['repeat']  . "\r\n";
endif;
if (!empty($alarm['duration'])):
  print "DURATION:" . $alarm['duration']  . "\r\n";
endif;
if ($alarm['action'] == 'EMAIL'):
  print "ATTENDEE:MAILTO:" . $alarm['email']  . "\r\n";
  print "SUMMARY:" . $alarm['summary']  . "\r\n";
endif;
print "DESCRIPTION:" . $alarm['description']  . "\r\n";
print "END:VALARM\r\n";
