# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

from elisa.plugins.pigment.widgets.box import VBox, HBox


class PanelScreen(VBox):
    
    """
    A generic screen widget that presents a header bar and two panels.
    """

    def create_widgets(self):
        # Overridden from mother class.
        self.header = self.create_header()
        self.pack_start(self.header)
        self.contents = HBox()
        self.contents.visible = True
        self.pack_start(self.contents, expand=True)
        self.left_panel = self.create_left_panel()
        self.contents.pack_start(self.left_panel)
        self.right_panel = self.create_right_panel()
        self.contents.pack_start(self.right_panel, expand=True)
        self.set_focus_proxy(self.contents)

    def create_header(self):
        """
        Create the header widget.

        This method must be overridden in subclasses.
        It is responsible for setting the visibility of the widget.

        @return: the header widget
        @rtype:  L{elisa.plugins.pigment.widgets.widget.Widget}
        """
        raise NotImplementedError()

    def create_left_panel(self):
        """
        Create the left panel widget and all its contents.

        This method must be overridden in subclasses.
        It is responsible for setting the visibility of the widget.

        @return: the left panel widget
        @rtype:  L{elisa.plugins.pigment.widgets.widget.Widget}
        """
        raise NotImplementedError()

    def create_right_panel(self):
        """
        Create the right panel widget and all its contents.

        This method must be overridden in subclasses.
        It is responsible for setting the visibility of the widget.

        @return: the left panel widget
        @rtype:  L{elisa.plugins.pigment.widgets.widget.Widget}
        """
        raise NotImplementedError()
