# -*- coding: utf-8 -*-
"""
pygments.lexers._stan_builtins
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This file contains the names of functions for Stan used by
``pygments.lexers.math.StanLexer.

:copyright: Copyright 2013 by the Pygments team, see AUTHORS.
:license: BSD, see LICENSE for details.
"""

KEYWORDS = ['else', 'for', 'if', 'in', 'lower', 'lp__', 'print', 'upper', 'while']

TYPES = [   'corr_matrix',
    'cov_matrix',
    'int',
    'matrix',
    'ordered',
    'positive_ordered',
    'real',
    'row_vector',
    'simplex',
    'unit_vector',
    'vector']

FUNCTIONS = [   'Phi',
    'Phi_approx',
    'abs',
    'acos',
    'acosh',
    'asin',
    'asinh',
    'atan',
    'atan2',
    'atanh',
    'bernoulli_cdf',
    'bernoulli_log',
    'bernoulli_logit_log',
    'bernoulli_rng',
    'beta_binomial_cdf',
    'beta_binomial_log',
    'beta_binomial_rng',
    'beta_cdf',
    'beta_log',
    'beta_rng',
    'binary_log_loss',
    'binomial_cdf',
    'binomial_coefficient_log',
    'binomial_log',
    'binomial_logit_log',
    'binomial_rng',
    'block',
    'categorical_log',
    'categorical_rng',
    'cauchy_cdf',
    'cauchy_log',
    'cauchy_rng',
    'cbrt',
    'ceil',
    'chi_square_log',
    'chi_square_rng',
    'cholesky_decompose',
    'col',
    'cols',
    'cos',
    'cosh',
    'crossprod',
    'cumulative_sum',
    'determinant',
    'diag_matrix',
    'diag_post_multiply',
    'diag_pre_multiply',
    'diagonal',
    'dims',
    'dirichlet_log',
    'dirichlet_rng',
    'dot_product',
    'dot_self',
    'double_exponential_log',
    'double_exponential_rng',
    'e',
    'eigenvalues_sym',
    'eigenvectors_sym',
    'epsilon',
    'erf',
    'erfc',
    'exp',
    'exp2',
    'exp_mod_normal_cdf',
    'exp_mod_normal_log',
    'exp_mod_normal_rng',
    'expm1',
    'exponential_cdf',
    'exponential_log',
    'exponential_rng',
    'fabs',
    'fdim',
    'floor',
    'fma',
    'fmax',
    'fmin',
    'fmod',
    'gamma_log',
    'gamma_rng',
    'gumbel_cdf',
    'gumbel_log',
    'gumbel_rng',
    'hypergeometric_log',
    'hypergeometric_rng',
    'hypot',
    'if_else',
    'int_step',
    'inv_chi_square_cdf',
    'inv_chi_square_log',
    'inv_chi_square_rng',
    'inv_cloglog',
    'inv_gamma_cdf',
    'inv_gamma_log',
    'inv_gamma_rng',
    'inv_logit',
    'inv_wishart_log',
    'inv_wishart_rng',
    'inverse',
    'lbeta',
    'lgamma',
    'lkj_corr_cholesky_log',
    'lkj_corr_cholesky_rng',
    'lkj_corr_log',
    'lkj_corr_rng',
    'lkj_cov_log',
    'lmgamma',
    'log',
    'log10',
    'log1m',
    'log1m_inv_logit',
    'log1p',
    'log1p_exp',
    'log2',
    'log_determinant',
    'log_inv_logit',
    'log_sum_exp',
    'logistic_cdf',
    'logistic_log',
    'logistic_rng',
    'logit',
    'lognormal_cdf',
    'lognormal_log',
    'lognormal_rng',
    'max',
    'mdivide_left_tri_low',
    'mdivide_right_tri_low',
    'mean',
    'min',
    'multi_normal_cholesky_log',
    'multi_normal_log',
    'multi_normal_prec_log',
    'multi_normal_rng',
    'multi_student_t_log',
    'multi_student_t_rng',
    'multinomial_cdf',
    'multinomial_log',
    'multinomial_rng',
    'multiply_log',
    'multiply_lower_tri_self_transpose',
    'neg_binomial_cdf',
    'neg_binomial_log',
    'neg_binomial_rng',
    'negative_epsilon',
    'negative_infinity',
    'normal_cdf',
    'normal_log',
    'normal_rng',
    'not_a_number',
    'ordered_logistic_log',
    'ordered_logistic_rng',
    'owens_t',
    'pareto_cdf',
    'pareto_log',
    'pareto_rng',
    'pi',
    'poisson_cdf',
    'poisson_log',
    'poisson_log_log',
    'poisson_rng',
    'positive_infinity',
    'pow',
    'prod',
    'rep_array',
    'rep_matrix',
    'rep_row_vector',
    'rep_vector',
    'round',
    'row',
    'rows',
    'scaled_inv_chi_square_cdf',
    'scaled_inv_chi_square_log',
    'scaled_inv_chi_square_rng',
    'sd',
    'sin',
    'singular_values',
    'sinh',
    'size',
    'skew_normal_cdf',
    'skew_normal_log',
    'skew_normal_rng',
    'softmax',
    'sqrt',
    'sqrt2',
    'square',
    'step',
    'student_t_cdf',
    'student_t_log',
    'student_t_rng',
    'sum',
    'tan',
    'tanh',
    'tcrossprod',
    'tgamma',
    'trace',
    'trunc',
    'uniform_log',
    'uniform_rng',
    'variance',
    'weibull_cdf',
    'weibull_log',
    'weibull_rng',
    'wishart_log',
    'wishart_rng']

DISTRIBUTIONS = [   'bernoulli',
    'bernoulli_logit',
    'beta',
    'beta_binomial',
    'binomial',
    'binomial_coefficient',
    'binomial_logit',
    'categorical',
    'cauchy',
    'chi_square',
    'dirichlet',
    'double_exponential',
    'exp_mod_normal',
    'exponential',
    'gamma',
    'gumbel',
    'hypergeometric',
    'inv_chi_square',
    'inv_gamma',
    'inv_wishart',
    'lkj_corr',
    'lkj_corr_cholesky',
    'lkj_cov',
    'logistic',
    'lognormal',
    'multi_normal',
    'multi_normal_cholesky',
    'multi_normal_prec',
    'multi_student_t',
    'multinomial',
    'multiply',
    'neg_binomial',
    'normal',
    'ordered_logistic',
    'pareto',
    'poisson',
    'poisson_log',
    'scaled_inv_chi_square',
    'skew_normal',
    'student_t',
    'uniform',
    'weibull',
    'wishart']

RESERVED = [   'alignas',
    'alignof',
    'and',
    'and_eq',
    'asm',
    'auto',
    'bitand',
    'bitor',
    'bool',
    'break',
    'case',
    'catch',
    'char',
    'char16_t',
    'char32_t',
    'class',
    'compl',
    'const',
    'const_cast',
    'constexpr',
    'continue',
    'decltype',
    'default',
    'delete',
    'do',
    'double',
    'dynamic_cast',
    'enum',
    'explicit',
    'export',
    'extern',
    'false',
    'false',
    'float',
    'friend',
    'goto',
    'inline',
    'int',
    'long',
    'mutable',
    'namespace',
    'new',
    'noexcept',
    'not',
    'not_eq',
    'nullptr',
    'operator',
    'or',
    'or_eq',
    'private',
    'protected',
    'public',
    'register',
    'reinterpret_cast',
    'repeat',
    'return',
    'short',
    'signed',
    'sizeof',
    'static',
    'static_assert',
    'static_cast',
    'struct',
    'switch',
    'template',
    'then',
    'this',
    'thread_local',
    'throw',
    'true',
    'true',
    'try',
    'typedef',
    'typeid',
    'typename',
    'union',
    'unsigned',
    'until',
    'using',
    'virtual',
    'void',
    'volatile',
    'wchar_t',
    'xor',
    'xor_eq']

