The SL Module - Statless request handling

Bogdan Iancu

   FhG FOKUS

Daniel-Constantin Mierla

   asipto.com

   Copyright  2003 FhG FOKUS
     __________________________________________________________________

   List of Examples

   1. default_code example
   2. default_reason example
   3. bind_tm example
   4. sl_send_reply usage
   5. send_reply usage
   6. sl_reply_error usage
   7. send_reply usage

1. Overview

   The SL module allows the SIP server to act as a stateless UA server and
   generate replies to SIP requests without keeping state. That is
   beneficial in many scenarios, in which you wish not to burden server's
   memory and scale well.

   The SL module needs to filter ACKs sent after a local stateless reply
   to an INVITE was generated. To recognize such ACKs, ser adds a special
   "signature" in to-tags. This signature is sought for in incoming ACKs,
   and if included, the ACKs are absorbed.

   To speed up the filtering process, the module uses a timeout mechanism.
   When a reply is sent, a timer us set. As long as the timer is valid,
   the incoming ACK requests will be checked using TO tag value. Once the
   timer expires, all the ACK messages are let through - a long time
   passed till it sent a reply, so it does not expect any ACK that have to
   be blocked.

   The ACK filtering may fail in some rare cases. If you think these
   matter to you, better use stateful processing (TM module) for INVITE
   processing. Particularly, the problem happens when a UA sends an INVITE
   which already has a to-tag in it (e.g., a re-INVITE) and the server
   want to reply to it. Then, it will keep the current to-tag, which will
   be mirrored in ACK. SER will not see its signature and forward the ACK
   downstream. Caused harm is not bad--just a useless ACK is forwarded.

2. Parameters

   2.1. default_code (int)
   2.2. default_reason (str)
   2.3. bind_tm (int)

2.1. default_code (int)

   Default reply status code.

   Default value is 500.

   Example 1. default_code example
...
modparam("sl", "default_code", 505)
...

2.2. default_reason (str)

   Default reply reason phrase.

   Default value is 'Internal Server Error'.

   Example 2. default_reason example
...
modparam("sl", "default_reason", "Server Error")
...

2.3. bind_tm (int)

   Controls if SL module should attempt to bind to TM module in order to
   send stateful reply when the transaction is created.

   Default value is 1 (enabled).

   Example 3. bind_tm example
...
modparam("sl", "bind_tm", 0)  # feature disabled
...

3. Functions

   3.1. sl_send_reply(code, reason)
   3.2. send_reply(code, reason)
   3.3. sl_reply_error()
   3.4. sl_forward _reply([ code, [ reason ] ])

3.1. sl_send_reply(code, reason)

   For the current request, a reply is sent back having the given code and
   text reason. The reply is sent stateless, totally independent of the
   Transaction module and with no retransmission for the INVITE's replies.

   Meaning of the parameters is as follows:
     * code - Return code.
     * reason - Reason phrase.

   Example 4. sl_send_reply usage
...
sl_send_reply("404", "Not found");
...

3.2. send_reply(code, reason)

   For the current request, a reply is sent back having the given code and
   text reason. The reply is sent stateful or stateless, depending of the
   TM module: if a transaction exists for the current request, then the
   reply is sent statefully, otherwise stateless.

   Meaning of the parameters is as follows:
     * code - Return code.
     * reason - Reason phrase.

   This function can be used from REQUEST_ROUTE, FAILURE_ROUTE,
   BRANCH_ROUTE.

   Example 5. send_reply usage
...
send_reply("404", "Not found");
...
send_reply("403", "Invalid user - $fU");
...

3.3. sl_reply_error()

   Sends back an error reply describing the nature of the last internal
   error. Usually this function should be used after a script function
   that returned an error code.

   Example 6. sl_reply_error usage
...
sl_reply_error();
...

3.4. sl_forward _reply([ code, [ reason ] ])

   Forward statelessy the current received SIP reply, with the option to
   change the status code and reason text. The new code has to be in the
   same class. The received reply is forwarded as well by core when the
   config execution ended, unless it is dropped from config.

   Meaning of the parameters is as follows:
     * code - Status code.
     * reason - Reason phrase.

   This function can be used from ONREPLY_ROUTE.

   Example 7. send_reply usage
...
if(status=="408")
    sl_forward_reply("404", "Not found");
...

4. Statistics

   4.1. 1xx_replies
   4.2. 200_replies
   4.3. 202_replies
   4.4. 2xx_replies
   4.5. 300_replies
   4.6. 301_replies
   4.7. 302_replies
   4.8. 3xx_replies
   4.9. 400_replies
   4.10. 401_replies
   4.11. 403_replies
   4.12. 404_replies
   4.13. 407_replies
   4.14. 408_replies
   4.15. 483_replies
   4.16. 4xx_replies
   4.17. 500_replies
   4.18. 5xx_replies
   4.19. 6xx_replies
   4.20. xxx_replies
   4.21. sent_replies
   4.22. sent_err_replies
   4.23. failures
   4.24. received_ACKs

4.1. 1xx_replies

   Number of 1xx replies.

4.2. 200_replies

   Number of 201 replies.

4.3. 202_replies

   Number of 202 replies.

4.4. 2xx_replies

   Number of 2xx replies.

4.5. 300_replies

   Number of 300 replies.

4.6. 301_replies

   Number of 301 replies.

4.7. 302_replies

   Number of 302 replies.

4.8. 3xx_replies

   Number of 3xx replies.

4.9. 400_replies

   Number of 400 replies.

4.10. 401_replies

   Number of 401 replies.

4.11. 403_replies

   Number of 403 replies.

4.12. 404_replies

   Number of 404 replies.

4.13. 407_replies

   Number of 407 replies.

4.14. 408_replies

   Number of 408 replies.

4.15. 483_replies

   Number of 483 replies.

4.16. 4xx_replies

   Number of 4xx replies.

4.17. 500_replies

   Number of 500 replies.

4.18. 5xx_replies

   Number of 5xx replies.

4.19. 6xx_replies

   Number of 6xx replies.

4.20. xxx_replies

   Number of replies whose code don't match any above.

4.21. sent_replies

   Number of all sent replies.

4.22. sent_err_replies

   Number of sent error replies.

4.23. failures

   Number of failures.

4.24. received_ACKs

   Number of received ACKs filtered by SL module.
