#
#  Copyright (c) 1994-1998 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 

# globals
#
set Dialog(title) {User Input Dialog}
set Dialog(msgFont) {*helvetica*bold-r*14*}

proc dialog_toplevel { w } {

    global Dialog
    toplevel $w

    #
    # Message and Input area
    #
    frame $w.top -relief flat -border 8
    entry $w.top.input -border 1
    message $w.top.msg -justify left -anchor w -aspect 2000 \
	-text $Dialog(message) -font $Dialog(msgFont)

    #
    # Button area
    #
    frame $w.bot -relief groove -border 2

    pack $w.top.msg -side top -fill x -expand 1
    pack $w.top.input -side top -fill x -expand 1
    pack $w.top -side top -fill both -expand 1
    pack $w.bot -side top -fill both -expand 1

    #
    # Default button... "APPLY"
    #
    frame $w.bot.0 -relief sunken -border 1
    pack $w.bot.0 -side left -expand 1 -padx 12 -pady 12
    button $w.bot.0.button -text "APPLY" -command "dialog_apply $w.top.input"
    pack $w.bot.0.button -expand 1 -padx 6 -pady 6

    #
    # Cancel button
    #
    button $w.bot.1 -text "CANCEL" -command "dialog_cancel $w"
    pack $w.bot.1 -side left -expand 1 -padx 20

    #
    # Bindings
    #
    bind $w.top.input <Return> {dialog_apply %W}
    focus $w.top.input

    wm title $w $Dialog(title)
    wm minsize $w 300 150
    wm geometry $w 300x150

}

proc dialog_apply { w } {
    global Dialog
    set Dialog(value) [$w get]
    if {$Dialog(standalone)} {
	puts stdout $Dialog(value)
	exit 0
    }
    destroy [winfo toplevel $w]
}

proc dialog_cancel { w } {
    global Dialog
    destroy [winfo toplevel $w]
    if {$Dialog(standalone)} {
	exit 0
    }
}

proc dialog_getOption { name } {

    global Dialog 
    
    set largs [llength $Dialog(args)]
    for {set x 0} {$x < $largs} {incr x} {
	set opt [lindex $Dialog(args) $x]
	if {$opt == "-$name"} {
	    switch -exact -- $opt -standalone {
		return 1
	    } default {
		incr x
		return [lindex $Dialog(args) $x]
	    }
	}
    }

    # If here, we didn't find anything
    switch $name {
	standalone {return 0}
	message {return {}} 
	default {}
    }
}

proc dialog_main { args } {
    global Dialog
    set Dialog(args) $args
    set Dialog(value) {}
    set Dialog(standalone) [dialog_getOption standalone] 
    set Dialog(message) [dialog_getOption message]
    if {$Dialog(standalone)} {
	wm withdraw .
    }
    dialog_toplevel .entrydialog
    wm protocol .entrydialog WM_DELETE_WINDOW "destroy .entrydialog"
    if {! $Dialog(standalone)} {
	tkwait window .entrydialog
	return $Dialog(value)
    }
}

if {[string match "entryDialog*" [winfo name .]]} {
    after 0 dialog_main -message \{Enter value\} -standalone
}
