/* packagekit-glib2.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Pk", gir_namespace = "PackageKitGlib", gir_version = "1.0", lower_case_cprefix = "pk_")]
namespace Pk {
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_catalog_get_type ()")]
	public class Catalog : GLib.Object {
		[CCode (has_construct_function = false)]
		public Catalog ();
		public async void lookup_async (string filename, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public static void test (void* user_data);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_category_get_type ()")]
	public class Category : Pk.Source {
		[CCode (has_construct_function = false)]
		public Category ();
		public unowned string get_icon ();
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned string get_parent_id ();
		public unowned string get_summary ();
		public void set_icon (string icon);
		public void set_id (string cat_id);
		public void set_name (string name);
		public void set_parent_id (string parent_id);
		public void set_summary (string summary);
		[NoAccessorMethod]
		public string cat_id { owned get; set; }
		public string icon { get; set; }
		public string name { get; set; }
		public string parent_id { get; set; }
		public string summary { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_client_get_type ()")]
	public class Client : GLib.Object {
		[CCode (has_construct_function = false)]
		public Client ();
		public Pk.Results accept_eula (string eula_id, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void accept_eula_async (string eula_id, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results adopt (string transaction_id, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void adopt_async (string transaction_id, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		[NoWrapper]
		public virtual void changed ();
		public Pk.Results download_packages ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, string directory, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void download_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, string directory, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results generic_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool get_background ();
		public uint get_cache_age ();
		public Pk.Results get_categories (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_categories_async (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_depends (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_depends_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_details ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_details_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_distro_upgrades (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_distro_upgrades_async (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_files ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_files_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public bool get_idle ();
		public bool get_interactive ();
		public unowned string get_locale ();
		public Pk.Results get_old_transactions (uint number, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_old_transactions_async (uint number, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_packages (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_packages_async (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Progress get_progress (string transaction_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async Pk.Progress get_progress_async (string transaction_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public Pk.Results get_repo_list (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_repo_list_async (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_requires (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_requires_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_update_detail ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_update_detail_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_updates (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_updates_async (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results install_files (Pk.Bitfield transaction_flags, [CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void install_files_async (Pk.Bitfield transaction_flags, [CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results install_packages (Pk.Bitfield transaction_flags, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void install_packages_async (Pk.Bitfield transaction_flags, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results install_signature (Pk.SigType type, string key_id, string package_id, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void install_signature_async (Pk.SigType type, string key_id, string package_id, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results refresh_cache (bool force, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void refresh_cache_async (bool force, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results remove_packages (Pk.Bitfield transaction_flags, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool allow_deps, bool autoremove, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void remove_packages_async (Pk.Bitfield transaction_flags, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool allow_deps, bool autoremove, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results repair_system (Pk.Bitfield transaction_flags, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void repair_system_async (Pk.Bitfield transaction_flags, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results repo_enable (string repo_id, bool enabled, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void repo_enable_async (string repo_id, bool enabled, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results repo_set_data (string repo_id, string parameter, string value, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void repo_set_data_async (string repo_id, string parameter, string value, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results resolve (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] packages, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void resolve_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] packages, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results search_details (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void search_details_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results search_files (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void search_files_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results search_groups (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void search_groups_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results search_names (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void search_names_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public void set_background (bool background);
		public void set_cache_age (uint cache_age);
		public void set_interactive (bool interactive);
		public void set_locale (string locale);
		public static void test (void* user_data);
		public Pk.Results update_packages (Pk.Bitfield transaction_flags, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void update_packages_async (Pk.Bitfield transaction_flags, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results upgrade_system (string distro_id, Pk.UpgradeKind upgrade_kind, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void upgrade_system_async (string distro_id, Pk.UpgradeKind upgrade_kind, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results what_provides (Pk.Bitfield filters, Pk.Provides provides, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void what_provides_async (Pk.Bitfield filters, Pk.Provides provides, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public bool background { get; set; }
		public uint cache_age { get; set; }
		public bool idle { get; }
		public bool interactive { get; set; }
		public string locale { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_client_helper_get_type ()")]
	public class ClientHelper : GLib.Object {
		[CCode (has_construct_function = false)]
		public ClientHelper ();
		public bool start (string socket_filename, string argv, string envp) throws GLib.Error;
		public bool stop () throws GLib.Error;
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_control_get_type ()")]
	public class Control : GLib.Object {
		[CCode (has_construct_function = false)]
		public Control ();
		public async Pk.Authorize can_authorize_async (string action_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual void connection_changed (bool connected);
		public async string get_daemon_state_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async Pk.Network get_network_state_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_properties (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool get_properties_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async string get_tid_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async uint get_time_since_action_async (Pk.Role role, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_transaction_list (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public async string[] get_transaction_list_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual void network_state_changed ();
		public bool set_proxy (string proxy_http, string proxy_ftp, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_proxy2 (string proxy_http, string proxy_https, string proxy_ftp, string proxy_socks, string no_proxy, string pac, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async void set_proxy2_async (string proxy_http, string proxy_https, string proxy_ftp, string proxy_socks, string no_proxy, string pac, GLib.Cancellable? cancellable);
		public async bool set_proxy_async (string proxy_http, string proxy_ftp, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool suggest_daemon_quit (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool suggest_daemon_quit_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public static void test (void* user_data);
		[NoAccessorMethod]
		public string backend_author { owned get; set; }
		[NoAccessorMethod]
		public string backend_description { owned get; set; }
		[NoAccessorMethod]
		public string backend_name { owned get; set; }
		[NoAccessorMethod]
		public bool connected { get; set; }
		[NoAccessorMethod]
		public string distro_id { owned get; set; }
		[NoAccessorMethod]
		public uint64 filters { get; set; }
		[NoAccessorMethod]
		public uint64 groups { get; set; }
		[NoAccessorMethod]
		public virtual bool locked { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] mime_types { owned get; set; }
		[NoAccessorMethod]
		public uint network_state { get; set; }
		[NoAccessorMethod]
		public uint64 provides { get; set; }
		[NoAccessorMethod]
		public uint64 roles { get; set; }
		[NoAccessorMethod]
		public uint version_major { get; }
		[NoAccessorMethod]
		public uint version_micro { get; }
		[NoAccessorMethod]
		public uint version_minor { get; }
		public virtual signal void repo_list_changed ();
		public virtual signal void restart_schedule ();
		public virtual signal void transaction_list_changed ([CCode (array_length = false, array_null_terminated = true)] string[] transaction_ids);
		public virtual signal void updates_changed ();
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_desktop_get_type ()")]
	public class Desktop : GLib.Object {
		[CCode (has_construct_function = false)]
		public Desktop ();
		public string get_package_for_file (string filename) throws GLib.Error;
		public bool open_database () throws GLib.Error;
		public static void test (void* user_data);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_details_get_type ()")]
	public class Details : Pk.Source {
		[CCode (has_construct_function = false)]
		public Details ();
		public unowned string get_description ();
		public Pk.Group get_group ();
		public unowned string get_license ();
		public unowned string get_package_id ();
		public uint64 get_size ();
		public unowned string get_url ();
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public uint group { get; set; }
		[NoAccessorMethod]
		public string license { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public uint64 size { get; set; }
		[NoAccessorMethod]
		public string url { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_distro_upgrade_get_type ()")]
	public class DistroUpgrade : Pk.Source {
		[CCode (has_construct_function = false)]
		public DistroUpgrade ();
		public unowned string get_id ();
		public Pk.DistroUpgradeEnum get_state ();
		public unowned string get_summary ();
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public uint state { get; set; }
		[NoAccessorMethod]
		public string summary { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_error_get_type ()")]
	public class Error : Pk.Source {
		[CCode (has_construct_function = false)]
		public Error ();
		public Pk.ErrorEnum get_code ();
		public unowned string get_details ();
		[NoAccessorMethod]
		public uint code { get; set; }
		[NoAccessorMethod]
		public string details { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_eula_required_get_type ()")]
	public class EulaRequired : Pk.Source {
		[CCode (has_construct_function = false)]
		public EulaRequired ();
		[NoAccessorMethod]
		public string eula_id { owned get; set; }
		[NoAccessorMethod]
		public string license_agreement { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public string vendor_name { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_files_get_type ()")]
	public class Files : Pk.Source {
		[CCode (has_construct_function = false)]
		public Files ();
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] files { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_item_progress_get_type ()")]
	public class ItemProgress : Pk.Source {
		[CCode (has_construct_function = false)]
		public ItemProgress ();
		public unowned string get_package_id ();
		public uint get_percentage ();
		public Pk.Status get_status ();
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public uint percentage { get; set; }
		[NoAccessorMethod]
		public uint status { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_media_change_required_get_type ()")]
	public class MediaChangeRequired : Pk.Source {
		[CCode (has_construct_function = false)]
		public MediaChangeRequired ();
		[NoAccessorMethod]
		public string media_id { owned get; set; }
		[NoAccessorMethod]
		public string media_text { owned get; set; }
		[NoAccessorMethod]
		public uint media_type { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_message_get_type ()")]
	public class Message : Pk.Source {
		[CCode (has_construct_function = false)]
		public Message ();
		public unowned string get_details ();
		public Pk.MessageEnum get_kind ();
		[NoAccessorMethod]
		public string details { owned get; set; }
		[NoAccessorMethod]
		public uint type { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_package_get_type ()")]
	public class Package : Pk.Source {
		[CCode (has_construct_function = false)]
		public Package ();
		public bool equal (Pk.Package package2);
		public bool equal_id (Pk.Package package2);
		public unowned string get_arch ();
		public unowned string get_data ();
		public unowned string get_id ();
		public Pk.Info get_info ();
		public unowned string get_name ();
		public unowned string get_summary ();
		public unowned string get_version ();
		public static string id_build (string name, string version, string arch, string data);
		public static bool id_check (string package_id);
		public static bool id_equal_fuzzy_arch (string package_id1, string package_id2);
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] id_split (string package_id);
		public static void id_test (void* user_data);
		public static string id_to_printable (string package_id);
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] ids_add_id (string package_ids, string package_id);
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] ids_add_ids (string package_ids, string package_ids_new);
		public static bool ids_check (string package_ids);
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] ids_from_id (string package_id);
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] ids_from_string (string package_id);
		public static bool ids_present_id (string package_ids, string package_id);
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] ids_remove_id (string package_ids, string package_id);
		public static void ids_test (void* user_data);
		public static string ids_to_string (string package_ids);
		public bool parse (string data) throws GLib.Error;
		public void print ();
		public bool set_id (string package_id) throws GLib.Error;
		public static void test (void* user_data);
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public uint group { get; set; }
		[NoAccessorMethod]
		public uint info { get; set; }
		[NoAccessorMethod]
		public string license { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; }
		[NoAccessorMethod]
		public uint64 size { get; set; }
		[NoAccessorMethod]
		public string summary { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] update_bugzilla_urls { owned get; set; }
		[NoAccessorMethod]
		public string update_changelog { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] update_cve_urls { owned get; set; }
		[NoAccessorMethod]
		public string update_issued { owned get; set; }
		[NoAccessorMethod]
		public string update_obsoletes { owned get; set; }
		[NoAccessorMethod]
		public uint update_restart { get; set; }
		[NoAccessorMethod]
		public uint update_state { get; set; }
		[NoAccessorMethod]
		public string update_text { owned get; set; }
		[NoAccessorMethod]
		public string update_updated { owned get; set; }
		[NoAccessorMethod]
		public string update_updates { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] update_vendor_urls { owned get; set; }
		[NoAccessorMethod]
		public string url { owned get; set; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_package_sack_get_type ()")]
	public class PackageSack : GLib.Object {
		[CCode (has_construct_function = false)]
		public PackageSack ();
		public bool add_package (Pk.Package package);
		public bool add_package_by_id (string package_id) throws GLib.Error;
		public bool add_packages_from_file (GLib.File file) throws GLib.Error;
		[NoWrapper]
		public virtual void changed ();
		public void clear ();
		public Pk.PackageSack filter (Pk.PackageSackFilterFunc filter_cb);
		public Pk.PackageSack filter_by_info (Pk.Info info);
		public Pk.Package find_by_id (string package_id);
		public GLib.GenericArray<weak Pk.Package> get_array ();
		public bool get_details (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async void get_details_async (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_ids ();
		public uint get_size ();
		public uint64 get_total_bytes ();
		public bool get_update_detail (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async void get_update_detail_async (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public bool merge_generic_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool remove_by_filter (Pk.PackageSackFilterFunc filter_cb);
		public bool remove_package (Pk.Package package);
		public bool remove_package_by_id (string package_id);
		public bool resolve (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async void resolve_async (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public void sort (Pk.PackageSackSortType type);
		public static void test (void* user_data);
		public bool to_file (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	[Compact]
	public class PackageSackResults {
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_progress_get_type ()")]
	public class Progress : GLib.Object {
		[CCode (has_construct_function = false)]
		public Progress ();
		public bool set_allow_cancel (bool allow_cancel);
		public bool set_caller_active (bool caller_active);
		public bool set_download_size_remaining (uint64 download_size_remaining);
		public bool set_elapsed_time (uint elapsed_time);
		public bool set_item_progress (Pk.ItemProgress item_progress);
		public bool set_package (Pk.Package package);
		public bool set_package_id (string package_id);
		public bool set_percentage (int percentage);
		public bool set_remaining_time (uint remaining_time);
		public bool set_role (Pk.Role role);
		public bool set_speed (uint speed);
		public bool set_status (Pk.Status status);
		public bool set_transaction_flags (uint64 transaction_flags);
		public bool set_transaction_id (string package_id);
		public bool set_uid (uint uid);
		public static void test (void* user_data);
		[NoAccessorMethod]
		public bool allow_cancel { get; set; }
		[NoAccessorMethod]
		public bool caller_active { get; set; }
		[NoAccessorMethod]
		public uint download_size_remaining { get; set; }
		[NoAccessorMethod]
		public uint elapsed_time { get; set; }
		[NoAccessorMethod]
		public Pk.ItemProgress item_progress { owned get; set; }
		[NoAccessorMethod]
		public Pk.Package package { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public int percentage { get; set; }
		[NoAccessorMethod]
		public uint remaining_time { get; set; }
		[NoAccessorMethod]
		public uint role { get; set; }
		[NoAccessorMethod]
		public uint speed { get; set; }
		[NoAccessorMethod]
		public uint status { get; set; }
		[NoAccessorMethod]
		public uint64 transaction_flags { get; set; }
		[NoAccessorMethod]
		public string transaction_id { owned get; set; }
		[NoAccessorMethod]
		public uint uid { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_repo_detail_get_type ()")]
	public class RepoDetail : Pk.Source {
		[CCode (has_construct_function = false)]
		public RepoDetail ();
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public bool enabled { get; set; }
		[NoAccessorMethod]
		public string repo_id { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_repo_signature_required_get_type ()")]
	public class RepoSignatureRequired : Pk.Source {
		[CCode (has_construct_function = false)]
		public RepoSignatureRequired ();
		[NoAccessorMethod]
		public string key_fingerprint { owned get; set; }
		[NoAccessorMethod]
		public string key_id { owned get; set; }
		[NoAccessorMethod]
		public string key_timestamp { owned get; set; }
		[NoAccessorMethod]
		public string key_url { owned get; set; }
		[NoAccessorMethod]
		public string key_userid { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public string repository_name { owned get; set; }
		[NoAccessorMethod]
		public uint type { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_require_restart_get_type ()")]
	public class RequireRestart : Pk.Source {
		[CCode (has_construct_function = false)]
		public RequireRestart ();
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public uint restart { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_results_get_type ()")]
	public class Results : GLib.Object {
		[CCode (has_construct_function = false)]
		public Results ();
		public bool add_category (Pk.Category item);
		public bool add_details (Pk.Details item);
		public bool add_distro_upgrade (Pk.DistroUpgrade item);
		public bool add_eula_required (Pk.EulaRequired item);
		public bool add_files (Pk.Files item);
		public bool add_media_change_required (Pk.MediaChangeRequired item);
		public bool add_message (Pk.Message item);
		public bool add_package (Pk.Package item);
		public bool add_repo_detail (Pk.RepoDetail item);
		public bool add_repo_signature_required (Pk.RepoSignatureRequired item);
		public bool add_require_restart (Pk.RequireRestart item);
		public bool add_transaction (Pk.TransactionPast item);
		public bool add_update_detail (Pk.UpdateDetail item);
		public GLib.GenericArray<weak Pk.Category> get_category_array ();
		public GLib.GenericArray<weak Pk.Details> get_details_array ();
		public GLib.GenericArray<weak Pk.DistroUpgrade> get_distro_upgrade_array ();
		public Pk.Error get_error_code ();
		public GLib.GenericArray<weak Pk.EulaRequired> get_eula_required_array ();
		public Pk.Exit get_exit_code ();
		public GLib.GenericArray<weak Pk.Files> get_files_array ();
		public GLib.GenericArray<weak Pk.MediaChangeRequired> get_media_change_required_array ();
		public GLib.GenericArray<weak Pk.Message> get_message_array ();
		public GLib.GenericArray<weak Pk.Package> get_package_array ();
		public Pk.PackageSack get_package_sack ();
		public GLib.GenericArray<weak Pk.RepoDetail> get_repo_detail_array ();
		public GLib.GenericArray<weak Pk.RepoSignatureRequired> get_repo_signature_required_array ();
		public GLib.GenericArray<weak Pk.RequireRestart> get_require_restart_array ();
		public Pk.Restart get_require_restart_worst ();
		public Pk.Role get_role ();
		public GLib.GenericArray<weak Pk.TransactionPast> get_transaction_array ();
		public Pk.Bitfield get_transaction_flags ();
		public GLib.GenericArray<weak Pk.UpdateDetail> get_update_detail_array ();
		public bool set_error_code (Pk.Error item);
		public bool set_exit_code (Pk.Exit exit_enum);
		public static void test (void* user_data);
		[NoAccessorMethod]
		public uint inputs { get; set; }
		[NoAccessorMethod]
		public Pk.Progress progress { owned get; set; }
		[NoAccessorMethod]
		public uint role { get; set; }
		[NoAccessorMethod]
		public uint64 transaction_flags { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_service_pack_get_type ()")]
	public class ServicePack : GLib.Object {
		[CCode (has_construct_function = false)]
		public ServicePack ();
		public bool check_valid (string filename) throws GLib.Error;
		public async void create_for_package_ids_async (string filename, string package_ids, string package_ids_exclude, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public async void create_for_updates_async (string filename, string package_ids_exclude, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public bool generic_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool set_temp_directory (string directory);
		public static void test (void* user_data);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_source_get_type ()")]
	public class Source : GLib.Object {
		[CCode (has_construct_function = false)]
		public Source ();
		[NoAccessorMethod]
		public uint role { get; set; }
		[NoAccessorMethod]
		public string transaction_id { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_task_get_type ()")]
	public class Task : Pk.Client {
		[CCode (has_construct_function = false)]
		public Task ();
		public async void download_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, string directory, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results download_packages_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, string directory, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		[NoWrapper]
		public virtual void eula_question (uint request, Pk.Results results);
		public Pk.Results generic_finish (GLib.AsyncResult res) throws GLib.Error;
		public async void get_categories_async (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_categories_sync (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_depends_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_depends_sync (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_details_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_details_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_files_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_files_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public bool get_interactive ();
		public bool get_only_download ();
		public async void get_packages_async (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_packages_sync (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_repo_list_async (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_repo_list_sync (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_requires_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_requires_sync (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public bool get_simulate ();
		public async void get_update_detail_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_update_detail_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void get_updates_async (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results get_updates_sync (Pk.Bitfield filters, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void install_files_async ([CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results install_files_sync ([CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void install_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results install_packages_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		[NoWrapper]
		public virtual void key_question (uint request, Pk.Results results);
		[NoWrapper]
		public virtual void media_change_question (uint request, Pk.Results results);
		public async void refresh_cache_async (bool force, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results refresh_cache_sync (bool force, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void remove_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool allow_deps, bool autoremove, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results remove_packages_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool allow_deps, bool autoremove, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void repair_system_async (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results repair_system_sync (GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void repo_enable_async (string repo_id, bool enabled, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results repo_enable_sync (string repo_id, bool enabled, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void resolve_async (Pk.Bitfield filters, string packages, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results resolve_sync (Pk.Bitfield filters, string packages, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void search_details_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results search_details_sync (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void search_files_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results search_files_sync (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void search_groups_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results search_groups_sync (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public async void search_names_async (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results search_names_sync (Pk.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public void set_interactive (bool interactive);
		public void set_only_download (bool only_download);
		public void set_simulate (bool simulate);
		[NoWrapper]
		public virtual void simulate_question (uint request, Pk.Results results);
		public static void test (void* user_data);
		[NoWrapper]
		public virtual void untrusted_question (uint request, Pk.Results results);
		public async void update_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results update_packages_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public bool user_accepted (uint request);
		public bool user_declined (uint request);
		public async void what_provides_async (Pk.Bitfield filters, Pk.Provides provides, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback);
		public Pk.Results what_provides_sync (Pk.Bitfield filters, Pk.Provides provides, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, Pk.ProgressCallback progress_callback) throws GLib.Error;
		public bool only_download { get; set; }
		public bool simulate { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_transaction_list_get_type ()")]
	public class TransactionList : GLib.Object {
		[CCode (has_construct_function = false)]
		public TransactionList ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_ids ();
		public static void test (void* user_data);
		public virtual signal void added (string tid);
		public virtual signal void removed (string tid);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_transaction_past_get_type ()")]
	public class TransactionPast : Pk.Source {
		[CCode (has_construct_function = false)]
		public TransactionPast ();
		public unowned string get_cmdline ();
		public unowned string get_data ();
		public GLib.DateTime get_datetime ();
		public uint get_duration ();
		public unowned string get_id ();
		public Pk.Role get_role ();
		public bool get_succeeded ();
		public unowned string get_timespec ();
		public int64 get_timestamp ();
		public uint get_uid ();
		[NoAccessorMethod]
		public string cmdline { owned get; set; }
		[NoAccessorMethod]
		public string data { owned get; set; }
		[NoAccessorMethod]
		public uint duration { get; set; }
		[NoAccessorMethod]
		public uint role { get; set; }
		[NoAccessorMethod]
		public bool succeeded { get; set; }
		[NoAccessorMethod]
		public string tid { owned get; set; }
		[NoAccessorMethod]
		public string timespec { owned get; set; }
		[NoAccessorMethod]
		public uint uid { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_update_detail_get_type ()")]
	public class UpdateDetail : Pk.Source {
		[CCode (has_construct_function = false)]
		public UpdateDetail ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_bugzilla_urls ();
		public unowned string get_changelog ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_cve_urls ();
		public unowned string get_issued ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_obsoletes ();
		public unowned string get_package_id ();
		public Pk.Restart get_restart ();
		public Pk.UpdateState get_state ();
		public unowned string get_update_text ();
		public unowned string get_updated ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_updates ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_vendor_urls ();
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] bugzilla_urls { owned get; set; }
		[NoAccessorMethod]
		public string changelog { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] cve_urls { owned get; set; }
		[NoAccessorMethod]
		public string issued { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] obsoletes { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public uint restart { get; set; }
		[NoAccessorMethod]
		public uint state { get; set; }
		[NoAccessorMethod]
		public string update_text { owned get; set; }
		[NoAccessorMethod]
		public string updated { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] updates { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] vendor_urls { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	[SimpleType]
	public struct Bitfield : uint64 {
		public static void test (void* user_data);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", has_type_id = false)]
	public struct EnumMatch {
		public uint value;
		public weak global::string string;
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkAuthorizeEnum", cprefix = "PK_AUTHORIZE_ENUM_", type_id = "pk_authorize_enum_get_type ()")]
	[GIR (name = "AuthorizeEnum")]
	public enum Authorize {
		UNKNOWN,
		YES,
		NO,
		INTERACTIVE,
		LAST;
		public static Pk.Authorize type_enum_from_string (string authorize_type);
		public static unowned string type_enum_to_string (Pk.Authorize authorize_type);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_DISTRO_UPGRADE_ENUM_", type_id = "pk_distro_upgrade_enum_get_type ()")]
	public enum DistroUpgradeEnum {
		UNKNOWN,
		STABLE,
		UNSTABLE,
		LAST;
		public static Pk.DistroUpgradeEnum from_string (string upgrade);
		public static unowned string to_string (Pk.DistroUpgradeEnum upgrade);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_ERROR_ENUM_", type_id = "pk_error_enum_get_type ()")]
	public enum ErrorEnum {
		UNKNOWN,
		OOM,
		NO_NETWORK,
		NOT_SUPPORTED,
		INTERNAL_ERROR,
		GPG_FAILURE,
		PACKAGE_ID_INVALID,
		PACKAGE_NOT_INSTALLED,
		PACKAGE_NOT_FOUND,
		PACKAGE_ALREADY_INSTALLED,
		PACKAGE_DOWNLOAD_FAILED,
		GROUP_NOT_FOUND,
		GROUP_LIST_INVALID,
		DEP_RESOLUTION_FAILED,
		FILTER_INVALID,
		CREATE_THREAD_FAILED,
		TRANSACTION_ERROR,
		TRANSACTION_CANCELLED,
		NO_CACHE,
		REPO_NOT_FOUND,
		CANNOT_REMOVE_SYSTEM_PACKAGE,
		PROCESS_KILL,
		FAILED_INITIALIZATION,
		FAILED_FINALISE,
		FAILED_CONFIG_PARSING,
		CANNOT_CANCEL,
		CANNOT_GET_LOCK,
		NO_PACKAGES_TO_UPDATE,
		CANNOT_WRITE_REPO_CONFIG,
		LOCAL_INSTALL_FAILED,
		BAD_GPG_SIGNATURE,
		MISSING_GPG_SIGNATURE,
		CANNOT_INSTALL_SOURCE_PACKAGE,
		REPO_CONFIGURATION_ERROR,
		NO_LICENSE_AGREEMENT,
		FILE_CONFLICTS,
		PACKAGE_CONFLICTS,
		REPO_NOT_AVAILABLE,
		INVALID_PACKAGE_FILE,
		PACKAGE_INSTALL_BLOCKED,
		PACKAGE_CORRUPT,
		ALL_PACKAGES_ALREADY_INSTALLED,
		FILE_NOT_FOUND,
		NO_MORE_MIRRORS_TO_TRY,
		NO_DISTRO_UPGRADE_DATA,
		INCOMPATIBLE_ARCHITECTURE,
		NO_SPACE_ON_DEVICE,
		MEDIA_CHANGE_REQUIRED,
		NOT_AUTHORIZED,
		UPDATE_NOT_FOUND,
		CANNOT_INSTALL_REPO_UNSIGNED,
		CANNOT_UPDATE_REPO_UNSIGNED,
		CANNOT_GET_FILELIST,
		CANNOT_GET_REQUIRES,
		CANNOT_DISABLE_REPOSITORY,
		RESTRICTED_DOWNLOAD,
		PACKAGE_FAILED_TO_CONFIGURE,
		PACKAGE_FAILED_TO_BUILD,
		PACKAGE_FAILED_TO_INSTALL,
		PACKAGE_FAILED_TO_REMOVE,
		UPDATE_FAILED_DUE_TO_RUNNING_PROCESS,
		PACKAGE_DATABASE_CHANGED,
		PROVIDE_TYPE_NOT_SUPPORTED,
		INSTALL_ROOT_INVALID,
		CANNOT_FETCH_SOURCES,
		CANCELLED_PRIORITY,
		UNFINISHED_TRANSACTION,
		LOCK_REQUIRED,
		LAST;
		public static Pk.ErrorEnum from_string (string code);
		public static unowned string to_string (Pk.ErrorEnum code);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkExitEnum", cprefix = "PK_EXIT_ENUM_", type_id = "pk_exit_enum_get_type ()")]
	[GIR (name = "ExitEnum")]
	public enum Exit {
		UNKNOWN,
		SUCCESS,
		FAILED,
		CANCELLED,
		KEY_REQUIRED,
		EULA_REQUIRED,
		KILLED,
		MEDIA_CHANGE_REQUIRED,
		NEED_UNTRUSTED,
		CANCELLED_PRIORITY,
		SKIP_TRANSACTION,
		REPAIR_REQUIRED,
		LAST;
		public static Pk.Exit enum_from_string (string exit);
		public static unowned string enum_to_string (Pk.Exit exit);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkFilterEnum", cprefix = "PK_FILTER_ENUM_", type_id = "pk_filter_enum_get_type ()")]
	[GIR (name = "FilterEnum")]
	public enum Filter {
		UNKNOWN,
		NONE,
		INSTALLED,
		NOT_INSTALLED,
		DEVELOPMENT,
		NOT_DEVELOPMENT,
		GUI,
		NOT_GUI,
		FREE,
		NOT_FREE,
		VISIBLE,
		NOT_VISIBLE,
		SUPPORTED,
		NOT_SUPPORTED,
		BASENAME,
		NOT_BASENAME,
		NEWEST,
		NOT_NEWEST,
		ARCH,
		NOT_ARCH,
		SOURCE,
		NOT_SOURCE,
		COLLECTIONS,
		NOT_COLLECTIONS,
		APPLICATION,
		NOT_APPLICATION,
		DOWNLOADED,
		NOT_DOWNLOADED,
		LAST;
		public static Pk.Bitfield bitfield_from_string (string filters);
		public static string bitfield_to_string (Pk.Bitfield filters);
		public static Pk.Filter enum_from_string (string filter);
		public static unowned string enum_to_string (Pk.Filter filter);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkGroupEnum", cprefix = "PK_GROUP_ENUM_", type_id = "pk_group_enum_get_type ()")]
	[GIR (name = "GroupEnum")]
	public enum Group {
		UNKNOWN,
		ACCESSIBILITY,
		ACCESSORIES,
		ADMIN_TOOLS,
		COMMUNICATION,
		DESKTOP_GNOME,
		DESKTOP_KDE,
		DESKTOP_OTHER,
		DESKTOP_XFCE,
		EDUCATION,
		FONTS,
		GAMES,
		GRAPHICS,
		INTERNET,
		LEGACY,
		LOCALIZATION,
		MAPS,
		MULTIMEDIA,
		NETWORK,
		OFFICE,
		OTHER,
		POWER_MANAGEMENT,
		PROGRAMMING,
		PUBLISHING,
		REPOS,
		SECURITY,
		SERVERS,
		SYSTEM,
		VIRTUALIZATION,
		SCIENCE,
		DOCUMENTATION,
		ELECTRONICS,
		COLLECTIONS,
		VENDOR,
		NEWEST,
		LAST;
		public static Pk.Bitfield bitfield_from_string (string groups);
		public static string bitfield_to_string (Pk.Bitfield groups);
		public static Pk.Group enum_from_string (string group);
		public static unowned string enum_to_string (Pk.Group group);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkInfoEnum", cprefix = "PK_INFO_ENUM_", type_id = "pk_info_enum_get_type ()")]
	[GIR (name = "InfoEnum")]
	public enum Info {
		UNKNOWN,
		INSTALLED,
		AVAILABLE,
		LOW,
		ENHANCEMENT,
		NORMAL,
		BUGFIX,
		IMPORTANT,
		SECURITY,
		BLOCKED,
		DOWNLOADING,
		UPDATING,
		INSTALLING,
		REMOVING,
		CLEANUP,
		OBSOLETING,
		COLLECTION_INSTALLED,
		COLLECTION_AVAILABLE,
		FINISHED,
		REINSTALLING,
		DOWNGRADING,
		PREPARING,
		DECOMPRESSING,
		UNTRUSTED,
		TRUSTED,
		LAST;
		public static Pk.Info enum_from_string (string info);
		public static unowned string enum_to_localised_past (Pk.Info info);
		public static unowned string enum_to_localised_present (Pk.Info info);
		public static unowned string enum_to_string (Pk.Info info);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkMediaTypeEnum", cprefix = "PK_MEDIA_TYPE_ENUM_", type_id = "pk_media_type_enum_get_type ()")]
	[GIR (name = "MediaTypeEnum")]
	public enum MediaType {
		UNKNOWN,
		CD,
		DVD,
		DISC,
		LAST;
		public static Pk.MediaType enum_from_string (string media_type);
		public static unowned string enum_to_string (Pk.MediaType media_type);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_MESSAGE_ENUM_", type_id = "pk_message_enum_get_type ()")]
	public enum MessageEnum {
		UNKNOWN,
		BROKEN_MIRROR,
		CONNECTION_REFUSED,
		PARAMETER_INVALID,
		PRIORITY_INVALID,
		BACKEND_ERROR,
		DAEMON_ERROR,
		CACHE_BEING_REBUILT,
		NEWER_PACKAGE_EXISTS,
		COULD_NOT_FIND_PACKAGE,
		CONFIG_FILES_CHANGED,
		PACKAGE_ALREADY_INSTALLED,
		AUTOREMOVE_IGNORED,
		REPO_METADATA_DOWNLOAD_FAILED,
		REPO_FOR_DEVELOPERS_ONLY,
		OTHER_UPDATES_HELD_BACK,
		LAST;
		public static Pk.MessageEnum from_string (string message);
		public static unowned string to_string (Pk.MessageEnum message);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkNetworkEnum", cprefix = "PK_NETWORK_ENUM_", type_id = "pk_network_enum_get_type ()")]
	[GIR (name = "NetworkEnum")]
	public enum Network {
		UNKNOWN,
		OFFLINE,
		ONLINE,
		WIRED,
		WIFI,
		MOBILE,
		LAST;
		public static Pk.Network enum_from_string (string network);
		public static unowned string enum_to_string (Pk.Network network);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_PACKAGE_SACK_SORT_TYPE_", type_id = "pk_package_sack_sort_type_get_type ()")]
	public enum PackageSackSortType {
		NAME,
		INFO,
		PACKAGE_ID,
		SUMMARY,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_PROGRESS_TYPE_", type_id = "pk_progress_type_get_type ()")]
	public enum ProgressType {
		PACKAGE_ID,
		TRANSACTION_ID,
		PERCENTAGE,
		ALLOW_CANCEL,
		STATUS,
		ROLE,
		CALLER_ACTIVE,
		ELAPSED_TIME,
		REMAINING_TIME,
		SPEED,
		DOWNLOAD_SIZE_REMAINING,
		UID,
		PACKAGE,
		ITEM_PROGRESS,
		TRANSACTION_FLAGS,
		INVALID
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkProvidesEnum", cprefix = "PK_PROVIDES_ENUM_", type_id = "pk_provides_enum_get_type ()")]
	[GIR (name = "ProvidesEnum")]
	public enum Provides {
		UNKNOWN,
		ANY,
		MODALIAS,
		CODEC,
		MIMETYPE,
		FONT,
		HARDWARE_DRIVER,
		POSTSCRIPT_DRIVER,
		PLASMA_SERVICE,
		SHARED_LIB,
		PYTHON,
		LANGUAGE_SUPPORT,
		LAST;
		public static Pk.Provides enum_from_string (string provides);
		public static unowned string enum_to_string (Pk.Provides provides);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkRestartEnum", cprefix = "PK_RESTART_ENUM_", type_id = "pk_restart_enum_get_type ()")]
	[GIR (name = "RestartEnum")]
	public enum Restart {
		UNKNOWN,
		NONE,
		APPLICATION,
		SESSION,
		SYSTEM,
		SECURITY_SESSION,
		SECURITY_SYSTEM,
		LAST;
		public static Pk.Restart enum_from_string (string restart);
		public static unowned string enum_to_string (Pk.Restart restart);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkRoleEnum", cprefix = "PK_ROLE_ENUM_", type_id = "pk_role_enum_get_type ()")]
	[GIR (name = "RoleEnum")]
	public enum Role {
		UNKNOWN,
		CANCEL,
		GET_DEPENDS,
		GET_DETAILS,
		GET_FILES,
		GET_PACKAGES,
		GET_REPO_LIST,
		GET_REQUIRES,
		GET_UPDATE_DETAIL,
		GET_UPDATES,
		INSTALL_FILES,
		INSTALL_PACKAGES,
		INSTALL_SIGNATURE,
		REFRESH_CACHE,
		REMOVE_PACKAGES,
		REPO_ENABLE,
		REPO_SET_DATA,
		RESOLVE,
		SEARCH_DETAILS,
		SEARCH_FILE,
		SEARCH_GROUP,
		SEARCH_NAME,
		UPDATE_PACKAGES,
		WHAT_PROVIDES,
		ACCEPT_EULA,
		DOWNLOAD_PACKAGES,
		GET_DISTRO_UPGRADES,
		GET_CATEGORIES,
		GET_OLD_TRANSACTIONS,
		UPGRADE_SYSTEM,
		REPAIR_SYSTEM,
		LAST;
		public static Pk.Bitfield bitfield_from_string (string roles);
		public static string bitfield_to_string (Pk.Bitfield roles);
		public static Pk.Role enum_from_string (string role);
		public static unowned string enum_to_localised_present (Pk.Role role);
		public static unowned string enum_to_string (Pk.Role role);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkSigTypeEnum", cprefix = "PK_SIGTYPE_ENUM_", type_id = "pk_sig_type_enum_get_type ()")]
	[GIR (name = "SigTypeEnum")]
	public enum SigType {
		UNKNOWN,
		GPG,
		LAST;
		public static Pk.SigType enum_from_string (string sig_type);
		public static unowned string enum_to_string (Pk.SigType sig_type);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkStatusEnum", cprefix = "PK_STATUS_ENUM_", type_id = "pk_status_enum_get_type ()")]
	[GIR (name = "StatusEnum")]
	public enum Status {
		UNKNOWN,
		WAIT,
		SETUP,
		RUNNING,
		QUERY,
		INFO,
		REMOVE,
		REFRESH_CACHE,
		DOWNLOAD,
		INSTALL,
		UPDATE,
		CLEANUP,
		OBSOLETE,
		DEP_RESOLVE,
		SIG_CHECK,
		TEST_COMMIT,
		COMMIT,
		REQUEST,
		FINISHED,
		CANCEL,
		DOWNLOAD_REPOSITORY,
		DOWNLOAD_PACKAGELIST,
		DOWNLOAD_FILELIST,
		DOWNLOAD_CHANGELOG,
		DOWNLOAD_GROUP,
		DOWNLOAD_UPDATEINFO,
		REPACKAGING,
		LOADING_CACHE,
		SCAN_APPLICATIONS,
		GENERATE_PACKAGE_LIST,
		WAITING_FOR_LOCK,
		WAITING_FOR_AUTH,
		SCAN_PROCESS_LIST,
		CHECK_EXECUTABLE_FILES,
		CHECK_LIBRARIES,
		COPY_FILES,
		LAST;
		public static Pk.Status enum_from_string (string status);
		public static unowned string enum_to_localised_text (Pk.Status status);
		public static unowned string enum_to_string (Pk.Status status);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkTransactionFlagEnum", cprefix = "PK_TRANSACTION_FLAG_ENUM_", type_id = "pk_transaction_flag_enum_get_type ()")]
	[GIR (name = "TransactionFlagEnum")]
	public enum TransactionFlag {
		NONE,
		ONLY_TRUSTED,
		SIMULATE,
		ONLY_DOWNLOAD,
		LAST;
		public static Pk.Bitfield bitfield_from_string (string transaction_flags);
		public static string bitfield_to_string (Pk.Bitfield transaction_flags);
		public static Pk.TransactionFlag enum_from_string (string transaction_flag);
		public static unowned string enum_to_string (Pk.TransactionFlag transaction_flag);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkUpdateStateEnum", cprefix = "PK_UPDATE_STATE_ENUM_", type_id = "pk_update_state_enum_get_type ()")]
	[GIR (name = "UpdateStateEnum")]
	public enum UpdateState {
		UNKNOWN,
		STABLE,
		UNSTABLE,
		TESTING,
		LAST;
		public static Pk.UpdateState enum_from_string (string update_state);
		public static unowned string enum_to_string (Pk.UpdateState update_state);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkUpgradeKindEnum", cprefix = "PK_UPGRADE_KIND_ENUM_", type_id = "pk_upgrade_kind_enum_get_type ()")]
	[GIR (name = "UpgradeKindEnum")]
	public enum UpgradeKind {
		UNKNOWN,
		MINIMAL,
		DEFAULT,
		COMPLETE,
		LAST;
		public static Pk.UpgradeKind enum_from_string (string upgrade_kind);
		public static unowned string enum_to_string (Pk.UpgradeKind upgrade_kind);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_CATALOG_ERROR_")]
	public errordomain CatalogError {
		FAILED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_CLIENT_ERROR_")]
	public errordomain ClientError {
		FAILED,
		FAILED_AUTH,
		NO_TID,
		ALREADY_TID,
		ROLE_UNKNOWN,
		CANNOT_START_DAEMON,
		INVALID_INPUT,
		INVALID_FILE,
		NOT_SUPPORTED,
		DECLINED_SIMULATION,
		LAST;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_CONTROL_ERROR_")]
	public errordomain ControlError {
		FAILED,
		CANNOT_START_DAEMON;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_SERVICE_PACK_ERROR_")]
	public errordomain ServicePackError {
		FAILED_SETUP,
		FAILED_DOWNLOAD,
		FAILED_EXTRACTION,
		FAILED_CREATE,
		NOTHING_TO_DO,
		NOT_COMPATIBLE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", instance_pos = 1.9)]
	public delegate bool PackageSackFilterFunc (Pk.Package package);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", instance_pos = 2.9)]
	public delegate void ProgressCallback (Pk.Progress progress, Pk.ProgressType type);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_CATALOG_FILE_EXTENSION")]
	public const string CATALOG_FILE_EXTENSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_CATALOG_FILE_HEADER")]
	public const string CATALOG_FILE_HEADER;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DBUS_INTERFACE")]
	public const string DBUS_INTERFACE;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DBUS_INTERFACE_TRANSACTION")]
	public const string DBUS_INTERFACE_TRANSACTION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DBUS_PATH")]
	public const string DBUS_PATH;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DBUS_SERVICE")]
	public const string DBUS_SERVICE;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DESKTOP_DEFAULT_APPLICATION_DIR")]
	public const string DESKTOP_DEFAULT_APPLICATION_DIR;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_IDS_DELIM")]
	public const string PACKAGE_IDS_DELIM;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_ID_ARCH")]
	public const int PACKAGE_ID_ARCH;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_ID_DATA")]
	public const int PACKAGE_ID_DATA;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_ID_NAME")]
	public const int PACKAGE_ID_NAME;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_ID_VERSION")]
	public const int PACKAGE_ID_VERSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_SERVICE_PACK_FILE_EXTENSION")]
	public const string SERVICE_PACK_FILE_EXTENSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_SERVICE_PACK_GROUP_NAME")]
	public const string SERVICE_PACK_GROUP_NAME;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_SYSTEM_PACKAGE_CACHE_FILENAME")]
	public const string SYSTEM_PACKAGE_CACHE_FILENAME;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_SYSTEM_PACKAGE_LIST_FILENAME")]
	public const string SYSTEM_PACKAGE_LIST_FILENAME;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void common_test (void* user_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void debug_add_log_domain (string log_domain);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static bool debug_is_verbose ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void debug_set_verbose (bool verbose);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static unowned string enum_find_string (Pk.EnumMatch table, uint value);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static uint enum_find_value (Pk.EnumMatch table, string string);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void enum_test (void* user_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static string get_distro_id ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static string iso8601_from_date (GLib.Date date);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static string iso8601_present ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__POINTER_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__POINTER_UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_BOXED (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_BOOLEAN_STRING_UINT_STRING_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_BOOLEAN_UINT_UINT_STRING_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_BOOLEAN_STRING_UINT_STRING_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT64 (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_UINT64 (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_UINT_STRING_STRING_UINT64 (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_STRING_UINT_UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_UINT_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__STRING_UINT_UINT_UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__UINT_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__UINT_STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void marshal_VOID__UINT_UINT_UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static void polkit_agent_close ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	public static int polkit_agent_open ();
}
