/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class ChannelDispatcherInterface
 * \headerfile TelepathyQt/channel-dispatcher.h <TelepathyQt/ChannelDispatcher>
 * \ingroup clientchanneldispatcher
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.ChannelDispatcher".
 */
class TP_QT_EXPORT ChannelDispatcherInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.ChannelDispatcher", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.ChannelDispatcher");
    }

    /**
     * Creates a ChannelDispatcherInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelDispatcherInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelDispatcherInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelDispatcherInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelDispatcherInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelDispatcherInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * A list of the extra interfaces provided by this channel dispatcher.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c SupportsRequestHints of type \c bool.
     *
     * 
     * If True, the channel dispatcher is new enough to support 
     * CreateChannelWithHints and EnsureChannelWithHints, in addition to the 
     * older CreateChannel and EnsureChannel methods, and also new enough to 
     * emit SucceededWithChannel before the older Succeeded signal. If False 
     * or missing, only the metadata-less variants are supported.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySupportsRequestHints() const
    {
        return internalRequestProperty(QLatin1String("SupportsRequestHints"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c CreateChannel on the remote object.
     * 
     * \htmlonly
     * <p>Equivalent to calling
     *    \endhtmlonly CreateChannelWithHints() \htmlonly  with an empty
     *   <var>Hints</var> parameter.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param account
     *     
     *     The Account for which the new channel is to be created.
     *
     * \param requestedProperties
     *     
     *     \htmlonly
     *     <p>A dictionary containing desirable properties.</p>
     *     
     *     <p>This parameter is used in the same way as the corresponding
     *       parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     *
     * \param userActionTime
     *     
     *     \htmlonly
     *     <p>The time at which user action occurred, or 0 if this channel
     *       request is for some reason not involving user action.</p>
     *     
     *     <p>This parameter is used in the same way as the corresponding
     *       parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     *
     * \param preferredHandler
     *     
     *     \htmlonly
     *     <p>Either the well-known bus name (starting with
     *       <code>org.freedesktop.Telepathy.Client.</code>)
     *       of the preferred handler for this
     *       channel, or an empty string to indicate that any handler would be
     *       acceptable.</p>
     *     
     *     <p>This parameter is used in the same way as the corresponding
     *       parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A ChannelRequest object.
     */
    inline QDBusPendingReply<QDBusObjectPath> CreateChannel(const QDBusObjectPath& account, const QVariantMap& requestedProperties, qlonglong userActionTime, const QString& preferredHandler, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusObjectPath>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CreateChannel"));
        callMessage << QVariant::fromValue(account) << QVariant::fromValue(requestedProperties) << QVariant::fromValue(userActionTime) << QVariant::fromValue(preferredHandler);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c EnsureChannel on the remote object.
     * 
     * \htmlonly
     * <p>Equivalent to calling
     *    \endhtmlonly EnsureChannelWithHints() \htmlonly  with an empty
     *   <var>Hints</var> parameter.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param account
     *     
     *     The Account for which the new channel is to be created.
     *
     * \param requestedProperties
     *     
     *     \htmlonly
     *     <p>A dictionary containing desirable properties.</p>
     *     
     *     <p>This parameter is used in the same way as the corresponding
     *       parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     *
     * \param userActionTime
     *     
     *     \htmlonly
     *     <p>The time at which user action occurred, or 0 if this channel
     *       request is for some reason not involving user action.</p>
     *     
     *     <p>This parameter is used in the same way as the corresponding
     *       parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     *
     * \param preferredHandler
     *     
     *     \htmlonly
     *     <p>Either the well-known bus name (starting with
     *       <code>org.freedesktop.Telepathy.Client.</code>)
     *       of the preferred handler for this
     *       channel, or an empty string to indicate that any handler would be
     *       acceptable. The behaviour and rationale are the same as for the
     *       corresponding parameter to
     *        \endhtmlonly EnsureChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A ChannelRequest object.
     */
    inline QDBusPendingReply<QDBusObjectPath> EnsureChannel(const QDBusObjectPath& account, const QVariantMap& requestedProperties, qlonglong userActionTime, const QString& preferredHandler, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusObjectPath>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("EnsureChannel"));
        callMessage << QVariant::fromValue(account) << QVariant::fromValue(requestedProperties) << QVariant::fromValue(userActionTime) << QVariant::fromValue(preferredHandler);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c CreateChannelWithHints on the remote object.
     * 
     * \htmlonly
     * <p>Start a request to create a channel. This initially just creates a
     *    \endhtmlonly ChannelRequestInterface \htmlonly 
     *   object, which can be used to continue the request and track its
     *   success or failure.</p>
     * 
     * <div class="rationale">
     *   <p>The request can take a long time - in the worst case, the
     *     channel dispatcher has to ask the account manager to put the
     *     account online, the account manager has to ask the operating
     *     system to obtain an Internet connection, and the operating
     *     system has to ask the user whether to activate an Internet
     *     connection using an on-demand mechanism like dialup.</p>
     * 
     *   <p>This means that using a single D-Bus method call and response
     *     to represent the whole request will tend to lead to that call
     *     timing out, which is not the behaviour we want.</p>
     * </div>
     * 
     * <p>If this method is called for an Account that is disabled, invalid
     *   or otherwise unusable, no error is signalled until
     *    \endhtmlonly ChannelRequestInterface::Proceed() \htmlonly 
     *   is called, at which point
     *    \endhtmlonly ChannelRequestInterface::Failed() \htmlonly 
     *   is emitted with an appropriate error.</p>
     * 
     * <div class="rationale">
     *   <p>This means there's only one code path for errors, apart from
     *     InvalidArgument for &quot;that request makes no sense&quot;.</p>
     * 
     *   <p>It also means that the request will proceed if the account is
     *     enabled after calling CreateChannel, but before calling
     *     Proceed.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param account
     *     
     *     The Account for which the new channel is to be created.
     *
     * \param requestedProperties
     *     
     *     \htmlonly
     *     <p>A dictionary containing desirable properties. This has the same
     *       semantics as the corresponding parameter to
     *        \endhtmlonly ConnectionInterfaceRequestsInterface::CreateChannel() \htmlonly .
     *     </p>
     *     
     *     <p>Certain properties will not necessarily make sense in this
     *       dictionary: for instance,
     *        \endhtmlonly \link ChannelInterface::requestPropertyTargetHandle() ChannelInterface::TargetHandle \endlink \htmlonly 
     *       can only be given if the requester is able to interact with a
     *        \endhtmlonly ConnectionInterface \htmlonly 
     *       to the desired account.</p>
     *     \endhtmlonly
     *
     * \param userActionTime
     *     
     *     \htmlonly
     *     <p>The time at which user action occurred, or 0 if this channel
     *       request is for some reason not involving user action.
     *       The  \endhtmlonly \link ChannelRequestInterface::requestPropertyUserActionTime() ChannelRequestInterface::UserActionTime \endlink \htmlonly 
     *       property will be set to this value, and it will eventually be
     *       passed as the <code>User_Action_Time</code> parameter of  \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly .</p>
     *     \endhtmlonly
     *
     * \param preferredHandler
     *     
     *     \htmlonly
     *     <p>Either the well-known bus name (starting with
     *       <code>org.freedesktop.Telepathy.Client.</code>)
     *       of the preferred handler for this
     *       channel, or an empty string to indicate that any handler would be
     *       acceptable. The channel dispatcher SHOULD dispatch as many as
     *       possible of the resulting channels (ideally, all of them)
     *       to that handler—irrespective of whether that handler's  \endhtmlonly \link ClientHandlerInterface::requestPropertyHandlerChannelFilter() ClientHandlerInterface::HandlerChannelFilter \endlink \htmlonly 
     *       matches the channel—and SHOULD remember the preferred handler
     *       so it can try to dispatch subsequent channels in the same bundle
     *       to the same handler.</p>
     *     
     *     <div class="rationale">
     *       <p>This must be the well-known bus name, not the unique name,
     *         to ensure that all handlers do indeed have the Client API,
     *         and the Client object on the handler can be located easily.</p>
     *     
     *       <p>This is partly so the channel dispatcher can call
     *          \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly 
     *         on it, and partly so the channel dispatcher
     *         can recover state if it crashes and is restarted.</p>
     *     
     *       <p>The filter should be disregarded for ease of use of this
     *         interface: clients will usually use this argument to request
     *         channels be sent to themself, and this should trump the filter
     *         not matching. This also allows a client to become the handler
     *         for a channel produced by one of its own requests, while not
     *         being a candidate to handle other channels of that type.</p>
     *     </div>
     *     
     *     <p>If this is a well-known bus name and the handler has the
     *       Requests interface, the channel dispatcher SHOULD
     *       call  \endhtmlonly ClientInterfaceRequestsInterface::AddRequest() \htmlonly 
     *       on that Handler after this method has returned.</p>
     *     
     *     <div class="rationale">
     *       <p>This ordering allows a Handler which calls CreateChannel with
     *         itself as the preferred handler to associate the call to
     *         AddRequest with that call.</p>
     *     </div>
     *     
     *     <p>This is copied to the ChannelRequest that is returned,
     *       as the  \endhtmlonly \link ChannelRequestInterface::requestPropertyPreferredHandler() ChannelRequestInterface::PreferredHandler \endlink \htmlonly 
     *       property.</p>
     *     \endhtmlonly
     *
     * \param hints
     *     
     *     Additional information about the channel request, which will be 
     *     used as the value for the resulting request&apos;s Hints property. 
     *     See the Hints property&apos;s documentation for rationale.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A ChannelRequest object.
     */
    inline QDBusPendingReply<QDBusObjectPath> CreateChannelWithHints(const QDBusObjectPath& account, const QVariantMap& requestedProperties, qlonglong userActionTime, const QString& preferredHandler, const QVariantMap& hints, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusObjectPath>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CreateChannelWithHints"));
        callMessage << QVariant::fromValue(account) << QVariant::fromValue(requestedProperties) << QVariant::fromValue(userActionTime) << QVariant::fromValue(preferredHandler) << QVariant::fromValue(hints);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c EnsureChannelWithHints on the remote object.
     * 
     * \htmlonly
     * <p>Start a request to ensure that a channel exists, creating it if
     *   necessary.  This initially just creates a  \endhtmlonly ChannelRequestInterface \htmlonly 
     *   object, which can be used to continue the request and track its
     *   success or failure.</p>
     * 
     * <p>If this method is called for an Account that is disabled, invalid
     *   or otherwise unusable, no error is signalled until
     *    \endhtmlonly ChannelRequestInterface::Proceed() \htmlonly 
     *   is called, at which point
     *    \endhtmlonly ChannelRequestInterface::Failed() \htmlonly 
     *   is emitted with an appropriate error.</p>
     * 
     * <div class="rationale">
     *   <p>The rationale is as for  \endhtmlonly ChannelDispatcherInterface::CreateChannelWithHints() \htmlonly .</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param account
     *     
     *     The Account for which the new channel is to be created.
     *
     * \param requestedProperties
     *     
     *     \htmlonly
     *     <p>A dictionary containing desirable properties. This has the same
     *       semantics as the corresponding parameter to
     *        \endhtmlonly ConnectionInterfaceRequestsInterface::EnsureChannel() \htmlonly .
     *     </p>
     *     
     *     <p>Certain properties will not necessarily make sense in this
     *       dictionary: for instance,
     *        \endhtmlonly \link ChannelInterface::requestPropertyTargetHandle() ChannelInterface::TargetHandle \endlink \htmlonly 
     *       can only be given if the requester is able to interact with a
     *        \endhtmlonly ConnectionInterface \htmlonly 
     *       to the desired account.</p>
     *     \endhtmlonly
     *
     * \param userActionTime
     *     
     *     \htmlonly
     *     <p>The time at which user action occurred, or 0 if this channel
     *       request is for some reason not involving user action.</p>
     *     
     *     <p>This parameter is used in the same way as the corresponding
     *       parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     *
     * \param preferredHandler
     *     
     *     \htmlonly
     *     <p>Either the well-known bus name (starting with
     *       <code>org.freedesktop.Telepathy.Client.</code>)
     *       of the preferred handler for this
     *       channel, or an empty string to indicate that any handler would be
     *       acceptable. The behaviour and rationale are the same as for the
     *       corresponding parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly , except
     *       as noted here.</p>
     *     
     *     <p>If any new channels are created in response to this
     *       request, the channel dispatcher SHOULD dispatch as many as
     *       possible of the resulting channels (ideally, all of them)
     *       to that handler, and SHOULD remember the preferred handler
     *       so it can try to dispatch subsequent channels in the same bundle
     *       to the same handler. If the requested channel already exists (that
     *       is,  \endhtmlonly ConnectionInterfaceRequestsInterface::EnsureChannel() \htmlonly 
     *       returns <code>Yours=False</code>) then the channel dispatcher
     *       SHOULD re-dispatch the channel to its existing handler, and MUST
     *       NOT dispatch it to this client (unless it is the existing handler);
     *       the request is still deemed to have succeeded in this case.</p>
     *     
     *     <div class="rationale">
     *       <p>An address book application, for example, might call  \endhtmlonly ChannelDispatcherInterface::EnsureChannel() \htmlonly 
     *         to ensure that a text channel with a particular contact is
     *         displayed to the user; it does not care whether a new channel was
     *         made. An IM client might call  \endhtmlonly ChannelDispatcherInterface::EnsureChannel() \htmlonly 
     *         in response to the user double-clicking an entry in the contact
     *         list, with itself as the <code>Preferred_Handler</code>; if the
     *         user already has a conversation with that contact in another
     *         application, they would expect the existing window to be
     *         presented, rather than their double-click leading to an error
     *         message.  So the request should succeed, even if its
     *         <code>Preferred_Handler</code> is not used.</p>
     *     </div>
     *     \endhtmlonly
     *
     * \param hints
     *     
     *     Additional information about the channel request, which will be 
     *     used as the value for the resulting request&apos;s Hints property.
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A ChannelRequest object.
     */
    inline QDBusPendingReply<QDBusObjectPath> EnsureChannelWithHints(const QDBusObjectPath& account, const QVariantMap& requestedProperties, qlonglong userActionTime, const QString& preferredHandler, const QVariantMap& hints, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<QDBusObjectPath>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("EnsureChannelWithHints"));
        callMessage << QVariant::fromValue(account) << QVariant::fromValue(requestedProperties) << QVariant::fromValue(userActionTime) << QVariant::fromValue(preferredHandler) << QVariant::fromValue(hints);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c DelegateChannels on the remote object.
     * 
     * \htmlonly
     * <p>Called by a
     *  \endhtmlonly ClientHandlerInterface \htmlonly 
     *   to redispatch a bunch of channels it is currently handling.</p>
     * 
     * <p>For each <var>Channel</var> in <var>Channels</var>, if another
     *    \endhtmlonly ClientHandlerInterface \htmlonly 
     *   can be found,
     *    \endhtmlonly ClientHandlerInterface::HandleChannels() \htmlonly 
     *   will be called on it until a
     *    \endhtmlonly ClientHandlerInterface \htmlonly 
     *   accepts it.</p>
     * 
     * <p>This method returns once all the <var>Channels</var> have either
     *   been accepted or rejected by Handlers.</p>
     * 
     * <p>If this method fails, the original
     *    \endhtmlonly ClientHandlerInterface \htmlonly 
     *   is still handling the channels.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param channels
     *     
     *     \htmlonly
     *     <p>The list of channels to redispatch. The caller has to be the current
     *        \endhtmlonly ClientHandlerInterface \htmlonly 
     *       of all of these channels
     *     </p>
     *     \endhtmlonly
     *
     * \param userActionTime
     *     
     *     \htmlonly
     *     <p>The time at which user action occurred, or 0 if this channels
     *       delegation is for some reason not involving user action.</p>
     *     
     *     <p>This parameter is used in the same way as the corresponding
     *       parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     *
     * \param preferredHandler
     *     
     *     \htmlonly
     *     <p>Either the well-known bus name (starting with
     *       <code>org.freedesktop.Telepathy.Client.</code>)
     *       of the preferred new handler for these
     *       channels, or an empty string to indicate that any handler would be
     *       acceptable. The behaviour and rationale are the same as for the
     *       corresponding parameter to
     *        \endhtmlonly CreateChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     \htmlonly
     *     <p>The list of channels which have been delegated; the caller is no
     *     longer handling these channels.</p>
     *     
     *     <p>The client should remove these channels from its
     *      \endhtmlonly \link ClientHandlerInterface::requestPropertyHandledChannels() ClientHandlerInterface::HandledChannels \endlink \htmlonly 
     *     property.</p>
     *     \endhtmlonly
     *
     * \return
     *     
     *     \htmlonly
     *     <p>The list of channels which have NOT been delegated; the caller is still
     *     handling these channels.</p>
     *     \endhtmlonly
     */
    inline QDBusPendingReply<Tp::ObjectPathList, Tp::NotDelegatedMap> DelegateChannels(const Tp::ObjectPathList& channels, qlonglong userActionTime, const QString& preferredHandler, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::ObjectPathList, Tp::NotDelegatedMap>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("DelegateChannels"));
        callMessage << QVariant::fromValue(channels) << QVariant::fromValue(userActionTime) << QVariant::fromValue(preferredHandler);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c PresentChannel on the remote object.
     * 
     * \htmlonly
     * <p>Equivalent of calling
     *  \endhtmlonly ChannelDispatcherInterface::EnsureChannel() \htmlonly 
     * with a <var>Requested_Properties</var> which would result in ensuring
     * <var>Channel</var>.</p>
     * 
     *  <p>If <var>Channel</var> is handled, its handler will be asked to present it the user
     *  (e.g. bring it into the foreground).</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param channel
     *     
     *     \htmlonly
     *     <p>The channel to present.</p>
     *     \endhtmlonly
     *
     * \param userActionTime
     *     
     *     \htmlonly
     *     <p>The time at which user action occurred, or 0 if this channel
     *       request is for some reason not involving user action.</p>
     *     
     *     <p>This parameter is used in the same way as the corresponding
     *       parameter to
     *        \endhtmlonly EnsureChannelWithHints() \htmlonly .</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> PresentChannel(const QDBusObjectPath& channel, qlonglong userActionTime, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("PresentChannel"));
        callMessage << QVariant::fromValue(channel) << QVariant::fromValue(userActionTime);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::ChannelDispatcherInterface*)
