(define (host) "i386-unknown-openbsd5.6")

(define (machine-vendor-os)
  (let ((match (regexp-search (rx (submatch (+ (~ #\-))) "-"
                                  (submatch (+ (~ #\-))) "-"
                                  (submatch (+ any)))
                              (host))))
    (list (match:substring match 1)
          (match:substring match 2)
          (match:substring match 3))))

(define (machine)
  (car (machine-vendor-os)))

(define (vendor)
  (cadr (machine-vendor-os)))

(define (os)
  (caddr (machine-vendor-os)))

(define (prefix) "/usr/local")

(define (exec-prefix) "/usr/local")

(define (bin-dir) "/usr/local/bin")

(define (lib-dir) "/usr/local/lib")

(define (include-dir) "/usr/local/include")

(define (man-dir) "/usr/local/man/man1")

(define (lib-dirs-list) (quote ("/usr/local/lib/scsh/modules" "/usr/local/lib/scsh/modules/0.6")))

(define (libs) "-lm  -lutil")

(define (defs) "-DHAVE_CONFIG_H")

(define (cflags) "-O2 -pipe")

(define (cppflags) "")

(define (ldflags) "-rdynamic")

(define (compiler-flags)
  (string-join (list "-I" (include-dir) (defs))))

(define (linker-flags)
  (string-join (list "-L" (lib-dir) (libs) "-lscsh") " "))

;;; Local Variables: 
;;; mode: Scheme
;;; End: 
